/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.timers.Timer;
import commonj.timers.TimerManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.commonj.ScheduledTimerListener;

public class TimerManagerFactoryBean
extends JndiLocatorSupport
implements FactoryBean,
InitializingBean,
DisposableBean,
Lifecycle {
    private TimerManager timerManager;
    private String timerManagerName;
    private boolean shared = false;
    private ScheduledTimerListener[] scheduledTimerListeners;
    private final List timers = new LinkedList();
    static /* synthetic */ Class class$commonj$timers$TimerManager;

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public void setTimerManagerName(String timerManagerName) {
        this.timerManagerName = timerManagerName;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setScheduledTimerListeners(ScheduledTimerListener[] scheduledTimerListeners) {
        this.scheduledTimerListeners = scheduledTimerListeners;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.timerManager == null) {
            if (this.timerManagerName == null) {
                throw new IllegalArgumentException("Either 'timerManager' or 'timerManagerName' must be specified");
            }
            this.timerManager = (TimerManager)this.lookup(this.timerManagerName, class$commonj$timers$TimerManager == null ? (class$commonj$timers$TimerManager = TimerManagerFactoryBean.class$("commonj.timers.TimerManager")) : class$commonj$timers$TimerManager);
        }
        for (int i = 0; i < this.scheduledTimerListeners.length; ++i) {
            ScheduledTimerListener scheduledTask = this.scheduledTimerListeners[i];
            Timer timer = null;
            timer = scheduledTask.isOneTimeTask() ? this.timerManager.schedule(scheduledTask.getTimerListener(), scheduledTask.getDelay()) : (scheduledTask.isFixedRate() ? this.timerManager.scheduleAtFixedRate(scheduledTask.getTimerListener(), scheduledTask.getDelay(), scheduledTask.getPeriod()) : this.timerManager.schedule(scheduledTask.getTimerListener(), scheduledTask.getDelay(), scheduledTask.getPeriod()));
            this.timers.add(timer);
        }
    }

    public Object getObject() {
        return this.timerManager;
    }

    public Class getObjectType() {
        return class$commonj$timers$TimerManager == null ? (class$commonj$timers$TimerManager = TimerManagerFactoryBean.class$("commonj.timers.TimerManager")) : class$commonj$timers$TimerManager;
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() {
        if (!this.shared) {
            this.timerManager.resume();
        }
    }

    public void stop() {
        if (!this.shared) {
            this.timerManager.suspend();
        }
    }

    public boolean isRunning() {
        return !this.timerManager.isSuspending() && !this.timerManager.isStopping();
    }

    public void destroy() {
        Iterator it = this.timers.iterator();
        while (it.hasNext()) {
            Timer timer = (Timer)it.next();
            try {
                timer.cancel();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not cancel CommonJ Timer", ex);
            }
        }
        this.timers.clear();
        if (!this.shared) {
            this.timerManager.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

