/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import com.j_spaces.core.client.MulticastLeaseProxy;
import com.j_spaces.core.client.MulticastTemplateContext;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.obf.dm;
import com.j_spaces.obf.fy;
import com.j_spaces.obf.mo;
import com.j_spaces.worker.multicast.MulticastCommandEntry;
import com.j_spaces.worker.multicast.MulticastConfig;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.id.UuidFactory;

public class MulticastNotifyDelegator
implements Runnable {
    public IJSpace _spaceProxy;
    public MulticastEventReceiver _multicastReceiver;
    public Thread _delegatorThread;
    public static final long DEFAULT_REPLY_TIMEOUT = 10000L;
    private static Hashtable a = new Hashtable();

    private MulticastNotifyDelegator(IJSpace iJSpace) throws RemoteException, IOException {
        Remote remote;
        if (iJSpace instanceof JSpaceClusteredProxy) {
            remote = iJSpace.getContainer();
            try {
                this._spaceProxy = remote.getSpace(iJSpace.getName(), iJSpace.isEmbedded());
            }
            catch (Exception exception) {
                throw new RemoteException("Failed to retrieve non clustered space proxy from container.", exception);
            }
        } else {
            this._spaceProxy = iJSpace instanceof DCacheSpaceImpl ? ((DCacheSpaceImpl)iJSpace).getRemoteSpace() : iJSpace;
        }
        remote = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
        SpaceConfig spaceConfig = remote.getConfig();
        String string = spaceConfig.getProperty("workers.MulticastNotifyWorker.multicast-group", "224.0.0.1");
        String string2 = spaceConfig.getProperty("workers.MulticastNotifyWorker.multicast-port", "34721");
        MulticastConfig multicastConfig = new MulticastConfig(string, string2);
        this._multicastReceiver = new MulticastEventReceiver(iJSpace.getName(), multicastConfig, null);
        this._multicastReceiver.a();
        this._delegatorThread = new Thread(this);
        this._delegatorThread.setDaemon(true);
        this._delegatorThread.setName("MulticastNotifyDelegator-" + iJSpace.getName());
        this._delegatorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MulticastNotifyDelegator getInstance(IJSpace iJSpace) throws RemoteException {
        if (iJSpace == null) {
            throw new RuntimeException("MulticastNotifyDelegator.getInstance(): null space proxy.");
        }
        MulticastNotifyDelegator multicastNotifyDelegator = (MulticastNotifyDelegator)a.get(iJSpace);
        if (multicastNotifyDelegator == null) {
            Hashtable hashtable = a;
            synchronized (hashtable) {
                multicastNotifyDelegator = (MulticastNotifyDelegator)a.get(iJSpace);
                if (multicastNotifyDelegator == null) {
                    try {
                        multicastNotifyDelegator = new MulticastNotifyDelegator(iJSpace);
                    }
                    catch (Exception exception) {
                        throw new RemoteException("Failed to initialize MulticastNotifyDelegator for " + iJSpace.getName() + " : " + exception.getMessage(), exception);
                    }
                    a.put(iJSpace, multicastNotifyDelegator);
                }
            }
        }
        return multicastNotifyDelegator;
    }

    public void run() {
        this._multicastReceiver.receiveAndNotify();
    }

    public MulticastCommandEntry getMutlicastCommandEntry(Entry entry, long l2, boolean bl2, int n2, INotifyDelegatorFilter iNotifyDelegatorFilter) throws IOException {
        MulticastCommandEntry multicastCommandEntry = new MulticastCommandEntry(MulticastCommandEntry.NOTIFY_REGISTRATION);
        multicastCommandEntry.setNotifyTemplate(entry);
        multicastCommandEntry.setNotifyMask(n2);
        multicastCommandEntry.setFifoTemplate(bl2);
        multicastCommandEntry.setSpaceUuid(this._spaceProxy.getReferentUuid());
        MarshalledObject<Serializable> marshalledObject = new MarshalledObject<MulticastCommandEntry>(multicastCommandEntry);
        String string = String.valueOf(marshalledObject.hashCode());
        multicastCommandEntry.setTemplateID(string);
        if (iNotifyDelegatorFilter != null) {
            marshalledObject = new MarshalledObject<INotifyDelegatorFilter>(iNotifyDelegatorFilter);
            String string2 = String.valueOf(marshalledObject.hashCode());
            multicastCommandEntry.setFilterID(string2);
            multicastCommandEntry.setNotifyFilter(iNotifyDelegatorFilter);
        }
        multicastCommandEntry.setTemplateLease(l2);
        multicastCommandEntry.setCommandUUID(UuidFactory.generate().toString());
        multicastCommandEntry.setNOWriteLeaseMode(false);
        return multicastCommandEntry;
    }

    public EventRegistration notify(Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2) throws TransactionException, RemoteException {
        return this.notify(entry, transaction, remoteEventListener, l2, marshalledObject, bl2, n2, null);
    }

    public EventRegistration notify(Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2, INotifyDelegatorFilter iNotifyDelegatorFilter) throws TransactionException, RemoteException {
        if (transaction != null) {
            throw new UnsupportedOperationException("MulticastNotifyDelegator doesn't support transactions.");
        }
        try {
            return this.a(entry, remoteEventListener, l2, marshalledObject, bl2, n2, iNotifyDelegatorFilter);
        }
        catch (IOException iOException) {
            if (iOException instanceof RemoteException) {
                throw (RemoteException)iOException;
            }
            throw new RemoteException("Failed to serialize " + entry.getClass() + " notify template : " + iOException.getMessage(), iOException);
        }
        catch (UnusableEntryException unusableEntryException) {
            throw new RemoteException("Failed to get confirmation reply from server : " + unusableEntryException.getMessage(), unusableEntryException);
        }
        catch (InterruptedException interruptedException) {
            throw new RemoteException("Notify operation was Interrupted : " + interruptedException.getMessage(), interruptedException);
        }
    }

    private EventRegistration a(Entry entry, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2, INotifyDelegatorFilter iNotifyDelegatorFilter) throws IOException, RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        String string = entry != null ? entry.getClass().getName() : "<null>";
        MulticastCommandEntry multicastCommandEntry = this.getMutlicastCommandEntry(entry, l2, bl2, n2, iNotifyDelegatorFilter);
        Lease lease = this._spaceProxy.write(multicastCommandEntry, null, multicastCommandEntry.getTemplateLease());
        MulticastCommandEntry multicastCommandEntry2 = MulticastCommandEntry.createCommand(MulticastCommandEntry.NOTIFY_REGISTRATION_CONFIRMATION, multicastCommandEntry.getCommandUUID());
        if ((multicastCommandEntry2 = (MulticastCommandEntry)this._spaceProxy.take(multicastCommandEntry2, null, 10000L)) == null) {
            throw new RemoteException("Failed to register notify template " + string + ". Failed to get confirmation on notify registration after " + 10000L + " ms." + "\nReason: The space : " + this._spaceProxy.getName() + " was cleaned or MulticastNotifyWorker was disabled.");
        }
        Object object = multicastCommandEntry2.getReplyObject();
        if (object instanceof Exception) {
            throw new RemoteException("Failed to register notify template : " + string, (Exception)object);
        }
        long l3 = ((EventRegistration)object).getID();
        long l4 = ((EventRegistration)object).getSequenceNumber();
        MulticastTemplateContext multicastTemplateContext = new MulticastTemplateContext(this._spaceProxy, multicastCommandEntry, remoteEventListener, marshalledObject, bl2, l4);
        MulticastLeaseProxy multicastLeaseProxy = new MulticastLeaseProxy(lease, multicastTemplateContext);
        EventRegistration eventRegistration = new EventRegistration(l3, null, multicastLeaseProxy, l4);
        multicastTemplateContext.setEventRegistration(eventRegistration);
        this._multicastReceiver.addTemplateContext(multicastTemplateContext);
        return eventRegistration;
    }

    public void close() {
        if (this._multicastReceiver != null) {
            this._multicastReceiver.close();
        }
    }

    public void finalize() {
        this.close();
    }

    public static class 1 {
    }

    private class MulticastEventReceiver
    extends fy
    implements Runnable {
        private MulticastConfig b;
        private String c;
        private Thread d;
        private mo e;
        private final Object f = new Object();
        private boolean g;
        private ConcurrentLinkedQueue h;

        private MulticastEventReceiver(String string, MulticastConfig multicastConfig) throws IOException {
            this.b = multicastConfig;
            this.c = "MulticastNotifyDelegatorReceiver-" + string + "-" + this.b.getIpGroup() + ":" + this.b.getMulticastPort();
            this.h = new ConcurrentLinkedQueue();
            this.e = new mo(this.c, multicastConfig);
        }

        public void a() {
            if (this.d == null) {
                this.d = new Thread(this);
                this.d.setDaemon(true);
                this.d.setName(this.c);
                this.d.start();
            }
        }

        public void run() {
            while (!this.shouldShutdown()) {
                try {
                    byte[] byArray = this.e.e();
                    boolean bl2 = this.enqueueEvent(byArray);
                    if (!bl2) continue;
                    this.b();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void b() {
            MulticastEventReceiver multicastEventReceiver = this;
            synchronized (multicastEventReceiver) {
                this.g = true;
                this.notifyAll();
            }
        }

        public void receiveAndNotify() {
            while (!this.shouldShutdown()) {
                Iterator iterator = this.h.iterator();
                while (iterator.hasNext()) {
                    MulticastTemplateContext multicastTemplateContext = (MulticastTemplateContext)iterator.next();
                    multicastTemplateContext.notifyEvents();
                }
                this.waitForEvents();
            }
        }

        public synchronized void waitForEvents() {
            try {
                while (!this.g && !this.shouldShutdown()) {
                    MulticastNotifyDelegator.this._multicastReceiver.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.g = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTemplateContext(MulticastTemplateContext multicastTemplateContext) throws IOException {
            Object object = this.f;
            synchronized (object) {
                if (this.h.isEmpty()) {
                    this.e.a();
                }
                this.h.add((Object)multicastTemplateContext);
            }
        }

        public boolean enqueueEvent(byte[] byArray) throws Exception {
            boolean bl2 = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n2 = dataInputStream.readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = dataInputStream.readInt();
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (this.h.isEmpty()) {
                        return bl2;
                    }
                    String string = dataInputStream.readUTF();
                    int n4 = dataInputStream.readInt();
                    Object object = null;
                    Iterator iterator = this.h.iterator();
                    while (iterator.hasNext()) {
                        MulticastTemplateContext multicastTemplateContext = (MulticastTemplateContext)iterator.next();
                        try {
                            if (!multicastTemplateContext.isValid(string)) continue;
                            if (object == null) {
                                byte[] byArray2 = new byte[n4];
                                dataInputStream.read(byArray2);
                                object = dm.b(byArray2);
                            }
                            multicastTemplateContext.addEvent(object);
                            bl2 = true;
                        }
                        catch (UnknownLeaseException unknownLeaseException) {
                            iterator.remove();
                        }
                    }
                    if (object == null) {
                        dataInputStream.skip(n4);
                    }
                    this.c();
                }
            }
            dataInputStream.close();
            return bl2;
        }

        private boolean c() {
            if (this.h.isEmpty()) {
                this.e.b();
                return true;
            }
            return false;
        }

        public void close() {
            this.requestShutdown();
            this.b();
            this.e.d();
            if (this.h != null) {
                Iterator iterator = this.h.iterator();
                while (iterator.hasNext()) {
                    MulticastTemplateContext multicastTemplateContext = (MulticastTemplateContext)iterator.next();
                    try {
                        multicastTemplateContext.eventRegistration.getLease().cancel();
                    }
                    catch (Exception exception) {}
                }
                this.h = null;
            }
            this.d = null;
        }

        public void waitWhileFinish() {
        }

        public /* synthetic */ MulticastEventReceiver(String string, MulticastConfig multicastConfig, 1 var4_4) throws IOException {
            this(string, multicastConfig);
        }
    }
}

