/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLValidationException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpaceURLValidator {
    private static final Logger a = Logger.getLogger("com.gigaspaces.client");
    private static final String b = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String c = "http://www.w3.org/2001/XMLSchema";
    private static final String d = "spaceUrlXML-Schema.xsd";
    private static final String e = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static String f = "space-url-attributes";

    public static String[] getClusterMembers(String string) {
        return string.trim().split(",");
    }

    public static void validateClusterSchemaAttributes(SpaceURL spaceURL) throws MalformedURLException {
        if (spaceURL.containsKey("cluster_schema") && !spaceURL.containsKey("total_members")) {
            throw new MalformedURLException("The <cluster_schema> attribute must be used together with the <total_members> attribute in the space URL: " + spaceURL);
        }
        if (spaceURL.containsKey("total_members") && !spaceURL.containsKey("cluster_schema")) {
            throw new MalformedURLException("The <total_members> attribute must be used together with the <cluster_schema> attribute in the space URL: " + spaceURL);
        }
        if (spaceURL.containsKey("cluster_schema") && spaceURL.containsKey("total_members")) {
            if (!spaceURL.containsKey("id")) {
                throw new MalformedURLException("The <cluster_schema=" + spaceURL.getProperty("cluster_schema") + "> attribute must be used together with the <" + "id" + "> attribute in the space URL: " + spaceURL);
            }
            String string = spaceURL.getProperty("cluster_schema");
            String string2 = spaceURL.getProperty("total_members");
            String[] stringArray = SpaceURLValidator.getClusterMembers(string2);
            int n2 = 0;
            int n3 = 0;
            if (stringArray.length > 1) {
                if (string.equalsIgnoreCase("partitioned-sync2backup") || string.equalsIgnoreCase("primary_backup")) {
                    try {
                        n2 = Integer.valueOf(stringArray[0]);
                        n3 = Integer.valueOf(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MalformedURLException("The <cluster_schema=" + string + "> attribute must be used together with the <" + "total_members" + "> attribute in the following format " + " total_members={number of primary instances, number of backup instances per primary} " + "in the space URL: " + spaceURL);
                    }
                }
            } else if (string.equalsIgnoreCase("partitioned-sync2backup") || string.equalsIgnoreCase("primary_backup")) {
                throw new MalformedURLException("The <cluster_schema=" + string + "> attribute must be used together with the <" + "total_members" + "> attribute in the following format " + " total_members={number of primary instances, number of backup instances per primary} " + "in the space URL: " + spaceURL);
            }
        }
    }

    public static void validate(SpaceURL spaceURL) throws Exception {
        try {
            if (a.isLoggable(Level.FINE)) {
                a.fine("attributesSpaceUrl  =  " + spaceURL);
            }
            Document document = SpaceURLValidator.a(spaceURL);
        }
        catch (SAXException sAXException) {
            String string = sAXException.getMessage();
            StringBuffer stringBuffer = new StringBuffer("Space url validation :: ");
            if (string.indexOf("cvc-complex-type") != -1) {
                string = stringBuffer.append(string.substring(string.lastIndexOf(58) + 1)).toString();
                string = string.replaceAll(", " + "ignoreValidation".toLowerCase(), "");
            } else if (string.indexOf("cvc-datatype-valid") != -1) {
                Enumeration<?> enumeration = spaceURL.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = spaceURL.getProperty(string2);
                    if (string3 == null || string.indexOf(string3) == -1) continue;
                    stringBuffer.append(string2 + " =");
                }
                string = stringBuffer.append(string.substring(string.lastIndexOf(58) + 1)).toString();
            }
            if (a.isLoggable(Level.FINE)) {
                a.fine(sAXException.toString());
            }
            throw new SpaceURLValidationException(string);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException) {
                if (a.isLoggable(Level.FINE)) {
                    a.fine("The DocumentBuilder implementation is from type org.apache.crimson.jaxp.DocumentBuilderFactoryImpl. Please add the xercesImpl.jar into the classpath.");
                }
            }
            throw exception;
        }
    }

    private static Document a(SpaceURL spaceURL) throws ParserConfigurationException, SAXException, IOException {
        Object object;
        Object object2;
        Object object3;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        URL uRL = ResourceLoader.getResourceURL(d);
        if (a.isLoggable(Level.FINE)) {
            a.fine("The schema file is   " + uRL);
        }
        documentBuilderFactory.setAttribute(b, c);
        if (uRL == null) {
            throw new SpaceURLValidationException("Could not find schema file <spaceUrlXML-Schema.xsd>, please check your classpath.");
        }
        documentBuilderFactory.setAttribute(e, uRL.toString());
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new DefaultErrorHandler(null));
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(f);
        document.appendChild(element);
        Enumeration<?> enumeration = spaceURL.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object4;
            object3 = (String)enumeration.nextElement();
            if (a.isLoggable(Level.FINEST)) {
                a.finest("SpaceURLValidator - token " + (String)object3);
            }
            object2 = document.createElement((String)object3);
            element.appendChild((Node)object2);
            object = spaceURL.getProperty((String)object3);
            if (object == null || ((String)object).trim().equals("")) continue;
            Element element2 = null;
            if (a.isLoggable(Level.FINEST)) {
                a.finest("SpaceURLValidator - value valueToken = " + (String)object);
            }
            if (((String)object3).equalsIgnoreCase("url")) {
                element2 = document.createElement((String)object3 + "_value");
                object = ((String)object).replaceAll("&", "&amp;");
                if (a.isLoggable(Level.FINEST)) {
                    a.finest("SpaceURLValidator - replaced '&' chars in valueToken  = " + (String)object);
                }
                object4 = document.createTextNode((String)object);
                element2.appendChild((Node)object4);
                object2.appendChild(element2);
                continue;
            }
            if (((String)object3).equalsIgnoreCase("host") || ((String)object3).equalsIgnoreCase("locators")) {
                element2 = document.createElement((String)object3 + "_value");
                if (a.isLoggable(Level.FINEST)) {
                    a.finest("SpaceURLValidator - token" + (String)object3 + " value= " + (String)object);
                }
                object4 = document.createTextNode((String)object);
                element2.appendChild((Node)object4);
                object2.appendChild(element2);
                continue;
            }
            object4 = new StringTokenizer((String)object, ",");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                element2 = document.createElement((String)object3 + "_value");
                String string = ((StringTokenizer)object4).nextToken();
                if (a.isLoggable(Level.FINEST)) {
                    a.finest("SpaceURLValidator - value= " + string);
                }
                Text text = document.createTextNode(string);
                element2.appendChild(text);
                object2.appendChild(element2);
            }
        }
        object3 = new ByteArrayOutputStream();
        JSpaceUtilities.domWriter(document.getFirstChild(), new PrintStream((OutputStream)object3), "");
        ((OutputStream)object3).flush();
        ((ByteArrayOutputStream)object3).close();
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        if (a.isLoggable(Level.FINEST)) {
            a.finest("SpaceURLValidator - " + new String((byte[])object2));
        }
        if (object2 != null) {
            object = new ByteArrayInputStream((byte[])object2);
            documentBuilder.parse((InputStream)object);
        }
        return document;
    }

    public static void main(String[] stringArray) {
        System.setProperty("com.client.validate.debug", "true");
        String string = "./mySpace?cluster_schema=partitioned-sync2backup&id=2,3&total_members=1,3w";
        SpaceURL spaceURL = new SpaceURL();
        spaceURL.put("cluster_schema", "partitioned-sync2backup");
        spaceURL.put("id", "2");
        spaceURL.put("total_members", "1,2");
        try {
            SpaceURLValidator spaceURLValidator = new SpaceURLValidator();
            SpaceURLValidator.validate(spaceURL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class 1 {
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        private String a(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.err.println("Warning: " + this.a(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.a(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.a(sAXParseException);
            throw new SAXException(string);
        }

        public /* synthetic */ DefaultErrorHandler(1 var1_1) {
            this();
        }
    }
}

