/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.exception.SpaceStoppedException;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.RefreshPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceID;

public class SpacesViewPanel
extends JPanel
implements ActionListener,
IRefreshable {
    private final SpaceBrowser _spaceBrowser;
    private final SpaceViewTableModel _spacesViewTableModel;
    private final JTable _spacesViewTable;
    private static final int CI_SPACE_NAME = 0;
    private static final int CI_CONTAINER_NAME = 1;
    private static final int CI_ENTRIES_COUNT = 2;
    private static final int CI_HOST_NAME = 3;
    private static final int CI_JINI_GROUP = 4;
    private static final int CI_SCHEMA_NAME = 5;
    private static final int CI_PERSISTENT = 6;
    private static final int CI_CLUSTERED = 7;
    private JPopupMenu spaceManagementPopupMenu;
    private JMenuItem classesMenuItem;
    private JMenuItem transactionsMenuItem;
    private JMenuItem queryMenuItem;
    private JMenuItem statisticsMenuItem;
    private JMenuItem benchmarkMenuItem;
    private JMenuItem usersMenuItem;
    private JMenuItem selMemberNameMenuItem;
    private RefreshPanel refreshPanel;
    private ColumnSortListener _columnSortListener;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    private static final String JINI_GROUP_BLANK_VALUE = "-";
    private static final String COUNT_BLANK_VALUE = "-";
    static /* synthetic */ Class class$com$j_spaces$core$exception$SpaceStoppedException;
    static /* synthetic */ Class class$com$j_spaces$core$exception$SpaceConfigurationException;

    public SpacesViewPanel(SpaceBrowser spaceBrowser) {
        this._spaceBrowser = spaceBrowser;
        this.setLayout(new BorderLayout());
        this._spacesViewTableModel = new SpaceViewTableModel(null);
        this._spacesViewTable = new JTable(this._spacesViewTableModel);
        this.refreshPanel = new RefreshPanel(this, true);
        JScrollPane jScrollPane = new JScrollPane(this._spacesViewTable);
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        this.add((Component)this.refreshPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this._columnSortListener = new ColumnSortListener(this._spacesViewTable, this._spacesViewTableModel);
        JTableHeader jTableHeader = this._spacesViewTable.getTableHeader();
        jTableHeader.addMouseListener(this._columnSortListener);
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(6);
        TableColumn tableColumn2 = tableColumnModel.getColumn(7);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        int n2 = 65;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn2.setPreferredWidth(n2);
        tableColumn2.setMaxWidth(n2);
        tableColumn3.setPreferredWidth(85);
        tableColumn3.setMaxWidth(85);
        jTableHeader.setReorderingAllowed(false);
        this._spacesViewTable.setAutoCreateColumnsFromModel(false);
        this._spacesViewTable.setSelectionMode(0);
        this._spacesViewTable.setAutoResizeMode(1);
        this._spacesViewTable.setAutoscrolls(true);
        this.addMouseListenerToTable();
        this.createPopupMenu();
    }

    private void addMouseListenerToTable() {
        this._spacesViewTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2 = SpacesViewPanel.this._spacesViewTable.getSelectedRow();
                    SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(n2);
                    ServiceID serviceID = spaceViewWrapper.getServiceID();
                    SpacesViewPanel.this._spaceBrowser.selectSpaceOperationNode(serviceID, null);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n2 = mouseEvent.getX();
                    int n3 = mouseEvent.getY();
                    int n4 = SpacesViewPanel.this._spacesViewTable.rowAtPoint(new Point(n2, n3));
                    SpacesViewPanel.this._spacesViewTable.setRowSelectionInterval(n4, n4);
                    if (n4 >= 0) {
                        SpaceViewWrapper spaceViewWrapper = SpacesViewPanel.this._spacesViewTableModel.getWrapperAt(n4);
                        String string = spaceViewWrapper.getContainerName();
                        String string2 = spaceViewWrapper.getSpaceName();
                        SpacesViewPanel.this.selMemberNameMenuItem.setText(string + ":" + string2);
                        SpacesViewPanel.this.spaceManagementPopupMenu.show(SpacesViewPanel.this._spacesViewTable, n2, n3);
                    }
                }
            }
        });
    }

    private void createPopupMenu() {
        this.spaceManagementPopupMenu = new JPopupMenu();
        this.selMemberNameMenuItem = new JMenuItem();
        this.classesMenuItem = new JMenuItem("Classes");
        this.transactionsMenuItem = new JMenuItem("Transactions");
        this.queryMenuItem = new JMenuItem("Query");
        this.statisticsMenuItem = new JMenuItem("Statistics");
        this.benchmarkMenuItem = new JMenuItem("Benchmark");
        this.usersMenuItem = new JMenuItem("Users");
        Font font = this.selMemberNameMenuItem.getFont();
        this.selMemberNameMenuItem.setFont(font.deriveFont(1));
        this.selMemberNameMenuItem.addActionListener(this);
        this.classesMenuItem.addActionListener(this);
        this.queryMenuItem.addActionListener(this);
        this.transactionsMenuItem.addActionListener(this);
        this.statisticsMenuItem.addActionListener(this);
        this.benchmarkMenuItem.addActionListener(this);
        this.usersMenuItem.addActionListener(this);
        this.spaceManagementPopupMenu.add(this.selMemberNameMenuItem);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(this.classesMenuItem);
        this.spaceManagementPopupMenu.add(this.transactionsMenuItem);
        this.spaceManagementPopupMenu.add(this.queryMenuItem);
        this.spaceManagementPopupMenu.add(this.statisticsMenuItem);
        this.spaceManagementPopupMenu.add(this.benchmarkMenuItem);
        this.spaceManagementPopupMenu.add(this.usersMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n2 = this._spacesViewTable.getSelectedRow();
        SpaceViewWrapper spaceViewWrapper = this._spacesViewTableModel.getWrapperAt(n2);
        ServiceID serviceID = spaceViewWrapper.getServiceID();
        this._spaceBrowser.selectSpaceOperationNode(serviceID, object == this.selMemberNameMenuItem ? null : ((JMenuItem)object).getText());
    }

    public void addSpace(IJSpace iJSpace, IRemoteJSpaceAdmin iRemoteJSpaceAdmin, ServiceID serviceID, SpaceConfig spaceConfig, ContainerConfig containerConfig) {
        Object object;
        String string = spaceConfig.getSpaceName();
        String string2 = spaceConfig.getSchemaName();
        boolean bl2 = spaceConfig.isClustered();
        boolean bl3 = spaceConfig.isPersistent();
        String string3 = containerConfig.containerName;
        String string4 = containerConfig.containerHostName;
        String string5 = "-";
        String string6 = "-";
        try {
            string5 = JSpaceUtilities.getJiniGroupRepresentation(iRemoteJSpaceAdmin);
            object = iRemoteJSpaceAdmin.getRuntimeInfo();
            string6 = SpacesViewPanel.count((SpaceRuntimeInfo)object);
        }
        catch (RemoteException remoteException) {
            Class<?> clazz = class$com$j_spaces$core$exception$SpaceConfigurationException;
            if (clazz == null) {
                clazz = class$com$j_spaces$core$exception$SpaceConfigurationException = new SpaceConfigurationException[0].getClass().getComponentType();
            }
            if (JSpaceUtilities.getCauseExceptionMessageFromHierarchy(remoteException, clazz) == null) {
                Class<?> clazz2 = class$com$j_spaces$core$exception$SpaceStoppedException;
                if (clazz2 == null) {
                    clazz2 = class$com$j_spaces$core$exception$SpaceStoppedException = new SpaceStoppedException[0].getClass().getComponentType();
                }
                if (JSpaceUtilities.getCauseExceptionMessageFromHierarchy(remoteException, clazz2) != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, remoteException.toString(), remoteException);
                    }
                } else {
                    SpaceBrowser.showException(remoteException.toString(), remoteException);
                }
            }
            this._spaceBrowser.debug(remoteException);
        }
        object = new SpaceViewWrapper(iRemoteJSpaceAdmin, serviceID, string, string3, string4, string5, string2, bl2, bl3, string6);
        this._spacesViewTableModel.addSpaceWrapper((SpaceViewWrapper)object);
        this._columnSortListener.sortAllRows();
    }

    private static String count(SpaceRuntimeInfo spaceRuntimeInfo) {
        long l2 = 0L;
        for (int i2 = 0; i2 < spaceRuntimeInfo.m_NumOFEntries.size(); ++i2) {
            l2 += (long)((Integer)spaceRuntimeInfo.m_NumOFEntries.get(i2)).intValue();
        }
        return String.valueOf(l2);
    }

    public void removeSpace(ServiceID serviceID) {
        this._spacesViewTableModel.removeSpace(serviceID);
    }

    public void refresh() {
        this._spacesViewTableModel.reload();
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
    }

    public void stop() {
    }

    private class ColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private SpaceViewTableModel _tableModel;
        private TableColumnModel _columnModel;

        public ColumnSortListener(JTable jTable, SpaceViewTableModel spaceViewTableModel) {
            this._table = jTable;
            this._tableModel = spaceViewTableModel;
            this._columnModel = this._table.getColumnModel();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(mouseEvent.getX());
            this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
            this._ascending = !this._ascending;
        }

        private void sortAllRowsBy(int n2, boolean bl2) {
            int n3 = this._table.getSelectedRow();
            SpaceViewWrapper spaceViewWrapper = null;
            if (n3 >= 0) {
                spaceViewWrapper = this._tableModel.getWrapperAt(n3);
            }
            Collections.sort(this._tableModel.getWrappersList(), new ColumnSorter(n2, bl2));
            this._tableModel.fireTableStructureChanged();
            this.selectTableRow(spaceViewWrapper);
        }

        public void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(SpaceViewWrapper spaceViewWrapper) {
            ServiceID serviceID;
            int n2;
            if (spaceViewWrapper != null && (n2 = this._tableModel.getWrapperIndex(serviceID = spaceViewWrapper.getServiceID())) != -1) {
                this._table.setRowSelectionInterval(n2, n2);
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int n2, boolean bl2) {
                this.colIndex = n2;
                this.ascending = bl2;
            }

            public int compare(Object object, Object object2) {
                SpaceViewWrapper spaceViewWrapper = (SpaceViewWrapper)object;
                SpaceViewWrapper spaceViewWrapper2 = (SpaceViewWrapper)object2;
                String string = SpacesViewPanel.this._spacesViewTableModel.getCellValue(spaceViewWrapper, this.colIndex);
                String string2 = SpacesViewPanel.this._spacesViewTableModel.getCellValue(spaceViewWrapper2, this.colIndex);
                if (this.colIndex == 2) {
                    long l2 = 0L;
                    long l3 = 0L;
                    try {
                        l2 = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.ascending ? -1 : 1;
                    }
                    try {
                        l3 = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.ascending ? 1 : -1;
                    }
                    if (this.ascending) {
                        return l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
                    }
                    return l3 < l2 ? -1 : (l3 == l2 ? 0 : 1);
                }
                if (this.ascending) {
                    return string.compareTo(string2);
                }
                return string2.compareTo(string);
            }
        }
    }

    private class SpaceViewWrapper {
        private IRemoteJSpaceAdmin _spaceAdmin;
        private ServiceID _serviceID;
        private String _spaceName;
        private String _containerName;
        private String _hostName;
        private String _jiniGroup;
        private String _schemaName;
        private String _persistent;
        private String _clustered;
        private String _entriesCount;
        private static final String YES_VAL = "Yes";
        private static final String NO_VAL = "No";
        static /* synthetic */ Class class$com$j_spaces$core$exception$SpaceUnavailableException;
        static /* synthetic */ Class class$com$j_spaces$core$exception$SpaceStoppedException;

        public SpaceViewWrapper(IRemoteJSpaceAdmin iRemoteJSpaceAdmin, ServiceID serviceID, String string, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, String string6) {
            this._containerName = string2;
            this._hostName = string3;
            this._jiniGroup = string4;
            this._schemaName = string5;
            this._serviceID = serviceID;
            this._spaceAdmin = iRemoteJSpaceAdmin;
            this._spaceName = string;
            this._clustered = bl2 ? YES_VAL : NO_VAL;
            this._persistent = bl3 ? YES_VAL : NO_VAL;
            this._entriesCount = string6;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public String getHostName() {
            return this._hostName;
        }

        public String getJiniGroup() {
            return this._jiniGroup;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public ServiceID getServiceID() {
            return this._serviceID;
        }

        public String getSpaceName() {
            return this._spaceName;
        }

        public String getClustered() {
            return this._clustered;
        }

        public String getPersistent() {
            return this._persistent;
        }

        public String getEntriesCount() {
            return this._entriesCount;
        }

        public void reload() {
            block13: {
                try {
                    SpaceRuntimeInfo spaceRuntimeInfo = this._spaceAdmin.getRuntimeInfo();
                    this._entriesCount = SpacesViewPanel.count(spaceRuntimeInfo);
                }
                catch (ConnectException connectException) {
                    this._entriesCount = "-";
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.log(Level.INFO, "Space \"" + this._spaceName + "\" is not available. " + connectException.toString());
                    }
                }
                catch (ConnectIOException connectIOException) {
                    this._entriesCount = "-";
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.log(Level.INFO, "Space \"" + this._spaceName + "\" is not available. " + connectIOException.toString());
                    }
                }
                catch (Exception exception) {
                    block15: {
                        block14: {
                            this._entriesCount = "-";
                            if (exception instanceof NoSuchObjectException) break block14;
                            Class<?> clazz = class$com$j_spaces$core$exception$SpaceUnavailableException;
                            if (clazz == null) {
                                clazz = class$com$j_spaces$core$exception$SpaceUnavailableException = new SpaceUnavailableException[0].getClass().getComponentType();
                            }
                            if (JSpaceUtilities.getCauseExceptionMessageFromHierarchy(exception, clazz) == null) break block15;
                        }
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("Space \"" + this._spaceName + "\" is not available." + " Shutdown or other abort operation in process.");
                        }
                    }
                    Class<?> clazz = class$com$j_spaces$core$exception$SpaceStoppedException;
                    if (clazz == null) {
                        clazz = class$com$j_spaces$core$exception$SpaceStoppedException = new SpaceStoppedException[0].getClass().getComponentType();
                    }
                    if (JSpaceUtilities.getCauseExceptionMessageFromHierarchy(exception, clazz) != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                    }
                    if (!_logger.isLoggable(Level.SEVERE)) break block13;
                    _logger.log(Level.SEVERE, "Exception while trying to retrieve runtime information from space \"" + this._spaceName + "\"." + exception.toString(), exception);
                }
            }
        }
    }

    private class SpaceViewTableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{"Name", "Container Name", "Count", "Host Name", "Jini Group", "Schema Name", "Persistent", "Clustered"};
        private List _wrappersList = Collections.synchronizedList(new ArrayList());
        private Map wrappersMap = new HashMap();

        private SpaceViewTableModel() {
        }

        public void addSpaceWrapper(SpaceViewWrapper spaceViewWrapper) {
            ServiceID serviceID = spaceViewWrapper.getServiceID();
            if (!this.wrappersMap.containsKey(serviceID)) {
                this.wrappersMap.put(serviceID, spaceViewWrapper);
                this._wrappersList.add(spaceViewWrapper);
                this.fireTableRowsInserted(this._wrappersList.size(), this._wrappersList.size());
            }
        }

        public void removeSpace(ServiceID serviceID) {
            SpaceViewWrapper spaceViewWrapper = (SpaceViewWrapper)this.wrappersMap.remove(serviceID);
            int n2 = this._wrappersList.indexOf(spaceViewWrapper);
            this._wrappersList.remove(spaceViewWrapper);
            this.fireTableRowsDeleted(n2, n2);
        }

        public SpaceViewWrapper getWrapper(ServiceID serviceID) {
            return (SpaceViewWrapper)this.wrappersMap.get(serviceID);
        }

        public int getWrapperIndex(ServiceID serviceID) {
            SpaceViewWrapper spaceViewWrapper = this.getWrapper(serviceID);
            if (spaceViewWrapper != null) {
                return this._wrappersList.indexOf(spaceViewWrapper);
            }
            return -1;
        }

        public Object getValueAt(int n2, int n3) {
            SpaceViewWrapper spaceViewWrapper = (SpaceViewWrapper)this._wrappersList.get(n2);
            if (spaceViewWrapper != null) {
                return this.getCellValue(spaceViewWrapper, n3);
            }
            return null;
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public Class getColumnClass(int n2) {
            Object object = this.getValueAt(0, n2);
            if (object != null) {
                return object.getClass();
            }
            return null;
        }

        public int getRowCount() {
            return this._wrappersList == null ? 0 : this._wrappersList.size();
        }

        public List getWrappersList() {
            return this._wrappersList;
        }

        public SpaceViewWrapper getWrapperAt(int n2) {
            return (SpaceViewWrapper)this._wrappersList.get(n2);
        }

        public String getCellValue(SpaceViewWrapper spaceViewWrapper, int n2) {
            switch (n2) {
                case 0: {
                    return spaceViewWrapper.getSpaceName();
                }
                case 1: {
                    return spaceViewWrapper.getContainerName();
                }
                case 3: {
                    return spaceViewWrapper.getHostName();
                }
                case 4: {
                    return spaceViewWrapper.getJiniGroup();
                }
                case 5: {
                    return spaceViewWrapper.getSchemaName();
                }
                case 6: {
                    return spaceViewWrapper.getPersistent();
                }
                case 7: {
                    return spaceViewWrapper.getClustered();
                }
                case 2: {
                    return spaceViewWrapper.getEntriesCount();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            List list = this._wrappersList;
            synchronized (list) {
                Iterator iterator = this._wrappersList.iterator();
                while (iterator.hasNext()) {
                    SpaceViewWrapper spaceViewWrapper = (SpaceViewWrapper)iterator.next();
                    spaceViewWrapper.reload();
                }
            }
        }

        public /* synthetic */ SpaceViewTableModel(1 var2_2) {
            this();
        }
    }
}

