/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import com.j_spaces.obf.li;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ColorMap {
    public static final Color COLOR_READ_DEFAULT = Color.RED;
    public static final Color COLOR_WRITE_DEFAULT = Color.GREEN;
    public static final Color COLOR_UPDATE_DEFAULT = Color.BLUE;
    public static final Color COLOR_TAKE_DEFAULT = new Color(243, 165, 252);
    public static final Color COLOR_NOTIFY_REGISTRATION_DEFAULT = Color.ORANGE;
    public static final Color COLOR_NOTIFY_SENT_DEFAULT = new Color(90, 37, 80);
    public static final Color COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT = new Color(46, 82, 46);
    public static final String COLOR_READ_STR = "Read";
    public static final String COLOR_WRITE_STR = "Write";
    public static final String COLOR_UPDATE_STR = "Update";
    public static final String COLOR_TAKE_STR = "Take";
    public static final String COLOR_NOTIFY_REGISTRATION_STR = "Notify registration";
    public static final String COLOR_NOTIFY_SENT_STR = "Notify sent";
    public static final String COLOR_NOTIFY_ACKNOWLEDGED_STR = "Notify ack.";
    private static ColorMap instance = new ColorMap();
    private static Properties browserProperties = new Properties();
    private Color colorRead = COLOR_READ_DEFAULT;
    private Color colorWrite = COLOR_WRITE_DEFAULT;
    private Color colorUpdate = COLOR_UPDATE_DEFAULT;
    private Color colorNotifyRegistration = COLOR_NOTIFY_REGISTRATION_DEFAULT;
    private Color colorNotifySent = COLOR_NOTIFY_SENT_DEFAULT;
    private Color colorNotifyAcknowledged = COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT;
    private Color colorTake = COLOR_TAKE_DEFAULT;
    private Map nameMapping = null;
    private Map colorMapping = new HashMap();
    public static final String COLORS_FILE = "gsbrowser.config";

    public static ColorMap instance() {
        return instance;
    }

    private ColorMap() {
        this.nameMapping = new HashMap();
        this.updateColorMapping();
        this.updateNameMapping();
        try {
            String string = li.a() + COLORS_FILE;
            this.doLoad(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public Map getNameMapping() {
        return this.nameMapping;
    }

    public Map getColorMapping() {
        return this.colorMapping;
    }

    private void updateNameMapping() {
        this.nameMapping.clear();
        this.nameMapping.put(this.colorRead, COLOR_READ_STR);
        this.nameMapping.put(this.colorWrite, COLOR_WRITE_STR);
        this.nameMapping.put(this.colorUpdate, COLOR_UPDATE_STR);
        this.nameMapping.put(this.colorTake, COLOR_TAKE_STR);
        this.nameMapping.put(this.colorNotifyRegistration, COLOR_NOTIFY_REGISTRATION_STR);
        this.nameMapping.put(this.colorNotifySent, COLOR_NOTIFY_SENT_STR);
        this.nameMapping.put(this.colorNotifyAcknowledged, COLOR_NOTIFY_ACKNOWLEDGED_STR);
    }

    private void updateColorMapping() {
        this.colorMapping.put(COLOR_READ_STR, this.colorRead);
        this.colorMapping.put(COLOR_WRITE_STR, this.colorWrite);
        this.colorMapping.put(COLOR_UPDATE_STR, this.colorUpdate);
        this.colorMapping.put(COLOR_TAKE_STR, this.colorTake);
        this.colorMapping.put(COLOR_NOTIFY_REGISTRATION_STR, this.colorNotifyRegistration);
        this.colorMapping.put(COLOR_NOTIFY_SENT_STR, this.colorNotifySent);
        this.colorMapping.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, this.colorNotifyAcknowledged);
    }

    public void doSave(OutputStream outputStream, String string) {
        this.updateVars();
        Properties properties = new Properties();
        properties.put(COLOR_READ_STR, "" + this.colorRead.getRGB());
        properties.put(COLOR_WRITE_STR, "" + this.colorWrite.getRGB());
        properties.put(COLOR_UPDATE_STR, "" + this.colorUpdate.getRGB());
        properties.put(COLOR_NOTIFY_REGISTRATION_STR, "" + this.colorNotifyRegistration.getRGB());
        properties.put(COLOR_NOTIFY_SENT_STR, "" + this.colorNotifySent.getRGB());
        properties.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, "" + this.colorNotifyAcknowledged.getRGB());
        properties.put(COLOR_TAKE_STR, "" + this.colorTake.getRGB());
        browserProperties = properties;
        try {
            properties.store(outputStream, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put(COLOR_READ_STR, "" + this.colorRead.getRGB());
        properties.put(COLOR_WRITE_STR, "" + this.colorWrite.getRGB());
        properties.put(COLOR_UPDATE_STR, "" + this.colorUpdate.getRGB());
        properties.put(COLOR_NOTIFY_REGISTRATION_STR, "" + this.colorNotifyRegistration.getRGB());
        properties.put(COLOR_NOTIFY_SENT_STR, "" + this.colorNotifySent.getRGB());
        properties.put(COLOR_NOTIFY_ACKNOWLEDGED_STR, "" + this.colorNotifyAcknowledged.getRGB());
        properties.put(COLOR_TAKE_STR, "" + this.colorTake.getRGB());
        return properties;
    }

    private void updateVars() {
        this.colorRead = (Color)this.colorMapping.get(COLOR_READ_STR);
        this.colorWrite = (Color)this.colorMapping.get(COLOR_WRITE_STR);
        this.colorUpdate = (Color)this.colorMapping.get(COLOR_UPDATE_STR);
        this.colorNotifyRegistration = (Color)this.colorMapping.get(COLOR_NOTIFY_REGISTRATION_STR);
        this.colorNotifySent = (Color)this.colorMapping.get(COLOR_NOTIFY_SENT_STR);
        this.colorNotifyAcknowledged = (Color)this.colorMapping.get(COLOR_NOTIFY_ACKNOWLEDGED_STR);
        this.colorTake = (Color)this.colorMapping.get(COLOR_TAKE_STR);
    }

    public void doLoad(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.colorRead = new Color(Integer.parseInt((String)properties.get(COLOR_READ_STR)));
            this.colorWrite = new Color(Integer.parseInt((String)properties.get(COLOR_WRITE_STR)));
            this.colorUpdate = new Color(Integer.parseInt((String)properties.get(COLOR_UPDATE_STR)));
            String string = (String)properties.get(COLOR_NOTIFY_REGISTRATION_STR);
            this.colorNotifyRegistration = string != null ? new Color(Integer.parseInt(string)) : COLOR_NOTIFY_REGISTRATION_DEFAULT;
            String string2 = (String)properties.get(COLOR_NOTIFY_SENT_STR);
            this.colorNotifySent = string2 != null ? new Color(Integer.parseInt(string2)) : COLOR_NOTIFY_SENT_DEFAULT;
            String string3 = (String)properties.get(COLOR_NOTIFY_ACKNOWLEDGED_STR);
            this.colorNotifyAcknowledged = string3 != null ? new Color(Integer.parseInt(string3)) : COLOR_NOTIFY_ACKNOWLEDGED_DEFAULT;
            this.colorTake = new Color(Integer.parseInt((String)properties.get(COLOR_TAKE_STR)));
            this.updateColorMapping();
            this.updateNameMapping();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

