/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.apache.commons.gs.beans.IntrospectionException;
import org.apache.commons.gs.beans.PropertyDescriptor;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Class mappedPropertyType;
    private Method mappedReadMethod;
    private Method mappedWriteMethod;
    private static final Class[] stringClassArray;
    private static Hashtable declaredMethodCache;
    static /* synthetic */ Class class$java$lang$String;

    public MappedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string + " on class: " + clazz.getClass().getName());
        }
        this.setName(string);
        String string2 = MappedPropertyDescriptor.capitalizePropertyName(string);
        try {
            this.mappedReadMethod = MappedPropertyDescriptor.findMethod(clazz, "get" + string2, 1, stringClassArray);
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            classArray[1] = this.mappedReadMethod.getReturnType();
            Class[] classArray2 = classArray;
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, "set" + string2, 2, classArray2);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (this.mappedReadMethod == null) {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, "set" + string2, 2);
        }
        if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + string + "' not found on " + clazz.getName());
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = MappedPropertyDescriptor.findMethod(clazz, string2, 1, stringClassArray);
        if (this.mappedReadMethod != null) {
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            classArray[1] = this.mappedReadMethod.getReturnType();
            Class[] classArray2 = classArray;
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, string3, 2, classArray2);
        } else {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(clazz, string3, 2);
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string, method, method2);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = method;
        this.mappedWriteMethod = method2;
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return this.mappedPropertyType;
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethod;
    }

    public void setMappedReadMethod(Method method) throws IntrospectionException {
        this.mappedReadMethod = method;
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethod;
    }

    public void setMappedWriteMethod(Method method) throws IntrospectionException {
        this.mappedWriteMethod = method;
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        this.mappedPropertyType = null;
        if (this.mappedReadMethod != null) {
            if (this.mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            this.mappedPropertyType = this.mappedReadMethod.getReturnType();
            if (this.mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
            }
        }
        if (this.mappedWriteMethod != null) {
            Class<?>[] classArray = this.mappedWriteMethod.getParameterTypes();
            if (classArray.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (this.mappedPropertyType != null && this.mappedPropertyType != classArray[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            this.mappedPropertyType = classArray[1];
        }
    }

    private static String capitalizePropertyName(String string) {
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        final Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return clazz2.getDeclaredMethods();
                }
                catch (SecurityException securityException) {
                    Method[] methodArray = clazz2.getMethods();
                    int n2 = methodArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Method method = methodArray[i2];
                        if (clazz2.equals(method.getDeclaringClass())) continue;
                        methodArray[i2] = null;
                    }
                    return methodArray;
                }
            }
        });
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            int n2;
            Method method = methodArray[i2];
            if (method == null || Modifier.isPublic(n2 = method.getModifiers())) continue;
            method.setAccessible(true);
        }
        declaredMethodCache.put(clazz, methodArray);
        return methodArray;
    }

    private static Method internalFindMethod(Class classArray, String string, int n2) {
        Object object;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = MappedPropertyDescriptor.getPublicDeclaredMethods((Class)object);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                int n3;
                Method method = methodArray[i2];
                if (method == null || Modifier.isStatic(n3 = method.getModifiers()) || !method.getName().equals(string) || method.getParameterTypes().length != n2) continue;
                return method;
            }
        }
        object = classArray.getInterfaces();
        for (int i3 = 0; i3 < ((Class<?>[])object).length; ++i3) {
            Method method = MappedPropertyDescriptor.internalFindMethod(object[i3], string, n2);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method internalFindMethod(Class classArray, String string, int n2, Class[] classArray2) {
        Object object;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = MappedPropertyDescriptor.getPublicDeclaredMethods((Class)object);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                int n3;
                Method method = methodArray[i2];
                if (method == null || Modifier.isStatic(n3 = method.getModifiers())) continue;
                Class<?>[] classArray3 = method.getParameterTypes();
                if (!method.getName().equals(string) || classArray3.length != n2) continue;
                boolean bl2 = false;
                if (n2 > 0) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        if (classArray3[i3] == classArray2[i3]) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                }
                return method;
            }
        }
        object = classArray.getInterfaces();
        for (int i4 = 0; i4 < ((Class<?>[])object).length; ++i4) {
            Method method = MappedPropertyDescriptor.internalFindMethod(object[i4], string, n2);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method findMethod(Class clazz, String string, int n2) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n2);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s)");
    }

    public static Method findMethod(Class clazz, String string, int n2, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n2, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s) of matching types.");
    }

    public static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!clazz2.isInterface()) continue;
            Class<?>[] classArray = clazz3.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!MappedPropertyDescriptor.isSubclass(classArray[i2], clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] != clazz) continue;
            return true;
        }
        return false;
    }

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        classArray[0] = clazz;
        stringClassArray = classArray;
        declaredMethodCache = new Hashtable();
    }
}

