/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.logging.Level;
import org.apache.commons.gs.collections.ArrayStack;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.ObjectCreationFactory;
import org.apache.commons.gs.digester.Rule;
import org.xml.sax.Attributes;

public class FactoryCreateRule
extends Rule {
    private boolean ignoreCreateExceptions;
    private ArrayStack exceptionIgnoredStack;
    public String attributeName = null;
    public String className = null;
    public ObjectCreationFactory creationFactory = null;

    public FactoryCreateRule(Digester digester, String string) {
        this(string);
    }

    public FactoryCreateRule(Digester digester, Class clazz) {
        this(clazz);
    }

    public FactoryCreateRule(Digester digester, String string, String string2) {
        this(string, string2);
    }

    public FactoryCreateRule(Digester digester, Class clazz, String string) {
        this(clazz, string);
    }

    public FactoryCreateRule(Digester digester, ObjectCreationFactory objectCreationFactory) {
        this(objectCreationFactory);
    }

    public FactoryCreateRule(String string) {
        this(string, false);
    }

    public FactoryCreateRule(Class clazz) {
        this(clazz, false);
    }

    public FactoryCreateRule(String string, String string2) {
        this(string, string2, false);
    }

    public FactoryCreateRule(Class clazz, String string) {
        this(clazz, string, false);
    }

    public FactoryCreateRule(ObjectCreationFactory objectCreationFactory) {
        this(objectCreationFactory, false);
    }

    public FactoryCreateRule(String string, boolean bl2) {
        this(string, null, bl2);
    }

    public FactoryCreateRule(Class clazz, boolean bl2) {
        this(clazz, null, bl2);
    }

    public FactoryCreateRule(String string, String string2, boolean bl2) {
        this.className = string;
        this.attributeName = string2;
        this.ignoreCreateExceptions = bl2;
    }

    public FactoryCreateRule(Class clazz, String string, boolean bl2) {
        this(clazz.getName(), string, bl2);
    }

    public FactoryCreateRule(ObjectCreationFactory objectCreationFactory, boolean bl2) {
        this.creationFactory = objectCreationFactory;
        this.ignoreCreateExceptions = bl2;
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        if (this.ignoreCreateExceptions) {
            if (this.exceptionIgnoredStack == null) {
                this.exceptionIgnoredStack = new ArrayStack();
            }
            try {
                Object object = this.getFactory(attributes).createObject(attributes);
                if (this.digester.log.isLoggable(Level.FINE)) {
                    this.digester.log.fine("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName());
                }
                this.digester.push(object);
                this.exceptionIgnoredStack.push(Boolean.FALSE);
            }
            catch (Exception exception) {
                if (this.digester.log.isLoggable(Level.INFO)) {
                    this.digester.log.info("[FactoryCreateRule] Create exception ignored: " + (exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage()));
                    if (this.digester.log.isLoggable(Level.FINE)) {
                        this.digester.log.log(Level.FINE, "[FactoryCreateRule] Ignored exception:", exception);
                    }
                }
                this.exceptionIgnoredStack.push(Boolean.TRUE);
            }
        } else {
            Object object = this.getFactory(attributes).createObject(attributes);
            if (this.digester.log.isLoggable(Level.FINE)) {
                this.digester.log.fine("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName());
            }
            this.digester.push(object);
        }
    }

    public void end(String string, String string2) throws Exception {
        if (this.ignoreCreateExceptions && this.exceptionIgnoredStack != null && !this.exceptionIgnoredStack.empty() && ((Boolean)this.exceptionIgnoredStack.pop()).booleanValue()) {
            if (this.digester.log.isLoggable(Level.FINEST)) {
                this.digester.log.finest("[FactoryCreateRule] No creation so no push so no pop");
            }
            return;
        }
        Object object = this.digester.pop();
        if (this.digester.log.isLoggable(Level.FINE)) {
            this.digester.log.fine("[FactoryCreateRule]{" + this.digester.match + "} Pop " + object.getClass().getName());
        }
    }

    public void finish() throws Exception {
        if (this.attributeName != null) {
            this.creationFactory = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FactoryCreateRule[");
        stringBuffer.append("className=");
        stringBuffer.append(this.className);
        stringBuffer.append(", attributeName=");
        stringBuffer.append(this.attributeName);
        if (this.creationFactory != null) {
            stringBuffer.append(", creationFactory=");
            stringBuffer.append(this.creationFactory);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public ObjectCreationFactory getFactory(Attributes attributes) throws Exception {
        if (this.creationFactory == null) {
            Object object;
            String string = this.className;
            if (this.attributeName != null && (object = attributes.getValue(this.attributeName)) != null) {
                string = object;
            }
            if (this.digester.log.isLoggable(Level.FINE)) {
                this.digester.log.fine("[FactoryCreateRule]{" + this.digester.match + "} New factory " + string);
            }
            object = this.digester.getClassLoader().loadClass(string);
            this.creationFactory = (ObjectCreationFactory)((Class)object).newInstance();
            this.creationFactory.setDigester(this.digester);
        }
        return this.creationFactory;
    }
}

