/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.net.InetAddress;
import org.garret.perst.Assert;

public class PatriciaTrieKey {
    public final long mask;
    public final int length;

    public PatriciaTrieKey(long l2, int n2) {
        this.mask = l2;
        this.length = n2;
    }

    public static PatriciaTrieKey fromIpAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        long l2 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 = l2 << 8 | (long)(byArray[i2] & 0xFF);
        }
        return new PatriciaTrieKey(l2, byArray.length * 8);
    }

    public static PatriciaTrieKey fromIpAddress(String string) throws NumberFormatException {
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            String string2 = (n4 = string.indexOf(46, n2)) < 0 ? string.substring(n2) : string.substring(n2, n4);
            n2 = n4 + 1;
            int n5 = Integer.parseInt(string2, 10);
            l2 = l2 << 8 | (long)(n5 & 0xFF);
            n3 += 8;
        } while (n2 > 0);
        return new PatriciaTrieKey(l2, n3);
    }

    public static PatriciaTrieKey fromDecimalDigits(String string) {
        long l2 = 0L;
        int n2 = string.length();
        Assert.that(n2 <= 16);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            Assert.that(c2 >= '0' && c2 <= '9');
            l2 = l2 << 4 | (long)(c2 - 48);
        }
        return new PatriciaTrieKey(l2, n2 * 4);
    }

    public static PatriciaTrieKey from7bitString(String string) {
        long l2 = 0L;
        int n2 = string.length();
        Assert.that(n2 * 7 <= 64);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            l2 = l2 << 7 | (long)(c2 & 0x7F);
        }
        return new PatriciaTrieKey(l2, n2 * 7);
    }

    public static PatriciaTrieKey from8bitString(String string) {
        long l2 = 0L;
        int n2 = string.length();
        Assert.that(n2 <= 8);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            l2 = l2 << 8 | (long)(c2 & 0xFF);
        }
        return new PatriciaTrieKey(l2, n2 * 8);
    }

    public static PatriciaTrieKey fromByteArray(byte[] byArray) {
        long l2 = 0L;
        int n2 = byArray.length;
        Assert.that(n2 <= 8);
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 << 8 | (long)(byArray[i2] & 0xFF);
        }
        return new PatriciaTrieKey(l2, n2 * 8);
    }
}

