/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import org.garret.perst.IFile;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ReplicationMasterFile;
import org.garret.perst.impl.ReplicationMasterStorageImpl;

public class AsyncReplicationMasterFile
extends ReplicationMasterFile {
    private int asyncBufSize;
    private int buffered;
    private boolean closed;
    private Object go;
    private Object async;
    private Parcel head;
    private Parcel tail;
    private Thread thread;

    public AsyncReplicationMasterFile(ReplicationMasterStorageImpl replicationMasterStorageImpl, IFile iFile, int n2) {
        super(replicationMasterStorageImpl, iFile);
        this.asyncBufSize = n2;
        this.start();
    }

    public AsyncReplicationMasterFile(IFile iFile, String[] stringArray, int n2, boolean bl2) {
        super(iFile, stringArray, bl2);
        this.asyncBufSize = n2;
        this.start();
    }

    private void start() {
        this.go = new Object();
        this.async = new Object();
        this.thread = new WriteThread();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long l2, byte[] byArray) {
        this.file.write(l2, byArray);
        for (int i2 = 0; i2 < this.out.length; ++i2) {
            Object object;
            if (this.out[i2] == null) continue;
            byte[] byArray2 = new byte[8 + byArray.length];
            Bytes.pack8(byArray2, 0, l2);
            System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
            Parcel parcel = new Parcel();
            parcel.data = byArray2;
            parcel.pos = l2;
            parcel.host = i2;
            try {
                object = this.async;
                synchronized (object) {
                    this.buffered += byArray2.length;
                    while (this.buffered > this.asyncBufSize) {
                        this.async.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = this.go;
            synchronized (object) {
                if (this.head == null) {
                    this.head = this.tail = parcel;
                } else {
                    this.tail = this.tail.next = parcel;
                }
                this.go.notify();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void asyncWrite() {
        block10: while (true) {
            block11: while (true) {
                var2_4 = this.go;
                synchronized (var2_4) {
                    while (this.head == null) {
                        if (this.closed) {
                            return;
                        }
                        this.go.wait();
                    }
                    var1_1 = this.head;
                    this.head = var1_1.next;
                }
                var2_4 = this.async;
                synchronized (var2_4) {
                    if (this.buffered > this.asyncBufSize) {
                        this.async.notifyAll();
                    }
                    this.buffered -= var1_1.data.length;
                }
                var2_3 = var1_1.host;
                while (true) {
                    if (this.out[var2_3] == null) continue block11;
                    try {
                        this.out[var2_3].write(var1_1.data);
                        if (!this.ack || var1_1.pos != 0L) continue block10;
                        if (this.in[var2_3].read(this.rcBuf) == 1) {
                            continue block11;
                        }
                    }
                    catch (IOException var3_5) {
                        // empty catch block
                    }
                    this.out[var2_3] = null;
                    this.sockets[var2_3] = null;
                    --this.nHosts;
                    if (this.handleError(this.hosts[var2_3])) ** break;
                    continue block11;
                    this.connect(var2_3);
                }
                break;
            }
            break;
        }
        catch (InterruptedException var1_2) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.go;
            synchronized (object) {
                this.closed = true;
                this.go.notify();
            }
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }

    static class Parcel {
        byte[] data;
        long pos;
        int host;
        Parcel next;

        Parcel() {
        }
    }

    class WriteThread
    extends Thread {
        WriteThread() {
        }

        public void run() {
            AsyncReplicationMasterFile.this.asyncWrite();
        }
    }
}

