/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.RndBtree;

class RndBtreeMultiFieldIndex
extends RndBtree
implements FieldIndex {
    String className;
    String[] fieldName;
    transient Class cls;
    transient Field[] fld;

    RndBtreeMultiFieldIndex() {
    }

    RndBtreeMultiFieldIndex(Class clazz, String[] stringArray, boolean bl2) {
        this.cls = clazz;
        this.unique = bl2;
        this.fieldName = stringArray;
        this.className = ClassDescriptor.getClassName(clazz);
        this.locateFields();
        this.type = 12;
    }

    private final void locateFields() {
        this.fld = new Field[this.fieldName.length];
        for (int i2 = 0; i2 < this.fieldName.length; ++i2) {
            this.fld[i2] = ClassDescriptor.locateField(this.cls, this.fieldName[i2]);
            if (this.fld[i2] != null) continue;
            throw new StorageError(20, this.className + "." + this.fieldName[i2]);
        }
    }

    public Class getIndexedClass() {
        return this.cls;
    }

    public Field[] getKeyFields() {
        return this.fld;
    }

    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateFields();
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        return new Key(new CompoundKey((Object[])key.oval), key.inclusion != 0);
    }

    private Key extractKey(IPersistent iPersistent) {
        Object[] objectArray = new Object[this.fld.length];
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                IPersistent iPersistent2;
                objectArray[i2] = this.fld[i2].get(iPersistent);
                if (!(objectArray[i2] instanceof IPersistent) || (iPersistent2 = (IPersistent)objectArray[i2]).isPersistent()) continue;
                this.getStorage().makePersistent(iPersistent2);
            }
        }
        catch (Exception exception) {
            throw new StorageError(17, exception);
        }
        return new Key(new CompoundKey(objectArray));
    }

    public boolean put(IPersistent iPersistent) {
        return super.put(this.extractKey(iPersistent), iPersistent);
    }

    public IPersistent set(IPersistent iPersistent) {
        return super.set(this.extractKey(iPersistent), iPersistent);
    }

    public void remove(IPersistent iPersistent) {
        super.remove(new RndBtree.BtreeKey(this.extractKey(iPersistent), iPersistent));
    }

    public IPersistent remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    public boolean containsObject(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (iPersistentArray[i2] != iPersistent) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IPersistent iPersistent) {
        Key key = this.extractKey(iPersistent);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] iPersistentArray = this.get(key, key);
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            if (!iPersistentArray[i2].equals(iPersistent)) continue;
            return true;
        }
        return false;
    }

    public void append(IPersistent iPersistent) {
        throw new StorageError(8);
    }

    public IPersistent[] get(Key key, Key key2) {
        ArrayList arrayList = new ArrayList();
        if (this.root != null) {
            this.root.find(this.convertKey(key), this.convertKey(key2), this.height, arrayList);
        }
        return (IPersistent[])arrayList.toArray((Object[])Array.newInstance(this.cls, arrayList.size()));
    }

    public IPersistent[] toPersistentArray() {
        IPersistent[] iPersistentArray = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != null) {
            this.root.traverseForward(this.height, iPersistentArray, 0);
        }
        return iPersistentArray;
    }

    public IPersistent get(Key key) {
        return super.get(this.convertKey(key));
    }

    public Iterator iterator(Key key, Key key2, int n2) {
        return super.iterator(this.convertKey(key), this.convertKey(key2), n2);
    }

    public Iterator entryIterator(Key key, Key key2, int n2) {
        return super.entryIterator(this.convertKey(key), this.convertKey(key2), n2);
    }

    public Iterator select(String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(this.cls, this.iterator(), string);
    }

    static class CompoundKey
    implements Comparable,
    Serializable {
        Object[] keys;

        public int compareTo(Object object) {
            CompoundKey compoundKey = (CompoundKey)object;
            int n2 = this.keys.length < compoundKey.keys.length ? this.keys.length : compoundKey.keys.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = ((Comparable)this.keys[i2]).compareTo(compoundKey.keys[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return 0;
        }

        CompoundKey(Object[] objectArray) {
            this.keys = objectArray;
        }
    }
}

