/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ServiceProviderImpl
implements ServiceProvider {
    private static final String CACHE_FILE = "services.cache";
    private static final String KEY_SERVICE_LIST = "SERVICE_ORDER";
    private static final String URL_ENCODING = "UTF8";
    private static final String SERVICE_SEPERATOR = "\u0001";
    private Properties serviceMap = null;
    private boolean isLoaded = false;

    public ServiceDefinition serviceForName(String string) {
        return this.serviceForName(string, true);
    }

    public ServiceDefinition serviceForName(String string, boolean bl2) {
        this.checkState();
        SystemConfig systemConfig = SystemConfig.getInstance();
        Properties properties = systemConfig.getJDBCDefaults();
        UserPreferences userPreferences = systemConfig.getPreferences();
        boolean bl3 = userPreferences.getBoolean("general.security-enabled");
        String string2 = string.toUpperCase();
        if (this.serviceMap.containsKey(string2)) {
            ServiceDefinition serviceDefinition = new ServiceDefinition(properties, bl3);
            String string3 = this.serviceMap.getProperty(string.toUpperCase());
            try {
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                serviceDefinition.load(inputStream);
                inputStream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, string3);
                return null;
            }
            if (bl2 && serviceDefinition.isRemote()) {
                try {
                    if (serviceDefinition.synchronize()) {
                        System.out.println(BasicUtilities.getString("Service_Sync_Success", string));
                        try {
                            this.saveService(serviceDefinition);
                        }
                        catch (IOException iOException) {
                            BasicUtilities.HandleException(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString("Service_Sync_Error", string));
                    return null;
                }
            }
            return serviceDefinition;
        }
        String string4 = BasicUtilities.getString("Service_Not_Registered_Error", string);
        throw new IllegalArgumentException(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveService(ServiceDefinition serviceDefinition) throws IOException {
        Object object;
        this.checkState();
        String string = this.serviceMap.getProperty(serviceDefinition.getName().toUpperCase());
        if (string == null) {
            String string2 = BasicUtilities.getString("Service_Not_Registered_Error", serviceDefinition.getName());
            throw new IllegalArgumentException(string2);
        }
        File file = null;
        try {
            object = new URL(string);
            file = new File(((URL)object).getPath());
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new IOException(BasicUtilities.getString("Error_Writing_File", string));
                }
            } else {
                file.createNewFile();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("Error_Writing_File", string));
            return false;
        }
        object = null;
        try {
            object = new FileOutputStream(file);
            serviceDefinition.store((OutputStream)object);
            this.store();
            ((OutputStream)object).flush();
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            BasicUtilities.HandleException(iOException, BasicUtilities.getString("Error_Writing_File", string));
            throw iOException;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceProvider::saveService(ServiceDefinition)");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                ((FileOutputStream)object).close();
            }
            catch (Throwable throwable) {}
            object = null;
            file = null;
            string = null;
        }
    }

    public boolean registerService(String string, URL uRL) {
        this.checkState();
        if (string == null) {
            String string2 = BasicUtilities.getString("Service_Null_Register_Error");
            throw new IllegalArgumentException(string2);
        }
        if ((string = string.trim()).indexOf(SERVICE_SEPERATOR) >= 0) {
            String string3 = BasicUtilities.getString("Service_Register_Error");
            throw new IllegalArgumentException(string3);
        }
        if (uRL == null) {
            try {
                uRL = new File(SystemConfig.getBaseDirectory(), string.concat(".service")).toURL();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (this.isURLRegistered(uRL)) {
            String string4 = BasicUtilities.getString("Service_URL_Registered_Error", uRL.toExternalForm());
            throw new IllegalArgumentException(string4);
        }
        if (string.equalsIgnoreCase(KEY_SERVICE_LIST)) {
            throw new IllegalArgumentException(BasicUtilities.getString("Service_Registered_Reservered_Error", string));
        }
        String string5 = string.trim().toUpperCase();
        String string6 = null;
        string6 = uRL.toExternalForm();
        if (this.isRegistered(string) && !this.deregisterService(string)) {
            return false;
        }
        this.serviceMap.setProperty(string5, string6);
        this.addNewServiceTolist(string);
        return true;
    }

    public boolean registerService(ServiceDefinition serviceDefinition, URL uRL) {
        if (serviceDefinition == null) {
            String string = BasicUtilities.getString("Service_Null_Register_Error");
            throw new IllegalArgumentException(string);
        }
        return this.registerService(serviceDefinition.getName(), uRL);
    }

    public boolean deregisterService(String string) {
        if (string != null) {
            this.checkState();
            String string2 = string.toUpperCase();
            if (this.serviceMap.containsKey(string2)) {
                String string3 = (String)this.serviceMap.remove(string2);
                this.removeNameFromServerList(string);
                return string3 != null;
            }
        }
        return false;
    }

    public boolean deregisterService(ServiceDefinition serviceDefinition) {
        if (serviceDefinition != null) {
            return this.deregisterService(serviceDefinition.getName());
        }
        return false;
    }

    public boolean isRegistered(ServiceDefinition serviceDefinition) {
        if (serviceDefinition != null) {
            return this.isRegistered(serviceDefinition.getName());
        }
        return false;
    }

    public boolean isRegistered(String string) {
        if (string != null) {
            this.checkState();
            String string2 = string.toUpperCase();
            return this.serviceMap.containsKey(string2);
        }
        return false;
    }

    public boolean isURLRegistered(URL uRL) {
        if (uRL != null) {
            this.checkState();
            Iterator<Object> iterator = this.serviceMap.keySet().iterator();
            String string = null;
            try {
                string = URLEncoder.encode(uRL.toExternalForm(), URL_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            while (iterator.hasNext()) {
                String string2 = (String)this.serviceMap.get(iterator.next());
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String nameForURL(URL uRL) {
        if (uRL != null) {
            this.checkState();
            Iterator<Object> iterator = this.serviceMap.keySet().iterator();
            String string = null;
            try {
                string = URLEncoder.encode(uRL.toExternalForm(), URL_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)this.serviceMap.get(string2);
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public URI uriForService(String string) {
        this.checkState();
        String string2 = string.toUpperCase();
        if (this.serviceMap.containsKey(string2)) {
            try {
                String string3 = this.serviceMap.getProperty(string2);
                URL uRL = new URL(string3);
                return new URI(uRL.toString());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        String string4 = BasicUtilities.getString("Service_Not_Registered_Error", string);
        throw new IllegalArgumentException(string4);
    }

    public URI uriForService(ServiceDefinition serviceDefinition) {
        return this.uriForService(serviceDefinition.getName());
    }

    public void detectServices() {
        this.checkState();
        StringBuffer stringBuffer = new StringBuffer("");
        this.serviceMap.clear();
        File[] fileArray = this.getPathLocations();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                this.scanDirectory(fileArray[i2], stringBuffer);
                continue;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }
        fileArray = null;
        this.serviceMap.put(KEY_SERVICE_LIST, stringBuffer.toString());
        try {
            this.store();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceProviderImpl::store()");
        }
    }

    public Collection getRegisteredServices() {
        return this.getRegisteredServices(false);
    }

    public Collection getRegisteredServices(boolean bl2) {
        this.checkState();
        if (bl2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.serviceMap.getProperty(KEY_SERVICE_LIST);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, SERVICE_SEPERATOR, false, true);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            return arrayList;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.serviceMap.keySet());
        arrayList.remove(KEY_SERVICE_LIST);
        return arrayList;
    }

    public void setPreferredServiceOrder(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            StringBuffer stringBuffer = new StringBuffer("");
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                String string = e2.toString();
                if (!this.isRegistered(string)) continue;
                stringBuffer.append(e2.toString());
                stringBuffer.append(SERVICE_SEPERATOR);
            }
            this.serviceMap.setProperty(KEY_SERVICE_LIST, stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer = null;
            iterator = null;
            try {
                this.store();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ServiceProviderImpl::store()");
            }
        }
    }

    public boolean removeService(ServiceDefinition serviceDefinition) throws IOException {
        return this.removeService(serviceDefinition.getName());
    }

    public boolean removeService(String string) throws IOException {
        this.checkState();
        if (string == null) {
            String string2 = BasicUtilities.getString("Service_Null_Remove_Error");
            throw new IllegalArgumentException(string2);
        }
        String string3 = string.toUpperCase();
        if (this.serviceMap.containsKey(string3)) {
            URL uRL = new URL(this.serviceMap.getProperty(string.toUpperCase()));
            File file = new File(uRL.getPath());
            boolean bl2 = true;
            if (file.exists()) {
                file.delete();
            }
            this.deregisterService(string);
            try {
                this.store();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl2;
        }
        String string4 = BasicUtilities.getString("Service_Not_Found_Error", string);
        throw new IllegalArgumentException(string4);
    }

    private void checkState() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException iOException) {
                BasicUtilities.HandleException(iOException, "ServiceProviderImpl::load()");
            }
        }
    }

    private void load() throws IOException {
        this.serviceMap = null;
        this.serviceMap = new Properties();
        File file = new File(SystemConfig.getBaseDirectory(), CACHE_FILE);
        if (file.exists() && file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.serviceMap.load(fileInputStream);
            String string = this.serviceMap.getProperty(KEY_SERVICE_LIST, SERVICE_SEPERATOR);
            StringTokenizer stringTokenizer = new StringTokenizer(string, SERVICE_SEPERATOR, false, true);
            if (stringTokenizer.countTokens() != this.serviceMap.size() - 1) {
                this.serviceMap.clear();
            }
            this.isLoaded = true;
        } else if (!file.exists()) {
            this.isLoaded = true;
            this.detectServices();
        }
    }

    private void store() throws IOException {
        File file = new File(SystemConfig.getBaseDirectory(), CACHE_FILE);
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        if (file.canWrite()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.serviceMap.store(fileOutputStream, "2.1.8");
        }
    }

    private void removeNameFromServerList(String string) {
        String string2 = this.serviceMap.getProperty(KEY_SERVICE_LIST, "");
        string = string.concat(SERVICE_SEPERATOR);
        string2 = StringUtilities.removeSubString(string2, string);
        this.serviceMap.setProperty(KEY_SERVICE_LIST, string2);
    }

    private void addNewServiceTolist(String string) {
        String string2 = this.serviceMap.getProperty(KEY_SERVICE_LIST, "");
        string2 = string2.concat(string);
        string2 = string2.concat(SERVICE_SEPERATOR);
        this.serviceMap.setProperty(KEY_SERVICE_LIST, string2);
    }

    private File[] getPathLocations() {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        String string = userPreferences.get("advanced.servicepath");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(SystemConfig.getBaseDirectory());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            arrayList.add(new File(string2));
        }
        return arrayList.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirectory(File file, StringBuffer stringBuffer) {
        File[] fileArray = file.listFiles(ServiceDefinition.getFileNameFilter());
        if (fileArray == null) {
            return;
        }
        Properties properties = new Properties(null);
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        boolean bl2 = userPreferences.getBoolean("general.security-enabled");
        ServiceDefinition serviceDefinition = new ServiceDefinition(properties, bl2);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String[] stringArray;
            FileInputStream fileInputStream = null;
            boolean bl3 = false;
            try {
                fileInputStream = new FileInputStream(fileArray[i2]);
                serviceDefinition.load(fileInputStream);
                fileInputStream.close();
                stringArray = serviceDefinition.getName().toUpperCase().trim();
                bl3 = !this.serviceMap.containsKey(stringArray);
                this.serviceMap.setProperty((String)stringArray, fileArray[i2].toURL().toString());
            }
            catch (Throwable throwable) {
                String string = BasicUtilities.getString("Error_Reading_File", fileArray[i2].getAbsolutePath());
                BasicUtilities.HandleException(throwable, string, true);
                continue;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (!bl3) continue;
            try {
                stringArray = new String[]{serviceDefinition.getName(), fileArray[i2].toURL().toExternalForm()};
                System.out.println(BasicUtilities.getString("Service_Detected_Message", stringArray));
                stringBuffer.append(serviceDefinition.getName());
                stringBuffer.append(SERVICE_SEPERATOR);
                continue;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }
        properties = null;
        userPreferences = null;
        serviceDefinition = null;
    }
}

