/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;

public class ImportEditor
extends JPanel
implements MouseListener,
ListSelectionListener,
ActionListener,
ChangeListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultListModel mdlMappings = new DefaultListModel();
    private DefaultComboBoxModel editorOptions = new DefaultComboBoxModel();
    private JSplitPane jspRoot = new JSplitPane(1);
    private JSplitPane jspData = new JSplitPane(0);
    private JList jlsMappings = new JList(this.mdlMappings);
    private JButton btnDelete = new JButton(BasicUtilities.loadIconResource("RowDelete16"));
    private JButton btnOpen = new JButton(BasicUtilities.loadIconResource("Open16"));
    private JButton btnSave = new JButton(BasicUtilities.loadIconResource("SaveAs16"));
    private JCheckBox chkUseBatch = new JCheckBox(BasicUtilities.getString("Import_Batch_Opt"));
    private JCheckBox chkUseTx = new JCheckBox(BasicUtilities.getString("Import_Trans_Opt"));
    private JLabel lblStatus = new JLabel("");
    private JLabel lblSelect = new JLabel("");
    private ITable tblImportData = new ITable();
    private TableSelector jtsSelector;
    private WizardPanel pnlEditor = new WizardPanel();
    private ImportConfig importMapping = new ImportConfig();
    private JComboBox jcbEditor = new JComboBox(this.editorOptions);
    private ColumnMapRenderer listRenderer = new ColumnMapRenderer(null);
    private DatabaseConnection connection = null;
    private ArrayList plugins = null;
    private String lastTable = null;
    private int lastSelection = -1;
    private boolean isLoading = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportEditor(DatabaseConnection databaseConnection) {
        super(new BorderLayout(1, 1));
        this.connection = databaseConnection;
        try {
            this.initUI();
            this.loadEditors();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ImportEditor()::initUI()");
        }
        finally {
            this.stateChanged(null);
        }
    }

    public void setData(EnhancedTableModel enhancedTableModel) {
        TableModel tableModel = this.tblImportData.getModel();
        this.tblImportData.setModel(enhancedTableModel);
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            ImportPlugin importPlugin = (ImportPlugin)iterator.next();
            if (tableModel != null) {
                tableModel.removeTableModelListener(importPlugin);
            }
            enhancedTableModel.addTableModelListener(importPlugin);
            try {
                importPlugin.handleDataModelChange(enhancedTableModel);
            }
            catch (Throwable throwable) {
                BasicUtilities.showExceptionPopup(this, throwable, null);
            }
        }
        BasicUtilities.optimizeTableView(this.tblImportData);
    }

    public ImportConfig getImportConfig() {
        this.importMapping.setUseTransaction(this.chkUseTx.isSelected());
        this.importMapping.setUseBatch(this.chkUseBatch.isSelected());
        return this.importMapping;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ImportPlugin importPlugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
        if (listSelectionEvent == null || listSelectionEvent.getValueIsAdjusting() || this.isLoading) {
            return;
        }
        int n2 = this.jlsMappings.getSelectedIndex();
        if (n2 < 0 || n2 >= this.mdlMappings.size()) {
            return;
        }
        String string = null;
        String string2 = null;
        string = this.lastSelection < 0 ? "" : (String)this.mdlMappings.get(this.lastSelection);
        string2 = (String)this.mdlMappings.get(n2);
        if (this.lastSelection >= 0) {
            try {
                if (!importPlugin.canChangeSelection()) {
                    ListSelectionModel listSelectionModel = this.jlsMappings.getSelectionModel();
                    listSelectionModel.setValueIsAdjusting(true);
                    this.jlsMappings.setSelectedIndex(this.lastSelection);
                    BasicUtilities.beep();
                    return;
                }
                this.importMapping.addEntry(string, importPlugin.createEntry());
            }
            catch (Throwable throwable) {
                BasicUtilities.showExceptionPopup(this, throwable, null);
            }
        }
        try {
            ImportConfig.Entry entry = this.importMapping.getEntry(string2);
            if (entry == null) {
                entry = new ImportConfig.Entry(importPlugin);
            } else {
                String string3 = this.pluginDescriptionForName(entry.getPluginName());
                this.jcbEditor.setSelectedItem(string3);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.showExceptionPopup(this, throwable, null);
        }
        this.lblSelect.setText(BasicUtilities.getString("Imported_Data_Using", string2));
        try {
            importPlugin.handleColumnSelectionChange(string2, string);
        }
        catch (Throwable throwable) {
            BasicUtilities.showExceptionPopup(this, throwable, null);
        }
        this.lastSelection = n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        this.lblStatus.setText(jButton.getActionCommand());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lblStatus.setText("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ImportPlugin importPlugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
        String string = this.jtsSelector.getSelectedCatalog();
        String string2 = this.jtsSelector.getSelectedSchema();
        String string3 = this.jtsSelector.getSelectedTable();
        String string4 = null;
        string4 = this.lastTable == null ? "" : this.lastTable;
        this.loadColumns(string, string2, string3);
        this.importMapping.setCatalog(string);
        this.importMapping.setSchema(string2);
        this.importMapping.setTable(string3);
        try {
            importPlugin.handleTableSelectionChange(string4, string3);
        }
        catch (Throwable throwable) {
            BasicUtilities.showExceptionPopup(this, throwable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.btnDelete) {
            BasicUtilities.removeSelectedRows(this.tblImportData);
        } else if (object == this.jcbEditor) {
            String string = (String)this.jcbEditor.getSelectedItem();
            String string2 = (String)this.jlsMappings.getSelectedValue();
            this.pnlEditor.showCard(string);
            ImportPlugin importPlugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
            try {
                ImportConfig.Entry entry = this.importMapping.removeEntry(string2);
                ImportConfig.Entry entry2 = null;
                if (entry != null && entry.getPluginName().equalsIgnoreCase(importPlugin.getName())) {
                    entry2 = entry;
                } else {
                    entry = null;
                    entry2 = new ImportConfig.Entry(importPlugin);
                }
                this.importMapping.addEntry(string2, entry2);
                importPlugin.setEntry(entry2);
            }
            catch (Throwable throwable) {
                BasicUtilities.showExceptionPopup(this, throwable, null);
            }
        } else if (object == this.btnSave) {
            this.importMapping.setUseTransaction(this.chkUseTx.isSelected());
            this.importMapping.setUseBatch(this.chkUseBatch.isSelected());
            String string = (String)this.jlsMappings.getSelectedValue();
            ImportPlugin importPlugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
            this.importMapping.addEntry(string, importPlugin.createEntry());
            String string3 = BasicUtilities.getString("ImportFile_Desc");
            FileFilter[] fileFilterArray = new FileFilter[]{new ExtensionFileFilter("icf", string3)};
            File file = BasicUtilities.saveSystemFile(this, fileFilterArray);
            if (file != null) {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    this.importMapping.store(fileOutputStream);
                    fileOutputStream.flush();
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
                finally {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {}
                    fileOutputStream = null;
                }
            }
        } else if (object == this.btnOpen) {
            this.loadConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns(String string, String string2, String string3) {
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.connection.getDatabaseInformation();
        this.lastSelection = -1;
        this.mdlMappings.removeAllElements();
        this.jlsMappings.clearSelection();
        if (!this.isLoading) {
            this.importMapping.clear();
        }
        try {
            resultSet = databaseMetaData.getColumns(string, string2, string3, null);
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_NAME");
                String string5 = JDBCUtilities.getTypeforValue(resultSet.getInt("DATA_TYPE"));
                this.mdlMappings.addElement(string4);
                this.listRenderer.columnInfo.put(string4, string5);
            }
        }
        catch (SQLException sQLException) {
            String string6 = BasicUtilities.getString("Column_Load_Error");
            BasicUtilities.showExceptionPopup(this, sQLException, string6);
        }
        catch (Throwable throwable) {
            BasicUtilities.beep();
            BasicUtilities.HandleException(throwable);
        }
        finally {
            if (this.mdlMappings.size() >= 1) {
                this.jlsMappings.setSelectedIndex(0);
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
    }

    private void loadEditors() {
        PluginFactory pluginFactory = SystemConfig.getInstance().getPluginFactory();
        this.plugins = new ArrayList(pluginFactory.createImportHandlers());
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            ImportPlugin importPlugin = (ImportPlugin)iterator.next();
            importPlugin.setDatabaseConnection(this.connection);
            try {
                JPanel jPanel = new JPanel();
                importPlugin.installEditor(jPanel);
                jPanel.setBorder(BorderFactory.createEmptyBorder());
                this.editorOptions.addElement(importPlugin.getDescription());
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                this.pnlEditor.add((Component)jScrollPane, importPlugin.getDescription());
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        FileFilter[] fileFilterArray;
        String string;
        int n2;
        if (!this.importMapping.isEmpty() && (n2 = JOptionPane.showConfirmDialog(this, string = BasicUtilities.getString("ImportConfig_DataLoss_Warning"), (String)(fileFilterArray = BasicUtilities.getString("Warning")), 0)) == 1) {
            return;
        }
        string = BasicUtilities.getString("ImportFile_Desc");
        fileFilterArray = new FileFilter[]{new ExtensionFileFilter("icf", string)};
        File file = BasicUtilities.getSystemFile(this, 0, fileFilterArray);
        if (file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.importMapping.load(fileInputStream);
                this.isLoading = true;
                this.jtsSelector.setSelectedCatalog(this.importMapping.getCatalog());
                this.jtsSelector.setSelectedSchema(this.importMapping.getSchema());
                this.jtsSelector.setSelectedTable(this.importMapping.getTable());
                if (this.chkUseTx.isEnabled()) {
                    this.chkUseTx.setSelected(this.importMapping.isUseTransaction());
                }
                if (this.chkUseBatch.isEnabled()) {
                    this.chkUseBatch.setSelected(this.importMapping.isUseBatch());
                }
                this.lastSelection = -1;
                this.lastTable = null;
                this.isLoading = false;
                this.jlsMappings.setSelectedIndex(0);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
                fileInputStream = null;
                this.invalidate();
                this.validateTree();
            }
        }
    }

    private void initUI() {
        this.listRenderer.config = this.importMapping;
        this.chkUseBatch.setEnabled(this.connection.isBatchSupported());
        this.chkUseTx.setEnabled(this.connection.isTransactionsSupported());
        this.chkUseBatch.setToolTipText(BasicUtilities.getString("Import_Batch_Tip"));
        this.chkUseTx.setToolTipText(BasicUtilities.getString("Import_Trans_Tip"));
        this.jtsSelector = new TableSelector(this.connection.getDatabaseInformation(), true);
        this.jtsSelector.setTablesEditable(false);
        this.jtsSelector.addChangeListener(this);
        this.jtsSelector.setSelectedSchema(this.connection.getSchema());
        this.tblImportData.allowColumnReordering(false);
        this.tblImportData.setSelectionToggleEnabled(false);
        this.tblImportData.setRowSelectionAllowed(true);
        this.tblImportData.setColumnSelectionAllowed(false);
        this.btnDelete.setToolTipText(BasicUtilities.getString("Import_Delete_Selected_Rows"));
        this.configureButton(this.btnDelete);
        this.configureButton(this.btnOpen);
        this.btnOpen.setActionCommand(BasicUtilities.getString("Import_Load_Configuration"));
        this.configureButton(this.btnSave);
        this.btnSave.setActionCommand(BasicUtilities.getString("Import_Save_Configuration"));
        this.jcbEditor.setMaximumRowCount(5);
        this.jcbEditor.addActionListener(this);
        this.jlsMappings.addListSelectionListener(this);
        this.jlsMappings.setDragEnabled(false);
        this.jlsMappings.setCellRenderer(this.listRenderer);
        this.jlsMappings.setSelectionMode(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.lblSelect.setText(BasicUtilities.getString("Imported_Data_Using", ""));
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        jPanel.add((Component)this.lblSelect, UI_CONSTRAINT);
        ImportEditor.constrain(1, 0, 1, 1, 0.75, 0.0, 18, 2);
        jPanel.add((Component)this.jcbEditor, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        jPanel.add((Component)new JScrollPane(this.pnlEditor), UI_CONSTRAINT);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(BasicUtilities.getString("Imported_Data_Preview"));
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        jPanel2.add((Component)jLabel, UI_CONSTRAINT);
        ImportEditor.constrain(2, 0, 1, 1, 0.0, 0.0, 12, 0);
        jPanel2.add((Component)this.btnDelete, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        jPanel2.add((Component)new JScrollPane(this.tblImportData), UI_CONSTRAINT);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        jPanel3.add((Component)this.btnOpen, UI_CONSTRAINT);
        ImportEditor.constrain(1, 0, 1, 1, 0.0, 0.0, 18, 0);
        jPanel3.add((Component)this.btnSave, UI_CONSTRAINT);
        ImportEditor.constrain(2, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.lblStatus, UI_CONSTRAINT);
        ImportEditor.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.chkUseTx, UI_CONSTRAINT);
        ImportEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.chkUseBatch, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 2, 1.0, 0.0, 17, 2);
        jPanel3.add((Component)this.jtsSelector, UI_CONSTRAINT);
        this.jspRoot.setOrientation(0);
        this.jspRoot.setBorder(BorderFactory.createEmptyBorder());
        this.jspRoot.setBottomComponent(jPanel2);
        this.jspRoot.setTopComponent(this.jspData);
        this.jspData.setLeftComponent(new JScrollPane(this.jlsMappings));
        this.jspData.setRightComponent(jPanel);
        this.jspData.setOrientation(1);
        this.jspData.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)jPanel3, "North");
        this.add((Component)this.jspRoot, "Center");
    }

    private void configureButton(JButton jButton) {
        jButton.setAlignmentY(0.5f);
        jButton.setBorderPainted(!BasicUtilities.isMac());
        jButton.setFocusPainted(false);
        jButton.addActionListener(this);
        jButton.addMouseListener(this);
    }

    private String pluginDescriptionForName(String string) {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            ImportPlugin importPlugin = (ImportPlugin)iterator.next();
            if (!importPlugin.getName().equalsIgnoreCase(string)) continue;
            return importPlugin.getDescription();
        }
        return null;
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        ImportEditor.UI_CONSTRAINT.gridx = n2;
        ImportEditor.UI_CONSTRAINT.gridy = n3;
        ImportEditor.UI_CONSTRAINT.gridwidth = n4;
        ImportEditor.UI_CONSTRAINT.gridheight = n5;
        ImportEditor.UI_CONSTRAINT.weightx = d2;
        ImportEditor.UI_CONSTRAINT.weighty = d3;
        ImportEditor.UI_CONSTRAINT.anchor = n6;
        ImportEditor.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private static class ColumnMapRenderer
    extends DefaultListCellRenderer {
        private HashMap columnInfo = new HashMap();
        private ImportConfig config = null;

        private ColumnMapRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            String[] stringArray = new String[]{(String)object, (String)this.columnInfo.get(object)};
            String string = BasicUtilities.getString("Import_ColumnList_Label", stringArray);
            super.getListCellRendererComponent((JList<?>)jList, string, n2, bl2, bl3);
            this.setIcon(BasicUtilities.loadIconResource("Table16"));
            if (this.config.containsKey(stringArray[0])) {
                this.setFont(jList.getFont().deriveFont(10.0f));
            } else {
                this.setFont(jList.getFont().deriveFont(1, 10.0f));
            }
            return this;
        }

        public /* synthetic */ ColumnMapRenderer(1 var1_1) {
            this();
        }
    }
}

