/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class JConsole
extends JComponent
implements AdjustmentListener,
PreferenceChangeListener {
    public static final String CATEGORY_SYSTEM_OUT = "system";
    public static final String CATEGORY_SYSTEM_ERR = "err";
    public static final String CATEGORY_DRIVER_MANAGER = BasicUtilities.getString("Driver_Manager_Category");
    public static final String CATEGORY_SCRIPT_DEBUG = BasicUtilities.getString("Script_Debug_Category");
    private static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final PrintStream err = new PrintStream(new FileOutputStream(FileDescriptor.err));
    private OutputStream os = new ConsoleOutputStream(this, "system");
    private JTextPane console = new JTextPane();
    private JScrollPane container = new JScrollPane(this.console);
    private String TSPattern = null;
    private SimpleDateFormat sdf = null;
    private Color clrDriverCat = null;
    private Color clrSystemCat = null;
    private Color clrErrorCat = null;
    private String defaultText = null;
    private UserPreferences prefs = null;
    private boolean autoScroll = true;

    public JConsole() {
        this("");
    }

    public JConsole(String string) {
        this.defaultText = string;
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
        this.console.setEditable(false);
        this.console.getCaret().setBlinkRate(0);
        BasicUtilities.localizeTextComponent(this.console, null);
        this.container.setHorizontalScrollBarPolicy(31);
        this.container.setVerticalScrollBarPolicy(22);
        this.container.getVerticalScrollBar().addAdjustmentListener(this);
    }

    public synchronized void configure(UserPreferences userPreferences) {
        this.registerPropertyListening(userPreferences);
        this.prefs = userPreferences;
        this.TSPattern = userPreferences.get("console.timestamp-format");
        if (this.TSPattern.trim().length() >= 1) {
            this.sdf = new SimpleDateFormat(this.TSPattern);
        } else {
            this.sdf = null;
            this.TSPattern = null;
        }
        this.clrDriverCat = userPreferences.getColor("console.sql-color");
        this.clrSystemCat = userPreferences.getColor("console.sys-color");
        this.clrErrorCat = userPreferences.getColor("console.err-color");
        this.setForeground(userPreferences.getColor("console.foreground-color"));
        this.setBackground(userPreferences.getColor("console.background-color"));
        this.setFont(userPreferences.getFont("console.font"));
        this.setText(this.defaultText);
    }

    public Document getDocument() {
        return this.console.getDocument();
    }

    public String getText() {
        return this.console.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string, String string2) {
        Document document;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (string2 == null) {
            return;
        }
        if (string2.trim().length() == 0) {
            return;
        }
        Document document2 = document = this.getDocument();
        synchronized (document2) {
            if (string == null) {
                string = CATEGORY_SYSTEM_OUT;
            }
            StyleConstants.setFontFamily(simpleAttributeSet, this.getFont().getFamily());
            StyleConstants.setFontSize(simpleAttributeSet, this.getFont().getSize());
            StyleConstants.setBold(simpleAttributeSet, this.getFont().isBold());
            StyleConstants.setItalic(simpleAttributeSet, this.getFont().isItalic());
            StyleConstants.setBackground(simpleAttributeSet, this.getBackground());
            if (this.TSPattern != null && this.sdf != null && !string2.equalsIgnoreCase(this.defaultText)) {
                String string3 = this.sdf.format(new Date());
                StyleConstants.setForeground(simpleAttributeSet, this.getForeground());
                string3 = string3.concat(" ");
                try {
                    document.insertString(document.getLength(), string3, simpleAttributeSet);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CATEGORY_DRIVER_MANAGER.equalsIgnoreCase(string) || CATEGORY_SCRIPT_DEBUG.equalsIgnoreCase(string)) {
                StyleConstants.setForeground(simpleAttributeSet, this.clrDriverCat == null ? this.getForeground() : this.clrDriverCat);
            } else if (CATEGORY_SYSTEM_OUT.equalsIgnoreCase(string)) {
                StyleConstants.setForeground(simpleAttributeSet, this.clrSystemCat == null ? this.getForeground() : this.clrSystemCat);
            } else if (CATEGORY_SYSTEM_ERR.equalsIgnoreCase(string)) {
                StyleConstants.setForeground(simpleAttributeSet, this.clrErrorCat == null ? this.getForeground() : this.clrErrorCat);
            }
            try {
                document.insertString(document.getLength(), string2, simpleAttributeSet);
            }
            catch (Exception exception) {
                BasicUtilities.HandleException((Throwable)exception, "JConsole:append(String,String):insertString", false, err);
            }
        }
        if (this.autoScroll) {
            try {
                int n2 = document.getLength();
                this.console.setCaretPosition(n2);
                this.scrollRectToVisible(this.console.modelToView(n2 - 1));
            }
            catch (Exception exception) {
                BasicUtilities.HandleException((Throwable)exception, "JConsole:append(String,String):setCaretPosition", false, err);
            }
            JScrollBar jScrollBar = this.container.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
        this.console.invalidate();
        this.repaint();
    }

    public void append(String string) {
        this.append(CATEGORY_SYSTEM_OUT, string);
    }

    public void setText(String string) {
        if (string == null) {
            return;
        }
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
            if (string.trim().length() == 0) {
                this.append(this.defaultText == null ? "" : this.defaultText);
            } else {
                this.append(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OutputStream createFilteredStream(String string) {
        if (string != null) {
            return new ConsoleOutputStream(this, string);
        }
        return this.toOutputStream();
    }

    public OutputStream toOutputStream() {
        return this.os;
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent == null || this.prefs == null) {
            return;
        }
        String string = preferenceChangeEvent.getKey();
        String string2 = preferenceChangeEvent.getNewValue();
        if (string.equals("console.background-color")) {
            this.setBackground(Color.decode(string2));
            this.syncDisplay();
        } else if (string.equals("console.foreground-color")) {
            this.setForeground(Color.decode(string2));
            this.syncDisplay();
        } else if (string.equals("console.err-color")) {
            this.clrErrorCat = Color.decode(string2);
        } else if (string.equals("console.font")) {
            this.setFont(StringUtilities.parseFontString(string2));
            this.syncDisplay();
        } else if (string.equals("console.sql-color")) {
            this.clrDriverCat = Color.decode(string2);
        } else if (string.equals("console.sys-color")) {
            this.clrSystemCat = Color.decode(string2);
        } else if (string.equals("console.timestamp-format")) {
            this.TSPattern = string2;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.autoScroll = !adjustmentEvent.getValueIsAdjusting();
    }

    private void registerPropertyListening(UserPreferences userPreferences) {
        if (userPreferences == null) {
            return;
        }
        if (this.prefs != null && userPreferences != this.prefs) {
            this.prefs.removePreferenceChangeListener(this);
        } else if (userPreferences == this.prefs && this.prefs != null) {
            return;
        }
        userPreferences.addPreferenceChangeListener(this);
    }

    private void syncDisplay() {
        StyledDocument styledDocument = (StyledDocument)this.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, this.getFont().getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, this.getFont().getSize());
        StyleConstants.setBold(simpleAttributeSet, this.getFont().isBold());
        StyleConstants.setItalic(simpleAttributeSet, this.getFont().isItalic());
        StyleConstants.setBackground(simpleAttributeSet, this.getBackground());
        styledDocument.setCharacterAttributes(0, styledDocument.getLength(), simpleAttributeSet, true);
    }

    private static class Appender
    implements Runnable {
        public JConsole textView = null;
        public String category = null;
        public String line = null;

        public Appender(JConsole jConsole, String string, String string2) {
            this.textView = jConsole;
            this.category = string;
            this.line = string2;
        }

        public void run() {
            try {
                this.textView.append(this.category, this.line);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private String category = null;
        private JConsole reference;

        public ConsoleOutputStream(JConsole jConsole, String string) {
            this.reference = jConsole;
            this.category = string != null ? string : JConsole.CATEGORY_SYSTEM_OUT;
        }

        public boolean isSystemStream() {
            return JConsole.CATEGORY_SYSTEM_ERR.equalsIgnoreCase(this.category) || JConsole.CATEGORY_SYSTEM_OUT.equalsIgnoreCase(this.category);
        }

        public synchronized void write(int n2) {
            this.buf.append(Character.toString((char)n2));
        }

        public synchronized void write(byte[] byArray, int n2, int n3) {
            this.buf.append(new String(byArray, n2, n3));
        }

        public synchronized void write(byte[] byArray) {
            this.buf.append(new String(byArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                char c2;
                if (this.buf.length() > 0 && ((c2 = this.buf.charAt(this.buf.length() - 1)) == '\n' || c2 == '\r')) {
                    if (Boolean.getBoolean("isql.debug.threads")) {
                        this.buf.insert(0, "] ");
                        this.buf.insert(0, Thread.currentThread().getName());
                        this.buf.insert(0, "[");
                    }
                    if (!this.isSystemStream()) {
                        if (this.category.trim().length() >= 1) {
                            this.buf.insert(0, "> ");
                            this.buf.insert(0, this.category);
                            this.buf.insert(0, "<");
                        }
                    } else if (Boolean.getBoolean("isql.debug")) {
                        if (JConsole.CATEGORY_SYSTEM_ERR.equalsIgnoreCase(this.category)) {
                            err.println(this.buf.toString().trim());
                        } else {
                            out.println(this.buf.toString().trim());
                        }
                    }
                    String string = this.buf.toString();
                    SwingUtilities.invokeLater(new Appender(this.reference, this.category, string));
                    this.buf.setLength(0);
                }
            }
        }
    }
}

