/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.isqlviewer.util.BasicUtilities;

public final class JListUISupport {
    static /* synthetic */ Class class$org$isqlviewer$swing$JListUISupport;

    public static void install(JList jList) {
        JListUISupport.install(jList, true);
    }

    public static void install(JList jList, boolean bl2) {
        if (jList == null || !(jList.getModel() instanceof DefaultListModel)) {
            throw new NullPointerException();
        }
        Im im2 = new Im(jList, bl2);
        Class<?> clazz = class$org$isqlviewer$swing$JListUISupport;
        if (clazz == null) {
            clazz = class$org$isqlviewer$swing$JListUISupport = new JListUISupport[0].getClass().getComponentType();
        }
        jList.putClientProperty(clazz, im2);
    }

    public static void uninstall(JList jList) {
        Im im2;
        Class<?> clazz = class$org$isqlviewer$swing$JListUISupport;
        if (clazz == null) {
            clazz = class$org$isqlviewer$swing$JListUISupport = new JListUISupport[0].getClass().getComponentType();
        }
        if ((im2 = (Im)jList.getClientProperty(clazz)) == null) {
            return;
        }
        jList.setDropTarget(null);
        im2.dndDragSource.removeDragSourceListener(im2);
        jList.removeKeyListener(im2);
        Class<?> clazz2 = class$org$isqlviewer$swing$JListUISupport;
        if (clazz2 == null) {
            clazz2 = class$org$isqlviewer$swing$JListUISupport = new JListUISupport[0].getClass().getComponentType();
        }
        jList.putClientProperty(clazz2, null);
    }

    private JListUISupport() {
    }

    private static class Im
    extends DropTargetAdapter
    implements KeyListener,
    DragSourceListener,
    DragGestureListener {
        private Point pt = new Point(2, 2);
        private JList list = null;
        private int dragIndex = -1;
        private DragSource dndDragSource = DragSource.getDefaultDragSource();

        public Im(JList jList, boolean bl2) {
            this.list = jList;
            DropTarget dropTarget = new DropTarget(jList, this);
            jList.setDropTarget(dropTarget);
            this.dndDragSource.createDefaultDragGestureRecognizer(jList, 3, this);
            if (bl2) {
                jList.addKeyListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                int n2 = this.list.locationToIndex(dropTargetDropEvent.getLocation());
                if (this.dragIndex == n2) {
                    return;
                }
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                switch (dropTargetDropEvent.getSourceActions()) {
                    case 2: 
                    case 3: {
                        Object object = null;
                        if (dropTargetDropEvent.isLocalTransfer()) {
                            object = defaultListModel.remove(this.dragIndex);
                        } else {
                            Object e2 = defaultListModel.get(this.dragIndex);
                            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                            for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                                Object object2 = transferable.getTransferData(dataFlavorArray[i2]);
                                if (!object2.getClass().isInstance(e2)) continue;
                                object = object2;
                                break;
                            }
                            if (object == null) {
                                dropTargetDropEvent.rejectDrop();
                                return;
                            }
                        }
                        defaultListModel.add(n2, object);
                        this.list.setSelectedIndex(n2);
                        return;
                    }
                    case 1: {
                        return;
                    }
                    default: {
                        BasicUtilities.beep();
                        dropTargetDropEvent.rejectDrop();
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                dropTargetDropEvent.rejectDrop();
                return;
            }
            finally {
                dropTargetDropEvent.dropComplete(true);
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            DragGestureRecognizer dragGestureRecognizer = dragGestureEvent.getSourceAsDragGestureRecognizer();
            try {
                int n2;
                this.dragIndex = n2 = this.list.locationToIndex(dragGestureEvent.getDragOrigin());
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                if (defaultListModel.getSize() <= 1 || !this.list.getCellBounds(n2, n2).contains(dragGestureEvent.getDragOrigin())) {
                    dragGestureRecognizer.resetRecognizer();
                    return;
                }
                Transferable transferable = (Transferable)defaultListModel.get(n2);
                if (DragSource.isDragImageSupported()) {
                    GraphicsConfiguration graphicsConfiguration = this.list.getGraphicsConfiguration();
                    Component component = this.list.getCellRenderer().getListCellRendererComponent(this.list, transferable, n2, false, true);
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension);
                    BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    component.paint(graphics2D);
                    graphics2D.setColor(BasicUtilities.DND_HAZE);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    this.dndDragSource.startDrag(dragGestureEvent, null, bufferedImage, this.pt, transferable, this);
                } else {
                    this.dndDragSource.startDrag(dragGestureEvent, null, null, this.pt, transferable, this);
                }
            }
            catch (Throwable throwable) {
                dragGestureRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            int n2 = this.list.locationToIndex(dragSourceDragEvent.getLocation());
            Rectangle rectangle = this.list.getCellBounds(Math.max(0, n2 - 1), Math.min(n2 + 1, this.list.getModel().getSize() - 1));
            this.list.scrollRectToVisible(rectangle);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 8: 
                case 127: {
                    DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                    int[] nArray = this.list.getSelectedIndices();
                    for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                        defaultListModel.remove(nArray[i2]);
                    }
                    if (nArray.length < 1) break;
                    if (nArray[0] <= defaultListModel.getSize() - 1) {
                        this.list.setSelectedIndex(nArray[0]);
                    } else {
                        this.list.clearSelection();
                    }
                    keyEvent.consume();
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

