/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.text;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SyntaxStylizer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.SQLTokenizer;
import org.isqlviewer.util.StringUtilities;

public class SQLDocument
extends DefaultStyledDocument {
    private SQLTokenizer st = new SQLTokenizer(" ");
    private SyntaxStylizer styles = null;
    private boolean overwrite = false;
    private HashMap aliasMap = new HashMap();
    private boolean renderLocked = false;

    public SQLDocument() {
        this(false);
    }

    public SQLDocument(boolean bl2) {
        if (!bl2) {
            this.styles = new SyntaxStylizer(this);
        }
        this.st.setQuotesEnabled(true);
        this.st.setTokenizeDirection(0);
        this.setAsynchronousLoadPriority(5);
    }

    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.overwrite) {
            try {
                this.doRemove(n2, string.length(), false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (attributeSet == null) {
            super.insertString(n2, string, this.styles.getDefaultStyle());
        } else {
            super.insertString(n2, string, attributeSet);
        }
        this.validateStyles();
    }

    public void remove(int n2, int n3) throws BadLocationException {
        this.doRemove(n2, n3, true);
    }

    public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
        if (attributeSet == null) {
            super.replace(n2, n3, string, this.styles.getDefaultStyle());
        } else {
            super.replace(n2, n3, string, attributeSet);
        }
        this.validateStyles();
    }

    public void getText(int n2, int n3, Segment segment) throws BadLocationException {
        super.getText(n2, Math.max(0, n3), segment);
    }

    public String getText(int n2, int n3) throws BadLocationException {
        return super.getText(n2, Math.max(0, n3));
    }

    public Object clone() {
        SQLDocument sQLDocument = new SQLDocument(true);
        sQLDocument.styles = this.styles;
        return sQLDocument;
    }

    public void updateConnection(DatabaseConnection databaseConnection) {
        if (this.styles != null) {
            this.styles.setConnection(databaseConnection);
        }
        this.validateStyles();
    }

    public SyntaxStylizer getStylizer() {
        return this.styles;
    }

    public boolean isAliased(String string) {
        if (string != null) {
            return this.aliasMap.containsKey(string.toUpperCase());
        }
        return false;
    }

    public String getTableForAlias(String string) {
        return (String)this.aliasMap.get(string);
    }

    public void setStylesEnabled(boolean bl2) {
        this.renderLocked = !bl2;
    }

    public void setOverwriteEnabled(boolean bl2) {
        this.overwrite = bl2;
    }

    public boolean getOverwriteEnabled() {
        return this.overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateStyles() {
        if (this.getCurrentWriter() != null) {
            return;
        }
        this.writeLock();
        try {
            this.aliasMap.clear();
            this.applyStyles();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toHTML(String string, boolean bl2) throws Exception {
        Color color;
        StringBuffer stringBuffer = new StringBuffer("");
        AttributeSet attributeSet = this.styles.getDefaultStyle();
        Color color2 = color = StyleConstants.getForeground(attributeSet);
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        SQLTokenizer sQLTokenizer = new SQLTokenizer(string);
        String string2 = null;
        if (bl2) {
            stringBuffer.append("<html><font color=\"");
            stringBuffer.append(StringUtilities.getHTMLColor(color));
            stringBuffer.append("\">");
        } else {
            stringBuffer.append("<span style=\"color:");
            stringBuffer.append(StringUtilities.getHTMLColor(color));
            stringBuffer.append(";\">");
        }
        while (sQLTokenizer.hasMoreTokens()) {
            attributeSet = this.styles.getDefaultStyle();
            String string3 = sQLTokenizer.nextToken().trim();
            int n5 = string3.length();
            int n6 = n2 + sQLTokenizer.getTokenIndex();
            string2 = null;
            if (n6 + n5 > n3 || (string3 = string.substring(n6, n6 + n5)).trim().length() == 0) continue;
            if (n4 != n6) {
                try {
                    string2 = string.substring(n4, n6);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            n4 = n6 + n5;
            if (string3.startsWith("--")) {
                attributeSet = this.styles.getSingleCommentStyle();
            } else if (string3.startsWith("/*")) {
                attributeSet = this.styles.getMultiCommentStyle();
            } else if (string3.startsWith("\"") || string3.startsWith("'")) {
                attributeSet = this.styles.getLiteralStyle();
            }
            if (attributeSet != null) {
                attributeSet = this.styles.getStyle(string3);
            }
            color2 = StyleConstants.getForeground(attributeSet);
            if (string2 != null) {
                string3 = string2.concat(string3);
            }
            if (!color.equals(color2)) {
                if (bl2) {
                    stringBuffer.append("</font>\n");
                    stringBuffer.append("<font color=\"");
                    stringBuffer.append(StringUtilities.getHTMLColor(color2));
                    stringBuffer.append("\">");
                } else {
                    stringBuffer.append("</span>\n");
                    stringBuffer.append("<span style=\"color:");
                    stringBuffer.append(StringUtilities.getHTMLColor(color2));
                    stringBuffer.append(";\">");
                }
                color = color2;
            }
            stringBuffer.append(StringUtilities.encode(string3, true, false));
        }
        if (bl2) {
            stringBuffer.append("</font>\n");
        } else {
            stringBuffer.append("</span>\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFromFile(File file) {
        int n2;
        FileInputStream fileInputStream = null;
        try {
            this.renderLocked = true;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[256];
            int n3 = 0;
            while (true) {
                if ((n2 = fileInputStream.read(byArray)) == -1) {
                    n2 = 1;
                    this.renderLocked = false;
                    this.validateStyles();
                    break;
                }
                String string = new String(byArray, 0, n2);
                this.insertString(n3, string, null);
                string = null;
                n3 += n2;
            }
        }
        catch (Throwable throwable) {
            try {
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.renderLocked = false;
                this.validateStyles();
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            if (fileInputStream == null) return n2 != 0;
            fileInputStream.close();
            return n2 != 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2 != 0;
    }

    public void doRemove(int n2, int n3, boolean bl2) throws BadLocationException {
        super.remove(n2, n3);
        if (bl2) {
            this.validateStyles();
        }
    }

    public String getString(Element element) throws BadLocationException {
        return this.getText(element.getStartOffset(), element.getEndOffset());
    }

    public void applyStyles() throws BadLocationException {
        if (this.renderLocked) {
            return;
        }
        AttributeSet attributeSet = this.styles.getDefaultStyle();
        int n2 = 0;
        int n3 = this.getLength();
        String string = this.getText(0, n3);
        this.setParagraphAttributes(n2, n3, attributeSet, true);
        this.st.setString(string.toUpperCase().concat("\n"));
        String string2 = null;
        while (this.st.hasMoreTokens()) {
            String string3 = this.st.nextToken().trim();
            int n4 = string3.length();
            int n5 = n2 + this.st.getTokenIndex();
            if (n4 == 0) continue;
            if (string3.startsWith("--")) {
                attributeSet = this.styles.getSingleCommentStyle();
                this.setCharacterAttributes(n5, n4, attributeSet, true);
                continue;
            }
            if (string3.startsWith("/*")) {
                attributeSet = this.styles.getMultiCommentStyle();
                this.setCharacterAttributes(n5, n4, attributeSet, true);
                continue;
            }
            if (string3.startsWith("&") && string3.length() >= 2) {
                attributeSet = this.styles.getParameterStyle();
                this.setCharacterAttributes(n5, n4, attributeSet, true);
                continue;
            }
            if (string3.startsWith("\"") || string3.startsWith("'")) {
                attributeSet = this.styles.getLiteralStyle();
                this.setCharacterAttributes(n5, n4, attributeSet, true);
                continue;
            }
            if (this.isAliased(string3)) {
                attributeSet = this.styles.getStyle(this.getTableForAlias(string3));
                this.setCharacterAttributes(n5, n4, attributeSet, true);
                continue;
            }
            attributeSet = this.styles.getStyle(string3);
            int n6 = this.styles.getStyleType(string3);
            if (n6 == 5) {
                this.aliasMap.put(string3.toUpperCase(), string3);
                string2 = string3;
            } else if (string2 != null && n6 == 0) {
                this.aliasMap.put(string3, string2);
            } else {
                string2 = null;
            }
            this.setCharacterAttributes(n5, n4, attributeSet, true);
        }
    }
}

