/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.ActionPopupMenu;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.MetadataTreeModel;
import org.isqlviewer.core.model.iSQLTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JDBCTreeCellRenderer;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.ExportWizard;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public final class JDBCExplorer
extends JFrame {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private boolean debug = false;
    private boolean verbose = false;
    private final Properties NULL_TABLE = new Properties();
    private String currentCatalog;
    private String currentSchema;
    private DatabaseMetaData metadata;
    private DatabaseConnection connection;
    private ActionInputHandler actionHandler = new ActionInputHandler(null);
    private TableSelector tsExplorer;
    private TableSelector tsPrimary;
    private TableSelector tsForiegn;
    private MetadataTreeModel mdlMetadata = new MetadataTreeModel(null);
    private iSQLTableModel mdlXref = new iSQLTableModel();
    private iSQLTableModel mdlMeta = new iSQLTableModel();
    private JButton btnPrint = new JButton(BasicUtilities.loadToolbarIconResource("Print"));
    private JButton btnPreview = new JButton(BasicUtilities.loadToolbarIconResource("PrintPreview"));
    private JButton btnDeleteRowColumn = new JButton(BasicUtilities.loadToolbarIconResource("RowDelete"));
    private JButton btnExportTable = new JButton(BasicUtilities.loadToolbarIconResource("Export"));
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnXRef = new JButton(BasicUtilities.loadIconResource("Query24"));
    private ITable tabMeta = new ITable();
    private ITable tabXref = new ITable();
    private JTabbedPane jtpMain = new JTabbedPane(1);
    private JTree treMetadata = new JTree();
    private JSplitPane jspJDBC = new JSplitPane(1);
    private ActionPopupMenu mnuSQLPopup = new ActionPopupMenu("CREATE SQL");
    private static JDBCExplorer instance = null;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$org$isqlviewer$ui$JDBCExplorer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        Class<?> clazz = class$org$isqlviewer$ui$JDBCExplorer;
        if (clazz == null) {
            clazz = class$org$isqlviewer$ui$JDBCExplorer = new JDBCExplorer[0].getClass().getComponentType();
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static int showDialog(MainFrame mainFrame) {
        if (instance != null) {
            instance.toFront();
            return 0;
        }
        try {
            instance = new JDBCExplorer(mainFrame, mainFrame.getJDBCConnection());
        }
        catch (Error error) {
            String string = BasicUtilities.getString("Fatal_Error_Occured");
            BasicUtilities.showExceptionPopup(mainFrame, error, string);
            return -1;
        }
        catch (Exception exception) {
            String string = BasicUtilities.getString("General_Exception_Occured");
            BasicUtilities.showExceptionPopup(mainFrame, exception, string);
            return -1;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("JDBCExplorerNotSupported"));
            return -1;
        }
        instance.restoreSession();
        instance.show();
        return 0;
    }

    private JDBCExplorer(Frame frame, DatabaseConnection databaseConnection) {
        super(BasicUtilities.getString("JDBCExplorer_Title"), frame.getGraphicsConfiguration());
        try {
            this.initUI();
            this.setConnection(databaseConnection);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "JDBCExplorer()::initUI()");
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.saveSession();
            if (this.connection != null) {
                this.connection.flushConnectionInfo();
            }
            SystemConfig.getInstance().getIPCService().unSubscribeAll(this.actionHandler);
        }
        super.processWindowEvent(windowEvent);
    }

    private void setConnection(DatabaseConnection databaseConnection) {
        this.mdlMetadata.updateConnection(databaseConnection);
        if (databaseConnection != null) {
            this.btnXRef.setEnabled(true);
            this.debug = databaseConnection.getDebugOn();
            this.verbose = databaseConnection.getVerboseOn();
            this.connection = databaseConnection;
            this.metadata = databaseConnection.getDatabaseInformation();
            this.mnuSQLPopup.removeAll();
            this.mnuSQLPopup.add(BasicUtilities.getString("JDBCExplorer_SQL_Create")).setEnabled(false);
            SQLTemplateAction sQLTemplateAction = new SQLTemplateAction(this.treMetadata, this.metadata, 4);
            sQLTemplateAction.putValue("Name", "DROP");
            this.mnuSQLPopup.add(sQLTemplateAction);
            this.mnuSQLPopup.addSeparator();
            sQLTemplateAction = new SQLTemplateAction(this.treMetadata, this.metadata, 0);
            sQLTemplateAction.putValue("Name", "SELECT");
            this.mnuSQLPopup.add(sQLTemplateAction);
            sQLTemplateAction = new SQLTemplateAction(this.treMetadata, this.metadata, 1);
            sQLTemplateAction.putValue("Name", "INSERT");
            this.mnuSQLPopup.add(sQLTemplateAction);
            sQLTemplateAction = new SQLTemplateAction(this.treMetadata, this.metadata, 3);
            sQLTemplateAction.putValue("Name", "UPDATE");
            this.mnuSQLPopup.add(sQLTemplateAction);
            sQLTemplateAction = new SQLTemplateAction(this.treMetadata, this.metadata, 2);
            sQLTemplateAction.putValue("Name", "DELETE");
            this.mnuSQLPopup.add(sQLTemplateAction);
            this.tsExplorer.updateMetaData(databaseConnection);
            this.tsPrimary.updateMetaData(databaseConnection);
            this.tsForiegn.updateMetaData(databaseConnection);
            this.tsExplorer.setSelectedSchema(databaseConnection.getSchema());
            this.tsPrimary.setSelectedSchema(databaseConnection.getSchema());
            this.tsForiegn.setSelectedSchema(databaseConnection.getSchema());
            this.treMetadata.setModel(this.mdlMetadata);
            this.mdlMetadata.setCatalog(this.tsExplorer.getSelectedCatalog(), false);
            this.mdlMetadata.setSchema(this.tsExplorer.getSelectedSchema(), false);
            this.mdlMetadata.reload();
            this.jspJDBC.setDividerLocation(this.treMetadata.getPreferredSize().width + this.jspJDBC.getDividerSize());
        } else {
            this.mnuSQLPopup.removeAll();
            this.tsPrimary.updateMetaData(null);
            this.tsForiegn.updateMetaData(null);
            this.tsExplorer.updateMetaData(null);
            this.connection = null;
            this.metadata = null;
            this.btnXRef.setEnabled(false);
        }
    }

    private void initUI() throws Exception {
        Object object;
        this.setDefaultCloseOperation(2);
        try {
            if (!BasicUtilities.isMac()) {
                object = ((ImageIcon)BasicUtilities.loadIconResource("Information24")).getImage();
                this.setIconImage((Image)object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SystemConfig.getInstance().getIPCService().subscribe(this.actionHandler, "isql-service-change");
        this.NULL_TABLE.setProperty(BasicUtilities.getString("Error"), BasicUtilities.getString("Data_Unavailable"));
        this.tsExplorer = new TableSelector(null, false);
        this.tsPrimary = new TableSelector(null, true);
        this.tsForiegn = new TableSelector(null, true);
        this.tabMeta.setModel(this.mdlMeta);
        this.tabMeta.setDragEnabled(true);
        this.tabXref.setModel(this.mdlXref);
        this.tabXref.setDragEnabled(true);
        this.tsPrimary.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Select_Primary_Table")));
        this.tsForiegn.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Select_Foreign_Table")));
        this.tabMeta.addActionListener(this.actionHandler);
        this.tabXref.addActionListener(this.actionHandler);
        this.tsExplorer.addChangeListener(this.actionHandler);
        this.jspJDBC.setLeftComponent(new JScrollPane(this.treMetadata));
        this.jspJDBC.setRightComponent(new JScrollPane(this.tabMeta));
        this.jspJDBC.setBorder(BorderFactory.createEmptyBorder());
        this.btnPreview.addActionListener(this.actionHandler);
        this.btnPrint.addActionListener(this.actionHandler);
        this.btnDeleteRowColumn.addActionListener(this.actionHandler);
        this.btnExportTable.addActionListener(this.actionHandler);
        this.btnOK.addActionListener(this.actionHandler);
        this.btnXRef.addActionListener(this.actionHandler);
        this.btnXRef.setAlignmentY(0.5f);
        this.btnXRef.setBorderPainted(!BasicUtilities.isMac());
        this.btnXRef.setFocusPainted(false);
        this.btnXRef.setMargin(BasicUtilities.isMac() ? new Insets(2, 3, 2, 3) : new Insets(1, 1, 1, 1));
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnXRef.setToolTipText(BasicUtilities.getString("Query_Cross_References"));
        object = ActionToolBar.createNullInstance();
        ((JToolBar)object).setOrientation(0);
        ((JToolBar)object).setFloatable(false);
        ((Container)object).add(this.btnPreview);
        ((Container)object).add(this.btnPrint);
        ((Container)object).add(this.btnDeleteRowColumn);
        ((Container)object).add(this.btnExportTable);
        ((Container)object).add(Box.createVerticalGlue());
        this.treMetadata.setModel(this.mdlMetadata);
        this.treMetadata.getSelectionModel().setSelectionMode(4);
        this.treMetadata.addMouseListener(this.actionHandler);
        this.treMetadata.addTreeExpansionListener(this.actionHandler);
        this.treMetadata.addTreeSelectionListener(this.actionHandler);
        this.treMetadata.setCellRenderer(new JDBCTreeCellRenderer());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        jPanel.add((Component)this.tsPrimary, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 1, 1, 1, 1.0, 0.0, 10, 2);
        jPanel.add((Component)this.tsForiegn, UI_CONSTRAINT);
        JDBCExplorer.constrain(1, 1, 1, 1, 0.0, 0.0, 15, 0);
        jPanel.add((Component)this.btnXRef, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 2, 2, 1, 0.0, 0.0, 16, 0);
        jPanel.add((Component)new JLabel(BasicUtilities.getString("XRefs_Results_Will_Show_Here")), UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 3, 2, 1, 1.0, 1.0, 10, 1);
        jPanel.add((Component)new JScrollPane(this.tabXref), UI_CONSTRAINT);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        jPanel2.add((Component)this.tsExplorer, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 1, 1, 1, 1.0, 1.0, 10, 1);
        jPanel2.add((Component)this.jspJDBC, UI_CONSTRAINT);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        jPanel3.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        JDBCExplorer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.btnOK, UI_CONSTRAINT);
        this.jtpMain.addTab(BasicUtilities.getString("Database_Objects"), jPanel2);
        this.jtpMain.addTab(BasicUtilities.getString("Cross_Refrences"), jPanel);
        this.jtpMain.addChangeListener(this.actionHandler);
        this.getContentPane().add((Component)object, "North");
        this.getContentPane().add((Component)jPanel3, "South");
        this.getContentPane().add((Component)this.jtpMain, "Center");
        this.pack();
    }

    private ITable getActiveTable() {
        int n2 = this.jtpMain.getSelectedIndex();
        if (n2 == 0) {
            return this.tabMeta;
        }
        if (n2 == 1) {
            return this.tabXref;
        }
        return null;
    }

    private void enableActions() {
        ITable iTable = this.getActiveTable();
        boolean bl2 = false;
        if (iTable != null) {
            TableModel tableModel = iTable.getModel();
            bl2 = tableModel != null ? tableModel.getRowCount() >= 1 : false;
        }
        this.btnDeleteRowColumn.setEnabled(bl2);
        this.btnExportTable.setEnabled(bl2);
        this.btnPreview.setEnabled(bl2);
        this.btnPrint.setEnabled(bl2);
    }

    private void processAction(ActionEvent actionEvent) {
        boolean bl2 = this.jtpMain.getSelectedIndex() == 1;
        ITable iTable = this.getActiveTable();
        if (iTable == null) {
            return;
        }
        EnhancedTableModel enhancedTableModel = (EnhancedTableModel)iTable.getModel();
        Class<?> clazz = class$javax$swing$JFrame;
        if (clazz == null) {
            clazz = class$javax$swing$JFrame = new JFrame[0].getClass().getComponentType();
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, this);
        Object object = actionEvent.getSource();
        if (object == this.btnPreview) {
            String string = bl2 ? BasicUtilities.getString("Cross_Refrences") : this.treMetadata.getSelectionPath().toString();
            PrinterPreview.showPrintPreviewDialog(jFrame, (Object)new JTable(enhancedTableModel), string);
        } else if (object == this.tabMeta) {
            if (this.tabMeta.getRowSelectionAllowed()) {
                this.btnDeleteRowColumn.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
            } else {
                this.btnDeleteRowColumn.setIcon(BasicUtilities.loadToolbarIconResource("ColumnDelete"));
            }
        } else if (object == this.btnExportTable) {
            ExportWizard exportWizard = new ExportWizard((Frame)jFrame, enhancedTableModel, this.connection);
            exportWizard.show();
        } else if (object == this.btnXRef) {
            String string = this.tsPrimary.getSelectedCatalog();
            String string2 = this.tsPrimary.getSelectedSchema();
            String string3 = this.tsPrimary.getSelectedTable();
            String string4 = this.tsForiegn.getSelectedCatalog();
            String string5 = this.tsForiegn.getSelectedSchema();
            String string6 = this.tsForiegn.getSelectedTable();
            try {
                if (this.tsPrimary.compareSelection(this.tsForiegn)) {
                    String string7 = BasicUtilities.getString("Cross_Reference_Check_Error", string3);
                    JOptionPane.showMessageDialog(this, string7);
                    return;
                }
                ResultSet resultSet = this.metadata.getCrossReference(string, string2, string3, string4, string5, string6);
                this.modelResultSet(resultSet);
            }
            catch (SQLException sQLException) {
                this.modelResultSet(null);
                String[] stringArray = new String[]{string3, sQLException.getMessage()};
                String string8 = BasicUtilities.getString("Cross_Reference_Error", stringArray);
                BasicUtilities.showExceptionPopup(this, sQLException, string8);
            }
        } else if (object == this.btnOK) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (object == this.btnPrint) {
            PrinterPreview.print(iTable, bl2 ? BasicUtilities.getString("Cross_Refrences") : this.treMetadata.getSelectionPath().toString());
        } else if (object == this.btnDeleteRowColumn) {
            if (iTable.getRowSelectionAllowed()) {
                BasicUtilities.removeSelectedRows(iTable);
            } else if (iTable.getColumnSelectionAllowed()) {
                BasicUtilities.removeSelectedColumns(iTable);
            }
        }
    }

    private void restoreSession() {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        BasicUtilities.setPreferredGeometry(this, new Dimension(640, 480), "JDBCExplorer.bounds");
        String string = "session.".concat("JDBCExplorer.tab.index");
        this.tsExplorer.setSelectedSchema(userPreferences.get("session.".concat("JDBCExplorer.schema")));
        this.tsExplorer.setSelectedCatalog(userPreferences.get("session.".concat("JDBCExplorer.catalog")));
        int n2 = userPreferences.getInt(string);
        if (n2 < 0) {
            n2 = 0;
        }
        this.jtpMain.setSelectedIndex(n2);
    }

    private void saveSession() {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        userPreferences.putRect("session.".concat("JDBCExplorer.bounds"), this.getBounds());
        String string = this.tsExplorer.getSelectedSchema();
        if (string != null) {
            userPreferences.put("session.".concat("JDBCExplorer.schema"), string);
        } else {
            userPreferences.clear("session.".concat("JDBCExplorer.schema"));
        }
        string = this.tsExplorer.getSelectedCatalog();
        if (string != null) {
            userPreferences.put("session.".concat("JDBCExplorer.catalog"), string);
        } else {
            userPreferences.clear("session.".concat("JDBCExplorer.catalog"));
        }
        int n2 = this.jtpMain.getSelectedIndex();
        userPreferences.putInt("session.".concat("JDBCExplorer.tab.index"), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modelResultSet(ResultSet resultSet) {
        ITable iTable = this.getActiveTable();
        if (iTable == null) {
            throw new IllegalStateException();
        }
        iSQLTableModel iSQLTableModel2 = (iSQLTableModel)iTable.getModel();
        try {
            if (resultSet != null) {
                iSQLTableModel2.setData(resultSet);
            } else {
                iSQLTableModel2.setData(this.NULL_TABLE);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "JDBCExplorer::modelResultSet(ResultSet, boolean)");
            iSQLTableModel2.setData(this.NULL_TABLE);
        }
        finally {
            PrintWriter printWriter;
            try {
                SQLWarningViewer.addResultsetWarnings(resultSet.getWarnings());
            }
            catch (SQLException sQLException) {
                printWriter = DriverManager.getLogWriter();
                if (printWriter != null) {
                    BasicUtilities.HandleException((Throwable)sQLException, "ResultSet::getWarnings()", true, printWriter);
                }
            }
            catch (Throwable throwable) {}
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                printWriter = DriverManager.getLogWriter();
                if (printWriter != null) {
                    BasicUtilities.HandleException((Throwable)sQLException, "ResultSet::close()", true, printWriter);
                }
            }
            catch (Throwable throwable) {}
            BasicUtilities.optimizeTableView(iTable);
            this.enableActions();
        }
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        JDBCExplorer.UI_CONSTRAINT.gridx = n2;
        JDBCExplorer.UI_CONSTRAINT.gridy = n3;
        JDBCExplorer.UI_CONSTRAINT.gridwidth = n4;
        JDBCExplorer.UI_CONSTRAINT.gridheight = n5;
        JDBCExplorer.UI_CONSTRAINT.weightx = d2;
        JDBCExplorer.UI_CONSTRAINT.weighty = d3;
        JDBCExplorer.UI_CONSTRAINT.anchor = n6;
        JDBCExplorer.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private static class SQLTemplateAction
    extends AbstractAction {
        public static final int SQL_SELECT = 0;
        public static final int SQL_INSERT = 1;
        public static final int SQL_DELETE = 2;
        public static final int SQL_UPDATE = 3;
        public static final int SQL_DROP = 4;
        private JTree treeReference = null;
        private int templateType = -1;
        private DatabaseMetaData dmd = null;
        private StringBuffer sql = new StringBuffer("");

        public SQLTemplateAction(JTree jTree, DatabaseMetaData databaseMetaData, int n2) {
            this.treeReference = jTree;
            this.templateType = n2;
            this.dmd = databaseMetaData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.sql.setLength(0);
            switch (this.templateType) {
                case 0: {
                    this.generateSelect();
                    break;
                }
                case 1: {
                    this.generateInsert();
                    break;
                }
                case 2: 
                case 3: {
                    this.generateDelete();
                    break;
                }
                case 4: {
                    this.generateDrop();
                }
            }
            IPCService iPCService = SystemConfig.getInstance().getIPCService();
            if (this.sql.length() >= 1) {
                iPCService.publish(actionEvent.getSource(), "isql-sql-message", this.sql.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateSelect() {
            TreePath[] treePathArray = this.treeReference.getSelectionPaths();
            StringBuffer stringBuffer = new StringBuffer("\nFROM\n ");
            StringBuffer stringBuffer2 = new StringBuffer("");
            MetadataTreeModel metadataTreeModel = (MetadataTreeModel)this.treeReference.getModel();
            this.sql.append("SELECT\n ");
            String string = null;
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                Object object;
                String string2;
                String string3;
                TreePath treePath = treePathArray[i2];
                int n2 = treePath.getPathCount();
                if (n2 == 3 && string == null) {
                    string3 = metadataTreeModel.getCurrentSchema();
                    string2 = treePath.getLastPathComponent().toString();
                    object = null;
                    try {
                        object = this.dmd.getColumns(metadataTreeModel.getCurrentCatlog(), metadataTreeModel.getCurrentSchema(), string2.trim(), "%");
                        Object[] objectArray = JDBCUtilities.getSingleColumn((ResultSet)object, "COLUMN_NAME", null);
                        for (int i3 = 0; i3 < objectArray.length - 1; ++i3) {
                            stringBuffer2.append(objectArray[i3]);
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(objectArray[objectArray.length - 1]);
                        this.sql.append("   ");
                        this.sql.append(StringUtilities.formatBreak(80, stringBuffer2.toString(), "   ", false));
                        stringBuffer2.setLength(0);
                        this.sql.append("\nFROM\n   ");
                        string2 = string3 == null | string3.length() == 0 ? "" : string3.concat(".".concat(string2));
                        this.sql.append(string2);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {}
                        object = null;
                    }
                    stringBuffer.setLength(0);
                    return;
                }
                if (n2 != 5) continue;
                string3 = metadataTreeModel.getCurrentSchema();
                string2 = treePath.getPath()[2].toString();
                string2 = string3 == null | string3.length() == 0 ? "" : string3.concat(".".concat(string2));
                object = treePath.getLastPathComponent().toString();
                if (string != null && !string2.equalsIgnoreCase(string)) continue;
                this.sql.append((String)object);
                if (i2 + 1 < treePathArray.length) {
                    this.sql.append(", ");
                }
                if (i2 != 0) continue;
                string = string2;
                stringBuffer.append(string);
            }
            this.sql.append(stringBuffer);
            stringBuffer.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateInsert() {
            TreePath[] treePathArray = this.treeReference.getSelectionPaths();
            StringBuffer stringBuffer = new StringBuffer("");
            MetadataTreeModel metadataTreeModel = (MetadataTreeModel)this.treeReference.getModel();
            this.sql.append("INSERT INTO\n {0}\n( ");
            String string = null;
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                Object object;
                String string2;
                TreePath treePath = treePathArray[i2];
                int n2 = treePath.getPathCount();
                if (n2 == 3 && string == null) {
                    Object object2;
                    string2 = treePath.getLastPathComponent().toString();
                    object = null;
                    try {
                        int n3;
                        object = this.dmd.getColumns(metadataTreeModel.getCurrentCatlog(), metadataTreeModel.getCurrentSchema(), string2.trim(), "%");
                        stringBuffer.setLength(0);
                        object2 = JDBCUtilities.getSingleColumn((ResultSet)object, "COLUMN_NAME", null);
                        for (n3 = 0; n3 < ((Object[])object2).length - 1; ++n3) {
                            stringBuffer.append(object2[n3]);
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(object2[((Object[])object2).length - 1]);
                        this.sql.append(StringUtilities.formatBreak(80, stringBuffer.toString(), "  ", false));
                        this.sql.append(")\nVALUES\n( ");
                        stringBuffer.setLength(0);
                        for (n3 = 0; n3 < ((Object[])object2).length - 1; ++n3) {
                            stringBuffer.append("&");
                            stringBuffer.append(object2[n3]);
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append("&");
                        stringBuffer.append(object2[((Object[])object2).length - 1]);
                        this.sql.append(StringUtilities.formatBreak(80, stringBuffer.toString(), "  ", false));
                        this.sql.append(")");
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable);
                    }
                    finally {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {}
                        object = null;
                    }
                    object2 = MessageFormat.format(this.sql.toString(), string2);
                    this.sql.setLength(0);
                    this.sql.append((String)object2);
                    return;
                }
                if (n2 != 5) continue;
                string2 = treePath.getPath()[2].toString();
                object = treePath.getLastPathComponent().toString();
                if (string != null && !string2.equalsIgnoreCase(string)) continue;
                this.sql.append((String)object);
                stringBuffer.append("&");
                stringBuffer.append((String)object);
                if (i2 + 1 < treePathArray.length) {
                    this.sql.append(", ");
                    stringBuffer.append(", ");
                }
                if (i2 != 0) continue;
                string = string2;
            }
            this.sql.append(")\nVALUES\n (");
            this.sql.append(StringUtilities.formatBreak(80, stringBuffer.toString(), "  ", false));
            this.sql.append(")");
            String string3 = MessageFormat.format(this.sql.toString(), string);
            this.sql.setLength(0);
            stringBuffer.setLength(0);
            this.sql.append(string3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateDelete() {
            TreePath[] treePathArray = this.treeReference.getSelectionPaths();
            StringBuffer stringBuffer = new StringBuffer("");
            MetadataTreeModel metadataTreeModel = (MetadataTreeModel)this.treeReference.getModel();
            if (this.templateType == 2) {
                this.sql.append("DELETE FROM\n {0}\nWHERE\n ");
            } else {
                this.sql.append("UPDATE\n {0}\nSET\n ");
            }
            String string = null;
            int n2 = this.sql.length() + 80;
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                Object object;
                String string2;
                TreePath treePath = treePathArray[i2];
                int n3 = treePath.getPathCount();
                if (n3 == 3 && string == null) {
                    Object object2;
                    string2 = treePath.getLastPathComponent().toString();
                    object = null;
                    try {
                        object = this.dmd.getColumns(metadataTreeModel.getCurrentCatlog(), metadataTreeModel.getCurrentSchema(), string2.trim(), "%");
                        object2 = JDBCUtilities.getSingleColumn((ResultSet)object, "COLUMN_NAME", null);
                        for (int i3 = 0; i3 < ((Object[])object2).length - 1; ++i3) {
                            if (n2 < this.sql.length() + 2 * object2[i3].toString().length() + 4) {
                                this.sql.append("\n ");
                                n2 = this.sql.length() + 80;
                            }
                            this.sql.append(object2[i3]);
                            this.sql.append("=&");
                            this.sql.append(object2[i3]);
                            if (this.templateType == 3) {
                                this.sql.append(", ");
                                continue;
                            }
                            this.sql.append(" AND ");
                        }
                        this.sql.append(object2[((Object[])object2).length - 1]);
                        this.sql.append("=&");
                        this.sql.append(object2[((Object[])object2).length - 1]);
                        this.sql.append(" ");
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {}
                        object = null;
                    }
                    object2 = MessageFormat.format(this.sql.toString(), string2);
                    this.sql.setLength(0);
                    this.sql.append((String)object2);
                    return;
                }
                if (n3 != 5) continue;
                string2 = treePath.getPath()[2].toString();
                object = treePath.getLastPathComponent().toString();
                if (string != null && !string2.equalsIgnoreCase(string)) continue;
                if (n2 < this.sql.length() + 2 * ((String)object).length() + 4) {
                    this.sql.append("\n ");
                    n2 = this.sql.length() + 80;
                }
                this.sql.append((String)object);
                this.sql.append(" = &");
                this.sql.append((String)object);
                if (i2 + 1 < treePathArray.length) {
                    if (this.templateType == 3) {
                        this.sql.append(", ");
                    } else {
                        this.sql.append(" AND ");
                    }
                }
                if (i2 != 0) continue;
                string = string2;
            }
            String string3 = MessageFormat.format(this.sql.toString(), string);
            this.sql.setLength(0);
            this.sql.append(string3);
            stringBuffer.setLength(0);
        }

        private void generateDrop() {
            MetadataTreeModel metadataTreeModel = (MetadataTreeModel)this.treeReference.getModel();
            TreePath[] treePathArray = this.treeReference.getSelectionPaths();
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                String string;
                TreePath treePath = treePathArray[i2];
                int n2 = treePath.getPathCount();
                String string2 = metadataTreeModel.getCurrentSchema();
                String string3 = string = treePath.getPath().length >= 3 ? treePath.getPath()[2].toString() : "";
                if (n2 == 3) {
                    this.sql.append("DROP TABLE\n ");
                    string = string2 == null | string2.length() == 0 ? "" : string2.concat(".".concat(string));
                    this.sql.append(string);
                    this.sql.append("\n&RESTRICT_OR_CASCADE;\n");
                    continue;
                }
                String string4 = string2 == null | string2.length() == 0 ? "" : string2.concat(".".concat(string));
                this.sql.append("ALTER TABLE ");
                this.sql.append(string4);
                this.sql.append("\n\tDROP COLUMN ");
                this.sql.append(treePath.getLastPathComponent());
                this.sql.append(" &RESTRICT_OR_CASCADE");
                this.sql.append(treePath.getLastPathComponent().toString().toUpperCase());
                this.sql.append(";\n");
            }
        }
    }

    private class ActionInputHandler
    extends MouseInputAdapter
    implements ActionListener,
    IPCListener,
    ChangeListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private ActionInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private boolean doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreePath treePath = JDBCExplorer.this.treMetadata.getSelectionPath();
                if (treePath == null) {
                    return false;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                int n2 = treePath.getPathCount();
                if (treePath != null && JDBCExplorer.this.mdlMetadata.isTableTypeNode(defaultMutableTreeNode) && (n2 == 5 || n2 == 3)) {
                    JDBCExplorer.this.mnuSQLPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                mouseEvent.consume();
                return true;
            }
            return false;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == JDBCExplorer.this.tsExplorer) {
                if (JDBCExplorer.this.mdlMeta == null || JDBCExplorer.this.connection == null) {
                    return;
                }
                JDBCExplorer.this.currentCatalog = JDBCExplorer.this.tsExplorer.getSelectedCatalog();
                JDBCExplorer.this.currentSchema = JDBCExplorer.this.tsExplorer.getSelectedSchema();
                JDBCExplorer.this.mdlMetadata.setCatalog(JDBCExplorer.this.currentCatalog, false);
                JDBCExplorer.this.mdlMetadata.setSchema(JDBCExplorer.this.currentSchema, false);
                JDBCExplorer.this.mdlMetadata.reload();
            } else if (object == JDBCExplorer.this.jtpMain) {
                JDBCExplorer.this.enableActions();
            }
        }

        public void receiveMessage(Object object, String string, Object object2) {
            if (string != null && string.equals("isql-service-change")) {
                JDBCExplorer.this.setConnection((DatabaseConnection)object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JDBCExplorer.this.processAction(actionEvent);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            finally {
                JDBCExplorer.this.enableActions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (JDBCExplorer.this.mdlMeta == null || JDBCExplorer.this.connection == null) {
                return;
            }
            if (!JDBCExplorer.this.btnExportTable.isEnabled()) {
                JDBCExplorer.this.btnExportTable.setEnabled(true);
            }
            JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                String string = (String)defaultMutableTreeNode.getUserObject();
                if (!(JDBCExplorer.this.mdlMetadata.isProcedureNode(defaultMutableTreeNode) || JDBCExplorer.this.mdlMetadata.isTableTypeNode(defaultMutableTreeNode) || defaultMutableTreeNode.getRoot().equals(defaultMutableTreeNode))) {
                    switch (defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode) - JDBCExplorer.this.mdlMetadata.getTableTypeCount()) {
                        case 0: {
                            JDBCExplorer.this.mdlMeta.setData(JDBCExplorer.this.connection.getConnectionInformation());
                            return;
                        }
                        case 1: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getSchemas());
                            return;
                        }
                        case 2: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getCatalogs());
                            return;
                        }
                        case 3: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTableTypes());
                            return;
                        }
                        case 4: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTypeInfo());
                            return;
                        }
                        case 5: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getUDTs(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null, null));
                            return;
                        }
                        default: {
                            JDBCExplorer.this.modelResultSet(null);
                            return;
                        }
                    }
                }
                String[] stringArray = new String[]{string.trim()};
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                switch (defaultMutableTreeNode.getLevel()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        if (JDBCExplorer.this.mdlMetadata.isTableTypeNode(defaultMutableTreeNode)) {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTables(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null, stringArray));
                            return;
                        } else {
                            if (!JDBCExplorer.this.mdlMetadata.isProcedureNode(defaultMutableTreeNode)) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedures(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null));
                            return;
                        }
                    }
                    case 2: {
                        String[] stringArray2 = new String[]{defaultMutableTreeNode.getPath()[1].toString().trim()};
                        if (JDBCExplorer.this.mdlMetadata.isTableTypeNode(defaultMutableTreeNode2)) {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTables(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string, stringArray2));
                            return;
                        } else {
                            if (!JDBCExplorer.this.mdlMetadata.isProcedureNode(defaultMutableTreeNode2)) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedures(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string));
                            return;
                        }
                    }
                    case 3: {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getPath()[1];
                        if (JDBCExplorer.this.mdlMetadata.isProcedureNode(defaultMutableTreeNode3)) {
                            String string2 = defaultMutableTreeNode.getPath()[2].toString();
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedureColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string2, null));
                            return;
                        }
                        String string3 = defaultMutableTreeNode.getUserObject().toString();
                        String string4 = defaultMutableTreeNode.getPath()[2].toString();
                        try {
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Columns"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4, null));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Indicies"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getIndexInfo(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4, false, false));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Primary_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getPrimaryKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Exported_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getExportedKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Imported_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getImportedKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Version_Columns"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getVersionColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4));
                                return;
                            }
                            if (string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Table_Privileges"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTablePrivileges(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4));
                                return;
                            }
                            if (!string3.equalsIgnoreCase(BasicUtilities.getString("JDBC_Column_Privileges"))) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumnPrivileges(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string4, null));
                            return;
                        }
                        catch (Throwable throwable) {
                            BasicUtilities.HandleException(throwable, BasicUtilities.getString("JDBC_MetaData_View_Error", defaultMutableTreeNode.toString()), JDBCExplorer.this.debug);
                            return;
                        }
                    }
                    case 4: {
                        String string5 = defaultMutableTreeNode.getPath()[2].toString();
                        JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, string5, defaultMutableTreeNode.getUserObject().toString()));
                        return;
                    }
                    default: {
                        JDBCExplorer.this.modelResultSet(null);
                        return;
                    }
                }
            }
            catch (SQLException sQLException) {
                JDBCExplorer.this.modelResultSet(null);
                if (!JDBCExplorer.this.verbose) return;
                BasicUtilities.HandleException(sQLException, null, JDBCExplorer.this.debug);
                return;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "JDBCExplorer::valueChanged(TreeSelectionEvent)");
                JDBCExplorer.this.treMetadata.clearSelection();
                JDBCExplorer.this.modelResultSet(null);
                return;
            }
            finally {
                JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!JDBCExplorer.this.mdlMetadata.isUncachedNode(defaultMutableTreeNode)) return;
                switch (defaultMutableTreeNode.getLevel()) {
                    case 1: {
                        JDBCExplorer.this.mdlMetadata.loadTableTypeNode(defaultMutableTreeNode, defaultMutableTreeNode.toString());
                        return;
                    }
                    case 2: {
                        JDBCExplorer.this.mdlMetadata.loadTableChildNodes(defaultMutableTreeNode);
                        return;
                    }
                    case 3: {
                        JDBCExplorer.this.mdlMetadata.loadColumnChildNodes(defaultMutableTreeNode);
                        return;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                JDBCExplorer.this.modelResultSet(null);
                if (!JDBCExplorer.this.verbose) return;
                BasicUtilities.HandleException(throwable, null, JDBCExplorer.this.debug);
                return;
            }
            finally {
                JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public /* synthetic */ ActionInputHandler(1 var2_2) {
            this();
        }
    }
}

