/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.isqlviewer.util.BasicUtilities;

public class LoginOptionPane
extends JDialog
implements ActionListener {
    private final Insets insDefault = new Insets(2, 2, 2, 2);
    private JTextField mUserName = new JTextField("", 16);
    private JPasswordField mUserPass = new JPasswordField("", 16);
    private JButton mOKButton = new JButton(BasicUtilities.getString("Ok"));
    private JButton mCancelButton = new JButton(BasicUtilities.getString("Cancel"));
    private String[] tokens = null;

    public LoginOptionPane(Frame frame) {
        super(frame, BasicUtilities.getString("AuthPrompt_Title"), true);
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pack();
        this.mUserName.grabFocus();
        this.setResizable(false);
    }

    public static String[] showDialog(Frame frame) {
        LoginOptionPane loginOptionPane = new LoginOptionPane(frame);
        loginOptionPane.setLocationRelativeTo(frame);
        loginOptionPane.show();
        return loginOptionPane.getAuthTokens();
    }

    public String[] getAuthTokens() {
        return this.tokens;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mUserPass) || object.equals(this.mOKButton)) {
            this.tokens = new String[2];
            this.tokens[0] = this.mUserName.getText();
            this.tokens[1] = new String(this.mUserPass.getPassword());
            this.dispose();
        } else if (object.equals(this.mCancelButton)) {
            this.tokens = null;
            this.dispose();
        } else if (object.equals(this.mUserName)) {
            this.mUserPass.requestFocus();
        }
    }

    private void initUI() throws Exception {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        this.mOKButton.addActionListener(this);
        this.mUserName.addActionListener(this);
        this.mUserPass.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mUserName.requestFocus();
        Component component = null;
        component = Box.createHorizontalStrut(8);
        jPanel.add(component, this.createGridBag(0, 0, 1, 5, 0.0, 0.0, 17, 0));
        component = Box.createHorizontalStrut(8);
        jPanel.add(component, this.createGridBag(1, 0, 2, 1, 0.0, 0.0, 17, 0));
        component = new JLabel(BasicUtilities.loadIconResource("Database24"));
        jPanel.add(component, this.createGridBag(1, 1, 1, 2, 0.0, 0.0, 10, 0));
        component = new JLabel(BasicUtilities.getString("SERV_User_Label"));
        jPanel.add(component, this.createGridBag(2, 1, 1, 1, 0.0, 0.0, 17, 0));
        component = new JLabel(BasicUtilities.getString("SERV_Pass_Label"));
        jPanel.add(component, this.createGridBag(2, 2, 1, 1, 0.0, 0.0, 17, 0));
        component = this.mUserName;
        jPanel.add(component, this.createGridBag(3, 1, 1, 1, 1.0, 0.0, 17, 2));
        component = this.mUserPass;
        jPanel.add(component, this.createGridBag(3, 2, 1, 1, 1.0, 0.0, 17, 2));
        component = this.mOKButton;
        jPanel.add(component, this.createGridBag(2, 3, 1, 1, 0.0, 0.0, 13, 0));
        component = this.mCancelButton;
        jPanel.add(component, this.createGridBag(3, 3, 1, 1, 0.0, 0.0, 17, 0));
        component = Box.createHorizontalStrut(8);
        jPanel.add(component, this.createGridBag(4, 0, 1, 5, 0.0, 0.0, 17, 0));
        component = Box.createHorizontalStrut(8);
        jPanel.add(component, this.createGridBag(1, 4, 2, 1, 0.0, 0.0, 17, 0));
    }

    private GridBagConstraints createGridBag(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        return new GridBagConstraints(n2, n3, n4, n5, d2, d3, n6, n7, this.insDefault, 1, 1);
    }
}

