/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.isqlviewer.core.EnhancedDataRenderer;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class MutableContentViewer
extends JComponent {
    private ThreadGroup renderProcess = new ThreadGroup("render-processes");
    private UserInputSupport support = new UserInputSupport(null);
    private JButton unzip = new JButton(BasicUtilities.loadToolbarIconResource("Tgz"));
    private JButton saveAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
    private JScrollPane jspView = new JScrollPane();
    private EnhancedDataRenderer currentRenderer = null;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public MutableContentViewer() {
        this.setLayout(new BorderLayout());
        ActionToolBar actionToolBar = ActionToolBar.createNullInstance();
        actionToolBar.setOrientation(0);
        actionToolBar.setFloatable(false);
        ((Container)actionToolBar).add(Box.createHorizontalGlue());
        ((Container)actionToolBar).add(this.saveAs);
        ((Container)actionToolBar).add(this.unzip);
        this.add((Component)actionToolBar, "North");
        this.add((Component)this.jspView, "Center");
        this.unzip.setToolTipText(BasicUtilities.getString("Content_Unzip_Tip"));
        this.unzip.setName("Tgz");
        this.unzip.setEnabled(false);
        this.unzip.addActionListener(this.support);
        this.saveAs.setToolTipText(BasicUtilities.getString("Content_SaveAs_Tip"));
        this.saveAs.setName("SaveAs");
        this.saveAs.setEnabled(false);
        this.saveAs.addActionListener(this.support);
    }

    public void setContent(Object object, EnhancedDataRenderer enhancedDataRenderer) {
        this.unzip.setEnabled(false);
        this.renderProcess.interrupt();
        this.currentRenderer = enhancedDataRenderer;
        try {
            JComponent jComponent = enhancedDataRenderer.getDataRenderer();
            jComponent.setPreferredSize(this.jspView.getPreferredSize());
            this.jspView.setViewportView(jComponent);
            Runnable runnable = enhancedDataRenderer.renderContent(object, jComponent);
            if (runnable != null) {
                Thread thread = new Thread(this.renderProcess, runnable, enhancedDataRenderer.getName());
                thread.start();
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        this.unzip.setEnabled(object != null);
        this.saveAs.setEnabled(object != null);
    }

    public boolean performPrint() {
        JComponent jComponent;
        if (this.currentRenderer != null && this.currentRenderer.isPrintable(jComponent = (JComponent)this.jspView.getViewport().getView())) {
            PrinterPreview.print(this.currentRenderer.getPrintableData(jComponent), this.currentRenderer.getName());
            return true;
        }
        return false;
    }

    public boolean performPrintPreview() {
        JComponent jComponent;
        if (this.currentRenderer != null && this.currentRenderer.isPrintable(jComponent = (JComponent)this.jspView.getViewport().getView())) {
            Class<?> clazz = class$javax$swing$JFrame;
            if (clazz == null) {
                clazz = class$javax$swing$JFrame = new JFrame[0].getClass().getComponentType();
            }
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, this);
            PrinterPreview.showPrintPreviewDialog(jFrame, this.currentRenderer.getPrintableData(jComponent), this.currentRenderer.getName());
            return true;
        }
        return false;
    }

    public static class 1 {
    }

    private static class Decompressor
    implements Runnable {
        private EnhancedDataRenderer cdr = null;
        private SimpleDateFormat sdf = new SimpleDateFormat("");
        private JComponent jcmp = null;

        public Decompressor(EnhancedDataRenderer enhancedDataRenderer, JComponent jComponent) {
            this.cdr = enhancedDataRenderer;
            this.jcmp = jComponent;
        }

        public void run() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            try {
                InputStream inputStream = this.cdr.getBinaryStream(this.jcmp);
                if (inputStream == null) {
                    BasicUtilities.beep();
                    return;
                }
                GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
                BasicUtilities.copyStream(gZIPInputStream, byteArrayOutputStream);
                System.out.println(BasicUtilities.getString("Ungzip_Message"));
                Runnable runnable = this.cdr.renderContent(new ByteArrayBlob(byteArrayOutputStream.toByteArray()), this.jcmp);
                if (runnable != null) {
                    runnable.run();
                }
                gZIPInputStream.close();
                return;
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            try {
                InputStream inputStream = this.cdr.getBinaryStream(this.jcmp);
                if (inputStream == null) {
                    BasicUtilities.beep();
                    return;
                }
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry != null) {
                    Object object;
                    do {
                        object = null;
                        object = BasicUtilities.getString("Zip_Entry_Header", zipEntry.getName());
                        System.out.println((String)object);
                        object = BasicUtilities.getString("Zip_Entry_Cmt", zipEntry.getComment());
                        System.out.println((String)object);
                        object = BasicUtilities.getString("Zip_Entry_CRC", Long.toHexString(zipEntry.getCrc()));
                        System.out.println((String)object);
                        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
                        this.sdf.applyPattern(userPreferences.get("general.timestamp-format"));
                        object = BasicUtilities.getString("Zip_Entry_Time", this.sdf.format(new Date(zipEntry.getTime())));
                        System.out.println((String)object);
                        object = BasicUtilities.getString("Zip_Entry_Size", StringUtilities.getHumanReadableSize(zipEntry.getSize()));
                        System.out.println((String)object);
                        BasicUtilities.copyStream(zipInputStream, byteArrayOutputStream);
                        zipInputStream.closeEntry();
                    } while ((zipEntry = zipInputStream.getNextEntry()) != null);
                    object = this.cdr.renderContent(new ByteArrayBlob(byteArrayOutputStream.toByteArray()), this.jcmp);
                    if (object != null) {
                        object.run();
                    }
                    zipInputStream.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            BasicUtilities.beep();
        }
    }

    private class UserInputSupport
    implements ActionListener {
        private UserInputSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            Object object = actionEvent.getSource();
            if (MutableContentViewer.this.currentRenderer == null) {
                return;
            }
            if (object == MutableContentViewer.this.unzip) {
                Decompressor decompressor = new Decompressor(MutableContentViewer.this.currentRenderer, (JComponent)MutableContentViewer.this.jspView.getViewport().getView());
                String string = MutableContentViewer.this.currentRenderer.getName();
                Thread thread = new Thread(MutableContentViewer.this.renderProcess, decompressor, string);
                thread.start();
                return;
            }
            if (object == MutableContentViewer.this.saveAs && (file = BasicUtilities.saveSystemFile(MutableContentViewer.this)) != null) {
                FileOutputStream fileOutputStream = null;
                InputStream inputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    inputStream = MutableContentViewer.this.currentRenderer.getBinaryStream((JComponent)MutableContentViewer.this.jspView.getViewport().getView());
                    BasicUtilities.copyStream(inputStream, fileOutputStream);
                    fileOutputStream.flush();
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        public /* synthetic */ UserInputSupport(1 var2_2) {
            this();
        }
    }
}

