/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class Ping
extends AbstractSpaceCommand {
    private String a;
    private OptionHandler b;
    public static final String OPERATION_NAME = "ping";

    public Ping() {
        String[] stringArray = new String[]{"i", "url", "c", "cluster", "s", "t", "h", "help", "read", "take", "x", "ft"};
        this.b = new OptionHandler(Formatter.fromArray((String[])stringArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            String string2;
            Map map = this.b.getOptions(string);
            Transaction transaction = null;
            int n2 = 5;
            long l2 = 100L;
            long l3 = Long.MAX_VALUE;
            long l4 = 5000L;
            String string3 = "";
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (map.containsKey("s")) {
                l2 = Long.parseLong((String)map.get("s"));
            }
            if (map.containsKey("i")) {
                n2 = Integer.parseInt((String)map.get("i"));
            }
            if (map.containsKey("t")) {
                l3 = Long.parseLong((String)map.get("t"));
            } else if (map.containsKey("ft")) {
                l4 = Long.parseLong((String)map.get("ft"));
                this.a = SpaceURL.concatAttrIfNotExist(this.a, "timeout", new Long(l4).toString());
            }
            byte[] byArray = new byte[(int)l2];
            boolean bl2 = map.containsKey("x");
            String string4 = map.containsKey("take") ? "\nStarted to TAKE" : "\nStarted to READ";
            String string5 = string2 = l3 == Long.MAX_VALUE ? "FOREVER" : l3 / 1000L + " seconds";
            if (!map.containsKey("url")) {
                IJSpace[] iJSpaceArray = this.getSelectedSpaceProxies(bufferedReader);
                this.a(null, this.a, string3, string2, l4, l2, n2);
                this.a(iJSpaceArray, l3, n2, map, byArray, bl2);
                return "";
            }
            this.a = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(this.a, true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object object = null;
            try {
                object = this.find(this.a);
            }
            catch (FinderException finderException) {
                return "";
            }
            if (object == null) {
                CLIUtilities.printWrongServiceURLMessage(this.a);
                return "";
            }
            IJSpace iJSpace = null;
            if (object instanceof IJSpaceContainer) {
                SpaceURL spaceURL = SpaceURLParser.parseURL(this.a);
                ServiceItem[] serviceItemArray = this.getContainerSpaces((IJSpaceContainer)object, spaceURL.getProtocol());
                IJSpace[] iJSpaceArray = this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
                if (iJSpaceArray != null && iJSpaceArray.length > 0) {
                    this.a(null, this.a, string3, string2, l4, l2, n2);
                    this.a(iJSpaceArray, l3, n2, map, byArray, bl2);
                }
                return "";
            }
            if (object instanceof IJSpace) {
                iJSpace = (IJSpace)object;
            }
            if (iJSpace == null) {
                String string6 = "Space was not found using the SpaceURL: " + this.a;
                System.out.println(string6);
                return "";
            }
            String string7 = iJSpace.getName();
            if (bl2) {
                string3 = " [ using transaction ] ";
            }
            this.a(string7, this.a, string3, string2, l4, l2, n2);
            ClusterPolicy clusterPolicy = this.getClusterPolicy(iJSpace);
            if (clusterPolicy != null) {
                if (map.containsKey("c") || map.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    this.a(clusterPolicy, l3, n2, map.containsKey("take"), byArray, bl2);
                } else {
                    IJSpace[] iJSpaceArray = this.getAllClusterMembers(clusterPolicy, bufferedReader);
                    if (iJSpaceArray == null) {
                        return "No cluster members found.";
                    }
                    this.a(iJSpaceArray, l3, n2, map, byArray, bl2);
                }
            } else {
                if (bl2) {
                    transaction = this.a(iJSpace);
                }
                this.a(iJSpace, l3, n2, map.containsKey("take"), byArray, transaction);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    private void a(String string, String string2, String string3, String string4, long l2, long l3, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.operationName);
        if (string != null) {
            stringBuffer.append(" from <" + string + "> space\n");
        }
        stringBuffer.append(" with:\n");
        stringBuffer.append("Finder URL: " + string2);
        stringBuffer.append("\nLease Timeout: " + string3);
        stringBuffer.append(" " + string4);
        stringBuffer.append("\nLookupFinder timeout: " + l2 / 1000L + " seconds\n");
        stringBuffer.append("Buffer Size: " + l3);
        stringBuffer.append("\nIterations: " + n2);
        stringBuffer.append("\n");
        System.out.println(stringBuffer.toString());
    }

    private void a(IJSpace[] iJSpaceArray, long l2, int n2, Map map, byte[] byArray, boolean bl2) throws RemoteException, LeaseDeniedException {
        if (iJSpaceArray != null) {
            Transaction transaction = null;
            int n3 = iJSpaceArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string = iJSpaceArray[i2].getName();
                System.out.println("Started to ping <" + string + "> space (" + (i2 + 1) + " of " + n3 + ")...");
                if (bl2) {
                    transaction = this.a(iJSpaceArray[i2]);
                }
                try {
                    this.a(iJSpaceArray[i2], l2, n2, map.containsKey("take"), byArray, transaction);
                    System.out.println(" successful\n");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(" fail");
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
    }

    private void a(IJSpace iJSpace, long l2, int n2, boolean bl2, byte[] byArray, Transaction transaction) throws Exception {
        long l3 = System.currentTimeMillis();
        for (int i2 = 1; i2 <= n2; ++i2) {
            iJSpace.write(new Message(i2, byArray), transaction, Long.MAX_VALUE);
            Message message = new Message(i2, null);
            if (bl2) {
                iJSpace.take(message, transaction, l2);
                continue;
            }
            iJSpace.read(message, transaction, l2);
        }
        if (transaction != null) {
            transaction.commit();
        }
        long l4 = (System.currentTimeMillis() - l3) / (long)n2;
        System.out.println("Average Time = " + l4 + " milliseconds");
    }

    private Transaction a(IJSpace iJSpace) throws RemoteException, LeaseDeniedException {
        TransactionManager transactionManager = LocalTransactionManager.getInstance(iJSpace);
        Transaction.Created created = TransactionFactory.create(transactionManager, Long.MAX_VALUE);
        return created.transaction;
    }

    public String getUsage() {
        StringBuffer stringBuffer = this.getBasicUsage();
        stringBuffer.append("\t-t     set timeout in milliseconds\n");
        stringBuffer.append("\t-ft    set LookupFinder timeout in milliseconds\n");
        stringBuffer.append("\t-s     set byte size of the object.\n");
        stringBuffer.append("\t-i     set number of iteration.\n");
        stringBuffer.append("\t-read  read from space\n");
        stringBuffer.append("\t-take  take from space\n");
        stringBuffer.append("\t-x     under transaction\n");
        stringBuffer.append("\n*****************************************************\n\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ClusterPolicy clusterPolicy, long l2, int n2, boolean bl2, byte[] byArray, boolean bl3) throws RemoteException, FinderException, NoSuchNameException {
        Map map = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy);
        Set set = map.entrySet();
        System.out.println("There are " + map.size() + " cluster spaces to be pinged.");
        int n3 = 0;
        Transaction transaction = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            IJSpace iJSpace = (IJSpace)entry.getValue();
            try {
                String string2 = n3 + " Ping <" + string + "> cluster member...";
                System.out.print(string2);
                if (bl3) {
                    transaction = this.a(iJSpace);
                }
                this.a(iJSpace, l2, n2, bl2, byArray, transaction);
                System.out.println(" successful.");
            }
            catch (Exception exception) {
                System.out.println(" fail.");
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
            finally {
                ++n3;
            }
        }
    }

    public static class Message
    implements Entry {
        public Integer m_counter;
        public byte[] m_content;

        public Message() {
        }

        public Message(int n2, byte[] byArray) {
            this.m_content = byArray;
            this.m_counter = _Integer.valueOf(n2);
        }

        public String toString() {
            return " reading  from space " + this.m_counter + " times.";
        }

        public static String[] __getSpaceIndexedFields() {
            String[] stringArray = new String[]{"m_counter"};
            return stringArray;
        }
    }
}

