/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceSQL
implements GS.OptionHandler,
Constants {
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler b;
    public static final String OPERATION_NAME = "sql";
    private static final String c = "com.j_spaces.jdbc.driver.GDriver";
    private static final String d = "jdbc:gigaspaces:url:";
    private ResultSet e;
    private int f;
    private Map g = new HashMap();

    public SpaceSQL() {
        String[] stringArray = new String[]{"h", "help", "url", "query", "multispace"};
        this.b = new OptionHandler(Formatter.fromArray((String[])stringArray));
        try {
            Class.forName(c);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to initialize com.j_spaces.jdbc.driver.GDriver class.");
            a.log(Level.SEVERE, classNotFoundException.toString(), classNotFoundException);
        }
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n\n");
        stringBuffer.append("Usage: space sql [options] query \n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help    prints help\n");
        stringBuffer.append("\t-url    space url, mandatory option\n");
        stringBuffer.append("\t-query  query that will be run on the space, mandatory option\n");
        stringBuffer.append("\t-multispace  indicates if this query will be multi space, by default query is single space\n");
        stringBuffer.append("Usage example: ");
        stringBuffer.append("\tspace sql url rmi://localhost:10098/myCache_container/myCache query select uid,* from com.j_spaces.examples.benchmark.messages.Message WHERE rownum<1000\n");
        stringBuffer.append("\n*****************************************************\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(String string, BufferedReader bufferedReader) {
        Statement statement = null;
        try {
            Map map = this.b.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                String string2 = this.getUsage();
                return string2;
            }
            if (!map.containsKey("url")) {
                CLIUtilities.printMissingParameterMessage("url");
                String string3 = this.getUsage();
                return string3;
            }
            if (!map.containsKey("query")) {
                CLIUtilities.printMissingParameterMessage("query");
                String string4 = this.getUsage();
                return string4;
            }
            String string5 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string5, true)) {
                CLIUtilities.printMissingValueMessage("url");
                String string6 = "";
                return string6;
            }
            String string7 = (String)map.get("query");
            if (JSpaceUtilities.isEmpty(string7, true)) {
                CLIUtilities.printMissingValueMessage("query");
                String string8 = "";
                return string8;
            }
            System.out.println("Query:" + string7);
            Connection connection = (Connection)this.g.get(string5);
            if (connection == null) {
                connection = DriverManager.getConnection(d + string5);
                this.g.put(string5, connection);
                connection.setAutoCommit(true);
            }
            statement = connection.createStatement();
            if (map.containsKey("multispace")) {
                ((GConnection)connection).setUseSingleSpace(false);
            } else {
                ((GConnection)connection).setUseSingleSpace(true);
            }
            if (string7.startsWith("select")) {
                this.e = statement.executeQuery(string7);
                this.a(this.e);
            } else {
                statement.executeUpdate(string7);
            }
            if (JSpaceUtilities.isEmpty(string7, true)) {
                CLIUtilities.printMissingValueMessage("url");
                String string9 = "";
                return string9;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to run query, see log file for details.");
            a.log(Level.SEVERE, exception.toString(), exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    a.log(Level.SEVERE, sQLException.toString(), sQLException);
                }
            }
        }
        return "";
    }

    private void a(ResultSet resultSet) {
        StringBuffer stringBuffer = null;
        try {
            int n2;
            resultSet.getMetaData();
            int n3 = resultSet.getMetaData().getColumnCount();
            stringBuffer = new StringBuffer();
            for (n2 = 1; n2 <= n3; ++n2) {
                stringBuffer.append(this.b(resultSet.getMetaData().getColumnName(n2), resultSet.getMetaData().getColumnDisplaySize(n2)));
                if (n2 == n3) {
                    stringBuffer.append("-|");
                    continue;
                }
                stringBuffer.append("-+-");
            }
            System.out.println("\n" + stringBuffer);
            stringBuffer = new StringBuffer();
            for (n2 = 1; n2 <= n3; ++n2) {
                stringBuffer.append(this.a(resultSet.getMetaData().getColumnName(n2), resultSet.getMetaData().getColumnDisplaySize(n2)));
                stringBuffer.append(" | ");
            }
            System.out.println(stringBuffer);
            stringBuffer = new StringBuffer();
            for (n2 = 1; n2 <= n3; ++n2) {
                stringBuffer.append(this.b(resultSet.getMetaData().getColumnName(n2), resultSet.getMetaData().getColumnDisplaySize(n2)));
                if (n2 == n3) {
                    stringBuffer.append("-|");
                    continue;
                }
                stringBuffer.append("-+-");
            }
            System.out.println(stringBuffer.toString());
            while (resultSet != null && resultSet.next()) {
                stringBuffer = new StringBuffer();
                for (n2 = 1; n2 <= n3; ++n2) {
                    stringBuffer.append(this.a(resultSet.getMetaData().getColumnName(n2), resultSet.getObject(n2).toString(), resultSet.getMetaData().getColumnDisplaySize(n2)));
                    stringBuffer.append(" | ");
                }
                System.out.println(stringBuffer + "\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String a(String string, int n2) {
        if (string == null) {
            string = "NULL";
        }
        if (this.f != 0 && n2 > this.f) {
            n2 = this.f;
        }
        if (n2 < string.length()) {
            n2 = string.length();
        }
        int n3 = string.length();
        boolean bl2 = false;
        if (n3 >= n2) {
            return string.substring(0, n2);
        }
        int n4 = n2 - n3;
        StringBuffer stringBuffer = new StringBuffer(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuffer.append(' ');
        }
        if (bl2) {
            return string + stringBuffer;
        }
        if (string.startsWith("-")) {
            return "-" + stringBuffer + string.substring(1);
        }
        return string + stringBuffer;
    }

    private String b(String string, int n2) {
        int n3;
        if (string == null) {
            string = "NULL";
        }
        if (this.f != 0 && n2 > this.f) {
            n2 = this.f;
        }
        if (n2 < string.length()) {
            n2 = string.length();
        }
        if ((n3 = string.length()) >= n2) {
            n2 = n3;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    private String a(String string, String string2, int n2) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (this.f != 0 && n2 > this.f) {
            n2 = this.f;
        }
        if (n2 < string.length()) {
            n2 = string.length();
        }
        int n3 = string2.length();
        boolean bl2 = false;
        if (n3 >= n2) {
            return string2.substring(0, n2);
        }
        int n4 = n2 - n3;
        StringBuffer stringBuffer = new StringBuffer(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuffer.append(' ');
        }
        if (bl2) {
            return string2 + stringBuffer;
        }
        if (string2.startsWith("-")) {
            return "-" + stringBuffer + string2.substring(1);
        }
        return string2 + stringBuffer;
    }
}

