/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.converter.pojo;

import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.converter.ConversionException;
import com.gigaspaces.converter.ConverterTracer;
import com.gigaspaces.converter.pojo.Configuration;
import com.gigaspaces.converter.pojo.POJODescription;
import com.j_spaces.kernel.ResourceLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.gs.beans.FeatureDescriptor;
import org.apache.commons.gs.beans.PropertyDescriptor;
import org.apache.commons.gs.beanutils.PropertyUtils;

public class ConverterHelper {
    private InputStream[] a;
    private File[] b;
    private File[] c;
    public Configuration configuration;
    private boolean d = false;
    private HashMap e = new HashMap();

    public ConverterHelper() {
        this.configuration = this.newConfiguration();
    }

    public ConverterHelper(boolean bl2) {
        this.d = bl2;
        this.configuration = this.newConfiguration();
    }

    public void setMappingResources(String[] stringArray) throws IOException {
        this.a = new InputStream[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.a[i2] = this.getInputStream(stringArray[i2].trim());
        }
        if (this.d) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception exception) {
                if (exception instanceof ConversionException) {
                    throw (ConversionException)exception;
                }
                throw new ConversionException("Failed to invoke the afterPropertiesSet() method", exception);
            }
        }
    }

    public void setMappingJarLocations(String[] stringArray) throws FileNotFoundException, IOException {
        this.c = new File[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.c[i2] = ConverterHelper.getFile(this.getURL(stringArray[i2].trim()));
        }
        if (this.d) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception exception) {
                if (exception instanceof ConversionException) {
                    throw (ConversionException)exception;
                }
                throw new ConversionException("Failed to invoke afterPropertiesSet() method", exception);
            }
        }
    }

    public void setMappingDirectoryLocations(String[] stringArray) throws FileNotFoundException, IOException {
        this.b = new File[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.b[i2] = ConverterHelper.getFile(this.getURL(stringArray[i2].trim()));
        }
        if (this.d) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception exception) {
                if (exception instanceof ConversionException) {
                    throw (ConversionException)exception;
                }
                throw new ConversionException("Failed to invoke afterPropertiesSet() method", exception);
            }
        }
    }

    public static File getFile(URL uRL) throws FileNotFoundException {
        return new File(URLDecoder.decode(uRL.getFile()));
    }

    public URL getURL(String string) throws IOException {
        URL uRL = null;
        uRL = ResourceLoader.getResourceURL(string);
        if (ConverterTracer.getLogger().isLoggable(Level.FINE)) {
            ConverterTracer.getLogger().log(Level.FINE, "*.gs.xml files are loaded from : {0}", uRL);
        }
        if (uRL == null) {
            throw new FileNotFoundException(string + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    public InputStream getInputStream(String string) throws IOException {
        InputStream inputStream = null;
        inputStream = ResourceLoader.getResourceStream(string);
        if (inputStream == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(string + " cannot be opened because it does not exist");
        }
        return inputStream;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configuration == null) {
            this.configuration = this.newConfiguration();
        }
        try {
            File file;
            int n2;
            if (this.a != null) {
                for (n2 = 0; n2 < this.a.length; ++n2) {
                    this.configuration.addInputStream(this.a[n2]);
                }
                if (this.d) {
                    this.a = null;
                }
            }
            if (this.c != null) {
                for (n2 = 0; n2 < this.c.length; ++n2) {
                    file = this.c[n2];
                    this.configuration.addJar(file);
                }
                if (this.d) {
                    this.c = null;
                }
            }
            if (this.b != null) {
                for (n2 = 0; n2 < this.b.length; ++n2) {
                    file = this.b[n2];
                    if (file == null) continue;
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("Mapping directory location [" + this.b[n2] + "] does not denote a directory");
                    }
                    this.configuration.addDirectory(file);
                }
                if (this.d) {
                    this.b = null;
                }
            }
            this.a(new ArrayList(this.configuration.getExternalEntryMap().values()), this.configuration.getExternalEntryMap());
            if (ConverterTracer.getLogger().isLoggable(Level.FINEST)) {
                ConverterTracer.getLogger().log(Level.FINEST, "The *.gs.xml mapping file structure: {0} ", this.configuration.getExternalEntryMap().values());
            }
            if (ConverterTracer.getLogger().isLoggable(Level.FINE) && this.configuration.getExternalEntryMap().values().isEmpty()) {
                ConverterTracer.getLogger().log(Level.FINE, " No *.gs.xml files were found under config/mapping folder.");
            }
        }
        catch (Exception exception) {
            if (exception instanceof ConversionException) {
                throw exception;
            }
            throw new ConversionException(exception);
        }
    }

    private void a(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            POJODescription pOJODescription;
            block4: {
                pOJODescription = (POJODescription)iterator.next();
                try {
                    if (this.e.get(pOJODescription.name) == null) {
                        this.fillNext(pOJODescription, list, map);
                    }
                    pOJODescription.postProcess();
                }
                catch (Exception exception) {
                    if (!ConverterTracer.getLogger().isLoggable(Level.SEVERE)) break block4;
                    ConverterTracer.getLogger().log(Level.SEVERE, "pojoDescription.postProcess() method of {0} failed due to exception {1}", new Object[]{pOJODescription.name, exception});
                }
            }
            this.e.put(pOJODescription.name, pOJODescription.name);
            iterator.remove();
        }
        this.e.clear();
    }

    public void fillNext(POJODescription pOJODescription, List list, Map map) {
        Object object;
        Serializable serializable;
        if (pOJODescription.getFieldInclusion() == SpaceClass.IncludeProperties.IMPLICIT) {
            serializable = null;
            try {
                serializable = Thread.currentThread().getContextClassLoader().loadClass(pOJODescription.name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConversionException("Failed to load class [" + pOJODescription.name + "]", classNotFoundException);
            }
            object = PropertyUtils.getPropertyDescriptors(serializable);
            for (int i2 = 0; i2 < ((PropertyDescriptor[])object).length; ++i2) {
                if (((PropertyDescriptor)object[i2]).getReadMethod().getDeclaringClass() != serializable || pOJODescription.getFieldNames().contains(((FeatureDescriptor)object[i2]).getName())) continue;
                pOJODescription.getFieldNames().add(((FeatureDescriptor)object[i2]).getName());
            }
        }
        Collections.sort(pOJODescription.fieldNames, new Comparator(){

            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }

            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((String)object, (String)object2);
            }
        });
        serializable = new ArrayList(pOJODescription.getRefClasses());
        object = serializable.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            POJODescription pOJODescription2 = (POJODescription)map.get(string);
            if (pOJODescription2 != null) {
                if (this.e.get(pOJODescription2.name) == null) {
                    this.fillNext(pOJODescription2, list, map);
                }
                this.unionPojoDescription(pOJODescription, pOJODescription2);
                this.e.put(pOJODescription2.name, pOJODescription2.name);
                continue;
            }
            if (!ConverterTracer.getLogger().isLoggable(Level.INFO)) continue;
            ConverterTracer.getLogger().log(Level.INFO, "The class name {0} has no declared gs xml file", string);
        }
    }

    public void unionPojoDescription(POJODescription pOJODescription, POJODescription pOJODescription2) {
        pOJODescription.fieldNames.removeAll(pOJODescription2.fieldNames);
        pOJODescription.fieldNames.addAll(0, pOJODescription2.fieldNames);
        if (pOJODescription.fieldPks.isEmpty()) {
            pOJODescription.fieldAutoPkGen.addAll(pOJODescription2.fieldAutoPkGen);
            pOJODescription.fieldPks.addAll(pOJODescription2.fieldPks);
        }
        if (pOJODescription.fieldIndexs.isEmpty() || pOJODescription.getIndexingMode()) {
            pOJODescription.fieldIndexs.addAll(pOJODescription2.fieldIndexs);
        }
        HashMap hashMap = new HashMap(pOJODescription2.defaultStringNullValueFields);
        hashMap.putAll(pOJODescription.defaultStringNullValueFields);
        pOJODescription.defaultStringNullValueFields.putAll(hashMap);
        HashMap hashMap2 = new HashMap(pOJODescription2.serializationTypeFields);
        hashMap2.putAll(pOJODescription.serializationTypeFields);
        pOJODescription.serializationTypeFields.putAll(hashMap2);
        pOJODescription.refClasses.removeAll(pOJODescription2.refClasses);
        pOJODescription.refClasses.addAll(pOJODescription2.refClasses);
        pOJODescription.hashBasedKey.removeAll(pOJODescription2.hashBasedKey);
        pOJODescription.hashBasedKey.addAll(pOJODescription2.hashBasedKey);
        pOJODescription.versioned.removeAll(pOJODescription2.versioned);
        pOJODescription.versioned.addAll(pOJODescription2.versioned);
        pOJODescription.persist.removeAll(pOJODescription2.persist);
        pOJODescription.persist.addAll(pOJODescription2.persist);
        pOJODescription.routing.removeAll(pOJODescription2.routing);
        pOJODescription.routing.addAll(pOJODescription2.routing);
        pOJODescription.exclude.removeAll(pOJODescription2.exclude);
        pOJODescription.exclude.addAll(pOJODescription2.exclude);
        pOJODescription.lazyDeserialization.removeAll(pOJODescription2.lazyDeserialization);
        pOJODescription.lazyDeserialization.addAll(pOJODescription2.lazyDeserialization);
        pOJODescription.payload.removeAll(pOJODescription2.payload);
        pOJODescription.payload.addAll(pOJODescription2.payload);
        pOJODescription.isValidPOJODescription();
    }

    public Configuration newConfiguration() {
        return new Configuration();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Map getPOJODescriptorsMap() {
        return this.configuration.getExternalEntryMap();
    }
}

