/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.transport;

import com.gigaspaces.transport.ITransportConfig;
import com.j_spaces.kernel.lrmi.DynamicSmartStub;
import com.j_spaces.obf.hv;
import com.j_spaces.obf.kf;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;

public class GenericExporter
implements Exporter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private ITransportConfig _config;
    private transient Map _identityExportObjTable = new HashMap();

    public GenericExporter(ITransportConfig iTransportConfig) {
        this._config = iTransportConfig;
    }

    public ITransportConfig getConfiguration() {
        return this._config;
    }

    public synchronized Remote export(Remote remote) throws ExportException {
        return this.export(remote, this._config);
    }

    public synchronized Remote export(Remote remote, ITransportConfig iTransportConfig) throws ExportException {
        Remote remote2;
        if (remote == null) {
            throw new IllegalArgumentException("Implementation obj: [ " + remote.getClass() + " can not be null");
        }
        if (iTransportConfig == null) {
            throw new IllegalArgumentException("Configuration object can not be null");
        }
        hv hv2 = new hv(remote);
        WeakReference weakReference = (WeakReference)this._identityExportObjTable.get(hv2);
        Remote remote3 = remote2 = weakReference != null ? (Remote)weakReference.get() : null;
        if (remote2 != null) {
            return remote2;
        }
        remote2 = kf.a().b(remote, iTransportConfig);
        this._identityExportObjTable.put(hv2, new WeakReference<Remote>(remote2));
        return remote2;
    }

    public synchronized boolean _unexport(Remote remote, boolean bl2) {
        Remote remote2;
        WeakReference weakReference = (WeakReference)this._identityExportObjTable.get(new hv(remote));
        Remote remote3 = remote2 = weakReference != null ? (Remote)weakReference.get() : null;
        if (remote2 == null) {
            return true;
        }
        DynamicSmartStub dynamicSmartStub = DynamicSmartStub.extractSmartStubFromProxy(remote2);
        dynamicSmartStub.close();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ObjImpl: [" + dynamicSmartStub.getLocalObjImpl() + "] was unexported.");
        }
        return true;
    }

    public synchronized boolean unexport(Remote remote, boolean bl2) {
        this._unexport(remote, bl2);
        this._identityExportObjTable.remove(new hv(remote));
        return true;
    }

    public synchronized boolean unexport(boolean bl2) {
        Iterator iterator = this._identityExportObjTable.keySet().iterator();
        while (iterator.hasNext()) {
            hv hv2 = (hv)iterator.next();
            Remote remote = (Remote)hv2.get();
            if (remote != null) {
                this._unexport(remote, bl2);
            }
            iterator.remove();
        }
        return true;
    }

    public synchronized boolean isExported(Remote remote) {
        return this._identityExportObjTable.containsKey(new hv(remote));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._identityExportObjTable = new HashMap();
    }
}

