/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.IStubHandler;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.obf.w;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLStubHandlerImpl
implements IStubHandler {
    private static final long serialVersionUID = 3835153952172815926L;
    public transient RMISSLClientSocketFactory m_Csf;
    public transient RMISSLServerSocketFactory m_Ssf;
    public transient SSLSocketFactory m_factory;
    public transient SSLServerSocketFactory m_serverFactory;
    private String m_SpaceName;
    private String m_Ssl_Protocol_Name;
    private String m_Ssl_Keystore_Type;
    private String m_Ssl_KeyManagment_Method;
    private String m_Ssl_KeyStore;
    private String m_Ssl_TrustStore;
    private String m_Ssl_Password;
    private int m_SpacePort;
    private int m_ClientPort;
    private boolean _isServerSide = true;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.core.common");

    public void init(String string) {
        this.m_SpaceName = string;
        this.m_SpacePort = Integer.parseInt(JProperties.getSpaceProperty(string, "lrmi-stub-handler.server-port", "0"));
        this.m_ClientPort = Integer.parseInt(JProperties.getSpaceProperty(string, "lrmi-stub-handler.client-port", "0"));
        this.m_Ssl_Protocol_Name = JProperties.getSpaceProperty(string, "ssl-stub-handler.protocol-name", "TLS");
        this.m_Ssl_Keystore_Type = JProperties.getSpaceProperty(string, "ssl-stub-handler.keystore-type", "JKS");
        this.m_Ssl_KeyManagment_Method = JProperties.getSpaceProperty(string, "ssl-stub-handler.key-managment-method", "SunX509");
        this.m_Ssl_KeyStore = JProperties.getSpaceProperty(string, "ssl-stub-handler.keystore", "testkeys");
        this.m_Ssl_TrustStore = JProperties.getSpaceProperty(string, "ssl-stub-handler.truststore", "testkeys");
        this.setTrustStore();
        this.m_Ssl_Password = System.getProperty("com.gs.security.ssl.password");
        if (this.m_Ssl_Password == null) {
            this.m_Ssl_Password = JProperties.getSpaceProperty(string, "ssl-stub-handler.password", "passphrase");
        }
    }

    public String getProtocolName() {
        return this.m_Ssl_Protocol_Name;
    }

    private void setTrustStore() {
        String string = System.getProperty("javax.net.ssl.trustStore");
        if (string != null && !string.equals("")) {
            return;
        }
        System.setProperty("javax.net.ssl.trustStore", this.m_Ssl_TrustStore);
    }

    public synchronized Remote exportObject(Remote remote) throws RemoteException {
        if (this._isServerSide) {
            if (this.m_Csf == null || this.m_Ssf == null) {
                this.m_Csf = new RMISSLClientSocketFactory(null);
                this.m_Ssf = new RMISSLServerSocketFactory(null);
            }
            try {
                return RemoteObject.toStub(remote);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return UnicastRemoteObject.exportObject(remote, this.m_SpacePort, this.m_Csf, this.m_Ssf);
            }
        }
        return UnicastRemoteObject.exportObject(remote, this.m_ClientPort);
    }

    public void unexportObject(Remote remote, boolean bl2) throws RemoteException {
        UnicastRemoteObject.unexportObject(remote, bl2);
    }

    public boolean isStub(Remote remote) {
        return remote instanceof RemoteStub;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._isServerSide = false;
        this.setTrustStore();
    }

    public String toString() {
        return "Space: [" + this.m_SpaceName + "] SSLStubHandlerImpl";
    }

    private class RMISSLServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RMISSLServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int n2) throws IOException {
            Object object;
            if (SSLStubHandlerImpl.this.m_serverFactory == null) {
                try {
                    char[] cArray = SSLStubHandlerImpl.this.m_Ssl_Password.toCharArray();
                    object = SSLContext.getInstance(SSLStubHandlerImpl.this.m_Ssl_Protocol_Name);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SSLStubHandlerImpl.this.m_Ssl_KeyManagment_Method);
                    KeyStore keyStore = KeyStore.getInstance(SSLStubHandlerImpl.this.m_Ssl_Keystore_Type);
                    keyStore.load(new FileInputStream(SSLStubHandlerImpl.this.m_Ssl_KeyStore), cArray);
                    keyManagerFactory.init(keyStore, cArray);
                    ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), null, null);
                    SSLStubHandlerImpl.this.m_serverFactory = ((SSLContext)object).getServerSocketFactory();
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "RMISSLServerSocketFactory failed to initialize " + exception.toString(), exception);
                    }
                    IOException iOException = new IOException(exception.getMessage());
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            object = (SSLServerSocket)SSLStubHandlerImpl.this.m_serverFactory.createServerSocket(n2);
            return object;
        }

        public /* synthetic */ RMISSLServerSocketFactory(w w2) {
            this();
        }
    }

    private class RMISSLClientSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RMISSLClientSocketFactory() {
        }

        public Socket createSocket(String string, int n2) throws IOException {
            if (SSLStubHandlerImpl.this.m_factory == null) {
                try {
                    SSLStubHandlerImpl.this.m_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to initialize RMISSLClientSocketFactory" + exception.toString(), exception);
                    }
                    IOException iOException = new IOException(exception.getMessage());
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
            SSLSocket sSLSocket = (SSLSocket)SSLStubHandlerImpl.this.m_factory.createSocket(string, n2);
            return sSLSocket;
        }

        public /* synthetic */ RMISSLClientSocketFactory(w w2) {
            this();
        }
    }
}

