/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.EntryPacket;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.AbstractDirectSpaceProxy;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.TypeTableEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.RemoteEvent;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.sf.retrotranslator.runtime.java.lang.Deprecated_;

public class EntryArrivedRemoteEvent
extends RemoteEvent
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -8397537059416989796L;
    private static final String EMPTY_STRING = "";
    private EntryPacket _entryPacket;
    private List _acceptableFilterIDList;
    private String _multicastTemplateID;
    private int _notifyType;
    public transient IJSpace _spaceProxy;
    private Uuid _spaceProxyUuid;

    public EntryArrivedRemoteEvent() {
        super(EMPTY_STRING, 0L, 0L, null);
    }

    public EntryArrivedRemoteEvent(IJSpace iJSpace, long l2, long l3, MarshalledObject marshalledObject, EntryPacket entryPacket, int n2) {
        super(EMPTY_STRING, l2, l3, marshalledObject);
        this._entryPacket = entryPacket;
        this._notifyType = n2;
        this._spaceProxy = iJSpace;
        this._spaceProxyUuid = this._spaceProxy.getReferentUuid();
    }

    public EntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    public Object getSource() {
        return this._spaceProxy;
    }

    public Uuid getSpaceUuid() {
        return this._spaceProxyUuid;
    }

    public ExternalEntry getExternalEntry() throws UnusableEntryException {
        return this._entryPacket.getExternalEntry(this._spaceProxy);
    }

    @Deprecated_
    public Entry getEntry(boolean bl2) throws UnusableEntryException {
        if (bl2) {
            return this._entryPacket.getExternalEntry(this._spaceProxy);
        }
        return this._entryPacket.getEntry(this._spaceProxy);
    }

    @Deprecated_
    public Entry getEntry() throws UnusableEntryException {
        Entry entry = this.getEntry(false);
        return entry;
    }

    public Object getObject() throws UnusableEntryException {
        TypeTableEntry typeTableEntry = ((AbstractDirectSpaceProxy)this._spaceProxy)._proxyUtil.isTypeInfo(this._entryPacket.m_ClassName);
        ExternalEntry externalEntry = null;
        if (typeTableEntry == null) {
            externalEntry = this.getExternalEntry();
        }
        if (typeTableEntry != null && typeTableEntry.getObjectFormat() == 1 || externalEntry != null && externalEntry._objectFormat == 1) {
            if (externalEntry == null) {
                externalEntry = this.getExternalEntry();
            }
            return JSpaceProxyUtil.converter.toPojo(externalEntry);
        }
        return this._entryPacket.getEntry(this._spaceProxy);
    }

    public int getNotifyType() {
        return this._notifyType;
    }

    public MarshalledObject getRegistrationObject() {
        return this.handback;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.eventID);
        objectOutput.writeLong(this.seqNum);
        objectOutput.writeLong(this._spaceProxyUuid.getMostSignificantBits());
        objectOutput.writeLong(this._spaceProxyUuid.getLeastSignificantBits());
        if (this.handback != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.handback);
        } else {
            objectOutput.writeBoolean(false);
        }
        objectOutput.writeInt(this._notifyType);
        if (this._entryPacket != null) {
            objectOutput.writeBoolean(true);
            this._entryPacket.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
        int n2 = this._acceptableFilterIDList == null ? 0 : this._acceptableFilterIDList.size();
        objectOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutput.writeUTF((String)this._acceptableFilterIDList.get(i2));
        }
        this._acceptableFilterIDList = null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        this.eventID = objectInput.readLong();
        this.seqNum = objectInput.readLong();
        this._spaceProxyUuid = UuidFactory.create(objectInput.readLong(), objectInput.readLong());
        if (objectInput.readBoolean()) {
            this.handback = (MarshalledObject)objectInput.readObject();
        }
        this._notifyType = objectInput.readInt();
        if (objectInput.readBoolean()) {
            this._entryPacket = new EntryPacket();
            this._entryPacket.readExternal(objectInput);
        }
        if ((n2 = objectInput.readInt()) != 0) {
            this._acceptableFilterIDList = new ArrayList(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this._acceptableFilterIDList.add(objectInput.readUTF());
            }
        }
    }

    public void setHandback(MarshalledObject marshalledObject) {
        this.handback = marshalledObject;
    }

    public void setSpaceProxy(IJSpace iJSpace) {
        this._spaceProxy = iJSpace;
    }

    public void setSequenceNumber(long l2) {
        this.seqNum = l2;
    }

    public EntryArrivedRemoteEvent cloneEvent(IJSpace iJSpace, MarshalledObject marshalledObject) {
        EntryArrivedRemoteEvent entryArrivedRemoteEvent = (EntryArrivedRemoteEvent)this.clone();
        entryArrivedRemoteEvent._spaceProxy = iJSpace;
        entryArrivedRemoteEvent.handback = marshalledObject;
        return entryArrivedRemoteEvent;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isAcceptableByFilter(String string) {
        if (this._acceptableFilterIDList != null) {
            return this._acceptableFilterIDList.contains(string);
        }
        return false;
    }

    public void initAcceptableFilterList(int n2) {
        if (this._acceptableFilterIDList == null && n2 > 0) {
            this._acceptableFilterIDList = new ArrayList(n2);
        }
    }

    public void addAcceptableFilterID(String string) {
        this.initAcceptableFilterList(1);
        this._acceptableFilterIDList.add(string);
    }

    public List getAcceptableFilterList() {
        return this._acceptableFilterIDList;
    }

    public void setMulticastTemplateID(String string) {
        this._multicastTemplateID = string;
    }

    public String getMulticastTemplateID() {
        return this._multicastTemplateID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._spaceProxy != null) {
            stringBuffer.append(" [Source space: " + this._spaceProxy.getName() + "]");
        }
        stringBuffer.append("\n [ EventId: " + this.eventID + "]");
        stringBuffer.append("\n [ SeqId: " + this.seqNum + "]");
        stringBuffer.append("\n [ NotifyType: " + this._notifyType + "]");
        stringBuffer.append("\n [ SpaceUUID: " + this._spaceProxyUuid + "]");
        return stringBuffer.toString();
    }
}

