/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.sf.retrotranslator.runtime.java.lang._Long;

public class NotifyDelegatorListener
implements RemoteEventListener,
Serializable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.notify");
    public String m_Uuid;
    private Uuid m_ownerUuid;
    private RemoteEventListener m_UserSuppliedListener;
    public boolean m_fifoEnabled;
    public long m_fifoOffset;
    public ConcurrentHashMap m_fifoDelegatorMap;
    public String _filterID;

    public NotifyDelegatorListener(Uuid uuid, RemoteEventListener remoteEventListener) {
        this.m_UserSuppliedListener = remoteEventListener;
        this.m_ownerUuid = uuid;
    }

    public NotifyDelegatorListener(Uuid uuid, RemoteEventListener remoteEventListener, boolean bl2) {
        this(uuid, remoteEventListener, bl2, 0L);
    }

    public NotifyDelegatorListener(Uuid uuid, RemoteEventListener remoteEventListener, boolean bl2, long l2) {
        this.m_UserSuppliedListener = remoteEventListener;
        this.m_fifoEnabled = bl2;
        this.m_Uuid = UuidFactory.generate().toString();
        this.m_ownerUuid = uuid;
        this.m_fifoOffset = l2;
        if (bl2) {
            this.m_fifoDelegatorMap = new ConcurrentHashMap();
            this.m_fifoDelegatorMap.put((Object)this.m_ownerUuid, (Object)new FifoDelegatorHolder(this.m_fifoOffset));
        }
    }

    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        if (this.m_fifoEnabled) {
            FifoDelegatorHolder fifoDelegatorHolder;
            Uuid uuid = ((EntryArrivedRemoteEvent)remoteEvent).getSpaceUuid();
            FifoDelegatorHolder fifoDelegatorHolder2 = (FifoDelegatorHolder)this.m_fifoDelegatorMap.get((Object)uuid);
            if (fifoDelegatorHolder2 == null && (fifoDelegatorHolder = (FifoDelegatorHolder)this.m_fifoDelegatorMap.putIfAbsent((Object)uuid, (Object)(fifoDelegatorHolder2 = new FifoDelegatorHolder(this.m_fifoOffset)))) != null) {
                fifoDelegatorHolder2 = fifoDelegatorHolder;
            }
            fifoDelegatorHolder2.notify(remoteEvent);
        } else {
            this.notifyEvent(remoteEvent);
        }
    }

    private void notifyEvent(RemoteEvent remoteEvent) throws RemoteException, UnknownEventException {
        if (this._filterID != null && !((EntryArrivedRemoteEvent)remoteEvent).isAcceptableByFilter(this._filterID)) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), this.m_UserSuppliedListener.getClass().getName() + "#notify", new Object[]{remoteEvent});
        }
        this.m_UserSuppliedListener.notify(remoteEvent);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting(this.getClass().getName(), this.m_UserSuppliedListener.getClass().getName() + "#notify");
        }
    }

    public void close() {
        if (this.m_fifoDelegatorMap != null) {
            Iterator iterator = this.m_fifoDelegatorMap.values().iterator();
            while (iterator.hasNext()) {
                FifoDelegatorHolder fifoDelegatorHolder = (FifoDelegatorHolder)iterator.next();
                fifoDelegatorHolder.close();
                iterator.remove();
            }
        }
    }

    public String getUUID() {
        return this.m_Uuid;
    }

    public boolean isFifoEnabled() {
        return this.m_fifoEnabled;
    }

    public RemoteEventListener getRemoteEventListener() {
        return this.m_UserSuppliedListener;
    }

    private final class FifoDelegatorHolder
    implements Serializable {
        private AtomicLong nextInOrder;
        private Map fifoMap;
        private FifoDelegatorThread fifoDelegatorThread;

        public FifoDelegatorHolder(long l2) {
            this.nextInOrder = new AtomicLong(l2);
            this.fifoMap = new ConcurrentHashMap();
            this.fifoDelegatorThread = new FifoDelegatorThread("NotifyDelegatorListener:FifoDelegatorThread");
        }

        public void notify(RemoteEvent remoteEvent) {
            this.fifoMap.put(_Long.valueOf(remoteEvent.getSequenceNumber()), remoteEvent);
            if (remoteEvent.getSequenceNumber() == this.nextInOrder.get()) {
                this.fifoDelegatorThread.b();
            }
        }

        public void close() {
            this.fifoDelegatorThread.c();
        }

        private final class FifoDelegatorThread
        extends Thread {
            public boolean a = true;
            public boolean b = false;
            public Object c = new Object();

            public FifoDelegatorThread(String string) {
                this.setName(string);
                this.setDaemon(true);
                this.start();
            }

            public void run() {
                while (this.a && !this.isInterrupted()) {
                    RemoteEvent remoteEvent = (RemoteEvent)FifoDelegatorHolder.this.fifoMap.remove(_Long.valueOf(FifoDelegatorHolder.this.nextInOrder.get()));
                    if (remoteEvent == null) {
                        this.a();
                        continue;
                    }
                    this.a(remoteEvent);
                    FifoDelegatorHolder.this.nextInOrder.incrementAndGet();
                }
            }

            private void a(RemoteEvent remoteEvent) {
                try {
                    NotifyDelegatorListener.this.notifyEvent(remoteEvent);
                }
                catch (Throwable throwable) {
                    System.err.println("Notify failed while delegating to supplied listener on event: " + remoteEvent + " [ Seq. " + remoteEvent.getSequenceNumber() + " ]" + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void a() {
                Object object = this.c;
                synchronized (object) {
                    if (!this.b) {
                        try {
                            this.c.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.interrupt();
                            this.a = false;
                        }
                    }
                    this.b = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void b() {
                Object object = this.c;
                synchronized (object) {
                    this.b = true;
                    this.c.notify();
                }
            }

            private void c() {
                this.a = false;
                this.b();
            }
        }
    }
}

