/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.INotifyDelegator;
import com.j_spaces.core.client.NotifyDelegatorListener;
import com.j_spaces.core.lrmi.LRMINotifyDelegatorListener;
import com.j_spaces.obf.di;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.id.Uuid;
import net.sf.retrotranslator.runtime.java.lang._Long;

public class NotifyDelegatorMultiplexer
implements INotifyDelegator,
Serializable {
    public static final long serialVersionUID = -842639427837085187L;
    private transient IJSpace _space;
    private transient Uuid _uuid;
    private transient NotifyDelegatorListener _embeddedDelegatorListener;
    private RemoteEventListener _notifyDelegatorStub;
    private transient HashMap _delegatorTable;
    private transient HashMap _registrationTable;

    public NotifyDelegatorMultiplexer(IJSpace iJSpace, RemoteEventListener remoteEventListener, boolean bl2) {
        this(remoteEventListener, bl2);
        this.setSpace(iJSpace);
        this._uuid = this._space.getReferentUuid();
    }

    public NotifyDelegatorMultiplexer(IJSpace iJSpace) throws RemoteException {
        if (iJSpace == null) {
            throw new NullPointerException("Space proxy can not be null.");
        }
        this.setSpace(iJSpace);
        this._uuid = this._space.getReferentUuid();
        this._delegatorTable = new HashMap();
        this._registrationTable = new HashMap();
    }

    public NotifyDelegatorMultiplexer(RemoteEventListener remoteEventListener) {
        this(remoteEventListener, false);
    }

    public NotifyDelegatorMultiplexer(RemoteEventListener remoteEventListener, boolean bl2) {
        if (remoteEventListener == null) {
            throw new NullPointerException("RemoteEventListener can not be null.");
        }
        this._embeddedDelegatorListener = new NotifyDelegatorListener(this._uuid, remoteEventListener, bl2);
    }

    public NotifyDelegatorMultiplexer(IJSpace iJSpace, Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2) throws TransactionException, RemoteException {
        this(iJSpace);
        this.notify(entry, transaction, remoteEventListener, l2, marshalledObject, bl2, n2);
    }

    public IJSpace getSpace() {
        return this._space;
    }

    public void setSpace(IJSpace iJSpace) {
        this._space = iJSpace instanceof DCacheSpaceImpl ? ((DCacheSpaceImpl)iJSpace).getRemoteSpace() : iJSpace;
    }

    public EventRegistration notify(Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2) throws TransactionException, RemoteException {
        if (this._space == null) {
            throw new RemoteException("Operation failed. NotifyDelegatorMultiplexer was constructed as listener.Use NotifyDelegatorMultiplexer constructor with space as parameter.");
        }
        NotifyDelegatorListener notifyDelegatorListener = new NotifyDelegatorListener(this._uuid, remoteEventListener, bl2);
        EventRegistration eventRegistration = di.a(this._space, entry) ? new di(this._space).a(entry, transaction, this.exportListener(this._space), l2, marshalledObject, n2) : this._space.notify(entry, transaction, this.exportListener(this._space), l2, marshalledObject, n2);
        Long l3 = _Long.valueOf(eventRegistration.getID());
        this._delegatorTable.put(l3, notifyDelegatorListener);
        this._registrationTable.put(l3, eventRegistration.getLease());
        return eventRegistration;
    }

    private RemoteEventListener exportListener(IJSpace iJSpace) throws RemoteException {
        RemoteEventListener remoteEventListener = (RemoteEventListener)iJSpace.getStubHandler().exportObject(this);
        return new LRMINotifyDelegatorListener(this, remoteEventListener);
    }

    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        EntryArrivedRemoteEvent entryArrivedRemoteEvent = (EntryArrivedRemoteEvent)remoteEvent;
        if (entryArrivedRemoteEvent._spaceProxy == null) {
            entryArrivedRemoteEvent._spaceProxy = this._space;
        }
        if (this._space == null) {
            RemoteEventListener remoteEventListener = this._embeddedDelegatorListener != null ? this._embeddedDelegatorListener : this._notifyDelegatorStub;
            remoteEventListener.notify(remoteEvent);
        } else {
            NotifyDelegatorListener notifyDelegatorListener = (NotifyDelegatorListener)this._delegatorTable.get(_Long.valueOf(remoteEvent.getID()));
            if (notifyDelegatorListener != null) {
                notifyDelegatorListener.notify(remoteEvent);
            }
        }
    }

    public void close() {
        Object object;
        if (this._registrationTable == null || this._registrationTable.size() == 0) {
            return;
        }
        Iterator iterator = this._registrationTable.values().iterator();
        while (iterator.hasNext()) {
            object = (Lease)iterator.next();
            try {
                object.cancel();
            }
            catch (Exception exception) {}
        }
        try {
            this._space.getStubHandler().unexportObject(this, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        iterator = this._delegatorTable.values().iterator();
        while (iterator.hasNext()) {
            object = (NotifyDelegatorListener)iterator.next();
            ((NotifyDelegatorListener)object).close();
        }
        this._delegatorTable.clear();
        this._registrationTable.clear();
    }

    public void finalize() {
        this.close();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUnshared(this._embeddedDelegatorListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._embeddedDelegatorListener = (NotifyDelegatorListener)objectInputStream.readUnshared();
    }
}

