/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class GSStreamMessageImpl
extends GSMessageImpl
implements StreamMessage {
    private static final long serialVersionUID = 1L;
    private ByteArrayOutputStream bytesOut;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private int bytesToRead = -1;

    public GSStreamMessageImpl(GSSessionImpl gSSessionImpl) throws JMSException {
        super(gSSessionImpl, "Stream");
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(10);
            int n2 = this.dataIn.read();
            if (n2 == 5) {
                return this.dataIn.readBoolean();
            }
            if (n2 == 4) {
                return Boolean.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to boolean.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a boolean type");
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(10);
            int n2 = this.dataIn.read();
            if (n2 == 7) {
                return this.dataIn.readByte();
            }
            if (n2 == 4) {
                return Byte.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to byte.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a byte type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(17);
            int n2 = this.dataIn.read();
            if (n2 == 8) {
                return this.dataIn.readShort();
            }
            if (n2 == 7) {
                return this.dataIn.readByte();
            }
            if (n2 == 4) {
                return Short.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to short.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a short type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(17);
            int n2 = this.dataIn.read();
            if (n2 == 6) {
                return this.dataIn.readChar();
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to char.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a char type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(33);
            int n2 = this.dataIn.read();
            if (n2 == 9) {
                return this.dataIn.readInt();
            }
            if (n2 == 8) {
                return this.dataIn.readShort();
            }
            if (n2 == 7) {
                return this.dataIn.readByte();
            }
            if (n2 == 4) {
                return Integer.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to int.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not an int type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int n2 = this.dataIn.read();
            if (n2 == 10) {
                return this.dataIn.readLong();
            }
            if (n2 == 9) {
                return this.dataIn.readInt();
            }
            if (n2 == 8) {
                return this.dataIn.readShort();
            }
            if (n2 == 7) {
                return this.dataIn.readByte();
            }
            if (n2 == 4) {
                return Long.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to long.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a long type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(33);
            int n2 = this.dataIn.read();
            if (n2 == 11) {
                return this.dataIn.readFloat();
            }
            if (n2 == 4) {
                return Float.valueOf(this.dataIn.readUTF()).floatValue();
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to float.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a float type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int n2 = this.dataIn.read();
            if (n2 == 12) {
                return this.dataIn.readDouble();
            }
            if (n2 == 11) {
                return this.dataIn.readFloat();
            }
            if (n2 == 4) {
                return Double.valueOf(this.dataIn.readUTF());
            }
            if (n2 == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to double.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a double type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public String readString() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int n2 = this.dataIn.read();
            if (n2 == 13) {
                return null;
            }
            if (n2 == 4) {
                return this.dataIn.readUTF();
            }
            if (n2 == 10) {
                return new Long(this.dataIn.readLong()).toString();
            }
            if (n2 == 9) {
                return new Integer(this.dataIn.readInt()).toString();
            }
            if (n2 == 8) {
                return new Short(this.dataIn.readShort()).toString();
            }
            if (n2 == 7) {
                return new Byte(this.dataIn.readByte()).toString();
            }
            if (n2 == 11) {
                return new Float(this.dataIn.readFloat()).toString();
            }
            if (n2 == 12) {
                return new Double(this.dataIn.readDouble()).toString();
            }
            if (n2 == 5) {
                return (this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE).toString();
            }
            if (n2 == 6) {
                return new Character(this.dataIn.readChar()).toString();
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a String type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        this.initializeReading();
        try {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (this.bytesToRead == 0) {
                this.bytesToRead = -1;
                return -1;
            }
            if (this.bytesToRead > 0) {
                if (byArray.length >= this.bytesToRead) {
                    this.bytesToRead = 0;
                    return this.dataIn.read(byArray, 0, this.bytesToRead);
                }
                this.bytesToRead -= byArray.length;
                return this.dataIn.read(byArray);
            }
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            if (this.dataIn.available() < 1) {
                throw new MessageFormatException("Not enough data left to read value");
            }
            this.dataIn.mark(byArray.length + 1);
            int n2 = this.dataIn.read();
            if (this.dataIn.available() < 1) {
                return -1;
            }
            if (n2 != 3) {
                throw new MessageFormatException("Not a byte array");
            }
            int n3 = this.dataIn.readInt();
            if (n3 >= byArray.length) {
                this.bytesToRead = n3 - byArray.length;
                return this.dataIn.read(byArray);
            }
            this.bytesToRead = 0;
            return this.dataIn.read(byArray, 0, n3);
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public Object readObject() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int n2 = this.dataIn.read();
            if (n2 == 13) {
                return null;
            }
            if (n2 == 4) {
                return this.dataIn.readUTF();
            }
            if (n2 == 10) {
                return new Long(this.dataIn.readLong());
            }
            if (n2 == 9) {
                return new Integer(this.dataIn.readInt());
            }
            if (n2 == 8) {
                return new Short(this.dataIn.readShort());
            }
            if (n2 == 7) {
                return new Byte(this.dataIn.readByte());
            }
            if (n2 == 11) {
                return new Float(this.dataIn.readFloat());
            }
            if (n2 == 12) {
                return new Double(this.dataIn.readDouble());
            }
            if (n2 == 5) {
                return this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (n2 == 6) {
                return new Character(this.dataIn.readChar());
            }
            if (n2 == 3) {
                int n3 = this.dataIn.readInt();
                byte[] byArray = new byte[n3];
                this.dataIn.read(byArray);
                return byArray;
            }
            this.dataIn.reset();
            throw new MessageFormatException("unknown type");
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.dataIn.reset();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed");
                jMSException.setLinkedException(iOException);
            }
            throw numberFormatException;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public void writeBoolean(boolean bl2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(5);
            this.dataOut.writeBoolean(bl2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeByte(byte by2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(7);
            this.dataOut.writeByte(by2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeShort(short s2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(8);
            this.dataOut.writeShort(s2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeChar(char c2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(6);
            this.dataOut.writeChar(c2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeInt(int n2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(9);
            this.dataOut.writeInt(n2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeLong(long l2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(10);
            this.dataOut.writeLong(l2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeFloat(float f2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(11);
            this.dataOut.writeFloat(f2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeDouble(double d2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(12);
            this.dataOut.writeDouble(d2);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeString(String string) throws JMSException {
        this.initializeWriting();
        try {
            if (string == null) {
                this.dataOut.write(13);
            } else {
                this.dataOut.write(4);
                this.dataOut.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(3);
            this.dataOut.writeInt(n3);
            this.dataOut.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            this.raise(iOException);
        }
    }

    public void writeObject(Object object) throws JMSException {
        this.initializeWriting();
        if (object == null) {
            try {
                this.dataOut.write(13);
            }
            catch (IOException iOException) {
                this.raise(iOException);
            }
        } else if (object instanceof String) {
            this.writeString(object.toString());
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        }
    }

    public void setBodyAsBytes(byte[] byArray, int n2, int n3) {
        super.setBodyAsBytes(byArray, n2, n3);
        this.dataOut = null;
        this.dataIn = null;
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.flush();
            byte[] byArray = this.bytesOut.toByteArray();
            super.setBodyAsBytes(byArray, 0, byArray.length);
            this.dataOut.close();
            this.dataOut = null;
        }
        return super.getBodyAsBytes();
    }

    public void reset() throws JMSException {
        this.m_bodyRO = true;
        if (this.dataOut != null) {
            try {
                this.dataOut.flush();
                byte[] byArray = this.bytesOut.toByteArray();
                super.setBodyAsBytes(byArray, 0, byArray.length);
                this.dataOut.close();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed: " + iOException.getMessage());
                jMSException.setLinkedException(iOException);
                throw jMSException;
            }
        }
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkWrite();
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkRead();
        try {
            ByteArray byteArray = super.getBodyAsBytes();
            if (this.dataIn == null && byteArray != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getBuf(), byteArray.getOffset(), byteArray.getLength());
                this.dataIn = new DataInputStream(byteArrayInputStream);
            }
        }
        catch (IOException iOException) {
            MessageNotReadableException messageNotReadableException = new MessageNotReadableException("getBodyAsBytes failed");
            messageNotReadableException.setLinkedException(iOException);
            throw messageNotReadableException;
        }
    }

    private final void raise(IOException iOException) throws JMSException {
        JMSException jMSException = new JMSException(iOException.getMessage());
        jMSException.setLinkedException(iOException);
        throw jMSException;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public String toString() {
        return '(' + super.toString() + " ,bytesOut= " + this.bytesOut + " ,dataIn= " + this.dataIn + " ,bytesToRead= " + this.bytesToRead + " ,stream message body= " + this.m_body_bytes + " ,dataOut= " + this.dataOut + ')';
    }
}

