/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import com.j_spaces.core.DropClassException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jms.GSQueueConnectionFactoryImpl;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSQueueSessionImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTopicConnectionFactoryImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.GSTopicSessionImpl;
import com.j_spaces.jms.GSXAQueueConnectionFactoryImpl;
import com.j_spaces.jms.GSXATopicConnectionFactoryImpl;
import com.j_spaces.jms.utils.StringsUtils;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.obf.li;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class GSJMSAdmin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME;
    private JSpaceAttributes configProps;
    private Element rootElement;
    private GSTopicConnectionFactoryImpl tcf;
    private GSXATopicConnectionFactoryImpl xatcf;
    private GSQueueConnectionFactoryImpl qcf;
    private GSXAQueueConnectionFactoryImpl xaqcf;
    private transient InitialContext jndiContext = null;
    private String containerPrefix;
    private String spacePrefix;
    private String bondedDestPrefixName;
    private String bondedQueueFacName;
    private String bondedTopicFacName;
    private String bondedXAQueueFacName;
    private String bondedXATopicFacName;
    private static Vector durableSubscribersClientIDVec;
    private String overwrittenConnFacSpaceURL;
    private static GSJMSAdmin m_adminInstance;
    private static String m_jmsConfigFileName;
    private String m_jmsConfigFileFullPath;
    private URL m_jmsConfigURL;
    private static File jmsDebugFile;
    public static final String DUR_SUBSCRIBERS_TAG = "durable-subscribers";
    public static final String DUR_SUB_CLIENT_ID = "clientID";
    public static final String DUR_SUB_SESSION_ID = "session-id";
    public static final String DUR_SUB_CONNECTION_ID = "connection-id";
    public static final String DUR_SUB_TOPIC_NAME = "durable-topic-name";
    public static final String DUR_SUB_SUBSCRIPTION_NAME = "durable-subscription-name";
    public static final String JMS_TAG = "jms";
    private int compressionMinSize = Integer.valueOf(System.getProperty("com.gs.jms.compressionMinSize", "500000"));
    private static Logger _logger;
    static /* synthetic */ Class class$com$j_spaces$jms$utils$GSJMSAdmin;

    private GSJMSAdmin(String string) throws JMSException {
        if (!StringsUtils.isEmpty(string)) {
            m_jmsConfigFileName = string;
            this.initJMSConfig(m_jmsConfigFileName, true);
        } else {
            this.initJMSConfig(m_jmsConfigFileName, false);
        }
    }

    public final String getOverwrittenConnFacSpaceURL() {
        return this.overwrittenConnFacSpaceURL;
    }

    public static synchronized GSJMSAdmin getInstance(String string) throws JMSException {
        if (null != m_adminInstance) {
            if (!StringsUtils.isEmpty(string) && !string.equals(m_jmsConfigFileName) && durableSubscribersClientIDVec == null) {
                m_adminInstance = new GSJMSAdmin(string);
            }
        } else if (durableSubscribersClientIDVec == null) {
            m_adminInstance = new GSJMSAdmin(string);
        }
        return m_adminInstance;
    }

    public static GSJMSAdmin getInstance() throws JMSException {
        return GSJMSAdmin.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJMSConfig(String string, boolean bl2) throws JMSException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            InputStream inputStream = null;
            if (bl2) {
                this.m_jmsConfigFileFullPath = string;
                inputStream = ResourceLoader.findJMSConfig(this.m_jmsConfigFileFullPath);
                this.m_jmsConfigURL = ResourceLoader.getResourceURL(this.m_jmsConfigFileFullPath);
                if (this.m_jmsConfigURL == null) {
                    this.m_jmsConfigURL = ResourceLoader.getResourceURL("config/jms/" + this.m_jmsConfigFileFullPath);
                    this.m_jmsConfigFileFullPath = this.m_jmsConfigURL.getProtocol().equalsIgnoreCase("file") ? this.m_jmsConfigURL.getFile() : "config/jms/" + this.m_jmsConfigFileFullPath;
                }
            } else {
                inputStream = ResourceLoader.findJMSConfig(this.m_jmsConfigFileFullPath);
                if (this.m_jmsConfigFileFullPath == null) {
                    this.m_jmsConfigURL = ResourceLoader.getResourceURL("config/jms/jms-config.xml");
                    this.m_jmsConfigFileFullPath = this.m_jmsConfigURL.getProtocol().equalsIgnoreCase("file") ? this.m_jmsConfigURL.getFile() : "config/jms/jms-config.xml";
                }
            }
            try {
                ArrayList arrayList = JProperties.convertXML(inputStream, null);
                this.rootElement = (Element)arrayList.get(0);
                this.configProps = (JSpaceAttributes)arrayList.get(1);
            }
            catch (SAXException sAXException) {
                JMSException jMSException = new JMSException("ERROR: in processing jms-config.xml file: " + sAXException.toString());
                jMSException.setLinkedException(sAXException);
                throw jMSException;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                JMSException jMSException = new JMSException("ERROR: in processing jms-config.xml file: " + parserConfigurationException.toString());
                jMSException.setLinkedException(parserConfigurationException);
                throw jMSException;
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("ERROR: in processing jms-config.xml file: " + iOException.toString());
                jMSException.setLinkedException(iOException);
                throw jMSException;
            }
            String string2 = this.configProps.getProperty("com.j_spaces.jms.jndi-bonded-names.connections.container-prefix");
            this.containerPrefix = JSpaceUtilities.getPropertyFromSystem(string2, "myJMS_container");
            String string3 = this.configProps.getProperty("com.j_spaces.jms.jndi-bonded-names.connections.space-prefix");
            this.spacePrefix = JSpaceUtilities.getPropertyFromSystem(string3, "myJMS");
            if (StringsUtils.isEmpty(this.containerPrefix)) {
                throw new ResourceAllocationException("The <container-prefix> tag must be defined in the " + this.m_jmsConfigFileFullPath + " file.");
            }
            if (StringsUtils.isEmpty(this.spacePrefix)) {
                throw new ResourceAllocationException("The <space-prefix> tag must be defined in the " + this.m_jmsConfigFileFullPath + " file.");
            }
            this.bondedDestPrefixName = "GigaSpaces;" + this.containerPrefix + ";" + this.spacePrefix + ";" + JMS_TAG + ";" + "destinations" + ";";
            this.bondedQueueFacName = "GigaSpaces;" + this.containerPrefix + ";" + this.spacePrefix + ";" + "GSQueueConnectionFactoryImpl";
            this.bondedTopicFacName = "GigaSpaces;" + this.containerPrefix + ";" + this.spacePrefix + ";" + "GSTopicConnectionFactoryImpl";
            this.bondedXAQueueFacName = "GigaSpaces;" + this.containerPrefix + ";" + this.spacePrefix + ";" + "GSXAQueueConnectionFactoryImpl";
            this.bondedXATopicFacName = "GigaSpaces;" + this.containerPrefix + ";" + this.spacePrefix + ";" + "GSXATopicConnectionFactoryImpl";
            String string4 = this.configProps.getProperty("com.j_spaces.jms.jndi-bonded-names.connections.overwrite-space-url");
            this.overwrittenConnFacSpaceURL = JSpaceUtilities.getPropertyFromSystem(string4, "/./myJMS?schema=default");
            try {
                NodeList nodeList = this.rootElement.getElementsByTagName(DUR_SUBSCRIBERS_TAG);
                if (nodeList.getLength() != 0) {
                    durableSubscribersClientIDVec = new Vector();
                    Node node = nodeList.item(0);
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        Node node3 = node2.getNextSibling();
                        String string5 = node3.getNodeName();
                        hashtable.put(DUR_SUB_CLIENT_ID, string5);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("Loading durable subscriber data:\nclientID : " + string5);
                        }
                        node3 = node2.getNextSibling();
                        Node node4 = node3.getFirstChild();
                        String string6 = node4.getNextSibling().getFirstChild().getTextContent();
                        hashtable.put(DUR_SUB_TOPIC_NAME, string6);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("durable-topic-name : " + string6);
                        }
                        node3 = node4.getNextSibling().getNextSibling();
                        Node node5 = node3.getNextSibling();
                        String string7 = node5.getTextContent();
                        hashtable.put(DUR_SUB_SESSION_ID, string7);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("session-id : " + string7);
                        }
                        node3 = node5.getNextSibling();
                        Node node6 = node3.getNextSibling();
                        String string8 = node6.getTextContent();
                        hashtable.put(DUR_SUB_CONNECTION_ID, string8);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("connection-id : " + string8);
                        }
                        node3 = node6.getNextSibling();
                        Node node7 = node3.getNextSibling();
                        String string9 = node7.getTextContent();
                        hashtable.put(DUR_SUB_SUBSCRIPTION_NAME, string9);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("durable-subscription-name : " + string9);
                        }
                        durableSubscribersClientIDVec.addElement(hashtable);
                        node2 = node2.getNextSibling().getNextSibling().getNextSibling();
                    }
                }
            }
            catch (Exception exception) {
                JMSException jMSException = new JMSException("ERROR: while processing <durable-subscribers> tag in the " + this.m_jmsConfigFileFullPath + " file: " + exception.toString());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
        }
    }

    private void saveJMSConfigState(Node node) throws IOException, FileNotFoundException {
        String string;
        File file;
        File file2 = new File(this.m_jmsConfigFileFullPath);
        if (!file2.exists()) {
            this.m_jmsConfigFileFullPath = li.d() + File.separator + "jms-config.xml";
        }
        if ((file = new File((string = this.m_jmsConfigFileFullPath.substring(0, this.m_jmsConfigFileFullPath.lastIndexOf("."))) + ".old")).exists()) {
            file.delete();
        } else {
            file2.renameTo(file);
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(string + ".xml"));
        JSpaceUtilities.domWriter(node, printStream, "");
        printStream.close();
    }

    private void updateDurableSubscribersDetails() throws JMSException {
        try {
            Object object;
            Node node;
            Object object2;
            NodeList nodeList = this.rootElement.getElementsByTagName(DUR_SUBSCRIBERS_TAG);
            if (nodeList.getLength() > 0) {
                object2 = this.rootElement.getElementsByTagName(JMS_TAG);
                node = object2.item(0);
                object = nodeList.item(0);
                node.removeChild((Node)object);
            }
            object2 = null;
            if (durableSubscribersClientIDVec.size() > 0) {
                object2 = this.rootElement.getOwnerDocument().createElement(DUR_SUBSCRIBERS_TAG);
                node = this.rootElement.getFirstChild().getNextSibling().getFirstChild().getNextSibling();
                node.appendChild((Node)object2);
            }
            for (int i2 = 0; i2 < durableSubscribersClientIDVec.size(); ++i2) {
                object = (Hashtable)durableSubscribersClientIDVec.get(i2);
                String string = ((Hashtable)object).get(DUR_SUB_CLIENT_ID).toString();
                String string2 = ((Hashtable)object).get(DUR_SUB_TOPIC_NAME).toString();
                String string3 = ((Hashtable)object).get(DUR_SUB_SESSION_ID).toString();
                String string4 = ((Hashtable)object).get(DUR_SUB_CONNECTION_ID).toString();
                String string5 = ((Hashtable)object).get(DUR_SUB_SUBSCRIPTION_NAME).toString();
                Element element = this.rootElement.getOwnerDocument().createElement(string);
                Element element2 = this.rootElement.getOwnerDocument().createElement(DUR_SUB_TOPIC_NAME);
                Element element3 = this.rootElement.getOwnerDocument().createElement(DUR_SUB_SESSION_ID);
                Element element4 = this.rootElement.getOwnerDocument().createElement(DUR_SUB_CONNECTION_ID);
                Element element5 = this.rootElement.getOwnerDocument().createElement(DUR_SUB_SUBSCRIPTION_NAME);
                Text text = this.rootElement.getOwnerDocument().createTextNode(string2);
                Text text2 = this.rootElement.getOwnerDocument().createTextNode(string3);
                Text text3 = this.rootElement.getOwnerDocument().createTextNode(string4);
                Text text4 = this.rootElement.getOwnerDocument().createTextNode(string5);
                element.appendChild(element2).appendChild(text);
                element.appendChild(element3).appendChild(text2);
                element.appendChild(element4).appendChild(text3);
                element.appendChild(element5).appendChild(text4);
                object2.appendChild(element);
            }
            this.saveJMSConfigState(this.rootElement);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JMSException jMSException = new JMSException("ERROR: while updating <durable-subscribers> tag details in the " + this.m_jmsConfigFileFullPath + " file: " + fileNotFoundException.toString());
            jMSException.setLinkedException(fileNotFoundException);
            throw jMSException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("ERROR: while updating <durable-subscribers> tag details in the " + this.m_jmsConfigFileFullPath + " file: " + iOException.toString());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
        catch (DOMException dOMException) {
            JMSException jMSException = new JMSException("ERROR: while updating <durable-subscribers> tag details in the " + this.m_jmsConfigFileFullPath + " file: " + dOMException.toString());
            jMSException.setLinkedException(dOMException);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewDurableSubscriberDetailsIntoXML(Hashtable hashtable) throws JMSException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (durableSubscribersClientIDVec == null) {
                durableSubscribersClientIDVec = new Vector();
            }
            durableSubscribersClientIDVec.addElement(hashtable);
            this.updateDurableSubscribersDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDurableSubscriberDetailsFromXML(Hashtable hashtable) throws JMSException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (durableSubscribersClientIDVec != null) {
                for (int i2 = 0; i2 < durableSubscribersClientIDVec.size(); ++i2) {
                    Hashtable hashtable2 = (Hashtable)durableSubscribersClientIDVec.get(i2);
                    if (!((String)hashtable2.get(DUR_SUB_CLIENT_ID)).toString().equalsIgnoreCase(hashtable.get(DUR_SUB_CLIENT_ID).toString())) continue;
                    durableSubscribersClientIDVec.remove(i2);
                    this.updateDurableSubscribersDetails();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDurableSubscriberDetailsFromXML(String string, String string2) {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (durableSubscribersClientIDVec != null) {
                for (int i2 = 0; i2 < durableSubscribersClientIDVec.size(); ++i2) {
                    Hashtable hashtable = (Hashtable)durableSubscribersClientIDVec.get(i2);
                    if (!hashtable.get(DUR_SUB_TOPIC_NAME).toString().equalsIgnoreCase(string) || !hashtable.get(DUR_SUB_SUBSCRIPTION_NAME).toString().equalsIgnoreCase(string2)) continue;
                    return hashtable;
                }
            }
        }
        return null;
    }

    private IJSpace findSpace(String string) throws ResourceAllocationException {
        IJSpace iJSpace = null;
        try {
            iJSpace = (IJSpace)SpaceFinder.find(string);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("GSJMSAdmin.findSpace() spaceURL: " + string + " | Found space: " + iJSpace.getName());
            }
        }
        catch (FinderException finderException) {
            throw new ResourceAllocationException("GSJMSAdmin - ERROR: Could not find space: " + string + finderException.getMessage() + "\n");
        }
        return iJSpace;
    }

    private void deleteDestinationFromSpace(IJSpace iJSpace, String string) {
        block4: {
            try {
                iJSpace.dropClass(string);
            }
            catch (RemoteException remoteException) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, remoteException.toString(), remoteException);
                }
            }
            catch (DropClassException dropClassException) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, dropClassException.toString(), dropClassException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSQueueConnectionFactoryImpl getQueueConnectionFactory() throws JMSException, NamingException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getQueueConnectionFactory() | bondedQueueFacName:\t" + this.bondedQueueFacName + " |  overwrittenConnFacSpaceURL:\t" + this.overwrittenConnFacSpaceURL + " | qcf: " + this.qcf);
            }
            if (this.qcf == null) {
                if (!StringsUtils.isEmpty(this.overwrittenConnFacSpaceURL)) {
                    this.findSpace(this.overwrittenConnFacSpaceURL);
                    this.qcf = (GSQueueConnectionFactoryImpl)this.jndiLookup(this.bondedQueueFacName);
                    this.qcf.initializeConnFactoryServices(this.overwrittenConnFacSpaceURL, m_adminInstance);
                } else {
                    this.qcf = (GSQueueConnectionFactoryImpl)this.jndiLookup(this.bondedQueueFacName);
                    this.qcf.initializeConnFactoryServices(null, m_adminInstance);
                }
            }
        }
        return this.qcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSTopicConnectionFactoryImpl getTopicConnectionFactory() throws JMSException, NamingException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getTopicConnectionFactory() | bondedTopicFacName:\t" + this.bondedTopicFacName + " |  overwrittenConnFacSpaceURL:\t" + this.overwrittenConnFacSpaceURL + " | tcf: " + this.tcf);
            }
            if (this.tcf == null) {
                if (!StringsUtils.isEmpty(this.overwrittenConnFacSpaceURL)) {
                    this.findSpace(this.overwrittenConnFacSpaceURL);
                    this.tcf = (GSTopicConnectionFactoryImpl)this.jndiLookup(this.bondedTopicFacName);
                    this.tcf.initializeConnFactoryServices(this.overwrittenConnFacSpaceURL, m_adminInstance);
                } else {
                    this.tcf = (GSTopicConnectionFactoryImpl)this.jndiLookup(this.bondedTopicFacName);
                    this.tcf.initializeConnFactoryServices(null, m_adminInstance);
                }
            }
        }
        return this.tcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSXAQueueConnectionFactoryImpl getXAQueueConnectionFactory() throws JMSException, NamingException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getXAQueueConnectionFactory() | bondedXAQueueFacName:\t" + this.bondedXAQueueFacName + " |  overwrittenConnFacSpaceURL:\t" + this.overwrittenConnFacSpaceURL + " | xaqcf: " + this.xaqcf);
            }
            if (this.xaqcf == null) {
                if (!StringsUtils.isEmpty(this.overwrittenConnFacSpaceURL)) {
                    this.findSpace(this.overwrittenConnFacSpaceURL);
                    this.xaqcf = (GSXAQueueConnectionFactoryImpl)this.jndiLookup(this.bondedXAQueueFacName);
                    this.xaqcf.initializeConnFactoryServices(this.overwrittenConnFacSpaceURL, m_adminInstance);
                } else {
                    this.xaqcf = (GSXAQueueConnectionFactoryImpl)this.jndiLookup(this.bondedXAQueueFacName);
                    this.xaqcf.initializeConnFactoryServices(null, m_adminInstance);
                }
            }
        }
        return this.xaqcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSXATopicConnectionFactoryImpl getXATopicConnectionFactory() throws JMSException, NamingException {
        GSJMSAdmin gSJMSAdmin = this;
        synchronized (gSJMSAdmin) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getXATopicConnectionFactory() | bondedXATopicFacName:\t" + this.bondedXATopicFacName + " |  overwrittenConnFacSpaceURL:\t" + this.overwrittenConnFacSpaceURL + " | xatcf: " + this.xatcf);
            }
            if (this.xatcf == null) {
                if (!StringsUtils.isEmpty(this.overwrittenConnFacSpaceURL)) {
                    this.findSpace(this.overwrittenConnFacSpaceURL);
                    this.xatcf = (GSXATopicConnectionFactoryImpl)this.jndiLookup(this.bondedXATopicFacName);
                    this.xatcf.initializeConnFactoryServices(this.overwrittenConnFacSpaceURL, m_adminInstance);
                } else {
                    this.xatcf = (GSXATopicConnectionFactoryImpl)this.jndiLookup(this.bondedXATopicFacName);
                    this.xatcf.initializeConnFactoryServices(null, m_adminInstance);
                }
            }
        }
        return this.xatcf;
    }

    public Destination createAndBindTempDestination(GSSessionImpl gSSessionImpl) throws JMSException, NamingException {
        Destination destination = null;
        destination = gSSessionImpl instanceof GSQueueSessionImpl ? ((GSQueueSessionImpl)gSSessionImpl).createTemporaryQueue() : ((GSTopicSessionImpl)gSSessionImpl).createTemporaryTopic();
        this.rebindToJNDI(this.bondedDestPrefixName + destination.toString(), destination);
        return destination;
    }

    public Destination createAndBindDestination(boolean bl2, String string) throws NamingException, JMSException {
        Remote remote = null;
        try {
            remote = bl2 ? this.getQueue(string) : this.getTopic(string);
        }
        catch (NamingException namingException) {
            remote = bl2 ? new GSQueueImpl(string) : new GSTopicImpl(string);
            this.rebindToJNDI(this.bondedDestPrefixName + string, remote);
        }
        return remote;
    }

    public void destroyAndUnBindDestination(String string) throws JMSException {
        try {
            this.unbindFromJNDI(this.bondedDestPrefixName + string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public GSQueueImpl getQueue(String string) throws NamingException, JMSException {
        return (GSQueueImpl)this.jndiLookup(this.bondedDestPrefixName + string);
    }

    public GSTopicImpl getTopic(String string) throws NamingException, JMSException {
        return (GSTopicImpl)this.jndiLookup(this.bondedDestPrefixName + string);
    }

    public Destination getDestination(String string) throws NamingException, JMSException {
        return (Destination)this.jndiLookup(this.bondedDestPrefixName + string);
    }

    public Object jndiLookup(String string) throws NamingException, JMSException {
        return this.getInitialContext().lookup(string);
    }

    private InitialContext getInitialContext() throws NamingException, JMSException {
        block3: {
            if (this.jndiContext == null) {
                try {
                    this.jndiContext = new InitialContext();
                    this.jndiContext.getEnvironment();
                }
                catch (NoInitialContextException noInitialContextException) {
                    Properties properties = new Properties();
                    properties.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
                    properties.setProperty("java.naming.provider.url", "rmi://localhost:10098");
                    this.jndiContext = new InitialContext(properties);
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.fine("GSJMSAdmin.getInitialContext() Using fallback jndiContext environment: " + this.jndiContext.getEnvironment());
                }
            }
        }
        return this.jndiContext;
    }

    public void rebindToJNDI(String string, Object object) throws NamingException, JMSException {
        this.getInitialContext().rebind(string, object);
    }

    public void unbindFromJNDI(String string) throws NamingException, JMSException {
        this.getInitialContext().unbind(string);
    }

    public static void exit(int n2) {
        System.exit(n2);
    }

    public String getBondedQueueFacName() {
        return this.bondedQueueFacName;
    }

    public String getBondedTopicFacName() {
        return this.bondedTopicFacName;
    }

    public String getBondedXAQueueFacName() {
        return this.bondedXAQueueFacName;
    }

    public String getBondedXATopicFacName() {
        return this.bondedXATopicFacName;
    }

    public String getBondedDestPrefixName() {
        return this.bondedDestPrefixName;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    static {
        Class<?> clazz = class$com$j_spaces$jms$utils$GSJMSAdmin;
        if (clazz == null) {
            clazz = class$com$j_spaces$jms$utils$GSJMSAdmin = new GSJMSAdmin[0].getClass().getComponentType();
        }
        CLASS_NAME = clazz.getName();
        m_adminInstance = null;
        m_jmsConfigFileName = "jms-config.xml";
        _logger = Logger.getLogger("com.gigaspaces.jms");
    }
}

