/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.j_spaces.kernel.time.SystemTime;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.Serializable;

public class UIDStringFactory
implements Serializable {
    private final String m_BasicName;
    private final ClassInfoEntry nullClassInfo;
    private volatile String m_TimeStamp;
    private boolean useTimeStamp;
    private AtomicLong m_Counter = new AtomicLong();
    private volatile long _lastAscendingOrder;
    private volatile int _optimisticClassInfoSize;
    private final ConcurrentHashMap m_ClassInfoHash;
    private static final int MAX_NUM_CLASSES_CACHED = 100;

    public UIDStringFactory() {
        this(null, null);
    }

    public UIDStringFactory(String string) {
        this(string, String.valueOf(SystemTime.timeMillis()));
    }

    public UIDStringFactory(String string, String string2) {
        this.m_BasicName = string;
        this.m_TimeStamp = string2;
        this.useTimeStamp = this.m_TimeStamp != null;
        this.m_ClassInfoHash = new ConcurrentHashMap();
        this.nullClassInfo = new ClassInfoEntry(null);
    }

    public String newId(String string) {
        long l2 = this.m_Counter.incrementAndGet();
        if (!this.useTimeStamp || l2 > this._lastAscendingOrder) {
            if (l2 == 0L) {
                this._lastAscendingOrder = 0L;
            }
            return this.createUID(string, l2, null);
        }
        this.m_TimeStamp = String.valueOf(SystemTime.timeMillis());
        ClassInfoEntry classInfoEntry = new ClassInfoEntry(string);
        this.m_ClassInfoHash.replace((Object)string, (Object)classInfoEntry);
        this._lastAscendingOrder = this.m_Counter.get();
        return this.createUID(string, l2, classInfoEntry);
    }

    public String newId(String string, String string2) {
        if (string.indexOf(94) != -1) {
            throw new RuntimeException("Invalid UID creation request: UID can not contains ^ character");
        }
        return this.newIdUncheked(string, string2);
    }

    public void newId(StringBuffer stringBuffer, String string, String string2) {
        if (string.indexOf(94) != -1) {
            throw new RuntimeException("Invalid UID creation request: UID can not contains ^ character");
        }
        this.newIdUncheked(stringBuffer, string, string2);
    }

    public final String newIdUncheked(String string, String string2) {
        ClassInfoEntry classInfoEntry = this.getClassInfo(string2);
        return classInfoEntry.createClassUID(string, 0);
    }

    public final void newIdUncheked(StringBuffer stringBuffer, String string, String string2) {
        ClassInfoEntry classInfoEntry = this.getClassInfo(string2);
        classInfoEntry.createClassUID(stringBuffer, string, 0);
    }

    public boolean verifyUIDString(String string) {
        try {
            int n2 = string.indexOf(94);
            if (n2 == -1) {
                return false;
            }
            Integer.parseInt(string.substring(0, n2));
            int n3 = string.indexOf(94, n2 + 1);
            if (n3 == -1) {
                return false;
            }
            Integer.parseInt(string.substring(n2 + 1, n3));
            int n4 = string.indexOf(94, n3 + 1);
            if (n4 == -1) {
                return false;
            }
            int n5 = string.indexOf(94, n4 + 1);
            if (n5 == -1) {
                return false;
            }
            Long.parseLong(string.substring(n4 + 1, n5));
            Long.parseLong(string.substring(n5 + 1));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getClasscodeFromUID(String string) {
        int n2 = string.indexOf(94);
        if (n2 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        return string.substring(0, n2);
    }

    public String getClassLengthFromUID(String string) {
        int n2 = string.indexOf(94);
        if (n2 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n3 = string.indexOf(94, n2 + 1);
        if (n3 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        return string.substring(n2 + 1, n3);
    }

    public String createUIDFromCounter() {
        long l2 = this.m_Counter.incrementAndGet();
        return String.valueOf(l2);
    }

    public String getBasicNameFromUID(String string) {
        int n2 = string.indexOf(94);
        if (n2 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n3 = string.indexOf(94, n2 + 1);
        if (n3 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n4 = string.lastIndexOf(94);
        if (n4 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n5 = string.lastIndexOf(94, n4 - 1);
        if (n5 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        return string.substring(n3 + 1, n5);
    }

    public String getSpaceNameFromUID(String string) {
        int n2 = string.indexOf(94);
        if (n2 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n3 = string.indexOf(94, n2 + 1);
        if (n3 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        int n4 = string.indexOf(94, n3 + 1);
        if (n4 == -1) {
            throw new RuntimeException("invalid UID string: " + string);
        }
        String string2 = string.substring(n3 + 1, n4);
        int n5 = string.indexOf(94, n4 + 1);
        if (n5 == -1) {
            return null;
        }
        long l2 = Long.parseLong(string.substring(n4 + 1, n5));
        return l2 != 0L ? string2 : null;
    }

    private ClassInfoEntry getClassInfo(String string) {
        if (string == null) {
            return this.nullClassInfo;
        }
        ClassInfoEntry classInfoEntry = (ClassInfoEntry)this.m_ClassInfoHash.get((Object)string);
        if (classInfoEntry == null) {
            classInfoEntry = new ClassInfoEntry(string);
            if (this._optimisticClassInfoSize > 100) {
                this._optimisticClassInfoSize = 0;
                this.m_ClassInfoHash.clear();
            }
            if (this.m_ClassInfoHash.putIfAbsent((Object)string, (Object)classInfoEntry) == null) {
                int n2 = this._optimisticClassInfoSize;
                this._optimisticClassInfoSize = ++n2;
            }
        }
        return classInfoEntry;
    }

    private String createUID(String string, long l2, ClassInfoEntry classInfoEntry) {
        ClassInfoEntry classInfoEntry2 = classInfoEntry != null ? classInfoEntry : this.getClassInfo(string);
        return classInfoEntry2.createClassUID(l2);
    }

    private class ClassInfoEntry
    implements Serializable {
        private final String classPrefix;
        private final int classPrefixLength;
        private static final String POST_FIX = "^0^0";
        private final int POST_FIX_LENGTH = "^0^0".length();

        public ClassInfoEntry(String string) {
            int n2 = 0;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                n2 = string.hashCode();
                n3 = string.length();
            }
            stringBuffer.append(n2);
            stringBuffer.append('^');
            stringBuffer.append(n3);
            stringBuffer.append('^');
            if (UIDStringFactory.this.m_BasicName != null && UIDStringFactory.this.useTimeStamp) {
                stringBuffer.append(UIDStringFactory.this.m_BasicName);
                stringBuffer.append('^');
                stringBuffer.append(UIDStringFactory.this.m_TimeStamp);
                stringBuffer.append('^');
            }
            this.classPrefix = stringBuffer.toString();
            this.classPrefixLength = this.classPrefix.length();
        }

        public String createClassUID(long l2) {
            return this.classPrefix.concat(Long.toString(l2));
        }

        private void getClientNameUID(StringBuffer stringBuffer, String string) {
            stringBuffer.append(this.classPrefix);
            stringBuffer.append(string);
            stringBuffer.append(POST_FIX);
        }

        public void createClassUID(StringBuffer stringBuffer, String string, int n2) {
            if (!UIDStringFactory.this.useTimeStamp && n2 == 0) {
                this.getClientNameUID(stringBuffer, string);
            } else {
                stringBuffer.append(this.classPrefix);
                stringBuffer.append(string);
                stringBuffer.append('^');
                stringBuffer.append(UIDStringFactory.this.m_TimeStamp);
                stringBuffer.append('^');
                stringBuffer.append(n2);
            }
        }

        public String createClassUID(String string, int n2) {
            StringBuffer stringBuffer = new StringBuffer(this.classPrefixLength + string.length() + this.POST_FIX_LENGTH);
            this.createClassUID(stringBuffer, string, n2);
            return stringBuffer.toString();
        }
    }
}

