/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.client.cache.map.MapCache;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.eviction.AbstractEvictionStrategy;
import com.j_spaces.map.eviction.NoneEvictionStrategy;
import com.j_spaces.obf.ci;
import com.sun.jini.start.LifeCycle;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheFinder
extends SpaceFinder {
    private static CacheFinder a = new CacheFinder();

    private CacheFinder() {
    }

    public static Object find(String string) throws FinderException {
        return CacheFinder.find(string, (Properties)null);
    }

    public static Object find(String[] stringArray) throws FinderException {
        SpaceURL[] spaceURLArray = CacheFinder.prepareUrl(stringArray, null);
        Properties properties = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return a.internalFind(spaceURLArray, null, properties);
    }

    public static Object find(String string, Properties properties) throws FinderException {
        SpaceURL[] spaceURLArray = CacheFinder.prepareUrl(string, properties);
        Properties properties2 = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return a.internalFind(spaceURLArray, null, properties2);
    }

    public static Object find(String string, IJSpace iJSpace) throws FinderException {
        SpaceURL[] spaceURLArray = CacheFinder.prepareUrl(string, null);
        Properties properties = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return a.internalFind(spaceURLArray, iJSpace, properties);
    }

    public final Object _find(SpaceURL spaceURL, IJSpace iJSpace, Properties properties, LifeCycle lifeCycle) throws FinderException {
        try {
            String string = spaceURL.getProperty("useLocalCache", Boolean.FALSE.toString());
            String string2 = spaceURL.getProperty("NOWriteLease");
            if (string2 == null) {
                spaceURL.setProperty("NOWriteLease", Boolean.TRUE.toString());
            }
            if (iJSpace == null) {
                iJSpace = (IJSpace)super._find(spaceURL, iJSpace, properties, lifeCycle);
                iJSpace.setNOWriteLeaseMode(true);
            } else {
                CacheFinder.loadCacheConfig(spaceURL, iJSpace, properties);
            }
            String string3 = iJSpace.getName() + "_DCache";
            if (string.equalsIgnoreCase(Boolean.TRUE.toString())) {
                Object object;
                EvictionStrategy evictionStrategy;
                boolean bl2 = Boolean.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.put-first", "true"));
                boolean bl3 = Boolean.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.multicast-notify", "false"));
                int n2 = Integer.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.compression", "0"));
                boolean bl4 = Boolean.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.versioned", "false"));
                try {
                    String string4 = JProperties.getSpaceProperty(string3, "dist-cache.eviction-strategy", "com.j_spaces.map.eviction.FIFOEvictionStrategy");
                    evictionStrategy = (EvictionStrategy)ci.a(string4).newInstance();
                    if (evictionStrategy instanceof AbstractEvictionStrategy) {
                        object = JProperties.getSpaceProperty(string3, "engine.memory_usage.eviction_batch_size", "500");
                        ((AbstractEvictionStrategy)evictionStrategy).setBatchSize(Integer.parseInt((String)object));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = Logger.getLogger("com.gigaspaces.client");
                    if (((Logger)object).isLoggable(Level.WARNING)) {
                        ((Logger)object).log(Level.WARNING, "Failed to find eviction strategy implementation using NoneEvictionStrategy.", classNotFoundException);
                    }
                    evictionStrategy = new NoneEvictionStrategy();
                }
                int n3 = Integer.valueOf(JProperties.getSpaceProperty(string3, "engine.cache_size", "100000"));
                object = spaceURL.getProperty("updateMode");
                int n4 = object == null ? Integer.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.update-mode", Constants.DCache.UPDATE_MODE_DEFUALT)).intValue() : Integer.valueOf((String)object).intValue();
                iJSpace.setOptimisticLocking(bl4);
                return new MapCache(iJSpace, bl4, n4, evictionStrategy, bl3, bl2, n3, n2, spaceURL.getURL());
            }
            int n5 = Integer.valueOf(JProperties.getSpaceProperty(string3, "dist-cache.compression", "0"));
            return new GSMapImpl(iJSpace, n5);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Exception exception) {
            throw new FinderException(exception.getMessage(), exception);
        }
    }

    public Object initCacheProperties(IJSpace iJSpace, Properties properties, SpaceURL spaceURL) throws Exception {
        CacheFinder.loadCacheConfig(spaceURL, iJSpace, properties);
        return iJSpace;
    }

    public static void main(String[] stringArray) throws FinderException {
        if (stringArray.length <= 0) {
            SpaceURLParser.printUsage();
            System.exit(-1);
        }
        CacheFinder.find(stringArray[0]);
    }
}

