/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.cluster.NewGroup;
import com.j_spaces.tools.cluster.TwoSelectionListPanel;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class GroupFailOverPanel
extends JPanel
implements ISetPanel {
    public JFrame m_parent;
    public Object[] m_availableAlternateGroups;
    public GroupInfo m_groupInfo;
    public Vector m_allGroupMembers;
    public JLabel labFailOverFindTimeout;
    public WholeNumberField txtfFailOverFindTimeout;
    public TwoSelectionListPanel m_panAlternateGroups;
    public final int ENABLE_COLUMN_WIDTH = 60;
    public final String[] OPERATIONS;
    public final String[] POLICY_TYPE;
    public OperationsTable m_operationTable;
    public ColumnSortListener m_columnSortListener;
    public JTabbedPane m_tabbedPanOperations;
    public JTabbedPane m_tabbedPaneFO;
    public JPanel m_panPolicyDesc;
    public BackupMembersDialog m_backupMembersDialog;
    public FailOverPolicyDescriptionPanel[] m_panOperationPolicyDesc;
    private JCheckBox failBackCheckBox;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public GroupFailOverPanel(JFrame jFrame, GroupInfo groupInfo, GroupInfo[] groupInfoArray) {
        block4: {
            this.m_allGroupMembers = new Vector();
            this.ENABLE_COLUMN_WIDTH = 60;
            this.OPERATIONS = new String[]{"Default", "Write", "Read", "Take", "Notify"};
            this.POLICY_TYPE = new String[]{"Fail To Available", "Fail To Backup", "Immediately Fail To Alternate"};
            this.m_operationTable = new OperationsTable();
            this.m_columnSortListener = new ColumnSortListener();
            this.m_tabbedPanOperations = new JTabbedPane();
            this.m_tabbedPaneFO = new JTabbedPane();
            this.m_panPolicyDesc = new JPanel();
            this.failBackCheckBox = new JCheckBox("Fail-back");
            this.m_parent = jFrame;
            try {
                String string = null;
                if (groupInfo != null) {
                    string = groupInfo.groupName;
                }
                this.m_panAlternateGroups = new TwoSelectionListPanel(true, string);
                this.m_panAlternateGroups.setSelectionFilter(new AtlernateGroupSelectionFilter(this.m_operationTable, this.m_panAlternateGroups));
                this.m_backupMembersDialog = new BackupMembersDialog(jFrame);
                this.m_panOperationPolicyDesc = new FailOverPolicyDescriptionPanel[5];
                for (int i2 = 0; i2 < this.m_panOperationPolicyDesc.length; ++i2) {
                    this.m_panOperationPolicyDesc[i2] = new FailOverPolicyDescriptionPanel(this, this.OPERATIONS[i2]);
                }
                this.jbInit();
                this.init(groupInfo, groupInfoArray);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public GroupFailOverPanel(JFrame jFrame) {
        this(jFrame, null, null);
    }

    public GroupFailOverPanel() {
        this(new JFrame());
    }

    public void init(GroupInfo groupInfo, Object[] objectArray) {
        this.m_groupInfo = groupInfo;
        this.m_availableAlternateGroups = objectArray;
        String string = null;
        String[] stringArray = null;
        this.m_allGroupMembers.clear();
        if (groupInfo != null) {
            string = groupInfo.groupName;
            if (groupInfo.failOverInfo != null) {
                stringArray = groupInfo.failOverInfo.alterGroup;
            }
            for (int i2 = 0; i2 < groupInfo.groupMembers.length; ++i2) {
                ClusterMemberInfo clusterMemberInfo = groupInfo.groupMembers[i2];
                if (clusterMemberInfo == null) continue;
                this.m_allGroupMembers.add(clusterMemberInfo.memberName);
            }
            this.restoreSettings(groupInfo.failOverInfo);
        }
        this.m_panAlternateGroups.setListModels(objectArray, stringArray, string);
    }

    public void jbInit() throws Exception {
        this.labFailOverFindTimeout = new JLabel("Find Timeout Msec:");
        this.txtfFailOverFindTimeout = new WholeNumberField();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), ""), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel.add((Component)this.labFailOverFindTimeout, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfFailOverFindTimeout, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.m_panAlternateGroups.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), ""), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "South");
        jPanel2.add((Component)this.m_panAlternateGroups, "Center");
        for (int i2 = 0; i2 < this.m_panOperationPolicyDesc.length; ++i2) {
            this.m_tabbedPanOperations.add((Component)this.m_panOperationPolicyDesc[i2], this.OPERATIONS[i2]);
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_operationTable);
        jScrollPane.setPreferredSize(new Dimension(5, 109));
        this.m_panPolicyDesc.setLayout(new BorderLayout());
        this.m_panPolicyDesc.add((Component)jScrollPane, "North");
        this.m_panPolicyDesc.add((Component)this.m_tabbedPanOperations, "Center");
        this.m_tabbedPaneFO.add((Component)this.m_panPolicyDesc, "Policy Description");
        this.m_tabbedPaneFO.add((Component)jPanel2, "Alternate Groups");
        this.setLayout(new BorderLayout());
        this.failBackCheckBox.setMnemonic('F');
        this.add((Component)this.failBackCheckBox, "North");
        this.add((Component)this.m_tabbedPaneFO, "Center");
        this.m_tabbedPanOperations.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = GroupFailOverPanel.this.m_tabbedPanOperations.getSelectedIndex();
                if (n2 != GroupFailOverPanel.this.m_operationTable.getSelectedRow()) {
                    GroupFailOverPanel.this.m_operationTable.changeSelection(n2, n2, false, false);
                }
            }
        });
    }

    public void addGroupMember(String string) {
        this.m_allGroupMembers.add(string);
        this.updateAllPolicyDescButtonsStatus();
    }

    public boolean removeGroupMember(String string) {
        boolean bl2 = this.m_allGroupMembers.remove(string);
        this.updateAllPolicyDescButtonsStatus();
        return bl2;
    }

    private void updateAllPolicyDescButtonsStatus() {
        for (int i2 = 0; i2 < this.m_panOperationPolicyDesc.length; ++i2) {
            if (!this.m_panOperationPolicyDesc[i2].isEnabled()) continue;
            this.m_panOperationPolicyDesc[i2].mi_backupMembersPanel.updateButtonsEnabledStatus(this.m_operationTable.hasPolicyType(i2, this.POLICY_TYPE[1]));
        }
    }

    public void setEnableComponentsStatus(boolean bl2) {
        this.m_tabbedPaneFO.setSelectedIndex(0);
        this.m_tabbedPaneFO.setEnabled(bl2);
        JSpaceUtilities.setAWTComponentsStatus(this.m_panPolicyDesc, bl2);
        if (bl2) {
            this.updateAllPolicyDescButtonsStatus();
        }
    }

    public void reset() {
        this.txtfFailOverFindTimeout.setValueInt(2000);
        this.m_panAlternateGroups.reset();
        this.failBackCheckBox.setSelected(false);
        for (int i2 = 0; i2 < this.m_tabbedPanOperations.getTabCount(); ++i2) {
            this.m_tabbedPanOperations.setEnabledAt(i2, false);
            this.m_panOperationPolicyDesc[i2].reset();
        }
        this.m_operationTable.reset();
    }

    public void restoreSettings(Object object) {
        if (object == null || !(object instanceof FailOverPolicy)) {
            return;
        }
        FailOverPolicy failOverPolicy = (FailOverPolicy)object;
        this.txtfFailOverFindTimeout.setValueInt((int)failOverPolicy.spaceFinderTimeout);
        this.failBackCheckBox.setSelected(failOverPolicy.isFailBackEnabled());
        HashMap<String, FailOverPolicy.FailOverPolicyDescription> hashMap = new HashMap<String, FailOverPolicy.FailOverPolicyDescription>();
        hashMap.put(this.OPERATIONS[0], failOverPolicy.m_DefaultFOPolicy);
        hashMap.put(this.OPERATIONS[1], failOverPolicy.m_WriteFOPolicy);
        hashMap.put(this.OPERATIONS[2], failOverPolicy.m_ReadFOPolicy);
        hashMap.put(this.OPERATIONS[3], failOverPolicy.m_TakeFOPolicy);
        hashMap.put(this.OPERATIONS[4], failOverPolicy.m_NotifyFOPolicy);
        for (int i2 = 0; i2 < this.m_panOperationPolicyDesc.length; ++i2) {
            Object v2 = hashMap.get(this.m_panOperationPolicyDesc[i2].mi_operationName);
            if (v2 != null) {
                this.m_panOperationPolicyDesc[i2].restoreSettings(v2);
            }
            this.m_tabbedPanOperations.setEnabledAt(i2, v2 != null);
        }
        Vector vector = new Vector();
        for (int i3 = 0; i3 < this.OPERATIONS.length; ++i3) {
            FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[i3]);
            Boolean bl2 = failOverPolicyDescription != null;
            String string = failOverPolicyDescription != null ? this.POLICY_TYPE[failOverPolicyDescription.m_PolicyType] : this.POLICY_TYPE[0];
            Boolean bl3 = failOverPolicyDescription != null ? failOverPolicyDescription.m_DisableAlternateGroups : false;
            Vector<Object> vector2 = new Vector<Object>(4);
            vector2.add(bl2);
            vector2.add(this.OPERATIONS[i3]);
            vector2.add(string);
            vector2.add(bl3);
            vector.add(vector2);
        }
        this.m_operationTable.tableModel.updateDataVector(vector);
    }

    public Object saveSettings() {
        FailOverPolicy failOverPolicy = new FailOverPolicy();
        failOverPolicy.alterGroup = this.m_panAlternateGroups.getSelectedItems();
        failOverPolicy.spaceFinderTimeout = this.txtfFailOverFindTimeout.getValueInt() > 0 ? (long)this.txtfFailOverFindTimeout.getValueInt() : 2000L;
        failOverPolicy.setFailBackEnabled(this.failBackCheckBox.isSelected());
        HashMap<String, FailOverPolicy.FailOverPolicyDescription> hashMap = new HashMap<String, FailOverPolicy.FailOverPolicyDescription>();
        for (int i2 = 0; i2 < this.m_panOperationPolicyDesc.length; ++i2) {
            FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = null;
            Object[] objectArray = this.m_operationTable.getOpeartionSettings(i2);
            if (((Boolean)objectArray[0]).booleanValue()) {
                failOverPolicyDescription = new FailOverPolicy.FailOverPolicyDescription();
                failOverPolicyDescription.m_PolicyType = (Integer)objectArray[1];
                failOverPolicyDescription.m_DisableAlternateGroups = (Boolean)objectArray[2];
                if (failOverPolicyDescription.m_PolicyType == 1) {
                    this.m_panOperationPolicyDesc[i2].saveSettingsTo(failOverPolicyDescription);
                }
            }
            hashMap.put(this.OPERATIONS[i2], failOverPolicyDescription);
        }
        failOverPolicy.m_DefaultFOPolicy = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[0]);
        failOverPolicy.m_WriteFOPolicy = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[1]);
        failOverPolicy.m_ReadFOPolicy = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[2]);
        failOverPolicy.m_TakeFOPolicy = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[3]);
        failOverPolicy.m_NotifyFOPolicy = (FailOverPolicy.FailOverPolicyDescription)hashMap.get(this.OPERATIONS[4]);
        return failOverPolicy;
    }

    public boolean canRemoveAlternateGroup() {
        return this.m_groupInfo.failOverInfo != null && !this.m_operationTable.hasPolicyType(this.POLICY_TYPE[2]) && this.m_groupInfo.failOverInfo.alterGroup.length >= 1;
    }

    private class AtlernateGroupSelectionFilter
    implements TwoSelectionListPanel.ISelectionFilter {
        public OperationsTable table;
        public TwoSelectionListPanel selectPanel;

        public AtlernateGroupSelectionFilter(OperationsTable operationsTable, TwoSelectionListPanel twoSelectionListPanel) {
            this.table = operationsTable;
            this.selectPanel = twoSelectionListPanel;
        }

        public boolean process() {
            boolean bl2;
            boolean bl3 = bl2 = this.table.hasPolicyType(GroupFailOverPanel.this.POLICY_TYPE[2]) && this.selectPanel.selectedItemsModel.size() == 1;
            if (bl2) {
                JOptionPane.showMessageDialog(GroupFailOverPanel.this.m_parent, "Definition of <Immediately Fail To Alternate> policy type,\nrequires the alternate group declaration.");
            }
            return !bl2;
        }
    }

    private class OperationsTable
    extends JTable {
        public final String[] COLUMN_LABELS;
        public final int OPERATION_DEFAULT = 0;
        public CustomTableModel tableModel;
        public JComboBox cmboxPolicyType;
        public Object previousPolicyType;

        public OperationsTable() {
            block3: {
                this.COLUMN_LABELS = new String[]{"Enable", "Operation", "Policy Type", "Disable Alternate Group"};
                this.OPERATION_DEFAULT = 0;
                this.tableModel = new CustomTableModel();
                this.cmboxPolicyType = new JComboBox<String>(GroupFailOverPanel.this.POLICY_TYPE);
                try {
                    for (int i2 = 0; i2 < GroupFailOverPanel.this.OPERATIONS.length; ++i2) {
                        this.tableModel.addRow(new Object[]{Boolean.FALSE, GroupFailOverPanel.this.OPERATIONS[i2], GroupFailOverPanel.this.POLICY_TYPE[0], Boolean.FALSE});
                    }
                    this.setModel(this.tableModel);
                    this.setRowHeight(this.getRowHeight() + 2);
                    this.getColumnModel().getColumn(2).setCellEditor(new PolicyTypeCellEditor(this.cmboxPolicyType, this));
                    this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            int n2;
                            if (listSelectionEvent.getValueIsAdjusting()) {
                                return;
                            }
                            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                            if (!listSelectionModel.isSelectionEmpty() && OperationsTable.this.tableModel.isOperationEnabled(n2 = listSelectionModel.getMinSelectionIndex())) {
                                GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(n2);
                            }
                        }
                    });
                    this.getColumnModel().getColumn(0).setMaxWidth(60);
                    this.getColumnModel().getColumn(0).setMinWidth(60);
                    this.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block3;
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }

        public void reset() {
            Vector vector = new Vector();
            int n2 = GroupFailOverPanel.this.m_operationTable.getRowCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Vector<Object> vector2 = new Vector<Object>(4);
                vector2.add(Boolean.FALSE);
                vector2.add(GroupFailOverPanel.this.OPERATIONS[i2]);
                vector2.add(GroupFailOverPanel.this.POLICY_TYPE[0]);
                vector2.add(Boolean.FALSE);
                vector.add(vector2);
            }
            GroupFailOverPanel.this.m_operationTable.tableModel.updateDataVector(vector);
            this.clearSelection();
            this.changeSelection(0, 0, false, false);
        }

        public Object[] getOpeartionSettings(int n2) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getValueAt(n2, 0);
            Object object = this.getValueAt(n2, 2);
            for (int i2 = 0; i2 < GroupFailOverPanel.this.POLICY_TYPE.length; ++i2) {
                if (!object.equals(GroupFailOverPanel.this.POLICY_TYPE[i2])) continue;
                objectArray[1] = new Integer(i2);
            }
            objectArray[2] = this.getValueAt(n2, 3);
            return objectArray;
        }

        public boolean hasPolicyType(String string) {
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                if (!this.getValueAt(i2, 2).equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPolicyType(int n2, String string) {
            return this.getValueAt(n2, 2).equals(string);
        }

        public boolean isOperationEnabled(int n2) {
            return this.tableModel.isOperationEnabled(n2);
        }

        public class CustomTableModel
        extends DefaultTableModel {
            public CustomTableModel() {
                for (int i2 = 0; i2 < OperationsTable.this.COLUMN_LABELS.length; ++i2) {
                    this.addColumn(OperationsTable.this.COLUMN_LABELS[i2]);
                }
                this.addTableModelListener(new TableModelListener(){

                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getType() == 0) {
                            int n2;
                            int n3 = tableModelEvent.getFirstRow();
                            CustomTableModel customTableModel = (CustomTableModel)tableModelEvent.getSource();
                            boolean bl2 = (Boolean)customTableModel.getValueAt(n3, 0);
                            String string = (String)customTableModel.getValueAt(n3, 2);
                            if (tableModelEvent.getColumn() == 0) {
                                GroupFailOverPanel.this.m_tabbedPanOperations.setEnabledAt(n3, bl2);
                                if (bl2) {
                                    GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(n3);
                                } else {
                                    if (!CustomTableModel.this.isBasicOperationsEnabled()) {
                                        GroupFailOverPanel.this.m_operationTable.setValueAt(Boolean.TRUE, 0, 0);
                                        return;
                                    }
                                    n2 = NewGroup.getEnabledTabIndex(GroupFailOverPanel.this.m_tabbedPanOperations);
                                    if (n2 == -1) {
                                        n2 = 0;
                                        GroupFailOverPanel.this.m_tabbedPanOperations.setEnabledAt(n2, true);
                                        GroupFailOverPanel.this.m_operationTable.setValueAt(Boolean.TRUE, 0, 0);
                                    }
                                    GroupFailOverPanel.this.m_operationTable.changeSelection(n2, 1, false, false);
                                    GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(n2);
                                }
                            }
                            if (tableModelEvent.getColumn() == 2) {
                                n2 = string.equals(GroupFailOverPanel.this.POLICY_TYPE[1]) ? 1 : 0;
                                GroupFailOverPanel.this.m_panOperationPolicyDesc[n3].setTabsEnabled(n2 != 0);
                                if (string.equals(GroupFailOverPanel.this.POLICY_TYPE[2]) && !GroupFailOverPanel.this.m_panAlternateGroups.hasSelectedItems()) {
                                    JOptionPane.showMessageDialog(GroupFailOverPanel.this.m_parent, "This policy type requires the alternate group declaration.");
                                    if (OperationsTable.this.previousPolicyType != null) {
                                        customTableModel.setValueAt(OperationsTable.this.previousPolicyType, n3, 2);
                                    }
                                    return;
                                }
                                if (string.equals(GroupFailOverPanel.this.POLICY_TYPE[2])) {
                                    customTableModel.setValueAt(new Boolean(false), n3, 3);
                                }
                            }
                        }
                    }
                });
            }

            public boolean isBasicOperationsEnabled() {
                for (int i2 = 1; i2 < GroupFailOverPanel.this.OPERATIONS.length; ++i2) {
                    if (this.isOperationEnabled(i2)) continue;
                    return false;
                }
                return true;
            }

            public boolean isOperationEnabled(int n2) {
                return (Boolean)this.getValueAt(n2, 0);
            }

            public void updateDataVector(Vector vector) {
                this.dataVector = vector;
                this.fireTableRowsUpdated(0, vector.size() - 1);
            }

            public boolean isCellEditable(int n2, int n3) {
                if (n3 != 0 && !this.isOperationEnabled(n2)) {
                    return false;
                }
                if (n3 == 3) {
                    String string = (String)this.getValueAt(n2, 2);
                    return !string.equals(GroupFailOverPanel.this.POLICY_TYPE[2]);
                }
                return n3 != 1;
            }

            public Class getColumnClass(int n2) {
                if (n2 != 2) {
                    Vector vector = (Vector)this.dataVector.elementAt(0);
                    return vector.elementAt(n2).getClass();
                }
                return super.getColumnClass(n2);
            }
        }

        public class PolicyTypeCellEditor
        extends DefaultCellEditor {
            public JComboBox combo;
            public JTable table;

            public PolicyTypeCellEditor(JComboBox jComboBox, JTable jTable) {
                super(jComboBox);
                this.combo = jComboBox;
                this.table = jTable;
                jComboBox.setFont(jTable.getFont());
            }

            public boolean isCellEditable(EventObject eventObject) {
                OperationsTable.this.previousPolicyType = this.table.getValueAt(this.table.getSelectedRow(), 2);
                return super.isCellEditable(eventObject);
            }
        }
    }

    private class FailOverPolicyDescriptionPanel
    extends JPanel
    implements ISetPanel {
        private static final int ADD_ROW_HEIGHT = 4;
        public String mi_operationName;
        public JTabbedPane mi_tabbedPaneBackups;
        public BackupOnlyPanel mi_backupOnlyPanel;
        public BackupMembersPanel mi_backupMembersPanel;

        public FailOverPolicyDescriptionPanel(Component component, String string) {
            block2: {
                this.mi_tabbedPaneBackups = new JTabbedPane();
                this.mi_backupOnlyPanel = new BackupOnlyPanel(this);
                this.mi_backupMembersPanel = new BackupMembersPanel(this);
                try {
                    this.mi_operationName = string;
                    this.jbInit();
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }

        public void jbInit() throws Exception {
            this.mi_tabbedPaneBackups.add((Component)this.mi_backupMembersPanel, "Backup Members");
            this.mi_tabbedPaneBackups.add((Component)this.mi_backupOnlyPanel, "Backup Only");
            this.setLayout(new BorderLayout());
            this.add((Component)this.mi_tabbedPaneBackups, "Center");
        }

        public void setTabsEnabled(boolean bl2) {
            this.mi_tabbedPaneBackups.setEnabledAt(0, bl2);
            this.mi_tabbedPaneBackups.setEnabledAt(1, bl2);
            JSpaceUtilities.setAWTComponentsStatus(this.mi_backupOnlyPanel, bl2);
            JSpaceUtilities.setAWTComponentsStatus(this.mi_backupMembersPanel, bl2);
            if (bl2) {
                this.mi_backupMembersPanel.updateButtonsEnableStatus();
            }
        }

        public void reset() {
            this.mi_backupMembersPanel.reset();
            this.mi_backupOnlyPanel.reset();
        }

        public void restoreSettings(Object object) {
            if (object == null) {
                return;
            }
            FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = (FailOverPolicy.FailOverPolicyDescription)object;
            this.mi_backupMembersPanel.restoreSettings(failOverPolicyDescription.m_BackupMemberNames);
            this.mi_backupOnlyPanel.restoreSettings(failOverPolicyDescription.m_BackupOnly);
        }

        public void saveSettingsTo(FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription) {
            failOverPolicyDescription.m_BackupMemberNames = (HashMap)this.mi_backupMembersPanel.saveSettings();
            failOverPolicyDescription.m_BackupOnly = (Vector)this.mi_backupOnlyPanel.saveSettings();
        }

        public Object saveSettings() {
            return null;
        }

        private class BackupMembersPanel
        extends JPanel
        implements ISetPanel {
            public JButton butAdd;
            public JButton butRemove;
            public JButton butRemoveAll;
            public JButton butShow;
            public JTable table;
            public final String[] COLUMN_LABELS;
            public CustomTableModel tableModel;
            public HashSet mi_selectedMembers;
            public Object mi_lastProcesedMember;

            public BackupMembersPanel(Component component) {
                block2: {
                    this.butAdd = new JButton();
                    this.butRemove = new JButton();
                    this.butRemoveAll = new JButton();
                    this.butShow = new JButton();
                    this.COLUMN_LABELS = new String[]{"Member Name", "Backup Members"};
                    this.tableModel = new CustomTableModel();
                    this.mi_selectedMembers = new HashSet();
                    try {
                        this.init();
                        this.reset();
                    }
                    catch (Exception exception) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block2;
                        _logger.log(Level.SEVERE, exception.toString(), exception);
                    }
                }
            }

            public void init() throws Exception {
                this.table = new JTable(this.tableModel){

                    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
                        Component component = super.prepareRenderer(tableCellRenderer, n2, n3);
                        if (component instanceof JComponent) {
                            JComponent jComponent = (JComponent)component;
                            Object object = this.getValueAt(n2, n3);
                            if (object != null) {
                                jComponent.setToolTipText(object.toString());
                            }
                        }
                        return component;
                    }
                };
                this.butAdd.setMnemonic(65);
                this.butAdd.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (BackupMembersPanel.this.table.isEditing()) {
                            BackupMembersPanel.this.table.getCellEditor().stopCellEditing();
                        }
                        BackupMembersPanel.this.tableModel.addRow(new Object[]{"", new Vector()});
                        BackupMembersPanel.this.updateButtonsEnableStatus();
                    }
                });
                this.butRemove.setMnemonic(82);
                this.butRemove.addActionListener(new ActionListener(){
                    public Object value;
                    public HashSet backupOnly;

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n2;
                        if (BackupMembersPanel.this.table.isEditing()) {
                            BackupMembersPanel.this.table.getCellEditor().stopCellEditing();
                        }
                        if ((n2 = BackupMembersPanel.this.table.getSelectedRow()) != -1) {
                            this.value = BackupMembersPanel.this.tableModel.getValueAt(n2, 0);
                            BackupMembersPanel.this.mi_selectedMembers.remove(this.value);
                            BackupMembersPanel.this.tableModel.removeRow(n2);
                            this.backupOnly = BackupMembersPanel.this.tableModel.getBackupOnlyMembers();
                            if (this.backupOnly.size() > 0) {
                                FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.updateTable(this.backupOnly);
                            } else {
                                FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.tableModel.reset();
                            }
                        }
                        BackupMembersPanel.this.updateButtonsEnableStatus();
                    }
                });
                this.butRemoveAll.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BackupMembersPanel.this.reset();
                    }
                });
                this.butShow.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("OPERATION: " + GroupFailOverPanel.this.m_operationTable + "\nBackup members:");
                        }
                        HashMap hashMap = (HashMap)FailOverPolicyDescriptionPanel.this.mi_backupMembersPanel.saveSettings();
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            Object k2 = iterator.next();
                            if (!_logger.isLoggable(Level.INFO)) continue;
                            _logger.info(k2 + " : " + hashMap.get(k2));
                        }
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.info("Backup ONLY:\n" + FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.saveSettings());
                        }
                    }
                });
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                tableColumnModel.getColumn(0).setCellEditor(new MemberCellEditor(new JComboBox(GroupFailOverPanel.this.m_allGroupMembers), this.table));
                tableColumnModel.getColumn(1).setCellEditor(new BackupCellEditor());
                this.table.setAutoscrolls(true);
                this.table.setAutoCreateColumnsFromModel(false);
                this.table.setRowHeight(this.table.getRowHeight() + 4);
                this.table.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                this.table.setPreferredScrollableViewportSize(new Dimension(5, 5));
                JScrollPane jScrollPane = new JScrollPane(this.table);
                jScrollPane.setPreferredSize(new Dimension(5, 5));
                this.butAdd.setText("Add");
                this.butRemove.setText("Remove");
                this.butRemoveAll.setText("Remove All");
                this.butShow.setText("Show");
                this.setLayout(new GridBagLayout());
                this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.butAdd, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
                this.add((Component)this.butRemove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
                this.add((Component)this.butRemoveAll, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
            }

            public void updateButtonsEnableStatus() {
                boolean bl2 = this.table.getRowCount() < GroupFailOverPanel.this.m_allGroupMembers.size();
                this.butAdd.setEnabled(bl2);
                bl2 = this.table.getRowCount() > 0;
                this.butRemove.setEnabled(bl2);
                this.butRemoveAll.setEnabled(bl2);
            }

            public void updateButtonsEnabledStatus(boolean bl2) {
                if (bl2) {
                    this.updateButtonsEnableStatus();
                } else {
                    this.butAdd.setEnabled(false);
                    this.butRemove.setEnabled(false);
                    this.butRemoveAll.setEnabled(false);
                }
            }

            public void reset() {
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tableModel.reset();
                this.mi_selectedMembers.clear();
                FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.reset();
                this.updateButtonsEnableStatus();
            }

            public void restoreSettings(Object object) {
                if (object == null) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                Object e2 = null;
                List list = null;
                this.reset();
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    e2 = iterator.next();
                    list = (List)hashMap.get(e2);
                    Vector vector = new Vector();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        vector.add(iterator2.next());
                    }
                    this.tableModel.addRow(new Object[]{e2, vector});
                    this.mi_selectedMembers.add(e2);
                }
            }

            public Object saveSettings() {
                HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
                Iterator<Vector> iterator = this.tableModel.getDataVector().iterator();
                while (iterator.hasNext()) {
                    Vector vector = iterator.next();
                    String string = (String)vector.get(0);
                    Vector vector2 = (Vector)vector.get(1);
                    if (string != null && string.trim().length() > 0 && vector2.size() > 0) {
                        hashMap.put(string, vector2);
                        continue;
                    }
                    iterator.remove();
                }
                this.tableModel.fireTableDataChanged();
                return hashMap;
            }

            public class CustomTableModel
            extends DefaultTableModel {
                public CustomTableModel() {
                    for (int i2 = 0; i2 < BackupMembersPanel.this.COLUMN_LABELS.length; ++i2) {
                        this.addColumn(BackupMembersPanel.this.COLUMN_LABELS[i2]);
                    }
                    this.addTableModelListener(new TableModelListener(){
                        public Object selectedItem;

                        public void tableChanged(TableModelEvent tableModelEvent) {
                            if (tableModelEvent.getType() == 0) {
                                if (tableModelEvent.getColumn() == 0) {
                                    CustomTableModel customTableModel = (CustomTableModel)tableModelEvent.getSource();
                                    this.selectedItem = customTableModel.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                                    if (this.selectedItem == null) {
                                        return;
                                    }
                                    BackupMembersPanel.this.mi_selectedMembers.add(this.selectedItem);
                                    if (FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.isSelected(this.selectedItem)) {
                                        JOptionPane.showMessageDialog(GroupFailOverPanel.this.m_parent, "The member [" + this.selectedItem + "] was removed from backup only table.");
                                    }
                                    if (!this.selectedItem.equals(BackupMembersPanel.this.mi_lastProcesedMember)) {
                                        customTableModel.setValueAt(new Vector(), tableModelEvent.getFirstRow(), 1);
                                    }
                                }
                                if (tableModelEvent.getColumn() == 1) {
                                    FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.updateTable(FailOverPolicyDescriptionPanel.this.mi_backupMembersPanel.tableModel.getBackupOnlyMembers());
                                }
                            }
                        }
                    });
                }

                public void reset() {
                    this.dataVector = new Vector();
                    this.fireTableDataChanged();
                }

                public Vector getOwnerMembers() {
                    Vector<String> vector = new Vector<String>();
                    for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                        String string = (String)this.getValueAt(i2, 0);
                        if (string == null || string.length() <= 0) continue;
                        vector.add(string);
                    }
                    return vector;
                }

                public HashSet getBackupOnlyMembers() {
                    HashSet hashSet = new HashSet();
                    for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                        Iterator iterator = ((Vector)this.getValueAt(i2, 1)).iterator();
                        while (iterator.hasNext()) {
                            hashSet.add(iterator.next());
                        }
                    }
                    Iterator iterator = this.getOwnerMembers().iterator();
                    while (iterator.hasNext()) {
                        hashSet.remove(iterator.next());
                    }
                    return hashSet;
                }
            }

            public class MemberCellEditor
            extends DefaultCellEditor {
                public JComboBox combo;

                public MemberCellEditor(JComboBox jComboBox, JTable jTable) {
                    super(jComboBox);
                    this.combo = jComboBox;
                    jComboBox.setFont(jTable.getFont());
                    this.setClickCountToStart(2);
                }

                public boolean isCellEditable(EventObject eventObject) {
                    boolean bl2 = super.isCellEditable(eventObject);
                    if (bl2) {
                        this.updateCellEditorValues();
                    }
                    return bl2;
                }

                public void updateCellEditorValues() {
                    int n2 = BackupMembersPanel.this.table.getSelectedRow();
                    if (n2 != -1) {
                        BackupMembersPanel.this.mi_lastProcesedMember = BackupMembersPanel.this.tableModel.getValueAt(n2, 0);
                        BackupMembersPanel.this.mi_selectedMembers.remove(BackupMembersPanel.this.mi_lastProcesedMember);
                    }
                    Vector vector = (Vector)GroupFailOverPanel.this.m_allGroupMembers.clone();
                    Iterator iterator = BackupMembersPanel.this.mi_selectedMembers.iterator();
                    while (iterator.hasNext()) {
                        vector.remove(iterator.next());
                    }
                    this.combo.setModel(new DefaultComboBoxModel(vector));
                }
            }

            public class BackupCellEditor
            extends DefaultCellEditor {
                public JButton button;
                public Vector availableBackups;
                public Vector selectedBackups;
                public BackupMembersDialog backupDialog;

                public BackupCellEditor() {
                    super(new JCheckBox());
                    this.button = new JButton();
                    this.editorComponent = this.button;
                    this.button.setBackground(BackupMembersPanel.this.table.getBackground());
                    this.button.setFocusPainted(false);
                    this.button.setFont(BackupMembersPanel.this.table.getFont());
                    this.button.setHorizontalAlignment(2);
                    this.button.setBorderPainted(false);
                    this.button.setMargin(new Insets(0, 0, 0, 0));
                    this.button.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n2 = BackupMembersPanel.this.table.getSelectedRow();
                            if (n2 == -1) {
                                return;
                            }
                            if (BackupMembersPanel.this.tableModel.getValueAt(n2, 0) == null || ((String)BackupMembersPanel.this.tableModel.getValueAt(n2, 0)).length() <= 0) {
                                return;
                            }
                            BackupCellEditor.this.availableBackups = (Vector)GroupFailOverPanel.this.m_allGroupMembers.clone();
                            BackupCellEditor.this.selectedBackups = (Vector)BackupMembersPanel.this.table.getModel().getValueAt(n2, 1);
                            BackupCellEditor.this.availableBackups.remove(BackupMembersPanel.this.tableModel.getValueAt(n2, 0));
                            Iterator iterator = BackupCellEditor.this.selectedBackups.iterator();
                            while (iterator.hasNext()) {
                                BackupCellEditor.this.availableBackups.remove(iterator.next());
                            }
                            GroupFailOverPanel.this.m_backupMembersDialog.setTitle("Define backup members for <" + BackupMembersPanel.this.tableModel.getValueAt(n2, 0) + ">");
                            GroupFailOverPanel.this.m_backupMembersDialog.setCellEditor(BackupCellEditor.this);
                            GroupFailOverPanel.this.m_backupMembersDialog.setListModels(BackupCellEditor.this.availableBackups, BackupCellEditor.this.selectedBackups);
                            GroupFailOverPanel.this.m_backupMembersDialog.show();
                            BackupCellEditor.this.fireEditingStopped();
                        }
                    });
                }

                public Object getCellEditorValue() {
                    Vector vector = new Vector();
                    if (this.selectedBackups != null) {
                        vector = (Vector)this.selectedBackups.clone();
                        this.selectedBackups.clear();
                    }
                    return vector;
                }

                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
                    ((JButton)this.editorComponent).setText(object.toString());
                    return this.editorComponent;
                }

                public void setResult(Vector vector) {
                    this.selectedBackups = vector;
                }
            }
        }

        private class BackupOnlyPanel
        extends JPanel
        implements ISetPanel {
            public CustomTableModel tableModel;
            public JTable table;
            public JPanel panTable;

            public BackupOnlyPanel(Component component) {
                block2: {
                    this.tableModel = new CustomTableModel();
                    this.table = new JTable(this.tableModel);
                    this.panTable = new JPanel();
                    try {
                        this.init();
                        this.reset();
                    }
                    catch (Exception exception) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block2;
                        _logger.log(Level.SEVERE, exception.toString(), exception);
                    }
                }
            }

            public void init() throws Exception {
                this.table.setAutoscrolls(true);
                this.table.setAutoCreateColumnsFromModel(false);
                this.table.setRowHeight(this.table.getRowHeight() + 4);
                this.table.getColumnModel().getColumn(0).setMaxWidth(60);
                this.table.getColumnModel().getColumn(0).setMinWidth(60);
                this.table.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                this.table.setPreferredScrollableViewportSize(new Dimension(5, 5));
                JScrollPane jScrollPane = new JScrollPane(this.table);
                jScrollPane.setPreferredSize(new Dimension(5, 5));
                this.setLayout(new BorderLayout());
                this.add((Component)jScrollPane, "Center");
            }

            public void reset() {
                this.tableModel.reset();
            }

            public void restoreSettings(Object object) {
                if (object == null) {
                    return;
                }
                this.reset();
                this.updateTable(FailOverPolicyDescriptionPanel.this.mi_backupMembersPanel.tableModel.getBackupOnlyMembers());
                if (this.tableModel.getRowCount() <= 0) {
                    return;
                }
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.tableModel.setEnabledMember(iterator.next(), true);
                }
            }

            public Object saveSettings() {
                Vector<Object> vector = new Vector<Object>();
                for (int i2 = 0; i2 < this.table.getRowCount(); ++i2) {
                    if (!((Boolean)this.table.getValueAt(i2, 0)).booleanValue()) continue;
                    vector.add(this.table.getValueAt(i2, 1));
                }
                return vector;
            }

            public boolean isSelected(Object object) {
                return this.tableModel.isSelected(object);
            }

            public boolean isContains(Object object) {
                return this.tableModel.isContains(object);
            }

            public void addItem(Object object) {
                this.tableModel.addItem(object);
            }

            public void removeItem(Object object) {
                this.tableModel.removeItem(object);
            }

            public void addItems(Vector vector) {
                this.tableModel.addItems(vector);
            }

            public void removeItems(Vector vector) {
                this.tableModel.removeItems(vector);
            }

            public void updateTable(Object object, Object object2) {
                this.tableModel.removeItem(object);
                if (object2 != null && ((String)object2).length() > 0 && !this.tableModel.isContains(object2)) {
                    this.tableModel.addItem(object2);
                }
            }

            public void updateTable(HashSet hashSet) {
                for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
                    if (hashSet.contains(this.tableModel.getValueAt(i2, 1))) continue;
                    this.tableModel.removeRow(i2);
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (this.tableModel.isContains(e2)) continue;
                    this.tableModel.addItem(e2);
                }
            }

            public class CustomTableModel
            extends DefaultTableModel {
                public final String[] COLUMN_LABELS = new String[]{"Enabled", "Member Name"};

                public CustomTableModel() {
                    for (int i2 = 0; i2 < this.COLUMN_LABELS.length; ++i2) {
                        this.addColumn(this.COLUMN_LABELS[i2]);
                    }
                }

                public void reset() {
                    this.dataVector = new Vector();
                    this.fireTableDataChanged();
                }

                public Class getColumnClass(int n2) {
                    Vector vector = (Vector)this.dataVector.elementAt(0);
                    return vector.elementAt(n2).getClass();
                }

                public boolean isCellEditable(int n2, int n3) {
                    return n3 == 0;
                }

                public boolean isContains(Object object) {
                    Iterator iterator = this.dataVector.iterator();
                    while (iterator.hasNext()) {
                        if (!((Vector)iterator.next()).contains(object)) continue;
                        return true;
                    }
                    return false;
                }

                public boolean isSelected(Object object) {
                    Iterator iterator = this.dataVector.iterator();
                    while (iterator.hasNext()) {
                        Vector vector = (Vector)iterator.next();
                        if (!vector.contains(object)) continue;
                        if (!vector.contains(Boolean.TRUE)) break;
                        return true;
                    }
                    return false;
                }

                public void removeItem(Object object) {
                    Iterator iterator = this.dataVector.iterator();
                    while (iterator.hasNext()) {
                        if (!((Vector)iterator.next()).contains(object)) continue;
                        iterator.remove();
                    }
                    this.fireTableDataChanged();
                }

                public void addItem(Object object) {
                    Vector<Object> vector = new Vector<Object>();
                    vector.add(Boolean.FALSE);
                    vector.add(object);
                    this.dataVector.add(vector);
                    this.fireTableDataChanged();
                }

                public void addItems(Vector vector) {
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        this.addItem(iterator.next());
                    }
                }

                public void removeItems(Vector vector) {
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        this.removeItem(iterator.next());
                    }
                }

                public int findMemberRow(Object object) {
                    if (this.getRowCount() > 0) {
                        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                            if (!this.getValueAt(i2, 1).equals(object)) continue;
                            return i2;
                        }
                    }
                    return -1;
                }

                public void setEnabledMember(Object object, boolean bl2) {
                    int n2 = this.findMemberRow(object);
                    if (n2 != -1) {
                        this.setValueAt(new Boolean(bl2), n2, 0);
                    }
                }
            }
        }
    }

    private static class BackupMembersDialog
    extends JDialog {
        public FailOverPolicyDescriptionPanel.BackupMembersPanel.BackupCellEditor cellEditor;
        public JPanel panCenter;
        public JButton butOK;
        public JButton butCancel;
        public TwoSelectionListPanel panSelectBackup;

        public BackupMembersDialog(JFrame jFrame) {
            block2: {
                super((Frame)jFrame, true);
                this.panCenter = new JPanel();
                this.butOK = new JButton("OK");
                this.butCancel = new JButton("Cancel");
                try {
                    this.panSelectBackup = new TwoSelectionListPanel(true, null);
                    this.butOK.setMnemonic(79);
                    this.butOK.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            BackupMembersDialog.this.cellEditor.setResult((Vector)BackupMembersDialog.this.panSelectBackup.saveSettings());
                            BackupMembersDialog.this.dispose();
                        }
                    });
                    this.butCancel.setMnemonic(67);
                    this.butCancel.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            BackupMembersDialog.this.dispose();
                        }
                    });
                    JPanel jPanel = new JPanel();
                    jPanel.add((Component)this.butOK, null);
                    jPanel.add((Component)this.butCancel, null);
                    JPanel jPanel2 = (JPanel)this.getContentPane();
                    jPanel2.setLayout(new BorderLayout());
                    jPanel2.add((Component)this.panSelectBackup, "Center");
                    jPanel2.add((Component)jPanel, "South");
                    this.setSize(400, 250);
                    JSpaceUtilities.setLocationRelativeTo(this, jFrame);
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }

        public void setCellEditor(FailOverPolicyDescriptionPanel.BackupMembersPanel.BackupCellEditor backupCellEditor) {
            this.cellEditor = backupCellEditor;
        }

        public void setListModels(Vector vector, Vector vector2) {
            this.panSelectBackup.setListModels(vector, vector2, null);
        }

        public void reset() {
            this.panSelectBackup.reset();
            this.butOK.setEnabled(false);
        }
    }
}

