/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.CreateGroups;
import com.j_spaces.tools.cluster.DescEventListener;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.NewCluster;
import com.j_spaces.tools.cluster.ResourcesInfo;
import com.j_spaces.tools.cluster.ViewFileDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ReportErrors
extends JPanel {
    public JPanel optionPanel = new JPanel();
    public JLabel groupNameLabel = new JLabel();
    public JPanel buttonPanel = new JPanel();
    public JPanel editButtonPanel = new JPanel();
    public JButton viewErrorButton = new JButton();
    public JButton viewFileButton = new JButton();
    public Document rootDoc;
    public CreateGroups m_createGroupDialog;
    public ViewFileDialog viewFileDialog;
    public JTree reportTree;
    public DefaultMutableTreeNode m_rootNode;
    public Hashtable groupNodeTable = new Hashtable();
    public Hashtable groupInfoTable = new Hashtable();
    public ByteArrayOutputStream byteArray;
    public byte[] previousByteArray;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public ReportErrors(CreateGroups createGroups) {
        this.m_createGroupDialog = createGroups;
        this.viewFileDialog = new ViewFileDialog(this.m_createGroupDialog.m_createMemDialog.m_newCluster);
        this.jbInit();
    }

    public NewCluster getOwnerDialog() {
        return this.m_createGroupDialog.m_createMemDialog.m_newCluster;
    }

    public void jbInit() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/viewFile.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/viewError.gif"));
        this.reportTree = new JTree(new DefaultMutableTreeNode("root"));
        this.reportTree.setRootVisible(false);
        this.reportTree.setCellRenderer(new TreeRenderer());
        this.reportTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.reportTree.getModel();
        this.m_rootNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        String[] stringArray = ResourcesInfo.reportError.getLabels();
        this.optionPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), stringArray[0]), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        this.groupNameLabel.setText(stringArray[1]);
        String[] stringArray2 = ResourcesInfo.reportError.getButtons();
        this.viewErrorButton.setText(stringArray2[0]);
        this.viewFileButton.setText(stringArray2[1] + "    ");
        String[] stringArray3 = ResourcesInfo.reportError.getToolTips();
        JLabel jLabel = this.m_createGroupDialog.m_createMemDialog.m_newCluster.stepDescLabel;
        this.reportTree.addMouseListener(new DescEventListener(jLabel, stringArray3[0]));
        this.viewErrorButton.addMouseListener(new DescEventListener(jLabel, stringArray3[1]));
        this.viewFileButton.addMouseListener(new DescEventListener(jLabel, stringArray3[2]));
        this.setLayout(new BorderLayout());
        this.optionPanel.setLayout(new BorderLayout());
        this.viewErrorButton.setRequestFocusEnabled(false);
        this.viewErrorButton.setIcon(imageIcon2);
        this.viewFileButton.setIcon(imageIcon);
        this.buttonPanel.setLayout(new BorderLayout());
        this.editButtonPanel.setLayout(new VerticalFlowLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.viewFileButton.setRequestFocusEnabled(false);
        this.viewErrorButton.setEnabled(false);
        this.add((Component)this.optionPanel, "Center");
        this.optionPanel.add((Component)this.groupNameLabel, "North");
        this.optionPanel.add((Component)new JScrollPane(this.reportTree), "Center");
        this.optionPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.add((Component)this.editButtonPanel, "North");
        this.editButtonPanel.add((Component)this.viewErrorButton, null);
        this.editButtonPanel.add((Component)this.viewFileButton, null);
        this.viewFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportErrors.this.viewFileDialog.show();
            }
        });
        this.viewErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportErrors.this.viewGroupError(null);
            }
        });
        this.reportTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (treePath = ReportErrors.this.reportTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath != null) {
                    Object object = treePath.getPath()[treePath.getPath().length - 1];
                    if (object instanceof GroupErrorNode) {
                        ReportErrors.this.viewErrorButton.setEnabled(true);
                    } else {
                        ReportErrors.this.viewErrorButton.setEnabled(false);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath;
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && (treePath = ReportErrors.this.reportTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath != null && (object = treePath.getPath()[treePath.getPath().length - 1]) instanceof GroupErrorNode) {
                    ReportErrors.this.viewGroupError((GroupErrorNode)object);
                }
            }
        });
    }

    private Node createTextNode(String string, String string2) {
        Element element = this.rootDoc.createElement(string);
        Text text = this.rootDoc.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    private ClusterMemberInfo[] createClusterMembers(Document document, Element element) {
        Element element2 = null;
        int n2 = this.m_createGroupDialog.m_createMemDialog.getMemberListModel().size();
        Object[] objectArray = new ClusterMemberInfo[n2];
        this.m_createGroupDialog.m_createMemDialog.getMemberListModel().copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = ((ClusterMemberInfo)objectArray[i2]).memberURL.getURL();
            String string2 = JSpaceUtilities.handleInvalidChars(string);
            element2 = document.createElement("member");
            element2.appendChild(this.createTextNode("member-name", ((ClusterMemberInfo)objectArray[i2]).memberName));
            element2.appendChild(this.createTextNode("member-url", string2));
            if (((ClusterMemberInfo)objectArray[i2]).paramData != null) {
                for (int i3 = 0; i3 < ((ClusterMemberInfo)objectArray[i2]).paramData.size(); ++i3) {
                    Element element3 = document.createElement("param");
                    String string3 = (String)((Vector)((ClusterMemberInfo)objectArray[i2]).paramData.get(i3)).get(0);
                    String string4 = (String)((Vector)((ClusterMemberInfo)objectArray[i2]).paramData.get(i3)).get(1);
                    element3.appendChild(this.createTextNode("param-name", string3));
                    element3.appendChild(this.createTextNode("param-value", string4));
                    element2.appendChild(element3);
                }
            }
            element.appendChild(element2);
        }
        if (element2 != null) {
            element.appendChild(element2);
        }
        return objectArray;
    }

    private void addFailOverPolicy(ClusterMemberInfo[] clusterMemberInfoArray, Document document, Element element, String string, FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription) throws Exception {
        String string2;
        Element element2;
        Element element3 = document.createElement(string);
        element.appendChild(element3);
        String string3 = ClusterXML.FAIL_OVER_POLICIES[failOverPolicyDescription.m_PolicyType];
        element3.appendChild(this.createTextNode("policy-type", string3));
        element3.appendChild(this.createTextNode("disable-alternate-group", String.valueOf(failOverPolicyDescription.m_DisableAlternateGroups)));
        if (failOverPolicyDescription.m_BackupMemberNames != null && !failOverPolicyDescription.m_BackupMemberNames.isEmpty()) {
            element2 = document.createElement("backup-members");
            element3.appendChild(element2);
            Iterator iterator = failOverPolicyDescription.m_BackupMemberNames.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                List list = (List)failOverPolicyDescription.m_BackupMemberNames.get(string2);
                Element element4 = document.createElement("member");
                element2.appendChild(element4);
                element4.appendChild(this.createTextNode("source-member", string2));
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string4 = (String)list.get(i2);
                    element4.appendChild(this.createTextNode("backup-member", string4));
                }
            }
        }
        if (failOverPolicyDescription.m_BackupOnly != null && !failOverPolicyDescription.m_BackupOnly.isEmpty()) {
            element2 = document.createElement("backup-members-only");
            element3.appendChild(element2);
            for (int i3 = 0; i3 < failOverPolicyDescription.m_BackupOnly.size(); ++i3) {
                string2 = (String)failOverPolicyDescription.m_BackupOnly.get(i3);
                element2.appendChild(this.createTextNode("backup-member-only", string2));
            }
        }
    }

    private void addLoadBalPolicy(ClusterMemberInfo[] clusterMemberInfoArray, Document document, Element element, String string, GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription loadBalancingPolicyDescription) {
        Element element2 = document.createElement(string);
        element.appendChild(element2);
        element2.appendChild(this.createTextNode("policy-type", loadBalancingPolicyDescription.m_PolicyType));
        element2.appendChild(this.createTextNode("broadcast-condition", loadBalancingPolicyDescription.getBroadcastCondition()));
        if (loadBalancingPolicyDescription.m_paramTable != null) {
            for (int i2 = 0; i2 < loadBalancingPolicyDescription.m_paramTable.size(); ++i2) {
                Vector vector = (Vector)loadBalancingPolicyDescription.m_paramTable.get(i2);
                String string2 = (String)vector.get(0);
                String string3 = (String)vector.get(1);
                if (!this.containsInMembers(clusterMemberInfoArray, string2)) {
                    if (!_logger.isLoggable(Level.INFO)) continue;
                    _logger.info("Param name : " + string2 + " of loadbalancing ignored... Because this member: " + string2 + " not found...");
                    continue;
                }
                Element element3 = document.createElement("param");
                element2.appendChild(element3);
                element3.appendChild(this.createTextNode("param-name", string2));
                element3.appendChild(this.createTextNode("param-value", string3));
            }
        }
    }

    private void removeNotExistMembersFromGroup(GroupInfo groupInfo, ClusterMemberInfo[] clusterMemberInfoArray) {
        Object object;
        int n2;
        HashSet<String> hashSet = new HashSet<String>();
        for (n2 = 0; n2 < groupInfo.groupMembers.length; ++n2) {
            object = groupInfo.groupMembers[n2];
            if (object == null || this.contains(clusterMemberInfoArray, object)) continue;
            hashSet.add(groupInfo.groupMembers[n2].memberName);
            groupInfo.groupMembers[n2] = null;
        }
        for (n2 = 0; n2 < clusterMemberInfoArray.length; ++n2) {
            object = clusterMemberInfoArray[n2];
            if (object == null || this.contains(groupInfo.groupMembers, object)) continue;
            hashSet.add(clusterMemberInfoArray[n2].memberName);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        if (groupInfo.failOverInfo != null) {
            List list = groupInfo.failOverInfo.failOverGroupMembersNames;
            if (list != null && !list.isEmpty()) {
                object = hashSet.iterator();
                while (object.hasNext()) {
                    list.remove(object.next());
                }
            }
            object = new Vector();
            ((Vector)object).add(groupInfo.failOverInfo.m_DefaultFOPolicy);
            ((Vector)object).add(groupInfo.failOverInfo.m_WriteFOPolicy);
            ((Vector)object).add(groupInfo.failOverInfo.m_ReadFOPolicy);
            ((Vector)object).add(groupInfo.failOverInfo.m_TakeFOPolicy);
            ((Vector)object).add(groupInfo.failOverInfo.m_NotifyFOPolicy);
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                Iterator<Object> iterator2;
                FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = (FailOverPolicy.FailOverPolicyDescription)iterator.next();
                if (failOverPolicyDescription == null) continue;
                if (failOverPolicyDescription.m_BackupMemberNames != null && !failOverPolicyDescription.m_BackupMemberNames.isEmpty()) {
                    iterator2 = failOverPolicyDescription.m_BackupMemberNames.keySet().iterator();
                    while (iterator2.hasNext()) {
                        Object object2 = iterator2.next();
                        if (hashSet.contains(object2)) {
                            iterator2.remove();
                            continue;
                        }
                        List list2 = (List)failOverPolicyDescription.m_BackupMemberNames.get(object2);
                        Iterator iterator3 = hashSet.iterator();
                        while (iterator3.hasNext()) {
                            list2.remove(iterator3.next());
                        }
                        if (!list2.isEmpty()) continue;
                        iterator2.remove();
                    }
                }
                if (failOverPolicyDescription.m_BackupOnly == null || failOverPolicyDescription.m_BackupOnly.isEmpty()) continue;
                iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    failOverPolicyDescription.m_BackupOnly.remove(iterator2.next());
                }
            }
        }
    }

    private GroupInfo[] createGroups(ClusterMemberInfo[] clusterMemberInfoArray, Document document, Element element) throws Exception {
        Object[] objectArray = new GroupInfo[this.m_createGroupDialog.getGroupModel().size()];
        this.m_createGroupDialog.getGroupModel().copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            this.removeNotExistMembersFromGroup((GroupInfo)objectArray[i2], clusterMemberInfoArray);
            Element element2 = document.createElement("group");
            element.appendChild(element2);
            element2.appendChild(this.createTextNode("group-name", ((GroupInfo)objectArray[i2]).groupName));
            Element element3 = document.createElement("group-members");
            element2.appendChild(element3);
            for (int i3 = 0; i3 < ((GroupInfo)objectArray[i2]).groupMembers.length; ++i3) {
                object4 = document.createElement("member");
                object4.appendChild(this.createTextNode("member-name", ((GroupInfo)objectArray[i2]).groupMembers[i3].memberName));
                element3.appendChild((Node)object4);
                if (((GroupInfo)objectArray[i2]).groupMembers[i3].m_replTransmissionPolicies != null) {
                    for (int i4 = 0; i4 < ((GroupInfo)objectArray[i2]).groupMembers[i3].m_replTransmissionPolicies.size(); ++i4) {
                        object3 = "";
                        object2 = (ReplicationTransmissionPolicy)((GroupInfo)objectArray[i2]).groupMembers[i3].m_replTransmissionPolicies.get(i4);
                        if (object2 == null) continue;
                        object = ((ReplicationTransmissionPolicy)object2).m_RepTransmissionOperations;
                        block12: for (int i5 = 0; i5 < ((String)object).length(); ++i5) {
                            switch (((String)object).charAt(i5)) {
                                case 'W': {
                                    object3 = (String)object3 + "write, ";
                                    continue block12;
                                }
                                case 'T': {
                                    object3 = (String)object3 + "take, ";
                                    continue block12;
                                }
                                case 'N': {
                                    object3 = (String)object3 + "notify, ";
                                }
                            }
                        }
                        object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(","));
                        Element element4 = document.createElement("repl-transmission-policy");
                        element4.appendChild(this.createTextNode("disable-transmission", String.valueOf(((ReplicationTransmissionPolicy)object2).m_DisableTransmission)));
                        element4.appendChild(this.createTextNode("target-member", ((ReplicationTransmissionPolicy)object2).m_TargetSpace));
                        element4.appendChild(this.createTextNode("transmission-operations", (String)object3));
                        element4.appendChild(this.createTextNode("sync-on-commit", String.valueOf(((ReplicationTransmissionPolicy)object2).m_SyncOnCommit)));
                        String string = ClusterXML.calculateReplicationMode(((ReplicationTransmissionPolicy)object2).isSyncReplication(), ((ReplicationTransmissionPolicy)object2).isOneWayReplication());
                        element4.appendChild(this.createTextNode("replication-mode", string));
                        String string2 = ((ReplicationTransmissionPolicy)object2).getCommunicationMode();
                        element4.appendChild(this.createTextNode("communication-mode", string2));
                        object4.appendChild(element4);
                    }
                }
                if (((GroupInfo)objectArray[i2]).groupMembers[i3].m_replFilters != null) {
                    ClusterMemberInfo.ReplFilters replFilters = ((GroupInfo)objectArray[i2]).groupMembers[i3].m_replFilters;
                    object3 = document.createElement("repl-filters");
                    if (replFilters.inputReplicationFilterClassName != null) {
                        object3.appendChild(this.createTextNode("input-filter-className", replFilters.inputReplicationFilterClassName));
                        if (replFilters.inputReplicationFilterParamUrl != null) {
                            object3.appendChild(this.createTextNode("input-filter-paramUrl", replFilters.inputReplicationFilterParamUrl));
                        }
                    }
                    if (replFilters.outputReplicationFilterClassName != null) {
                        object3.appendChild(this.createTextNode("output-filter-className", replFilters.outputReplicationFilterClassName));
                        if (replFilters.outputReplicationFilterParamUrl != null) {
                            object3.appendChild(this.createTextNode("output-filter-paramUrl", replFilters.outputReplicationFilterParamUrl));
                        }
                    }
                    object4.appendChild((Node)object3);
                }
                if (((GroupInfo)objectArray[i2]).groupMembers[i3].m_replRecovery == null || !(!((GroupInfo)objectArray[i2]).repInfo.m_MemoryRecovery && ((GroupInfo)objectArray[i2]).groupMembers[i3].m_replRecovery.recoveryEnabled || ((GroupInfo)objectArray[i2]).repInfo.m_MemoryRecovery && !((GroupInfo)objectArray[i2]).groupMembers[i3].m_replRecovery.sourceMemberRecovery.equals("First available member")) && (!((GroupInfo)objectArray[i2]).repInfo.m_MemoryRecovery || ((GroupInfo)objectArray[i2]).groupMembers[i3].m_replRecovery.recoveryEnabled)) continue;
                ClusterMemberInfo.ReplRecovery replRecovery = ((GroupInfo)objectArray[i2]).groupMembers[i3].m_replRecovery;
                object3 = document.createElement("repl-recovery");
                object3.appendChild(this.createTextNode("enabled", String.valueOf(replRecovery.recoveryEnabled)));
                if (replRecovery.sourceMemberRecovery != null) {
                    object3.appendChild(this.createTextNode("source-member-name", replRecovery.sourceMemberRecovery));
                }
                object4.appendChild((Node)object3);
            }
            if (((GroupInfo)objectArray[i2]).repInfo != null) {
                Element element5 = document.createElement("repl-policy");
                element2.appendChild(element5);
                element5.appendChild(this.createTextNode("replication-mode", ((GroupInfo)objectArray[i2]).repInfo.m_ReplicationMode));
                switch (((GroupInfo)objectArray[i2]).repInfo.m_PolicyType) {
                    case 0: {
                        object4 = "full-replication";
                        break;
                    }
                    case 1: {
                        object4 = "partial-replication";
                        break;
                    }
                    default: {
                        object4 = "full-replication";
                    }
                }
                element5.appendChild(this.createTextNode("policy-type", (String)object4));
                element5.appendChild(this.createTextNode("recovery", new Boolean(((GroupInfo)objectArray[i2]).repInfo.m_MemoryRecovery).toString()));
                element5.appendChild(this.createTextNode("replicate-notify-templates", new Boolean(((GroupInfo)objectArray[i2]).repInfo.m_ReplicateNotifyTemplates).toString()));
                element5.appendChild(this.createTextNode("trigger-notify-templates", new Boolean(((GroupInfo)objectArray[i2]).repInfo.m_TriggerNotifyTemplates).toString()));
                element5.appendChild(this.createTextNode("repl-find-timeout", ((GroupInfo)objectArray[i2]).repInfo.m_SpaceFinderTimeout));
                element5.appendChild(this.createTextNode("repl-find-report-interval", ((GroupInfo)objectArray[i2]).repInfo.m_ReplFindReportInterval));
                element5.appendChild(this.createTextNode("repl-original-state", new Boolean(((GroupInfo)objectArray[i2]).repInfo.m_ReplicateOriginalState).toString()));
                element5.appendChild(this.createTextNode("communication-mode", ((GroupInfo)objectArray[i2]).repInfo.m_CommunicationMode.toLowerCase()));
                element5.appendChild(this.createTextNode("redo-log-capacity", ((GroupInfo)objectArray[i2]).repInfo.m_RedoLogCapacity));
                element5.appendChild(this.createTextNode("recovery-chunk-size", ((GroupInfo)objectArray[i2]).repInfo.m_RecoveryChunkSize));
                Element element6 = document.createElement("async-replication");
                element6.appendChild(this.createTextNode("sync-on-commit", new Boolean(((GroupInfo)objectArray[i2]).repInfo.m_SyncOnCommit).toString()));
                element6.appendChild(this.createTextNode("sync-on-commit-timeout", ((GroupInfo)objectArray[i2]).repInfo.m_SyncOnCommitTimeOut));
                element6.appendChild(this.createTextNode("repl-chunk-size", ((GroupInfo)objectArray[i2]).repInfo.m_ReplicationChunkSize));
                element6.appendChild(this.createTextNode("repl-interval-millis", ((GroupInfo)objectArray[i2]).repInfo.m_ReplicationIntervalMillis));
                element6.appendChild(this.createTextNode("repl-interval-opers", ((GroupInfo)objectArray[i2]).repInfo.m_ReplicationIntervalOperations));
                element5.appendChild(element6);
                object3 = document.createElement("sync-replication");
                object3.appendChild(this.createTextNode("todo-queue-timeout", ((GroupInfo)objectArray[i2]).repInfo.m_TodoQueueTimeout));
                object3.appendChild(this.createTextNode("hold-txn-lock", ClusterXML.HOLD_TXN_LOCK_DEFAULT_VALUE));
                object2 = document.createElement("unicast");
                object2.appendChild(this.createTextNode("min-work-threads", ((GroupInfo)objectArray[i2]).repInfo.m_MinUnicastWorkingThreads));
                object2.appendChild(this.createTextNode("max-work-threads", ((GroupInfo)objectArray[i2]).repInfo.m_MaxUnicastWorkingThreads));
                object3.appendChild((Node)object2);
                object = document.createElement("multicast");
                object.appendChild(this.createTextNode("ip-group", ((GroupInfo)objectArray[i2]).repInfo.m_IpGroup));
                object.appendChild(this.createTextNode("port", ((GroupInfo)objectArray[i2]).repInfo.m_Port));
                object.appendChild(this.createTextNode("ttl", ((GroupInfo)objectArray[i2]).repInfo.m_TTL));
                object.appendChild(this.createTextNode("min-work-threads", ((GroupInfo)objectArray[i2]).repInfo.m_MinMulticastWorkingThreads));
                object.appendChild(this.createTextNode("max-work-threads", ((GroupInfo)objectArray[i2]).repInfo.m_MaxMulticastWorkingThreads));
                object3.appendChild((Node)object);
                element5.appendChild((Node)object3);
            }
            if (((GroupInfo)objectArray[i2]).loadBalInfo != null) {
                Element element7 = document.createElement("load-bal-policy");
                element2.appendChild(element7);
                element7.appendChild(this.createTextNode("load-bal-impl-class", ((GroupInfo)objectArray[i2]).loadBalInfo.m_ImplementationClassName));
                element7.appendChild(this.createTextNode("apply-ownership", String.valueOf(((GroupInfo)objectArray[i2]).loadBalInfo.isApplyOwnership())));
                element7.appendChild(this.createTextNode("disable-parallel-scattering", String.valueOf(((GroupInfo)objectArray[i2]).loadBalInfo.isDisableParallelScattering())));
                int n2 = ((GroupInfo)objectArray[i2]).loadBalInfo.getProxyBroadcatThreadpoolMinSize();
                String string = n2 <= 0 ? ClusterXML.PROXY_BROADCAST_THREADPOOL_MIN_SIZE_DEFAULT_VALUE : String.valueOf(n2);
                int n3 = ((GroupInfo)objectArray[i2]).loadBalInfo.getProxyBroadcatThreadpoolMaxSize();
                object2 = n3 <= 0 ? ClusterXML.PROXY_BROADCAST_THREADPOOL_MAX_SIZE_DEFAULT_VALUE : String.valueOf(n3);
                element7.appendChild(this.createTextNode("proxy-broadcast-threadpool-min-size", string));
                element7.appendChild(this.createTextNode("proxy-broadcast-threadpool-max-size", (String)object2));
                if (((GroupInfo)objectArray[i2]).loadBalInfo.m_WriteOperationsPolicy != null) {
                    this.addLoadBalPolicy(clusterMemberInfoArray, document, element7, "write", ((GroupInfo)objectArray[i2]).loadBalInfo.m_WriteOperationsPolicy);
                }
                if (((GroupInfo)objectArray[i2]).loadBalInfo.m_ReadOperationsPolicy != null) {
                    this.addLoadBalPolicy(clusterMemberInfoArray, document, element7, "read", ((GroupInfo)objectArray[i2]).loadBalInfo.m_ReadOperationsPolicy);
                }
                if (((GroupInfo)objectArray[i2]).loadBalInfo.m_TakeOperationsPolicy != null) {
                    this.addLoadBalPolicy(clusterMemberInfoArray, document, element7, "take", ((GroupInfo)objectArray[i2]).loadBalInfo.m_TakeOperationsPolicy);
                }
                if (((GroupInfo)objectArray[i2]).loadBalInfo.m_NotifyOperationsPolicy != null) {
                    this.addLoadBalPolicy(clusterMemberInfoArray, document, element7, "notify", ((GroupInfo)objectArray[i2]).loadBalInfo.m_NotifyOperationsPolicy);
                }
                if (((GroupInfo)objectArray[i2]).loadBalInfo.m_DefaultPolicy != null) {
                    this.addLoadBalPolicy(clusterMemberInfoArray, document, element7, "default", ((GroupInfo)objectArray[i2]).loadBalInfo.m_DefaultPolicy);
                }
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo == null) continue;
            Element element8 = document.createElement("fail-over-policy");
            element2.appendChild(element8);
            element8.appendChild(this.createTextNode("fail-back", String.valueOf(((GroupInfo)objectArray[i2]).failOverInfo.isFailBackEnabled())));
            element8.appendChild(this.createTextNode("fail-over-find-timeout", String.valueOf(((GroupInfo)objectArray[i2]).failOverInfo.spaceFinderTimeout)));
            if (((GroupInfo)objectArray[i2]).failOverInfo.m_WriteFOPolicy != null) {
                this.addFailOverPolicy(clusterMemberInfoArray, document, element8, "write", ((GroupInfo)objectArray[i2]).failOverInfo.m_WriteFOPolicy);
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo.m_ReadFOPolicy != null) {
                this.addFailOverPolicy(clusterMemberInfoArray, document, element8, "read", ((GroupInfo)objectArray[i2]).failOverInfo.m_ReadFOPolicy);
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo.m_TakeFOPolicy != null) {
                this.addFailOverPolicy(clusterMemberInfoArray, document, element8, "take", ((GroupInfo)objectArray[i2]).failOverInfo.m_TakeFOPolicy);
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo.m_NotifyFOPolicy != null) {
                this.addFailOverPolicy(clusterMemberInfoArray, document, element8, "notify", ((GroupInfo)objectArray[i2]).failOverInfo.m_NotifyFOPolicy);
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo.m_DefaultFOPolicy != null) {
                this.addFailOverPolicy(clusterMemberInfoArray, document, element8, "default", ((GroupInfo)objectArray[i2]).failOverInfo.m_DefaultFOPolicy);
            }
            if (((GroupInfo)objectArray[i2]).failOverInfo.alterGroup == null) continue;
            Element element9 = document.createElement("alternate-groups");
            if (((GroupInfo)objectArray[i2]).failOverInfo.alterGroup.length > 0) {
                element8.appendChild(element9);
            }
            for (int i6 = 0; i6 < ((GroupInfo)objectArray[i2]).failOverInfo.alterGroup.length; ++i6) {
                element9.appendChild(this.createTextNode("group", ((GroupInfo)objectArray[i2]).failOverInfo.alterGroup[i6]));
            }
        }
        return objectArray;
    }

    private boolean contains(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null || !objectArray[i2].equals(object)) continue;
            return true;
        }
        return false;
    }

    private boolean containsInMembers(ClusterMemberInfo[] clusterMemberInfoArray, String string) {
        for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
            if (clusterMemberInfoArray[i2] == null || !clusterMemberInfoArray[i2].memberName.equals(string)) continue;
            return true;
        }
        return false;
    }

    private int trimNull(Object[] objectArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            ++n2;
        }
        return n2;
    }

    private boolean verifyGroupSyntax(GroupInfo[] groupInfoArray) {
        Object object;
        int n2;
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = new ClusterMemberInfo[this.m_createGroupDialog.m_createMemDialog.getMemberListModel().size()];
        this.m_createGroupDialog.m_createMemDialog.getMemberListModel().copyInto(objectArray);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.reportTree.getModel();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            for (int i2 = 0; i2 < groupInfoArray.length; ++i2) {
                if (!this.contains(groupInfoArray[i2].groupMembers, objectArray[n2])) continue;
                GroupInfoMemo groupInfoMemo = (GroupInfoMemo)this.groupInfoTable.get(((ClusterMemberInfo)objectArray[n2]).memberName);
                GroupReportNode groupReportNode = (GroupReportNode)this.groupNodeTable.get(groupInfoArray[i2].groupName);
                if (groupReportNode == null) {
                    groupReportNode = new GroupReportNode(groupInfoArray[i2].groupName, null);
                    this.groupNodeTable.put(groupInfoArray[i2].groupName, groupReportNode);
                    defaultTreeModel.insertNodeInto(groupReportNode, this.m_rootNode, this.m_rootNode.getChildCount());
                }
                if (!(groupInfoArray[i2].loadBalInfo == null || hashSet.contains(groupInfoArray[i2].groupName) || groupInfoArray[i2].loadBalInfo.m_DefaultPolicy != null || groupInfoArray[i2].loadBalInfo.m_WriteOperationsPolicy != null && groupInfoArray[i2].loadBalInfo.m_ReadOperationsPolicy != null && groupInfoArray[i2].loadBalInfo.m_TakeOperationsPolicy != null && groupInfoArray[i2].loadBalInfo.m_NotifyOperationsPolicy != null)) {
                    object = new GroupErrorNode("Default LoadBalancing policy not defined...", "Default LoadBalancing Policy not defined in group <" + groupInfoArray[i2].groupName + ">.", null);
                    defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                    bl2 = true;
                    hashSet.add(groupInfoArray[i2].groupName);
                }
                if (groupInfoMemo == null) {
                    groupInfoMemo = new GroupInfoMemo(groupInfoArray[i2].groupName, null);
                    groupInfoMemo.replic = groupInfoArray[i2].repInfo != null;
                    groupInfoMemo.loadBalan = groupInfoArray[i2].loadBalInfo != null;
                    groupInfoMemo.failOver = groupInfoArray[i2].failOverInfo != null;
                    this.groupInfoTable.put(((ClusterMemberInfo)objectArray[n2]).memberName, groupInfoMemo);
                    continue;
                }
                if (groupInfoArray[i2].repInfo != null && groupInfoMemo.replic) {
                    object = new GroupErrorNode("Wrong member: " + ((ClusterMemberInfo)objectArray[n2]).memberName + " definition...", "This member: <" + ((ClusterMemberInfo)objectArray[n2]).memberName + "> can be defined only in one Replication group.\nThe member was already defined in <" + groupInfoMemo.groupName + "> Replication group.", null);
                    defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                    bl2 = true;
                }
                if (groupInfoArray[i2].loadBalInfo != null) {
                    if (groupInfoMemo.loadBalan) {
                        object = new GroupErrorNode("Wrong member: " + ((ClusterMemberInfo)objectArray[n2]).memberName + " definition...", "This member: <" + ((ClusterMemberInfo)objectArray[n2]).memberName + "> can be defined only in one LoadBalancing group.\nThe member was already defined in <" + groupInfoMemo.groupName + "> LoadBalancig group.", null);
                        defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                        bl2 = true;
                    }
                    if (groupInfoMemo.failOver) {
                        object = new GroupErrorNode("Wrong member: " + ((ClusterMemberInfo)objectArray[n2]).memberName + " definition...", "This member: <" + ((ClusterMemberInfo)objectArray[n2]).memberName + "> can't be defined in different LoadBalancing and FailOver groups.\nCheck definition of <" + groupInfoMemo.groupName + "> and <" + groupInfoArray[i2].groupName + "> groups.", null);
                        defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                        bl2 = true;
                    }
                }
                if (groupInfoArray[i2].failOverInfo == null) continue;
                if (groupInfoMemo.failOver) {
                    object = new GroupErrorNode("Wrong member: " + ((ClusterMemberInfo)objectArray[n2]).memberName + " definition...", "This member: <" + ((ClusterMemberInfo)objectArray[n2]).memberName + "> can be defined only in one FailOver group.\nThe member was already defined in <" + groupInfoMemo.groupName + "> FailOver group.", null);
                    defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                    bl2 = true;
                }
                if (!groupInfoMemo.loadBalan) continue;
                object = new GroupErrorNode("Wrong member: " + ((ClusterMemberInfo)objectArray[n2]).memberName + " definition...", "This member: <" + ((ClusterMemberInfo)objectArray[n2]).memberName + "> can't be defined in different FailOver and LoadBalancing groups.\nCheck definition of <" + groupInfoMemo.groupName + "> and <" + groupInfoArray[i2].groupName + "> groups.", null);
                defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
                bl2 = true;
            }
        }
        for (n2 = 0; n2 < groupInfoArray.length; ++n2) {
            if (this.trimNull(groupInfoArray[n2].groupMembers) > 1) continue;
            GroupReportNode groupReportNode = (GroupReportNode)this.groupNodeTable.get(groupInfoArray[n2].groupName);
            if (groupReportNode == null) {
                groupReportNode = new GroupReportNode(groupInfoArray[n2].groupName, null);
                defaultTreeModel.insertNodeInto(groupReportNode, this.m_rootNode, this.m_rootNode.getChildCount());
            }
            object = new GroupErrorNode("Missing number of members...", "This group: <" + groupInfoArray[n2].groupName + "> should contain at least 2 members.", null);
            defaultTreeModel.insertNodeInto((MutableTreeNode)object, groupReportNode, groupReportNode.getChildCount());
            bl2 = true;
        }
        for (n2 = 0; n2 < this.m_rootNode.getChildCount(); ++n2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(n2);
            if (defaultMutableTreeNode.getChildCount() <= 0) {
                object = new GroupNormalNode("No Errors.", null);
                defaultTreeModel.insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            object = defaultTreeModel.getPathToRoot(defaultMutableTreeNode);
            TreePath treePath = new TreePath((Object[])object);
            this.reportTree.expandPath(treePath);
        }
        return bl2;
    }

    public boolean validateClusterConfiguration() throws Exception {
        boolean bl2 = false;
        this.groupNodeTable.clear();
        this.groupInfoTable.clear();
        this.m_rootNode.removeAllChildren();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.reportTree.getModel();
        defaultTreeModel.reload();
        this.viewErrorButton.setEnabled(false);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.rootDoc = documentBuilder.newDocument();
        Element element = this.rootDoc.createElement("cluster-config");
        String string = this.m_createGroupDialog.m_createMemDialog.m_newCluster.getClusterName();
        String string2 = this.m_createGroupDialog.m_createMemDialog.m_newCluster.getClusterFilePath();
        this.viewFileDialog.setTitle("XML Preview " + string2);
        Node node = this.createTextNode("cluster-name", string);
        element.appendChild(node);
        Element element2 = this.rootDoc.createElement("dist-cache");
        element2.appendChild(this.createTextNode("config-name", this.m_createGroupDialog.m_createMemDialog.m_newCluster.getDCacheConfigName()));
        element.appendChild(element2);
        Node node2 = this.createTextNode("notify-recovery", ClusterXML.NOTIFY_RECOVERY_DEFAULT_VALUE);
        element.appendChild(node2);
        Element element3 = this.createCacheLoaderTags(this.rootDoc);
        element.appendChild(element3);
        Element element4 = this.createMirrorServiceTags(this.rootDoc);
        element.appendChild(element4);
        Element element5 = this.rootDoc.createElement("cluster-members");
        element.appendChild(element5);
        ClusterMemberInfo[] clusterMemberInfoArray = this.createClusterMembers(this.rootDoc, element5);
        Element element6 = this.rootDoc.createElement("groups");
        element.appendChild(element6);
        GroupInfo[] groupInfoArray = this.createGroups(clusterMemberInfoArray, this.rootDoc, element6);
        bl2 = this.verifyGroupSyntax(groupInfoArray);
        if (this.byteArray != null) {
            this.previousByteArray = this.byteArray.toByteArray();
        }
        this.byteArray = new ByteArrayOutputStream();
        JSpaceUtilities.domWriter(element, new PrintStream(this.byteArray), "");
        this.viewFileDialog.setText(this.byteArray.toString());
        this.byteArray.close();
        return bl2;
    }

    private Element createMirrorServiceTags(Document document) {
        Element element = this.rootDoc.createElement("mirror-service");
        element.appendChild(this.createTextNode("enabled", ClusterXML.MIRROR_SERVICE_ENABLED_DEFAULT_VALUE));
        element.appendChild(this.createTextNode("url", "jini://*/mirror-service_container/mirror-service"));
        element.appendChild(this.createTextNode("bulk-size", ClusterXML.MIRROR_SERVICE_BULK_SIZE_DEFAULT_VALUE));
        element.appendChild(this.createTextNode("interval-millis", ClusterXML.MIRROR_SERVICE_INTERVAL_MILLIS_DEFAULT_VALUE));
        element.appendChild(this.createTextNode("interval-opers", ClusterXML.MIRROR_SERVICE_INTERVAL_OPERS_DEFAULT_VALUE));
        return element;
    }

    private Element createCacheLoaderTags(Document document) {
        Element element = this.rootDoc.createElement("cache-loader");
        element.appendChild(this.createTextNode("external-data-source", "${com.gs.cluster.cache-loader.external-data-source}"));
        element.appendChild(this.createTextNode("central-data-source", "${com.gs.cluster.cache-loader.central-data-source}"));
        return element;
    }

    public boolean createFile(String string) throws IOException {
        if (Arrays.equals(this.previousByteArray, this.byteArray.toByteArray())) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.byteArray.toByteArray());
        fileOutputStream.close();
        this.previousByteArray = this.byteArray.toByteArray();
        return true;
    }

    public void reset() {
        this.previousByteArray = null;
    }

    private void viewGroupError(GroupErrorNode groupErrorNode) {
        if (groupErrorNode == null) {
            TreePath treePath = this.reportTree.getSelectionPath();
            groupErrorNode = (GroupErrorNode)treePath.getPath()[treePath.getPath().length - 1];
        }
        JOptionPane.showConfirmDialog(this, groupErrorNode.getErrorDescription(), "Error", -1, 0, ResourcesInfo.ERROR_ICON);
    }

    public static class TreeRenderer
    extends DefaultTreeCellRenderer {
        public ImageIcon groupIcon;
        public ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/errorTreeSmall.gif"));
        public ImageIcon okIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/ok.gif"));

        public TreeRenderer() {
            this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/groupTree.gif"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            ImageIcon imageIcon = this.getIcon(object);
            this.setIcon(imageIcon);
            return this;
        }

        private ImageIcon getIcon(Object object) {
            ImageIcon imageIcon = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            imageIcon = defaultMutableTreeNode instanceof GroupReportNode ? this.groupIcon : (defaultMutableTreeNode instanceof GroupErrorNode ? this.errorIcon : this.okIcon);
            return imageIcon;
        }
    }

    public static class GroupNormalNode
    extends DefaultMutableTreeNode {
        public String status;

        private GroupNormalNode(String string) {
            super(string);
            this.status = string;
        }

        public String toString() {
            return this.status;
        }

        public /* synthetic */ GroupNormalNode(String string, 1 var2_2) {
            this(string);
        }
    }

    public static class GroupErrorNode
    extends DefaultMutableTreeNode {
        public String error;
        public String descError;

        private GroupErrorNode(String string, String string2) {
            super(string);
            this.error = string;
            this.descError = string2;
        }

        public String toString() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.descError;
        }

        public /* synthetic */ GroupErrorNode(String string, String string2, 1 var3_3) {
            this(string, string2);
        }
    }

    public static class GroupReportNode
    extends DefaultMutableTreeNode {
        public String groupName;

        private GroupReportNode(String string) {
            super(string);
            this.groupName = string;
        }

        public String toString() {
            return this.groupName;
        }

        public /* synthetic */ GroupReportNode(String string, 1 var2_2) {
            this(string);
        }
    }

    public static class GroupInfoMemo {
        public String groupName;
        public boolean failOver = false;
        public boolean loadBalan = false;
        public boolean replic = false;

        private GroupInfoMemo(String string) {
            this.groupName = string;
        }

        public /* synthetic */ GroupInfoMemo(String string, 1 var2_2) {
            this(string);
        }
    }
}

