/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.GraphPanel;
import com.j_spaces.tools.cluster.view.GroupsGraphPanel;
import com.j_spaces.tools.cluster.view.GroupsLegend;
import com.j_spaces.tools.cluster.view.MembersTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;

public class ClusterPanel
extends JPanel {
    private ClusterViewDlg m_owner;
    private GroupInfo[] _curGroupsInfo;
    private ClusterMemberInfo[] m_membersInfo;
    private GroupsGraphPanel m_groupsPanel;
    private MembersTable m_membersTable;
    private JPanel groups;
    private JPanel grPan;
    private JSplitPane splitPan;
    private static ClusterPanel instance;
    private static Logger _logger;

    public ClusterPanel() {
        this.init();
    }

    public static ClusterPanel getInstance() {
        if (instance == null) {
            instance = new ClusterPanel();
        }
        return instance;
    }

    public void setClusterPanel(ClusterViewDlg clusterViewDlg, GroupInfo[] groupInfoArray, ClusterMemberInfo[] clusterMemberInfoArray) {
        block3: {
            try {
                if (this._curGroupsInfo == null || this._curGroupsInfo != groupInfoArray) {
                    this.m_owner = clusterViewDlg;
                    this._curGroupsInfo = groupInfoArray;
                    this.m_membersInfo = clusterMemberInfoArray;
                    this.m_groupsPanel.setGroupsGraphPanel(this, this._curGroupsInfo);
                    this.m_membersTable.setMembers(this.m_membersInfo);
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void clearCurGroupInfo() {
        this._curGroupsInfo = null;
    }

    private void init() {
        this.groups = new JPanel(new BorderLayout());
        this.groups.setBorder(new TitledBorder("Groups"));
        this.grPan = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 150));
        this.m_groupsPanel = GroupsGraphPanel.getInstance();
        this.groups.add((Component)this.m_groupsPanel, "Center");
        this.grPan.add((Component)this.groups, "Center");
        this.grPan.add((Component)new GroupsLegend(), "East");
        this.splitPan = new JSplitPane();
        this.splitPan.setOrientation(0);
        this.splitPan.setOneTouchExpandable(true);
        this.splitPan.setDividerSize(8);
        this.m_membersTable = new MembersTable();
        this.splitPan.add((Component)this.grPan, "left");
        this.splitPan.add((Component)this.m_membersTable, "right");
        this.add((Component)this.splitPan, "Center");
    }

    public GraphPanel getGraphPanel() {
        return this.m_groupsPanel;
    }

    public void setClusterTreeNode(String string) {
        this.m_owner.setClusterTreeNode(string);
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");
    }
}

