/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.Edge;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.Node;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.jini.core.lookup.ServiceID;

public abstract class GraphPanel
extends JComponent
implements Runnable,
MouseListener,
MouseMotionListener,
ActionListener {
    private final String PROPERTY_STEP = "cluster.view.GraphPanel.step";
    public Component parent;
    public int nodeRadius;
    public int nodeDistance;
    public int edgeLength;
    public int graphStep;
    public int nnodes;
    public ArrayList nodesList = new ArrayList(100);
    public Image imgMember;
    public BasicStroke strokeNormal = new BasicStroke(2.0f, 0, 1);
    public BasicStroke strokeDotted = new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{2.0f, 6.0f, 2.0f, 6.0f}, 0.0f);
    public BasicStroke strokeBackward = new BasicStroke(1.0f, 0, 0);
    public int nedges;
    public ArrayList edgesList = new ArrayList(100);
    public Thread relaxer;
    public boolean paused;
    public boolean stress;
    public boolean random;
    public Node pick;
    public Node source;
    public boolean pickfixed;
    public Image offscreen;
    public Dimension offscreensize;
    public Graphics2D offgraphics;
    public final Color fixedColor = Color.red;
    public final Color selectColor = Color.pink;
    public final Color edgeColor = Color.black;
    public final Color nodeColor = new Color(143, 143, 190);
    public final Color stressColor = Color.darkGray;
    public final Color arcColor1 = Color.black;
    public final Color arcColor2 = Color.black;
    public final Color arcColor3 = Color.black;
    public final int rectWidthIncrement = 10;
    public static final int NODE_RADIUS_SMALL = 15;
    public static final int NODE_RADIUS_LARGE = 23;
    public static final int EDGE_LENGTH_SMALL = 80;
    public static final int EDGE_LENGTH_LARGE = 240;
    public static Font FONT_SIZE_SMALL = new Font("Tahoma", 0, 9);
    public static Font FONT_SIZE_LARGE = new Font("Tahoma", 0, 11);
    private Font curFont = FONT_SIZE_LARGE;
    private JPopupMenu spaceManagementPopupMenu;
    private JMenuItem classesMenuItem;
    private JMenuItem transactionsMenuItem;
    private JMenuItem queryMenuItem;
    private JMenuItem statisticsMenuItem;
    private JMenuItem benchmarkMenuItem;
    private JMenuItem usersMenuItem;
    private JMenuItem selMemberNameMenuItem;
    private Node clickedNode;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public GraphPanel() {
        this.addMouseListener(this);
        this.graphStep = Integer.parseInt(System.getProperty("cluster.view.GraphPanel.step", "5"));
        this.initPopupMenu();
    }

    public void setGraphPanel(Component component, int n2, int n3) {
        block3: {
            try {
                this.parent = component;
                this.nodeRadius = n2;
                this.nodeDistance = (int)((double)n2 * 2.4);
                this.edgeLength = n3;
                this.relaxer = new Thread(this);
            }
            catch (NumberFormatException numberFormatException) {
                this.graphStep = 5;
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void setSpaceIDToNode(ServiceID serviceID, String string) {
        Iterator iterator = this.nodesList.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.lbl.equals(string)) continue;
            node.setServiceID(serviceID);
            break;
        }
    }

    public abstract void paintNode(Graphics var1, Node var2, FontMetrics var3);

    public abstract void performNodeAction(Node var1);

    public void increaseZoom() {
        this.nodeRadius = 15;
        this.edgeLength = 240;
        this.curFont = FONT_SIZE_SMALL;
        this.updateEdgeLength(this.edgeLength);
    }

    public void decreaseZoom() {
        this.nodeRadius = 23;
        this.edgeLength = 80;
        this.curFont = FONT_SIZE_LARGE;
        this.updateEdgeLength(this.edgeLength);
    }

    public void reset() {
        this.nnodes = 0;
        this.nodesList = new ArrayList(100);
        this.nedges = 0;
        this.edgesList = new ArrayList(100);
        this.pick = null;
        this.source = null;
        this.spaceManagementPopupMenu.setVisible(false);
    }

    private void updateEdgeLength(int n2) {
        int n3 = this.edgesList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ((Edge)this.edgesList.get((int)i2)).len = n2;
        }
    }

    private void initPopupMenu() {
        this.spaceManagementPopupMenu = new JPopupMenu();
        this.selMemberNameMenuItem = new JMenuItem();
        this.classesMenuItem = new JMenuItem("Classes");
        this.transactionsMenuItem = new JMenuItem("Transactions");
        this.queryMenuItem = new JMenuItem("Query");
        this.statisticsMenuItem = new JMenuItem("Statistics");
        this.benchmarkMenuItem = new JMenuItem("Benchmark");
        this.usersMenuItem = new JMenuItem("Users");
        Font font = this.selMemberNameMenuItem.getFont();
        this.selMemberNameMenuItem.setFont(font.deriveFont(1));
        this.selMemberNameMenuItem.addActionListener(this);
        this.classesMenuItem.addActionListener(this);
        this.transactionsMenuItem.addActionListener(this);
        this.queryMenuItem.addActionListener(this);
        this.statisticsMenuItem.addActionListener(this);
        this.benchmarkMenuItem.addActionListener(this);
        this.usersMenuItem.addActionListener(this);
        this.spaceManagementPopupMenu.add(this.selMemberNameMenuItem);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(this.classesMenuItem);
        this.spaceManagementPopupMenu.add(this.transactionsMenuItem);
        this.spaceManagementPopupMenu.add(this.queryMenuItem);
        this.spaceManagementPopupMenu.add(this.statisticsMenuItem);
        this.spaceManagementPopupMenu.add(this.benchmarkMenuItem);
        this.spaceManagementPopupMenu.add(this.usersMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.classesMenuItem || object == this.queryMenuItem || object == this.statisticsMenuItem || object == this.benchmarkMenuItem || object == this.usersMenuItem) {
            SpaceBrowser.getInstance().selectSpaceOperationNode(this.clickedNode.getServiceID(), ((JMenuItem)object).getText());
        } else if (object == this.selMemberNameMenuItem) {
            SpaceBrowser.getInstance().selectSpaceOperationNode(this.clickedNode.getServiceID(), null);
        }
    }

    private int findNodeByID(String string) {
        for (int i2 = 0; i2 < this.nnodes; ++i2) {
            if (!((Node)this.nodesList.get(i2)).getNodeId().equals(string)) continue;
            return i2;
        }
        String[] stringArray = JSpaceUtilities.resolveClusterGuiId(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        return this.addNode(string4, string2, string3, null, false);
    }

    public int addNode(String string, String string2, String string3, ServiceID serviceID, boolean bl2) {
        double d2 = 30.0 + 300.0 * Math.random();
        double d3 = 30.0 + 200.0 * Math.random();
        Node node = new Node(d2, d3, false, string, string2, string3, serviceID, bl2);
        this.nodesList.add(this.nnodes, node);
        return this.nnodes++;
    }

    public void addEdge(String string, String string2, int n2, boolean bl2, boolean bl3) {
        Edge edge = new Edge();
        edge.from = this.findNodeByID(string);
        edge.to = this.findNodeByID(string2);
        edge.len = n2;
        edge.visible = bl2;
        edge.setStatus(1);
        edge.backwardRepl = bl3;
        this.edgesList.add(this.nedges++, edge);
        this.getNodebyId((String)string2).isTarget = true;
    }

    public synchronized void start() {
        if (!this.relaxer.isAlive()) {
            this.relaxer.start();
        }
        this.paused = false;
        this.notify();
    }

    public void stop() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.relaxer == thread) {
            this.relax();
            try {
                GraphPanel graphPanel = this;
                synchronized (graphPanel) {
                    this.wait(100L);
                }
                if (!this.paused) continue;
                graphPanel = this;
                synchronized (graphPanel) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, interruptedException.toString(), interruptedException);
            }
        }
    }

    public synchronized void relax() {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        for (int i2 = 0; i2 < this.nedges; ++i2) {
            Edge edge = (Edge)this.edgesList.get(i2);
            Node node = (Node)this.nodesList.get(edge.to);
            Node node2 = (Node)this.nodesList.get(edge.from);
            d6 = node.x - node2.x;
            d5 = node.y - node2.y;
            d4 = Math.sqrt(d6 * d6 + d5 * d5);
            d4 = d4 == 0.0 ? 1.0E-4 : d4;
            double d7 = (((Edge)this.edgesList.get((int)i2)).len - d4) / (d4 * 3.0);
            d3 = d7 * d6;
            d2 = d7 * d5;
            node.dx += d3;
            node.dy += d2;
            node2.dx += -d3;
            node2.dy += -d2;
        }
        for (int i3 = 0; i3 < this.nnodes; ++i3) {
            Node node = (Node)this.nodesList.get(i3);
            d3 = 0.0;
            d2 = 0.0;
            for (int i4 = 0; i4 < this.nnodes; ++i4) {
                if (i3 == i4) continue;
                Node node3 = (Node)this.nodesList.get(i4);
                d6 = node.x - node3.x;
                d5 = node.y - node3.y;
                d4 = d6 * d6 + d5 * d5;
                if (d4 == 0.0) {
                    d3 += Math.random();
                    d2 += Math.random();
                    continue;
                }
                if (!(d4 < (double)(this.nodeDistance * this.nodeDistance))) continue;
                d3 += d6 / d4;
                d2 += d5 / d4;
            }
            double d8 = d3 * d3 + d2 * d2;
            if (!(d8 > 0.0)) continue;
            d8 = Math.sqrt(d8) / 2.0;
            node.dx += d3 / d8;
            node.dy += d2 / d8;
        }
        Dimension dimension = this.getSize();
        dimension.height -= this.nodeRadius + 12;
        dimension.width -= this.nodeRadius;
        for (int i5 = 0; i5 < this.nnodes; ++i5) {
            Node node = (Node)this.nodesList.get(i5);
            if (!node.fixed && !ClusterViewMenuBar.FREEZE_ALL_MEMBERS) {
                node.x += Math.max((double)(-this.graphStep), Math.min((double)this.graphStep, node.dx));
                node.y += Math.max((double)(-this.graphStep), Math.min((double)this.graphStep, node.dy));
            }
            if (node.x < 0.0) {
                node.x = 0.0;
            } else if (node.x > (double)dimension.width) {
                node.x = dimension.width;
            }
            if (node.y < 0.0) {
                node.y = 0.0;
            } else if (node.y > (double)dimension.height) {
                node.y = dimension.height;
            }
            node.dx /= 2.0;
            node.dy /= 2.0;
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
            this.offgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.offgraphics.setColor(MembersLegend.getColor("Background"));
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        for (int i2 = 0; i2 < this.nedges; ++i2) {
            Edge edge = (Edge)this.edgesList.get(i2);
            Node node = (Node)this.nodesList.get(edge.from);
            Node node2 = (Node)this.nodesList.get(edge.to);
            int n2 = (int)node.x;
            int n3 = (int)node.y;
            int n4 = (int)node2.x;
            int n5 = (int)node2.y;
            int n6 = (int)Math.abs(Math.sqrt((n2 - n4) * (n2 - n4) + (n3 - n5) * (n3 - n5)) - edge.len);
            if (edge.backwardRepl) {
                this.offgraphics.setColor(Color.black);
                this.offgraphics.setStroke(this.strokeBackward);
            } else {
                this.offgraphics.setColor(MembersLegend.getColor(edge.getStatus()));
                this.offgraphics.setStroke(this.strokeDotted);
            }
            this.offgraphics.drawLine(n2, n3, n4, n5);
        }
        FontMetrics fontMetrics = this.offgraphics.getFontMetrics();
        this.offgraphics.setStroke(this.strokeNormal);
        this.offgraphics.setFont(this.curFont);
        for (int i3 = 0; i3 < this.nnodes; ++i3) {
            this.paintNode(this.offgraphics, (Node)this.nodesList.get(i3), fontMetrics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public Node findNode(MouseEvent mouseEvent) {
        Node node = null;
        double d2 = Double.MAX_VALUE;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        for (int i2 = 0; i2 < this.nnodes; ++i2) {
            Node node2 = (Node)this.nodesList.get(i2);
            double d3 = (node2.x - (double)n2) * (node2.x - (double)n2) + (node2.y - (double)n3) * (node2.y - (double)n3);
            if (!(d3 < d2)) continue;
            node = node2;
            d2 = d3;
        }
        return node;
    }

    public Hashtable findEdges(Node node) {
        Hashtable<String, Edge> hashtable = new Hashtable<String, Edge>();
        int n2 = this.findNodeByID(node.getNodeId());
        for (int i2 = 0; i2 < this.nedges; ++i2) {
            Edge edge = (Edge)this.edgesList.get(i2);
            if (edge == null || edge.from != n2) continue;
            int n3 = edge.to;
            hashtable.put(((Node)this.nodesList.get((int)n3)).lbl, edge);
        }
        return hashtable;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.pick = this.findNode(mouseEvent);
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            this.pickfixed = this.pick.fixed;
            this.pick.x = n2;
            this.pick.y = n3;
            this.repaint();
            mouseEvent.consume();
            this.performNodeAction(this.pick);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.clickedNode = this.getClickedNode(mouseEvent.getX(), mouseEvent.getY());
            if (this.clickedNode != null) {
                this.selMemberNameMenuItem.setText(this.clickedNode.lbl);
                if ((this.clickedNode.status.equals("Alive") || this.clickedNode.status.equals("MirrorAlive")) && this.clickedNode.getServiceID() != null) {
                    this.spaceManagementPopupMenu.show(this, n2, n3);
                }
            }
        } else {
            this.addMouseMotionListener(this);
            double d2 = Double.MAX_VALUE;
            for (int i2 = 0; i2 < this.nnodes; ++i2) {
                Node node = (Node)this.nodesList.get(i2);
                double d3 = (node.x - (double)n2) * (node.x - (double)n2) + (node.y - (double)n3) * (node.y - (double)n3);
                if (!(d3 < d2)) continue;
                this.pick = node;
                d2 = d3;
            }
            this.pickfixed = this.pick.fixed;
            this.pick.fixed = true;
            this.pick.x = n2;
            this.pick.y = n3;
            this.repaint();
            mouseEvent.consume();
        }
    }

    private Node getClickedNode(int n2, int n3) {
        FontMetrics fontMetrics = this.offgraphics.getFontMetrics();
        Iterator iterator = this.nodesList.iterator();
        while (iterator.hasNext()) {
            int n4;
            Node node = (Node)iterator.next();
            if (!(ClusterViewMenuBar.SHOW_OVAL ? (double)n2 <= node.x + (double)(this.nodeRadius / 2) && (double)n2 >= node.x - (double)(this.nodeRadius / 2) && (double)n3 <= node.y + (double)(this.nodeRadius / 2) && (double)n3 >= node.y - (double)(this.nodeRadius / 2) : (double)n2 <= node.x + (double)((n4 = fontMetrics.stringWidth(node.lbl) + 10) / 2) && (double)n2 >= node.x - (double)(n4 / 2) && (double)n3 <= node.y + (double)(this.nodeRadius / 2) && (double)n3 >= node.y - (double)(this.nodeRadius / 2))) continue;
            return node;
        }
        return null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.removeMouseMotionListener(this);
        if (this.pick != null) {
            this.pick.x = mouseEvent.getX();
            this.pick.y = mouseEvent.getY();
            this.pick.fixed = this.pickfixed;
            this.pick = null;
        }
        this.repaint();
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pick != null) {
            this.pick.x = mouseEvent.getX();
            this.pick.y = mouseEvent.getY();
            this.repaint();
            mouseEvent.consume();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Node getNodebyId(String string) {
        return (Node)this.nodesList.get(this.findNodeByID(string));
    }

    public Node getNodeByIndex(int n2) {
        return (Node)this.nodesList.get(n2);
    }
}

