/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.filters;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.ct;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.cluster.ResourcesInfo;
import com.j_spaces.tools.filters.FilterDetailsDialog;
import com.j_spaces.tools.filters.FiltersInfo;
import com.j_spaces.tools.spacebrowser.LoginDialog;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigAdvancedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SortFiltersDialog
extends JDialog {
    public JPanel optionPanel = new JPanel();
    public JLabel filterNameLabel = new JLabel();
    public JPanel buttonPanel = new JPanel();
    public JPanel southPanel = new JPanel();
    public JPanel editButtonPanel = new JPanel();
    public JPanel moveButtonPanel = new JPanel();
    public JButton moveDownButton = new JButton();
    public JButton moveUpButton = new JButton();
    public JButton addButton = new JButton();
    public JButton removeButton = new JButton();
    public JButton editButton = new JButton();
    public JButton renameButton = new JButton();
    public JButton newLikeButton = new JButton();
    public JButton cancelButton = new JButton();
    public JButton enableButton = new JButton();
    public ImageIcon enabledIcon = new ImageIcon();
    public ImageIcon disabledIcon = new ImageIcon();
    public DefaultListModel m_filterModel = new DefaultListModel();
    public JListExt m_filterList = new JListExt(this.m_filterModel, null);
    public SpaceConfigAdvancedPanel m_parentDialog;
    public SpaceBrowser m_spaceBrowser;
    public FilterDetailsDialog m_filterWizardDialog;
    public FilterDetailsDialog m_defaultSecurityDialog;
    private LoginDialog m_loginDialog;
    private GenericPrincipal m_adminAccount;
    private ct m_encrypter;
    private static SortFiltersDialog instance = null;
    private String curContainerName;

    public SortFiltersDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SortFiltersDialog(JFrame jFrame, String string, boolean bl2) {
        super(jFrame, string, bl2);
        this.m_spaceBrowser = SpaceBrowser.getInstance();
        this.m_loginDialog = new LoginDialog("Administrator Login", true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SortFiltersDialog(SpaceConfigAdvancedPanel spaceConfigAdvancedPanel) {
        super(spaceConfigAdvancedPanel.m_spaceBrowser, "Create new Filter", true);
        this.m_parentDialog = spaceConfigAdvancedPanel;
        this.m_loginDialog = new LoginDialog(this, "Administrator Login", true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.m_filterWizardDialog = new FilterDetailsDialog(this);
        this.m_defaultSecurityDialog = new FilterDetailsDialog(this);
        this.m_filterList.setCellRenderer(new FilterRenderer(null));
        this.getContentPane().setLayout(new BorderLayout());
        this.optionPanel.setLayout(new BorderLayout());
        this.addButton.setRequestFocusEnabled(false);
        this.removeButton.setRequestFocusEnabled(false);
        this.editButton.setRequestFocusEnabled(false);
        this.newLikeButton.setRequestFocusEnabled(false);
        this.enableButton.setRequestFocusEnabled(false);
        this.buttonPanel.setLayout(new BorderLayout());
        this.m_filterList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editButtonPanel.setLayout(new VerticalFlowLayout());
        this.moveDownButton.setRequestFocusEnabled(false);
        this.moveUpButton.setRequestFocusEnabled(false);
        this.moveButtonPanel.setLayout(new VerticalFlowLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.renameButton.setRequestFocusEnabled(false);
        this.addButton.setIcon(this.getImage("newGroup.gif"));
        this.newLikeButton.setIcon(this.getImage("newLikeGroup.gif"));
        this.removeButton.setIcon(this.getImage("removeGroup.gif"));
        this.moveUpButton.setIcon(this.getImage("moveUp.gif"));
        this.renameButton.setIcon(this.getImage("renameGroup.gif"));
        this.moveDownButton.setIcon(this.getImage("moveDown.gif"));
        this.editButton.setIcon(this.getImage("editGroup.gif"));
        this.enabledIcon = this.getImage("enabledButton.gif");
        this.disabledIcon = this.getImage("errorTreeSmall.gif");
        this.enableButton.setIcon(this.disabledIcon);
        this.optionPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Filters Configuration"), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        this.filterNameLabel.setText("Filter Names:");
        this.setTitle("Filter Management");
        this.southPanel.setLayout(new BorderLayout());
        this.cancelButton.setText("Close");
        this.southPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        this.getContentPane().add((Component)this.optionPanel, "Center");
        this.optionPanel.add((Component)this.filterNameLabel, "North");
        this.optionPanel.add((Component)new JScrollPane(this.m_filterList), "Center");
        this.optionPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.add((Component)this.editButtonPanel, "North");
        this.editButtonPanel.add((Component)this.addButton, null);
        this.editButtonPanel.add((Component)this.newLikeButton, null);
        this.editButtonPanel.add((Component)this.editButton, null);
        this.editButtonPanel.add((Component)this.renameButton, null);
        this.editButtonPanel.add((Component)this.removeButton, null);
        this.editButtonPanel.add((Component)this.enableButton, null);
        this.buttonPanel.add((Component)this.moveButtonPanel, "South");
        this.moveButtonPanel.add((Component)this.moveUpButton, null);
        this.moveButtonPanel.add((Component)this.moveDownButton, null);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.cancelButton, "East");
        this.addButton.setText("New...");
        this.addButton.setHorizontalAlignment(10);
        this.newLikeButton.setText("New Like...");
        this.newLikeButton.setHorizontalAlignment(10);
        this.editButton.setText("Edit...");
        this.editButton.setHorizontalAlignment(10);
        this.renameButton.setText("Rename...");
        this.renameButton.setHorizontalAlignment(10);
        this.removeButton.setText("Remove");
        this.removeButton.setHorizontalAlignment(10);
        this.moveUpButton.setText("Up Priority");
        this.moveUpButton.setHorizontalAlignment(10);
        this.moveDownButton.setText("Down Priority");
        this.moveDownButton.setHorizontalAlignment(10);
        this.enableButton.setText("Disable");
        this.enableButton.setHorizontalAlignment(10);
        this.m_filterList.setSelectionMode(0);
        this.pack();
        this.setDefaultFilterConfig(null);
        this.moveDownButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.newLikeButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.dispose();
            }
        });
        this.m_filterList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2 = SortFiltersDialog.this.m_filterList.locationToIndex(mouseEvent.getPoint());
                    if (n2 == -1) {
                        return;
                    }
                    SortFiltersDialog.this.editFilter(null);
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.removeFilter();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.editFilter(null);
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.moveDownButton();
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.moveUpButton();
            }
        });
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.renameFilter();
            }
        });
        this.newLikeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.createFilterNewLike();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SortFiltersDialog.this.m_filterWizardDialog.showWizardData(new FiltersInfo(), false);
            }
        });
        this.enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersInfo filtersInfo = (FiltersInfo)SortFiltersDialog.this.m_filterList.getSelectedValue();
                if (filtersInfo.isDefaultSecurityFilter() && !SortFiltersDialog.this.adminAuthentication()) {
                    return;
                }
                if (filtersInfo.enabled) {
                    filtersInfo.enabled = false;
                    SortFiltersDialog.this.enableButton.setText("Enable");
                    SortFiltersDialog.this.enableButton.setIcon(SortFiltersDialog.this.enabledIcon);
                } else {
                    filtersInfo.enabled = true;
                    SortFiltersDialog.this.enableButton.setText("Disable");
                    SortFiltersDialog.this.enableButton.setIcon(SortFiltersDialog.this.disabledIcon);
                }
                if (filtersInfo.filterName.equals("DefaultSecurityFilter")) {
                    SortFiltersDialog.this.m_parentDialog.setUserPermissionEnabled(filtersInfo.enabled);
                }
                SortFiltersDialog.this.m_filterList.repaint();
            }
        });
        this.m_filterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = SortFiltersDialog.this.m_filterList.getAnchorSelectionIndex();
                SortFiltersDialog.this.m_filterList.ensureIndexIsVisible(n2);
                FiltersInfo filtersInfo = (FiltersInfo)SortFiltersDialog.this.m_filterList.getSelectedValue();
                if (filtersInfo != null) {
                    boolean bl2;
                    if (filtersInfo.enabled) {
                        SortFiltersDialog.this.enableButton.setText("Disable");
                        SortFiltersDialog.this.enableButton.setIcon(SortFiltersDialog.this.disabledIcon);
                    } else {
                        SortFiltersDialog.this.enableButton.setText("Enable");
                        SortFiltersDialog.this.enableButton.setIcon(SortFiltersDialog.this.enabledIcon);
                    }
                    boolean bl3 = bl2 = !filtersInfo.filterName.equalsIgnoreCase("DefaultSecurityFilter");
                    if (filtersInfo.filterName.equalsIgnoreCase("Statistics")) {
                        bl2 = false;
                    }
                    SortFiltersDialog.this.removeButton.setEnabled(bl2);
                    SortFiltersDialog.this.renameButton.setEnabled(bl2);
                    SortFiltersDialog.this.newLikeButton.setEnabled(bl2);
                    SortFiltersDialog.this.editButton.setEnabled(bl2);
                }
                if (SortFiltersDialog.this.m_filterModel.size() <= 1 || n2 <= 0) {
                    SortFiltersDialog.this.moveUpButton.setEnabled(false);
                } else {
                    SortFiltersDialog.this.moveUpButton.setEnabled(true);
                }
                if (SortFiltersDialog.this.m_filterModel.size() <= 1 || n2 + 1 >= SortFiltersDialog.this.m_filterModel.size()) {
                    SortFiltersDialog.this.moveDownButton.setEnabled(false);
                } else {
                    SortFiltersDialog.this.moveDownButton.setEnabled(true);
                }
            }
        });
    }

    private ImageIcon getImage(String string) {
        return new ImageIcon(this.getClass().getResource("/image/cluster-wizard/" + string));
    }

    public void setFiltersInfo(FiltersInfo filtersInfo, boolean bl2) {
        if (bl2) {
            int n2 = this.m_filterList.getSelectedIndex();
            this.m_filterModel.set(n2, filtersInfo);
        } else {
            this.m_filterModel.addElement(filtersInfo);
            this.m_filterList.setSelectedIndex(this.m_filterModel.getSize() - 1);
        }
    }

    public void addFiltersInfo(FiltersInfo[] filtersInfoArray) {
        int n2;
        FiltersInfo[] filtersInfoArray2 = new FiltersInfo[filtersInfoArray.length];
        for (n2 = 0; n2 < filtersInfoArray.length; ++n2) {
            filtersInfoArray2[n2] = (FiltersInfo)filtersInfoArray[n2].clone();
        }
        this.m_filterModel.removeAllElements();
        this.m_filterWizardDialog.clearUserPermissionTable();
        for (n2 = 0; n2 < filtersInfoArray2.length; ++n2) {
            if (filtersInfoArray2[n2].usersInfo != null && filtersInfoArray2[n2].filterName.equalsIgnoreCase("DefaultSecurityFilter")) {
                for (int i2 = 0; i2 < filtersInfoArray2[n2].usersInfo.length; ++i2) {
                    this.m_filterWizardDialog.addUserInfo(filtersInfoArray2[n2].usersInfo[i2], false);
                }
            }
            this.m_filterModel.addElement(filtersInfoArray2[n2]);
            this.m_filterList.setSelectedIndex(this.m_filterModel.getSize() - 1);
        }
    }

    public void setDefaultFilterConfig(GenericPrincipal[] genericPrincipalArray) {
        FiltersInfo filtersInfo = new FiltersInfo();
        filtersInfo.secured = true;
        filtersInfo.beforeWrite = true;
        filtersInfo.beforeTake = true;
        filtersInfo.beforeRead = true;
        filtersInfo.usersInfo = genericPrincipalArray;
        filtersInfo.filterName = "DefaultSecurityFilter";
        filtersInfo.filterClassName = Constants.Filter.FILTER_SECURITY_CLASSNAME_DEFAULT;
        filtersInfo.paramURL = "default-users";
        this.addFiltersInfo(new FiltersInfo[]{filtersInfo});
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        this.m_filterWizardDialog.setUserDefinedRoles(userDefinedRoleArray);
    }

    public boolean isFilterExists(String string) throws ListItemAlreadyExistsException {
        return this.m_filterList.contains(string);
    }

    public void moveUpButton() {
        Object e2 = this.m_filterList.getSelectedValue();
        int n2 = this.m_filterList.getSelectedIndex();
        Object e3 = this.m_filterModel.get(n2 - 1);
        this.m_filterModel.set(n2 - 1, e2);
        this.m_filterModel.set(n2, e3);
        this.m_filterList.setSelectedIndex(n2 - 1);
    }

    public void moveDownButton() {
        Object e2 = this.m_filterList.getSelectedValue();
        int n2 = this.m_filterList.getSelectedIndex();
        Object e3 = this.m_filterModel.get(n2 + 1);
        this.m_filterModel.set(n2 + 1, e2);
        this.m_filterModel.set(n2, e3);
        this.m_filterList.setSelectedIndex(n2 + 1);
    }

    public boolean editFilter(JSpaceProxyWrapper jSpaceProxyWrapper) {
        FiltersInfo filtersInfo = (FiltersInfo)this.m_filterList.getSelectedValue();
        if (filtersInfo.isDefaultSecurityFilter()) {
            return this.editDefaultSecurityFilter(jSpaceProxyWrapper);
        }
        this.m_filterWizardDialog.showWizardData(filtersInfo, true);
        return true;
    }

    public boolean editDefaultSecurityFilter(JSpaceProxyWrapper jSpaceProxyWrapper) {
        if (jSpaceProxyWrapper == null || !jSpaceProxyWrapper.isLoginProcessed()) {
            if (!this.adminAuthentication()) {
                return false;
            }
            if (jSpaceProxyWrapper != null) {
                jSpaceProxyWrapper.setLoginProcessed(true);
            }
        }
        FiltersInfo filtersInfo = (FiltersInfo)this.m_filterList.getItem("DefaultSecurityFilter");
        this.m_defaultSecurityDialog.showWizardData(filtersInfo, true);
        return true;
    }

    public void setAdminAccount(GenericPrincipal genericPrincipal) {
        this.m_adminAccount = genericPrincipal;
    }

    public void setCurContainerName(String string) {
        this.curContainerName = string;
    }

    public boolean adminAuthentication() {
        this.m_loginDialog.clean();
        if (this.m_adminAccount != null && this.isDefaultSecurFilterEnabled()) {
            this.m_loginDialog.setUsername(this.m_adminAccount.getUserName());
        }
        this.m_loginDialog.setDescription("<html>Please specify [" + this.curContainerName + "] container administrator user name and password</html>");
        this.m_loginDialog.setVisible(true);
        if (!this.m_loginDialog.isPressedOK()) {
            return false;
        }
        if (!this.m_loginDialog.getUsername().equals(this.m_adminAccount.getUserName())) {
            JOptionPane.showMessageDialog(this.m_loginDialog, "<html>Invalid Administrator user name.<br>Please provide correct administrator user name.</html>", "Administrator Login", 0);
            return false;
        }
        if (this.m_encrypter == null) {
            this.m_encrypter = ct.a();
        }
        if (!this.m_loginDialog.getPassword().equals(this.m_encrypter.b(this.m_adminAccount.getPassword()))) {
            JOptionPane.showMessageDialog(this.m_loginDialog, "<html>Invalid Administrator user name.<br>Please provide correct administrator password.</html>", "Administrator Login", 0);
            return false;
        }
        return true;
    }

    public boolean isDefaultSecurFilterEnabled() {
        FiltersInfo filtersInfo = (FiltersInfo)this.m_filterList.getItem("DefaultSecurityFilter");
        return filtersInfo.enabled;
    }

    public void setDefaultSecurFilterEnabled(boolean bl2) {
        FiltersInfo filtersInfo = (FiltersInfo)this.m_filterList.getItem("DefaultSecurityFilter");
        if (!bl2) {
            filtersInfo.enabled = false;
            this.enableButton.setText("Enable");
            this.enableButton.setIcon(this.enabledIcon);
        } else {
            filtersInfo.enabled = true;
            this.enableButton.setText("Disable");
            this.enableButton.setIcon(this.disabledIcon);
        }
        this.m_filterList.repaint();
    }

    public void removeFilter() {
        int n2 = this.m_filterList.getSelectedIndex();
        String string = this.m_filterList.getSelectedValue().toString();
        this.m_filterModel.remove(n2);
        if (n2 == this.m_filterModel.getSize()) {
            this.m_filterList.setSelectedIndex(n2 - 1);
        } else {
            this.m_filterList.setSelectedIndex(n2);
        }
    }

    public void createFilterNewLike() {
        this.m_filterWizardDialog.showWizardData((FiltersInfo)this.m_filterList.getSelectedValue(), false);
    }

    private void renameFilter() {
        FiltersInfo filtersInfo = (FiltersInfo)this.m_filterList.getSelectedValue();
        String string = filtersInfo.filterName;
        String string2 = JOptionPane.showInputDialog(this, "Enter new filter name:", "Rename Filter", 2);
        if (string2 == null || string2.trim().length() <= 0) {
            return;
        }
        try {
            this.m_filterList.contains(string2);
        }
        catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
            JOptionPane.showConfirmDialog(this, "This filter: " + string2 + " already exists.", "Error", -1, 0, ResourcesInfo.WARNING_ICON);
            return;
        }
        filtersInfo.filterName = string2.trim();
        this.m_filterList.repaint();
    }

    public FiltersInfo[] getFiltersInfo() {
        Object[] objectArray = new FiltersInfo[this.m_filterModel.size()];
        this.m_filterModel.copyInto(objectArray);
        return objectArray;
    }

    public void showDialog() {
        this.m_filterList.setSelectedIndex(0);
        JSpaceUtilities.setLocationRelativeTo(this, this.m_parentDialog);
        this.show();
    }

    public IJSpace getSpaceProxy() {
        return this.m_spaceBrowser.getSelectedSpace();
    }

    public static void main(String[] stringArray) {
        new SortFiltersDialog(new JDialog(), "Create new Filter", true).show();
    }

    public static class JListExt
    extends JList {
        private JListExt(DefaultListModel defaultListModel) {
            super(defaultListModel);
        }

        public boolean contains(String string) throws ListItemAlreadyExistsException {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                FiltersInfo filtersInfo = (FiltersInfo)defaultListModel.get(i2);
                if (!string.equals(filtersInfo.filterName)) continue;
                throw new ListItemAlreadyExistsException("The fiter: " + string + " already exists.");
            }
            return false;
        }

        public Object getItem(String string) {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                FiltersInfo filtersInfo = (FiltersInfo)defaultListModel.get(i2);
                if (!string.equals(filtersInfo.filterName)) continue;
                this.setSelectedIndex(i2);
                return filtersInfo;
            }
            return null;
        }

        public /* synthetic */ JListExt(DefaultListModel defaultListModel, 1 var2_2) {
            this(defaultListModel);
        }
    }

    private static class FilterRenderer
    extends DefaultListCellRenderer {
        public ImageIcon filterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/filterIcon.gif"));
        public ImageIcon defaultFilterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/defaultFilterIcon.gif"));

        private FilterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            if (object == null) {
                return this;
            }
            FiltersInfo filtersInfo = (FiltersInfo)object;
            if (filtersInfo.enabled) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.red);
            }
            if (filtersInfo.filterName.equalsIgnoreCase("DefaultSecurityFilter")) {
                this.setIcon(this.defaultFilterIcon);
            } else {
                this.setIcon(this.filterIcon);
            }
            return this;
        }

        public /* synthetic */ FilterRenderer(1 var1_1) {
            this();
        }
    }
}

