/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.filters;

import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.ct;
import com.j_spaces.tools.components.ItemsControlPanel;
import com.j_spaces.tools.filters.FilterDetailsDialog;
import com.j_spaces.tools.filters.RolesManagerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class UserDetailsDialog
extends JDialog {
    public JLabel userNameLabel = new JLabel();
    public JLabel passwordLabel = new JLabel();
    public JPanel northPanel = new JPanel();
    public JPanel mainPanel = new JPanel();
    public JPanel rulesPanel = new JPanel();
    public JPanel southPanel = new JPanel();
    public JPanel buttonPanel = new JPanel();
    public JPanel centerPanel = new JPanel();
    public JCheckBox writeCB = new JCheckBox();
    public JCheckBox adminCB = new JCheckBox();
    public JCheckBox readCB = new JCheckBox();
    public JTextField userNameTF = new JTextField();
    public JButton addButton = new JButton();
    public JButton cancelButton = new JButton();
    public JButton roleManagerButton = new JButton();
    public JPanel roleManagerPanel = new JPanel();
    public FilterDetailsDialog parentDialog;
    public RolesManagerDialog roleManager;
    public ItemsControlPanel userDefinedRolesPanel;
    public List userDefinedRoles;
    public GenericPrincipal currentEditedUser;
    private JLabel confirmPassLabel = new JLabel();
    private JPasswordField passwordTF = new JPasswordField();
    private JPasswordField confirmPasswordTF = new JPasswordField();
    private ct m_encrypter;

    public UserDetailsDialog(FilterDetailsDialog filterDetailsDialog, boolean bl2) {
        super((Dialog)filterDetailsDialog, bl2);
        try {
            this.parentDialog = filterDetailsDialog;
            this.roleManager = new RolesManagerDialog(this, true);
            this.userDefinedRolesPanel = new ItemsControlPanel(new Object[]{" ", "Role name"}, "User Defined Roles");
            this.userDefinedRolesPanel.setControlsVisible(false);
            this.userDefinedRolesPanel.setDataModel(new UserDefinedRolesTableModel());
            this.userDefinedRolesPanel.getJTable().getColumnModel().getColumn(0).setMinWidth(20);
            this.userDefinedRolesPanel.getJTable().getColumnModel().getColumn(0).setMaxWidth(20);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public UserDetailsDialog(FilterDetailsDialog filterDetailsDialog) {
        this(filterDetailsDialog, true);
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        this.roleManager.setUserDefinedRoles(userDefinedRoleArray);
        this.userDefinedRoles = new ArrayList();
        for (int i2 = 0; i2 < userDefinedRoleArray.length; ++i2) {
            this.userDefinedRoles.add(userDefinedRoleArray[i2].toString());
        }
    }

    public void fromRoleManager_actionOK() {
        this.userDefinedRoles = this.roleManager.getRoleNamesList();
        this.userDefinedRolesPanel.clean();
        if (this.userDefinedRoles != null) {
            for (int i2 = 0; i2 < this.userDefinedRoles.size(); ++i2) {
                boolean bl2 = false;
                if (this.currentEditedUser != null && this.currentEditedUser.userDefinedRoles != null) {
                    bl2 = this.currentEditedUser.userDefinedRoles.contains(this.userDefinedRoles.get(i2));
                }
                this.userDefinedRolesPanel.addRow(new Object[]{bl2, this.userDefinedRoles.get(i2)});
            }
        }
        this.parentDialog.fromRolesManager_actionOK();
    }

    public void fromRoleManager_actionAddRole(UserDefinedRole userDefinedRole) {
        this.userDefinedRolesPanel.addRow(new Object[]{false, userDefinedRole});
    }

    private void jbInit() throws Exception {
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.southPanel.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        this.rulesPanel.setLayout(new GridBagLayout());
        this.rulesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "System Roles"));
        this.userNameLabel.setText("User Name: ");
        this.passwordLabel.setText("Password: ");
        this.writeCB.setText("Write");
        this.adminCB.setText("Admin");
        this.addButton.setText("OK");
        this.cancelButton.setText("Cancel");
        this.readCB.setText("Read");
        this.confirmPassLabel.setText("Confirm Password:");
        this.roleManagerButton.setText("Roles Manager");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.buttonPanel, "East");
        this.southPanel.add((Component)this.roleManagerPanel, "West");
        this.roleManagerPanel.add(this.roleManagerButton);
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.rulesPanel, "North");
        this.centerPanel.add((Component)this.userDefinedRolesPanel, "Center");
        this.northPanel.add((Component)this.userNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.northPanel.add((Component)this.userNameTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.confirmPassLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.passwordTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.confirmPasswordTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.rulesPanel.add((Component)this.adminCB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rulesPanel.add((Component)this.readCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rulesPanel.add((Component)this.writeCB, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
        this.userNameTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (UserDetailsDialog.this.userNameTF.getText().trim().length() == 0) {
                    UserDetailsDialog.this.addButton.setEnabled(false);
                } else {
                    UserDetailsDialog.this.addButton.setEnabled(true);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDetailsDialog.this.addUserInfo();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDetailsDialog.this.dispose();
            }
        });
        this.roleManagerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDetailsDialog.this.roleManager.show();
            }
        });
        this.userNameTF.setText(System.getProperty("user.name", ""));
        this.userNameTF.selectAll();
        this.userNameTF.requestFocus();
        this.addButton.setEnabled(false);
    }

    private void addUserInfo() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList arrayList2 = new ArrayList();
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            String string = this.userNameTF.getText().trim();
            String string2 = String.valueOf(this.passwordTF.getPassword());
            String string3 = String.valueOf(this.confirmPasswordTF.getPassword());
            if (string2.trim().length() <= 0) {
                throw new IllegalArgumentException("Please, specify a password");
            }
            if (!string2.equals(string3)) {
                throw new IllegalArgumentException("The password you typed do not match. Type the same password in both text boxes.");
            }
            if (this.m_encrypter == null) {
                this.m_encrypter = ct.a();
            }
            if (!"ANONYMOUS".equalsIgnoreCase(string)) {
                string2 = this.m_encrypter.a(String.valueOf(this.passwordTF.getPassword()));
            }
            if (this.writeCB.isSelected()) {
                arrayList.add("W");
            }
            if (this.readCB.isSelected()) {
                arrayList.add("R");
            }
            if (this.adminCB.isSelected()) {
                arrayList.add("A");
            }
            Vector<Vector> vector = this.userDefinedRolesPanel.getDataModel().getDataVector();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                Vector vector2 = vector.get(i2);
                if (!((Boolean)vector2.get(0)).booleanValue()) continue;
                Object e2 = vector2.get(1);
                arrayList2.add(e2);
                arrayList.add(e2.toString());
            }
            GenericPrincipal genericPrincipal = new GenericPrincipal(string, string2, arrayList, null, null);
            genericPrincipal.userDefinedRoles = arrayList2;
            this.parentDialog.addUserInfo(genericPrincipal, !this.userNameTF.isEditable());
            this.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showConfirmDialog(this, illegalArgumentException.getMessage(), "Message", -1, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showConfirmDialog(this, exception.getMessage(), "Message", -1, 2);
        }
    }

    public static int searchRole(String[] stringArray, String string) {
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return i2;
        }
        return n2;
    }

    public void clear() {
        this.setTitle("Add User");
        this.addButton.setEnabled(false);
        this.userNameTF.setEditable(true);
        this.writeCB.setSelected(false);
        this.readCB.setSelected(false);
        this.adminCB.setSelected(false);
        this.userNameTF.setText("");
        this.passwordTF.setText("");
        this.confirmPasswordTF.setText("");
        this.userDefinedRolesPanel.clean();
        if (this.userDefinedRoles != null) {
            for (int i2 = 0; i2 < this.userDefinedRoles.size(); ++i2) {
                this.userDefinedRolesPanel.addRow(new Object[]{Boolean.FALSE, this.userDefinedRoles.get(i2)});
            }
        }
    }

    public void setUserData(GenericPrincipal genericPrincipal) {
        if (genericPrincipal == null) {
            return;
        }
        this.currentEditedUser = genericPrincipal;
        this.setTitle("Edit User Details");
        this.addButton.setEnabled(true);
        this.userNameTF.setEditable(false);
        this.userNameTF.setText(genericPrincipal.getUserName());
        if (this.m_encrypter == null) {
            this.m_encrypter = ct.a();
        }
        String string = genericPrincipal.getPassword();
        if (!"ANONYMOUS".equalsIgnoreCase(genericPrincipal.getUserName())) {
            string = this.m_encrypter.b(genericPrincipal.getPassword());
        }
        this.passwordTF.setText(string);
        this.confirmPasswordTF.setText(string);
        if (UserDetailsDialog.searchRole(genericPrincipal.getRoles(), "W") != -1) {
            this.writeCB.setSelected(true);
        }
        if (UserDetailsDialog.searchRole(genericPrincipal.getRoles(), "R") != -1) {
            this.readCB.setSelected(true);
        }
        if (UserDetailsDialog.searchRole(genericPrincipal.getRoles(), "A") != -1) {
            this.adminCB.setSelected(true);
        }
        this.userDefinedRolesPanel.clean();
        if (this.userDefinedRoles != null) {
            for (int i2 = 0; i2 < this.userDefinedRoles.size(); ++i2) {
                boolean bl2 = genericPrincipal.userDefinedRoles.contains(this.userDefinedRoles.get(i2));
                this.userDefinedRolesPanel.addRow(new Object[]{bl2, this.userDefinedRoles.get(i2)});
            }
        }
    }

    public void show() {
        JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
        super.show();
    }

    private class UserDefinedRolesTableModel
    extends DefaultTableModel {
        public UserDefinedRolesTableModel() {
            super(new Object[]{"", "Role name"}, 0);
        }

        public boolean isCellEditable(int n2, int n3) {
            return n3 != 1;
        }

        public Class getColumnClass(int n2) {
            Vector vector = (Vector)this.dataVector.elementAt(0);
            return vector.elementAt(n2).getClass();
        }
    }
}

