/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.NewSpaceDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class NewSchemaNameDialog
extends JDialog
implements ActionListener {
    private JTextField textField = new JTextField();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private NewSpaceDialog newSpaceDialog;
    private String newSchemaName;

    public NewSchemaNameDialog(NewSpaceDialog newSpaceDialog) {
        super(newSpaceDialog, "Schema Name Definition", true);
        this.newSpaceDialog = newSpaceDialog;
        this.init();
        this.setSize(365, 145);
        this.setResizable(false);
    }

    private void init() {
        Box box = this.createTopBox();
        Box box2 = this.createButtonsBox();
        this.getContentPane().add((Component)box, "Center");
        this.getContentPane().add((Component)box2, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewSchemaNameDialog.this.clearAndHide();
            }

            public void windowOpened(WindowEvent windowEvent) {
                NewSchemaNameDialog.this.textField.selectAll();
            }
        });
    }

    private Box createButtonsBox() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Dimension dimension = new Dimension(70, 22);
        this.okButton.setPreferredSize(dimension);
        this.okButton.setMinimumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        Box box = new Box(1);
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.okButton);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.cancelButton);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(7));
        box.add(box2);
        box.add(Box.createVerticalStrut(7));
        return box;
    }

    private Box createTopBox() {
        Box box = new Box(1);
        Box box2 = new Box(0);
        Box box3 = new Box(0);
        JTextArea jTextArea = new JTextArea("Schema configuration was changed.\nPlease provide a different name.\nThis schema will be used for the newly created space.");
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setBackground(UIManager.getColor("Label.background"));
        jTextArea.setEditable(false);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(jTextArea);
        box3.add(Box.createHorizontalGlue());
        Dimension dimension = new Dimension(230, 22);
        this.textField.setPreferredSize(dimension);
        this.textField.setMaximumSize(dimension);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    NewSchemaNameDialog.this.checkSchemaNameValidation();
                }
            }
        });
        JLabel jLabel = new JLabel("Enter schema name:");
        box2.add(Box.createHorizontalStrut(10));
        box2.add(jLabel);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.textField);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(5));
        box.add(box3);
        box.add(Box.createVerticalStrut(5));
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        return box;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.checkSchemaNameValidation();
        } else if (object == this.cancelButton) {
            this.clearAndHide();
        }
    }

    private void checkSchemaNameValidation() {
        this.newSchemaName = this.textField.getText();
        boolean bl2 = JSpaceUtilities.isEmpty(this.newSchemaName, true);
        if (bl2) {
            JOptionPane.showMessageDialog(this, "Please enter valid schema name.", "Schema Name", 1);
        } else {
            boolean bl3 = this.newSpaceDialog.isSchemaNameExists(this.newSchemaName);
            if (bl3) {
                this.textField.selectAll();
                JOptionPane.showMessageDialog(this, "Schema with this name already defined.\nPlease provide another schema name.", "Schema Name", 1);
            } else {
                this.setVisible(false);
            }
        }
    }

    public void clearAndHide() {
        this.newSchemaName = null;
        this.textField.setText("");
        this.setVisible(false);
    }

    public String getNewSchemaName() {
        return this.newSchemaName;
    }
}

