/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private static Toolkit toolkit;
    private static NumberFormat integerFormatter;
    private boolean integerOnly;

    public WholeNumberField(boolean bl2) {
        this.integerOnly = bl2;
        integerFormatter = NumberFormat.getNumberInstance(Locale.US);
        integerFormatter.setParseIntegerOnly(bl2);
        toolkit = Toolkit.getDefaultToolkit();
    }

    public WholeNumberField() {
        this(true);
    }

    public float getValueFloat() {
        float f2 = 0.0f;
        try {
            f2 = integerFormatter.parse(this.getText()).floatValue();
        }
        catch (ParseException parseException) {
            toolkit.beep();
        }
        return f2;
    }

    public int getValueInt() {
        int n2 = 0;
        try {
            n2 = integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            toolkit.beep();
        }
        return n2;
    }

    public void setValueInt(int n2) {
        this.setText(integerFormatter.format(n2));
    }

    public void setValueFloat(float f2) {
        this.setText(integerFormatter.format(f2));
    }

    public Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            for (int i2 = 0; i2 < cArray2.length; ++i2) {
                if (Character.isDigit(cArray[i2]) || cArray[i2] == '.' && !WholeNumberField.this.integerOnly) {
                    cArray2[n3++] = cArray[i2];
                    continue;
                }
                if (cArray[i2] == ',') continue;
                toolkit.beep();
            }
            super.insertString(n2, new String(cArray2, 0, n3), attributeSet);
        }
    }
}

