/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.statistics;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.Trace2DLtd;
import com.j_spaces.tools.spacebrowser.statistics.ColorMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class LineGraph
extends JPanel {
    private Chart2D chart;
    private int xTime;
    private List TRACES;
    private ITrace2D trace1;
    private ITrace2D trace2;
    private ITrace2D trace3;
    private ITrace2D trace4;
    private ITrace2D trace5;
    private ITrace2D trace6;
    private ITrace2D trace7;

    public LineGraph() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.initChart();
    }

    private void initChart() {
        this.chart = new Chart2D();
        this.chart.setGridX(true);
        this.chart.setGridY(true);
        this.chart.setDecimalsX(0);
        this.xTime = 0;
        this.TRACES = new ArrayList();
        this.trace1 = new Trace2DLtd(60);
        this.trace2 = new Trace2DLtd(60);
        this.trace3 = new Trace2DLtd(60);
        this.trace4 = new Trace2DLtd(60);
        this.trace5 = new Trace2DLtd(60);
        this.trace6 = new Trace2DLtd(60);
        this.trace7 = new Trace2DLtd(60);
        this.updateColors();
        this.TRACES.add(this.trace1);
        this.TRACES.add(this.trace2);
        this.TRACES.add(this.trace3);
        this.TRACES.add(this.trace4);
        this.TRACES.add(this.trace5);
        this.TRACES.add(this.trace6);
        this.TRACES.add(this.trace7);
        this.chart.addTrace(this.trace1);
        this.chart.addTrace(this.trace2);
        this.chart.addTrace(this.trace3);
        this.chart.addTrace(this.trace4);
        this.chart.addTrace(this.trace5);
        this.chart.addTrace(this.trace6);
        this.chart.addTrace(this.trace7);
        this.chart.setGridColor(Color.DARK_GRAY);
        this.removeAll();
        this.add((Component)this.chart, "Center");
        this.revalidate();
        this.repaint();
    }

    public void updateColors() {
        Map map = ColorMap.instance().getColorMapping();
        this.trace1.setColor((Color)map.get("Read"));
        this.trace2.setColor((Color)map.get("Write"));
        this.trace3.setColor((Color)map.get("Update"));
        this.trace5.setColor((Color)map.get("Take"));
        this.trace4.setColor((Color)map.get("Notify registration"));
        this.trace6.setColor((Color)map.get("Notify sent"));
        this.trace7.setColor((Color)map.get("Notify ack."));
    }

    public void doStep(int n2) {
        this.xTime += n2;
    }

    public void addTracepoint(int n2, int n3, boolean bl2) {
        ITrace2D iTrace2D = (ITrace2D)this.TRACES.get(n2);
        iTrace2D.addPoint((double)this.xTime, (double)n3);
        List list = this.chart.getTraces();
        int n4 = list.indexOf(iTrace2D);
        if (!bl2 && n4 > -1) {
            this.chart.removeTrace(iTrace2D);
        }
        if (bl2 && n4 < 0) {
            this.chart.addTrace(iTrace2D);
        }
    }

    public void clearGraph() {
        this.initChart();
    }
}

