/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TypePlainDocument
extends PlainDocument {
    private int documentType;
    public static final int DT_INT = 1;
    public static final int DT_LONG = 2;
    public static final int DT_FLOAT = 3;
    public static final int DT_DOUBLE = 4;
    public static final int DT_STRING = 5;

    public TypePlainDocument(int n2) {
        this.documentType = n2;
    }

    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (!this.isValid(n2, string)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(n2, string, attributeSet);
        }
    }

    private boolean isValid(int n2, String string) throws BadLocationException {
        String string2 = this.getText(0, this.getLength());
        String string3 = string2.substring(0, n2) + string + string2.substring(n2, string2.length());
        if (string3.length() == 0) {
            return true;
        }
        try {
            switch (this.documentType) {
                case 4: {
                    new Double(string3);
                    break;
                }
                case 3: {
                    new Float(string3);
                    break;
                }
                case 1: {
                    new Integer(string3);
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    new Long(string3);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

