/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.logging.Level;
import org.apache.commons.gs.beanutils.ConvertUtils;
import org.apache.commons.gs.beanutils.MethodUtils;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    public String bodyText = null;
    private int targetOffset = 0;
    public String methodName = null;
    public int paramCount = 0;
    public Class[] paramTypes = null;
    private String[] paramClassNames = null;
    public boolean useExactMatch = false;
    static /* synthetic */ Class class$java$lang$String;

    public CallMethodRule(Digester digester, String string, int n2) {
        this(string, n2);
    }

    public CallMethodRule(Digester digester, String string, int n2, String[] stringArray) {
        this(string, n2, stringArray);
    }

    public CallMethodRule(Digester digester, String string, int n2, Class[] classArray) {
        this(string, n2, classArray);
    }

    public CallMethodRule(String string, int n2) {
        this(0, string, n2);
    }

    public CallMethodRule(int n2, String string, int n3) {
        this.targetOffset = n2;
        this.methodName = string;
        this.paramCount = n3;
        if (n3 == 0) {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz;
            this.paramTypes = classArray;
        } else {
            this.paramTypes = new Class[n3];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = new String[0].getClass().getComponentType();
                }
                this.paramTypes[i2] = clazz;
            }
        }
    }

    public CallMethodRule(String string) {
        this(0, string, 0, (Class[])null);
    }

    public CallMethodRule(int n2, String string) {
        this(n2, string, 0, (Class[])null);
    }

    public CallMethodRule(String string, int n2, String[] stringArray) {
        this(0, string, n2, stringArray);
    }

    public CallMethodRule(int n2, String string, int n3, String[] stringArray) {
        this.targetOffset = n2;
        this.methodName = string;
        this.paramCount = n3;
        if (stringArray == null) {
            this.paramTypes = new Class[n3];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                this.paramTypes[i2] = "abc".getClass();
            }
        } else {
            this.paramClassNames = new String[stringArray.length];
            for (int i3 = 0; i3 < this.paramClassNames.length; ++i3) {
                this.paramClassNames[i3] = stringArray[i3];
            }
        }
    }

    public CallMethodRule(String string, int n2, Class[] classArray) {
        this(0, string, n2, classArray);
    }

    public CallMethodRule(int n2, String string, int n3, Class[] classArray) {
        this.targetOffset = n2;
        this.methodName = string;
        this.paramCount = n3;
        if (classArray == null) {
            this.paramTypes = new Class[n3];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                this.paramTypes[i2] = "abc".getClass();
            }
        } else {
            this.paramTypes = new Class[classArray.length];
            for (int i3 = 0; i3 < this.paramTypes.length; ++i3) {
                this.paramTypes[i3] = classArray[i3];
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean bl2) {
        this.useExactMatch = bl2;
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            for (int i2 = 0; i2 < this.paramClassNames.length; ++i2) {
                try {
                    this.paramTypes[i2] = digester.getClassLoader().loadClass(this.paramClassNames[i2]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    digester.getLogger().log(Level.SEVERE, "(CallMethodRule) Cannot load class " + this.paramClassNames[i2], classNotFoundException);
                    this.paramTypes[i2] = null;
                }
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] objectArray = new Object[this.paramCount];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = null;
            }
            this.digester.pushParams(objectArray);
        }
    }

    public void body(String string) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = string.trim();
        }
    }

    public void end() throws Exception {
        Object object;
        int n2;
        Object[] objectArray = null;
        if (this.paramCount > 0) {
            objectArray = (Object[])this.digester.popParams();
            if (this.digester.log.isLoggable(Level.FINEST)) {
                n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.digester.log.finest("[CallMethodRule](" + i2 + ")" + objectArray[i2]);
                }
            }
            if (this.paramCount == 1 && objectArray[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            objectArray = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] objectArray2 = new Object[this.paramTypes.length];
        for (n2 = 0; n2 < this.paramTypes.length; ++n2) {
            block22: {
                block21: {
                    if (objectArray[n2] == null) break block21;
                    if (!(objectArray[n2] instanceof String)) break block22;
                    Class<?> clazz = class$java$lang$String;
                    if (clazz == null) {
                        clazz = new String[0].getClass().getComponentType();
                    }
                    if (clazz.isAssignableFrom(this.paramTypes[n2])) break block22;
                }
                objectArray2[n2] = ConvertUtils.convert((String)objectArray[n2], this.paramTypes[n2]);
                continue;
            }
            objectArray2[n2] = objectArray[n2];
        }
        Object object2 = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (object2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[CallMethodRule]{");
            stringBuffer.append(this.digester.match);
            stringBuffer.append("} Call target is null (");
            stringBuffer.append("targetOffset=");
            stringBuffer.append(this.targetOffset);
            stringBuffer.append(",stackdepth=");
            stringBuffer.append(this.digester.getCount());
            stringBuffer.append(")");
            throw new SAXException(stringBuffer.toString());
        }
        if (this.digester.log.isLoggable(Level.FINE)) {
            object = new StringBuffer("[CallMethodRule]{");
            ((StringBuffer)object).append(this.digester.match);
            ((StringBuffer)object).append("} Call ");
            ((StringBuffer)object).append(object2.getClass().getName());
            ((StringBuffer)object).append(".");
            ((StringBuffer)object).append(this.methodName);
            ((StringBuffer)object).append("(");
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                if (i3 > 0) {
                    ((StringBuffer)object).append(",");
                }
                if (objectArray2[i3] == null) {
                    ((StringBuffer)object).append("null");
                } else {
                    ((StringBuffer)object).append(objectArray2[i3].toString());
                }
                ((StringBuffer)object).append("/");
                if (this.paramTypes[i3] == null) {
                    ((StringBuffer)object).append("null");
                    continue;
                }
                ((StringBuffer)object).append(this.paramTypes[i3].getName());
            }
            ((StringBuffer)object).append(")");
            this.digester.log.fine(((StringBuffer)object).toString());
        }
        object = null;
        object = this.useExactMatch ? MethodUtils.invokeExactMethod(object2, this.methodName, objectArray2, this.paramTypes) : MethodUtils.invokeMethod(object2, this.methodName, objectArray2, this.paramTypes);
        this.processMethodCallResult(object);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public void processMethodCallResult(Object object) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CallMethodRule[");
        stringBuffer.append("methodName=");
        stringBuffer.append(this.methodName);
        stringBuffer.append(", paramCount=");
        stringBuffer.append(this.paramCount);
        stringBuffer.append(", paramTypes={");
        if (this.paramTypes != null) {
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.paramTypes[i2].getName());
            }
        }
        stringBuffer.append("}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

