/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beanutils.BeanUtils;
import org.apache.commons.gs.beanutils.DynaBean;
import org.apache.commons.gs.beanutils.PropertyUtils;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.Rule;
import org.apache.commons.gs.digester.Rules;
import org.xml.sax.Attributes;

public class SetNestedPropertiesRule
extends Rule {
    private Logger log = null;
    private boolean trimData = true;
    private boolean allowUnknownChildElements = false;
    private HashMap elementNames = new HashMap();

    public SetNestedPropertiesRule() {
    }

    public SetNestedPropertiesRule(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public SetNestedPropertiesRule(String[] stringArray, String[] stringArray2) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = null;
            if (i2 < stringArray2.length) {
                string = stringArray2[i2];
            }
            this.elementNames.put(stringArray[i2], string);
        }
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        this.log = digester.getLogger();
    }

    public void setTrimData(boolean bl2) {
        this.trimData = bl2;
    }

    public boolean getTrimData() {
        return this.trimData;
    }

    public void setAllowUnknownChildElements(boolean bl2) {
        this.allowUnknownChildElements = bl2;
    }

    public boolean getAllowUnknownChildElements() {
        return this.allowUnknownChildElements;
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Rules rules = this.digester.getRules();
        AnyChildRule anyChildRule = new AnyChildRule(null);
        anyChildRule.setDigester(this.digester);
        AnyChildRules anyChildRules = new AnyChildRules(anyChildRule);
        anyChildRules.init(this.digester.getMatch() + "/", rules);
        this.digester.setRules(anyChildRules);
    }

    public void body(String string) throws Exception {
        AnyChildRules anyChildRules = (AnyChildRules)this.digester.getRules();
        this.digester.setRules(anyChildRules.getOldRules());
    }

    public void addAlias(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetNestedPropertiesRule[");
        stringBuffer.append("allowUnknownChildElements=");
        stringBuffer.append(this.allowUnknownChildElements);
        stringBuffer.append(", trimData=");
        stringBuffer.append(this.trimData);
        stringBuffer.append(", elementNames=");
        stringBuffer.append(this.elementNames);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class 1 {
    }

    private class AnyChildRule
    extends Rule {
        private String currChildNamespaceURI = null;
        private String currChildElementName = null;

        private AnyChildRule() {
        }

        public void begin(String string, String string2, Attributes attributes) throws Exception {
            this.currChildNamespaceURI = string;
            this.currChildElementName = string2;
        }

        public void body(String string) throws Exception {
            Object object;
            boolean bl2 = SetNestedPropertiesRule.this.log.isLoggable(Level.FINE);
            String string2 = this.currChildElementName;
            if (SetNestedPropertiesRule.this.elementNames.containsKey(this.currChildElementName) && (string2 = (String)SetNestedPropertiesRule.this.elementNames.get(this.currChildElementName)) == null) {
                return;
            }
            if (this.digester.log.isLoggable(Level.FINE)) {
                this.digester.log.fine("[SetNestedPropertiesRule]{" + this.digester.match + "} Setting property '" + string2 + "' to '" + string + "'");
            }
            Object object2 = this.digester.peek();
            if (this.digester.log.isLoggable(Level.FINE)) {
                if (object2 != null) {
                    this.digester.log.fine("[SetNestedPropertiesRule]{" + this.digester.match + "} Set " + object2.getClass().getName() + " properties");
                } else {
                    this.digester.log.fine("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
                }
            }
            if (SetNestedPropertiesRule.this.trimData) {
                string = string.trim();
            }
            if (!SetNestedPropertiesRule.this.allowUnknownChildElements && (object2 instanceof DynaBean ? (object = ((DynaBean)object2).getDynaClass().getDynaProperty(string2)) == null : (object = PropertyUtils.getPropertyDescriptor(object2, string2)) == null)) {
                throw new NoSuchMethodException("Bean has no property named " + string2);
            }
            try {
                BeanUtils.setProperty(object2, string2, string);
            }
            catch (NullPointerException nullPointerException) {
                this.digester.log.severe("NullPointerException: top=" + object2 + ",propName=" + string2 + ",value=" + string + "!");
                throw nullPointerException;
            }
        }

        public void end(String string, String string2) throws Exception {
            this.currChildElementName = null;
        }

        public /* synthetic */ AnyChildRule(1 var2_2) {
            this();
        }
    }

    private class AnyChildRules
    implements Rules {
        private String matchPrefix = null;
        private Rules decoratedRules = null;
        private ArrayList rules = new ArrayList(1);
        private AnyChildRule rule;

        public AnyChildRules(AnyChildRule anyChildRule) {
            this.rule = anyChildRule;
            this.rules.add(anyChildRule);
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }

        public String getNamespaceURI() {
            return null;
        }

        public void setNamespaceURI(String string) {
        }

        public void add(String string, Rule rule) {
        }

        public void clear() {
        }

        public List match(String string) {
            return this.match(null, string);
        }

        public List match(String string, String string2) {
            List list = this.decoratedRules.match(string, string2);
            if (string2.startsWith(this.matchPrefix) && string2.indexOf(47, this.matchPrefix.length()) == -1) {
                if (list == null || list.size() == 0) {
                    return this.rules;
                }
                LinkedList<AnyChildRule> linkedList = new LinkedList<AnyChildRule>(list);
                linkedList.addLast(this.rule);
                return linkedList;
            }
            return list;
        }

        public List rules() {
            throw new RuntimeException("AnyChildRules.rules not implemented.");
        }

        public void init(String string, Rules rules) {
            this.matchPrefix = string;
            this.decoratedRules = rules;
        }

        public Rules getOldRules() {
            return this.decoratedRules;
        }
    }
}

