/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class LruObjectCache
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    static final int defaultInitSize = 1319;
    int count;
    int threshold;
    int pinLimit;
    int nPinned;
    Entry pinList;
    boolean flushing;

    public LruObjectCache(int n2) {
        int n3 = n2 == 0 ? 1319 : n2;
        this.threshold = (int)((float)n3 * 0.75f);
        this.table = new Entry[n3];
        this.pinList = new Entry(0, null, null);
        this.pinLimit = n2;
        this.pinList.lru = this.pinList.mru = this.pinList;
    }

    public synchronized boolean remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.oid == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                entry.clear();
                this.unpinObject(entry);
                --this.count;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    protected Reference createReference(Object object) {
        return new WeakReference<Object>(object);
    }

    private final void unpinObject(Entry entry) {
        if (entry.pin != null) {
            entry.unpin();
            --this.nPinned;
        }
    }

    private final void pinObject(Entry entry, IPersistent iPersistent) {
        if (this.pinLimit != 0) {
            if (entry.pin != null) {
                entry.unlink();
            } else if (this.nPinned == this.pinLimit) {
                this.pinList.lru.unpin();
            } else {
                ++this.nPinned;
            }
            entry.linkAfter(this.pinList, iPersistent);
        }
    }

    public synchronized void put(int n2, IPersistent iPersistent) {
        Reference reference = this.createReference(iPersistent);
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                entry.ref = reference;
                this.pinObject(entry, iPersistent);
                return;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold && !this.flushing) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = new Entry(n2, reference, entryArray[n3]);
        this.pinObject(entryArray[n3], iPersistent);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPersistent get(int n2) {
        while (true) {
            block10: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    Entry[] entryArray = this.table;
                    int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry = entryArray[n3];
                    while (entry != null) {
                        if (entry.oid == n2) {
                            IPersistent iPersistent = (IPersistent)entry.ref.get();
                            if (iPersistent == null) {
                                if (entry.dirty != 0) {
                                    break block10;
                                }
                            } else {
                                if (iPersistent.isDeleted()) {
                                    entry.ref.clear();
                                    this.unpinObject(entry);
                                    return null;
                                }
                                this.pinObject(entry, iPersistent);
                            }
                            return iPersistent;
                        }
                        entry = entry.next;
                    }
                    return null;
                }
            }
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        while (true) {
            block11: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    this.flushing = true;
                    for (int i2 = 0; i2 < this.table.length; ++i2) {
                        Entry entry = this.table[i2];
                        while (entry != null) {
                            IPersistent iPersistent = (IPersistent)entry.ref.get();
                            if (iPersistent != null) {
                                if (iPersistent.isModified()) {
                                    iPersistent.store();
                                }
                            } else if (entry.dirty != 0) {
                                break block11;
                            }
                            entry = entry.next;
                        }
                    }
                    this.flushing = false;
                    if (this.count >= this.threshold) {
                        this.rehash();
                    }
                    return;
                }
            }
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        while (true) {
            block10: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    for (int i2 = 0; i2 < this.table.length; ++i2) {
                        Entry entry = this.table[i2];
                        while (entry != null) {
                            IPersistent iPersistent = (IPersistent)entry.ref.get();
                            if (iPersistent != null) {
                                if (iPersistent.isModified()) {
                                    entry.dirty = 0;
                                    this.unpinObject(entry);
                                    iPersistent.invalidate();
                                }
                            } else if (entry.dirty != 0) {
                                break block10;
                            }
                            entry = entry.next;
                        }
                        this.table[i2] = null;
                    }
                    this.count = 0;
                    this.nPinned = 0;
                    this.pinList.lru = this.pinList.mru = this.pinList;
                    return;
                }
            }
            System.runFinalization();
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = null;
        }
        this.count = 0;
        this.nPinned = 0;
        this.pinList.lru = this.pinList.mru = this.pinList;
    }

    void rehash() {
        Object object;
        Entry[] entryArray;
        Object object2;
        int n2 = this.table.length;
        Entry[] entryArray2 = this.table;
        int n3 = n2;
        while (--n3 >= 0) {
            object2 = null;
            Entry[] entryArray3 = entryArray2[n3];
            while (entryArray3 != null) {
                entryArray = entryArray3.next;
                object = entryArray3.ref.get();
                if ((object == null || object.isDeleted()) && entryArray3.dirty == 0) {
                    --this.count;
                    entryArray3.clear();
                    if (object2 == null) {
                        entryArray2[n3] = entryArray;
                    } else {
                        object2.next = entryArray;
                    }
                } else {
                    object2 = entryArray3;
                }
                entryArray3 = entryArray;
            }
        }
        if (this.count <= this.threshold >>> 1) {
            return;
        }
        int n4 = n2 * 2 + 1;
        entryArray = new Entry[n4];
        this.threshold = (int)((float)n4 * 0.75f);
        this.table = entryArray;
        n3 = n2;
        while (--n3 >= 0) {
            object2 = entryArray2[n3];
            while (object2 != null) {
                object = object2;
                object2 = object2.next;
                int n5 = (object.oid & Integer.MAX_VALUE) % n4;
                object.next = entryArray[n5];
                entryArray[n5] = object;
            }
        }
    }

    public synchronized void setDirty(IPersistent iPersistent) {
        int n2 = iPersistent.getOid();
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                ++entry.dirty;
                return;
            }
            entry = entry.next;
        }
    }

    public synchronized void clearDirty(IPersistent iPersistent) {
        int n2 = iPersistent.getOid();
        Entry[] entryArray = this.table;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.oid == n2) {
                if (entry.dirty > 0) {
                    --entry.dirty;
                }
                return;
            }
            entry = entry.next;
        }
    }

    public int size() {
        return this.count;
    }

    static class Entry {
        Entry next;
        Reference ref;
        int oid;
        int dirty;
        Entry lru;
        Entry mru;
        IPersistent pin;

        void unlink() {
            this.lru.mru = this.mru;
            this.mru.lru = this.lru;
        }

        void unpin() {
            this.unlink();
            this.mru = null;
            this.lru = null;
            this.pin = null;
        }

        void linkAfter(Entry entry, IPersistent iPersistent) {
            this.mru = entry.mru;
            this.mru.lru = this;
            entry.mru = this;
            this.lru = entry;
            this.pin = iPersistent;
        }

        void clear() {
            this.ref.clear();
            this.ref = null;
            this.dirty = 0;
            this.next = null;
        }

        Entry(int n2, Reference reference, Entry entry) {
            this.next = entry;
            this.oid = n2;
            this.ref = reference;
        }
    }
}

