/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.IFile;
import org.garret.perst.impl.OSFile;

public class Rc4File
implements IFile {
    private IFile file;
    private byte[] cipherBuf = new byte[4096];
    private byte[] initState = new byte[256];
    private byte[] state = new byte[256];
    private int x;
    private int y;
    private long length;
    private byte[] zeroPage;

    public void write(long l2, byte[] byArray) {
        if (l2 > this.length) {
            if (this.zeroPage == null) {
                this.zeroPage = new byte[4096];
                this.encrypt(this.zeroPage, 0, this.zeroPage, 0, 4096);
            }
            do {
                this.file.write(this.length, this.zeroPage);
            } while ((this.length += 4096L) < l2);
        }
        if (l2 == this.length) {
            this.length += 4096L;
        }
        this.encrypt(byArray, 0, this.cipherBuf, 0, byArray.length);
        this.file.write(l2, this.cipherBuf);
    }

    public int read(long l2, byte[] byArray) {
        if (l2 < this.length) {
            int n2 = this.file.read(l2, byArray);
            this.decrypt(byArray, 0, byArray, 0, n2);
            return n2;
        }
        return 0;
    }

    public Rc4File(String string, boolean bl2, boolean bl3, String string2) {
        this.file = new OSFile(string, bl2, bl3);
        this.length = this.file.length() & 0xFFFFFFFFFFFFF000L;
        this.setKey(string2.getBytes());
    }

    public Rc4File(IFile iFile, String string) {
        this.file = iFile;
        this.length = iFile.length() & 0xFFFFFFFFFFFFF000L;
        this.setKey(string.getBytes());
    }

    private void setKey(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < 256; ++n2) {
            this.initState[n2] = (byte)n2;
        }
        n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n3 = byArray[n2] + this.initState[i2] + n3 & 0xFF;
            byte by2 = this.initState[i2];
            this.initState[i2] = this.initState[n3];
            this.initState[n3] = by2;
            n2 = (n2 + 1) % byArray.length;
        }
    }

    private final void encrypt(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        this.y = 0;
        this.x = 0;
        System.arraycopy(this.initState, 0, this.state, 0, this.state.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[n3 + i2] = (byte)(byArray[n2 + i2] ^ this.state[this.nextState()]);
        }
    }

    private final void decrypt(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        this.y = 0;
        this.x = 0;
        System.arraycopy(this.initState, 0, this.state, 0, this.state.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[n3 + i2] = (byte)(byArray[n2 + i2] ^ this.state[this.nextState()]);
        }
    }

    private final int nextState() {
        this.x = this.x + 1 & 0xFF;
        this.y = this.y + this.state[this.x] & 0xFF;
        byte by2 = this.state[this.x];
        this.state[this.x] = this.state[this.y];
        this.state[this.y] = by2;
        return this.state[this.x] + this.state[this.y] & 0xFF;
    }

    public void close() {
        this.file.close();
    }

    public boolean tryLock(boolean bl2) {
        return this.file.tryLock(bl2);
    }

    public void lock(boolean bl2) {
        this.file.lock(bl2);
    }

    public void unlock() {
        this.file.unlock();
    }

    public void sync() {
        this.file.sync();
    }

    public long length() {
        return this.file.length();
    }
}

