/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Relation;
import org.garret.perst.StorageError;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

class ThickIndex
extends PersistentResource
implements Index {
    private Index index;
    private int nElems;
    static final int BTREE_THRESHOLD = 128;

    ThickIndex(Class clazz, StorageImpl storageImpl) {
        super(storageImpl);
        this.index = storageImpl.createIndex(clazz, true);
    }

    ThickIndex() {
    }

    public IPersistent get(Key key) {
        Relation relation;
        IPersistent iPersistent = this.index.get(key);
        if (iPersistent == null) {
            return null;
        }
        if (iPersistent instanceof Relation && (relation = (Relation)iPersistent).size() == 1) {
            return relation.get(0);
        }
        throw new StorageError(4);
    }

    public IPersistent[] get(Key key, Key key2) {
        return this.extend(this.index.get(key, key2));
    }

    private IPersistent[] extend(IPersistent[] iPersistentArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            Iterator iterator;
            IPersistent iPersistent = iPersistentArray[i2];
            Iterator iterator2 = iterator = iPersistent instanceof Relation ? ((Relation)iPersistent).iterator() : ((IPersistentSet)iPersistent).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList.toArray(new IPersistent[arrayList.size()]);
    }

    public IPersistent get(String string) {
        return this.get(new Key(string));
    }

    public IPersistent[] getPrefix(String string) {
        return this.extend(this.index.getPrefix(string));
    }

    public IPersistent[] prefixSearch(String string) {
        return this.extend(this.index.prefixSearch(string));
    }

    public int size() {
        return this.nElems;
    }

    public void clear() {
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            ((IPersistent)iterator.next()).deallocate();
        }
        this.index.clear();
        this.nElems = 0;
        this.modify();
    }

    public IPersistent[] toPersistentArray() {
        return this.extend(this.index.toPersistentArray());
    }

    public IPersistent[] toPersistentArray(IPersistent[] iPersistentArray) {
        IPersistent[] iPersistentArray2 = this.index.toPersistentArray();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < iPersistentArray2.length; ++i2) {
            Iterator iterator;
            IPersistent iPersistent = iPersistentArray2[i2];
            Iterator iterator2 = iterator = iPersistent instanceof Relation ? ((Relation)iPersistent).iterator() : ((IPersistentSet)iPersistent).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList.toArray(iPersistentArray);
    }

    public Iterator iterator() {
        return new ExtendIterator(this.index.iterator());
    }

    public Iterator entryIterator() {
        return new ExtendEntryIterator(this.index.entryIterator());
    }

    public Iterator iterator(Key key, Key key2, int n2) {
        return new ExtendIterator(this.index.iterator(key, key2, n2));
    }

    public Iterator entryIterator(Key key, Key key2, int n2) {
        return new ExtendEntryIterator(this.index.entryIterator(key, key2, n2));
    }

    public Iterator prefixIterator(String string) {
        return new ExtendIterator(this.index.prefixIterator(string));
    }

    public Class getKeyType() {
        return this.index.getKeyType();
    }

    public Class[] getKeyTypes() {
        return new Class[]{this.getKeyType()};
    }

    public boolean put(Key key, IPersistent iPersistent) {
        IPersistent iPersistent2 = this.index.get(key);
        if (iPersistent2 == null) {
            Relation relation = this.getStorage().createRelation(null);
            relation.add(iPersistent);
            this.index.put(key, (IPersistent)relation);
        } else if (iPersistent2 instanceof Relation) {
            Relation relation = (Relation)iPersistent2;
            if (relation.size() == 128) {
                IPersistentSet iPersistentSet = this.getStorage().createSet();
                for (int i2 = 0; i2 < 128; ++i2) {
                    iPersistentSet.add(relation.getRaw(i2));
                }
                iPersistentSet.add(iPersistent);
                this.index.set(key, (IPersistent)iPersistentSet);
                relation.deallocate();
            } else {
                relation.add(iPersistent);
            }
        } else {
            ((IPersistentSet)iPersistent2).add(iPersistent);
        }
        ++this.nElems;
        this.modify();
        return true;
    }

    public IPersistent set(Key key, IPersistent iPersistent) {
        Relation relation;
        IPersistent iPersistent2 = this.index.get(key);
        if (iPersistent2 == null) {
            Relation relation2 = this.getStorage().createRelation(null);
            relation2.add(iPersistent);
            this.index.put(key, (IPersistent)relation2);
            ++this.nElems;
            this.modify();
            return null;
        }
        if (iPersistent2 instanceof Relation && (relation = (Relation)iPersistent2).size() == 1) {
            IPersistent iPersistent3 = relation.get(0);
            relation.set(0, iPersistent);
            return iPersistent3;
        }
        throw new StorageError(4);
    }

    public void remove(Key key, IPersistent iPersistent) {
        IPersistentSet iPersistentSet;
        IPersistent iPersistent2 = this.index.get(key);
        if (iPersistent2 instanceof Relation) {
            Relation relation = (Relation)iPersistent2;
            int n2 = relation.indexOf(iPersistent);
            if (n2 >= 0) {
                relation.remove(n2);
                if (relation.size() == 0) {
                    this.index.remove(key, (IPersistent)relation);
                    relation.deallocate();
                }
                --this.nElems;
                this.modify();
                return;
            }
        } else if (iPersistent2 instanceof IPersistentSet && (iPersistentSet = (IPersistentSet)iPersistent2).remove(iPersistent)) {
            if (iPersistentSet.size() == 0) {
                this.index.remove(key, (IPersistent)iPersistentSet);
                iPersistentSet.deallocate();
            }
            --this.nElems;
            this.modify();
            return;
        }
        throw new StorageError(5);
    }

    public IPersistent remove(Key key) {
        throw new StorageError(4);
    }

    public boolean put(String string, IPersistent iPersistent) {
        return this.put(new Key(string), iPersistent);
    }

    public IPersistent set(String string, IPersistent iPersistent) {
        return this.set(new Key(string), iPersistent);
    }

    public void remove(String string, IPersistent iPersistent) {
        this.remove(new Key(string), iPersistent);
    }

    public IPersistent remove(String string) {
        throw new StorageError(4);
    }

    public void deallocate() {
        this.clear();
        this.index.deallocate();
        super.deallocate();
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    public Object getAt(int n2) {
        Iterator iterator;
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("Position " + n2 + ", index size " + this.nElems);
        }
        if (n2 <= this.nElems / 2) {
            iterator = this.entryIterator(null, null, 0);
            while (--n2 >= 0) {
                iterator.next();
            }
        } else {
            iterator = this.entryIterator(null, null, 1);
            n2 -= this.nElems;
            while (++n2 < 0) {
                iterator.next();
            }
        }
        return ((Map.Entry)iterator.next()).getValue();
    }

    public Iterator entryIterator(int n2, int n3) {
        return new ExtendEntryStartFromIterator(n2, n3);
    }

    class ExtendEntryStartFromIterator
    extends ExtendEntryIterator {
        ExtendEntryStartFromIterator(int n2, int n3) {
            super(ThickIndex.this.entryIterator(null, null, n3));
            int n4;
            int n5 = n4 = n3 == 0 ? n2 : ThickIndex.this.nElems - n2 - 1;
            while (--n4 >= 0 && this.hasNext()) {
                this.next();
            }
        }
    }

    static class ExtendEntryIterator
    implements Iterator {
        private Iterator outer;
        private Iterator inner;
        private Object key;

        public boolean hasNext() {
            return this.inner != null;
        }

        public Object next() {
            ExtendEntry extendEntry = new ExtendEntry(this.key, this.inner.next());
            if (!this.inner.hasNext()) {
                if (this.outer.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.outer.next();
                    this.key = entry.getKey();
                    Object v2 = entry.getValue();
                    this.inner = v2 instanceof Relation ? ((Relation)v2).iterator() : ((IPersistentSet)v2).iterator();
                } else {
                    this.inner = null;
                }
            }
            return extendEntry;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ExtendEntryIterator(Iterator iterator) {
            this.outer = iterator;
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.key = entry.getKey();
                Object v2 = entry.getValue();
                this.inner = v2 instanceof Relation ? ((Relation)v2).iterator() : ((IPersistentSet)v2).iterator();
            }
        }
    }

    static class ExtendEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        ExtendEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }

    static class ExtendIterator
    implements PersistentIterator {
        private Iterator outer;
        private Iterator inner;

        public boolean hasNext() {
            return this.inner != null;
        }

        public Object next() {
            Object e2 = this.inner.next();
            if (!this.inner.hasNext()) {
                Object e3;
                this.inner = this.outer.hasNext() ? ((e3 = this.outer.next()) instanceof Relation ? ((Relation)e3).iterator() : ((IPersistentSet)e3).iterator()) : null;
            }
            return e2;
        }

        public int nextOid() {
            int n2 = ((PersistentIterator)this.inner).nextOid();
            if (!this.inner.hasNext()) {
                Object e2;
                this.inner = this.outer.hasNext() ? ((e2 = this.outer.next()) instanceof Relation ? ((Relation)e2).iterator() : ((IPersistentSet)e2).iterator()) : null;
            }
            return n2;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ExtendIterator(Iterator iterator) {
            this.outer = iterator;
            if (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.inner = e2 instanceof Relation ? ((Relation)e2).iterator() : ((IPersistentSet)e2).iterator();
            }
        }
    }
}

