/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.sql.DriverManager;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class Launcher {
    public static long startTime = 0L;
    public static final ThreadGroup SHUT_DOWN_THREAD_GROUP = new ThreadGroup("isql-shutdown-hooks");

    private Launcher() {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        BasicUtilities.setLookAndFeel(userPreferences.get("general.plaf-class"));
        if (BasicUtilities.isMac() && !Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        MainFrame mainFrame = new MainFrame();
        mainFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        startTime = System.currentTimeMillis();
        BasicShutdownHook basicShutdownHook = new BasicShutdownHook(null);
        Runtime.getRuntime().addShutdownHook(new Thread(SHUT_DOWN_THREAD_GROUP, basicShutdownHook, "isql-shutdown"));
        try {
            Launcher.handCMDLine(stringArray);
        }
        catch (Exception exception) {
            BasicUtilities.HandleException(exception, BasicUtilities.getString("CMD_Line_Error"), true);
            System.exit(-1);
        }
        try {
            new Launcher();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("iSQL_Init_Error"), true);
            System.exit(-1);
        }
    }

    private static void handCMDLine(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (string.equalsIgnoreCase(BasicUtilities.getString("Help_Version_A")) || string.equalsIgnoreCase(BasicUtilities.getString("Help_Version_B"))) {
                    System.out.println(BasicUtilities.getString("Help_Line_1", "2.1.8"));
                    System.exit(1);
                    continue;
                }
                if (string.equalsIgnoreCase(BasicUtilities.getString("Help_Script_A")) || string.equalsIgnoreCase(BasicUtilities.getString("Help_Script_B"))) {
                    try {
                        System.exit(1);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println(BasicUtilities.getString("No_Script_Provied"));
                        System.exit(-1);
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, BasicUtilities.getString("Script_Error", stringArray[i2]), true);
                        System.exit(-1);
                    }
                    continue;
                }
                if (!string.equalsIgnoreCase(BasicUtilities.getString("Help_Help_A")) && !string.equalsIgnoreCase(BasicUtilities.getString("Help_Help_B"))) continue;
                String[] stringArray2 = new String[2];
                System.out.println(BasicUtilities.getString("Help_Line_1", "2.1.8"));
                stringArray2[0] = BasicUtilities.getString("Help_Help_A");
                stringArray2[1] = BasicUtilities.getString("Help_Help_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", stringArray2));
                System.out.println(BasicUtilities.getString("Help_Line_H"));
                System.out.println();
                stringArray2[0] = BasicUtilities.getString("Help_Script_A");
                stringArray2[1] = BasicUtilities.getString("Help_Script_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", stringArray2));
                System.out.println(BasicUtilities.getString("Help_Line_B"));
                System.out.println();
                stringArray2[0] = BasicUtilities.getString("Help_Version_A");
                stringArray2[1] = BasicUtilities.getString("Help_Version_B");
                System.out.println(BasicUtilities.getString("Help_Line_X", stringArray2));
                System.out.println(BasicUtilities.getString("Help_Line_V"));
                System.out.println();
                System.exit(0);
            }
        }
    }

    public static class 1 {
    }

    private static class BasicShutdownHook
    implements Runnable {
        private BasicShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DriverManager.getLogWriter().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.err.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                BasicUtilities.restoreSystemErr();
            }
            try {
                System.out.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                BasicUtilities.restoreSystemOut();
            }
            System.out.println(BasicUtilities.getString("Shutdown_Message"));
            try {
                SystemConfig.shutdown();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        public /* synthetic */ BasicShutdownHook(1 var1_1) {
            this();
        }
    }
}

