/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class AutovaluePlugin
extends AbstractImportPlugin {
    private JComboBox jcbAType = new JComboBox();
    private HashMap nativeTypes = null;
    private JTextField txtAOptions = new JTextField();
    private static final String KEY_SQL_TYPE = "sqltype";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_SELECTION = "selection";

    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        Object object = this.jcbAType.getSelectedItem();
        object = this.jcbAType.getSelectedItem();
        if (object != null) {
            entry.put(KEY_SELECTION, object);
            if (!this.nativeTypes.isEmpty()) {
                entry.put(KEY_SQL_TYPE, this.nativeTypes.get(object));
            } else {
                entry.put(KEY_SQL_TYPE, new Integer(JDBCUtilities.getTypeforName((String)object)));
            }
        } else {
            entry.put(KEY_SQL_TYPE, new Integer(12));
        }
        entry.put(KEY_OPTIONS, this.txtAOptions.getText());
        return entry;
    }

    public void setEntry(ImportConfig.Entry entry) {
        this.jcbAType.setSelectedItem(entry.get(KEY_SELECTION));
        this.txtAOptions.setText(entry.getProperty(KEY_OPTIONS, ""));
    }

    public void handleColumnSelectionChange(String string, String string2) {
    }

    public void handleTableSelectionChange(String string, String string2) {
    }

    public void installEditor(Container container) {
        this.nativeTypes = JDBCUtilities.getNativeTypeMap(this.connection.getDatabaseInformation());
        if (this.nativeTypes.isEmpty()) {
            this.jcbAType = new JComboBox<String>(AutovaluePlugin.getDefaultTypes());
        } else {
            String[] stringArray;
            Iterator iterator = this.nativeTypes.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                Integer n2 = (Integer)this.nativeTypes.get(stringArray);
                boolean bl2 = JDBCUtilities.isDateType(n2);
                boolean bl3 = JDBCUtilities.isNumberType(n2);
                boolean bl4 = JDBCUtilities.isStringType(n2);
                boolean bl5 = JDBCUtilities.isBooleanType(n2);
                boolean bl6 = n2 == 0;
                if (bl6 || bl4 || bl2 || bl3 || bl5) continue;
                iterator.remove();
            }
            stringArray = (String[])this.nativeTypes.keySet().toArray();
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            this.jcbAType = new JComboBox<String>(stringArray);
        }
        container.setLayout(new GridBagLayout());
        AutovaluePlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        AutovaluePlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_SQL_Type")), UI_CONSTRAINT);
        AutovaluePlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbAType, UI_CONSTRAINT);
        AutovaluePlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Auto_Options")), UI_CONSTRAINT);
        AutovaluePlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtAOptions, UI_CONSTRAINT);
        AutovaluePlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        AutovaluePlugin.constrain(0, 2, 3, 1, 0.0, 1.0, 10, 0);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
    }

    public ImportProcessor createProcessor() {
        return new AutoValueProcessor(null);
    }

    public String getDescription() {
        return BasicUtilities.getString("Import_Map_Auto");
    }

    private static String[] getDefaultTypes() {
        return new String[]{"BIGINT", "BIT", "BOOLEAN", "CHAR", "DATE", "DECIMAL", "DOUBLE", "FLOAT", "INTEGER", "NUMERIC", "NULL", "REAL", "SMALLINT", "TIME", "TIMESTAMP", "TINYINT", "NULL", "VARCHAR"};
    }

    public static class 1 {
    }

    private static class AutoValueProcessor
    implements ImportProcessor {
        private int sqltype = 1111;
        private String options = "";

        private AutoValueProcessor() {
        }

        public boolean canSkip() {
            return false;
        }

        public int prepareImport(int n2, int n3, Map map, PreparedStatement preparedStatement, int n4) throws SQLException {
            Format format;
            Object object = null;
            SystemConfig systemConfig = SystemConfig.getInstance();
            if (this.options.length() == 0) {
                return 3;
            }
            if (JDBCUtilities.isNumberType(this.sqltype)) {
                format = NumberFormat.getInstance();
                Number number = null;
                try {
                    if (this.options.startsWith("!")) {
                        object = ((NumberFormat)format).parse(this.options.substring(1));
                    }
                    number = ((NumberFormat)format).parse(this.options);
                    object = new Double(number.doubleValue() + (double)n2);
                }
                catch (ParseException parseException) {
                    throw new SQLException(parseException.getMessage());
                }
            } else if (JDBCUtilities.isDateType(this.sqltype)) {
                format = new SimpleDateFormat("");
                ((SimpleDateFormat)format).applyPattern(systemConfig.getFormatForSQLType(this.sqltype));
                if (this.options.equalsIgnoreCase("now")) {
                    object = new Date();
                } else {
                    try {
                        object = ((DateFormat)format).parse(this.options);
                    }
                    catch (ParseException parseException) {
                        throw new SQLException(parseException.getMessage());
                    }
                }
            } else {
                object = JDBCUtilities.isBooleanType(this.sqltype) ? Boolean.valueOf(this.options) : this.options;
            }
            try {
                object = JDBCUtilities.convertValue(object, this.sqltype, null);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
            JDBCUtilities.configurePreparedStatement(preparedStatement, n3, object, this.sqltype, false);
            return 0;
        }

        public void setEntry(ImportConfig.Entry entry) {
            this.sqltype = (Integer)entry.get(AutovaluePlugin.KEY_SQL_TYPE);
            this.options = entry.getProperty(AutovaluePlugin.KEY_OPTIONS, "");
        }

        public /* synthetic */ AutoValueProcessor(1 var1_1) {
            this();
        }
    }
}

