/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionManager
implements MouseListener,
Runnable {
    public static final String DND_PROXY_COMMAND = "dnd-proxy";
    private String imageLoction = "/images/";
    private Hashtable actions;
    private ActionListener listener = null;
    private ItemListener itemlistener = null;
    private PropertyChangeSupport support;
    private Vector queue = new Vector();

    public static ActionManager createDefaultInstance() {
        return new BasicActionManager(null);
    }

    public ActionManager() {
        this.actions = new Hashtable();
        this.support = new PropertyChangeSupport(this);
    }

    public abstract void addActions();

    public void addAction(String string, Action action) {
        this.actions.put(string, action);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.add(this.listener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.remove(this.listener, actionListener);
    }

    public final void setImagePath(String string) {
        this.imageLoction = string;
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemlistener = AWTEventMulticaster.add(this.itemlistener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemlistener = AWTEventMulticaster.remove(this.itemlistener, itemListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public ImageIcon getSmallIcon(String string, String string2) {
        return this.getIcon(string, 16, string2);
    }

    public ImageIcon getLargeIcon(String string, String string2) {
        return this.getIcon(string, 24, string2);
    }

    public ImageIcon getIcon(String string, int n2, String string2) {
        String string3 = this.imageLoction + string + n2 + "." + string2;
        URL uRL = this.getClass().getResource(string3);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public Action getAction(String string) {
        if (string != null && string != "") {
            return (Action)this.actions.get(string);
        }
        return null;
    }

    public Action getAction(int n2) {
        return this.getAction(Integer.toString(n2));
    }

    public void doAction(ActionEvent actionEvent) {
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
    }

    public void doItemEvent(ItemEvent itemEvent) {
        if (this.itemlistener != null) {
            this.itemlistener.itemStateChanged(itemEvent);
        }
    }

    public void setActionEnabled(String string, boolean bl2) {
        try {
            this.getAction(string).setEnabled(bl2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setActionEnabled(int n2, boolean bl2) {
        try {
            this.getAction(n2).setEnabled(bl2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void forwardAction(ActionEvent actionEvent) {
        this.addEvent(actionEvent);
    }

    public final void forwardItemEvent(ItemEvent itemEvent) {
        this.addEvent(itemEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        Action action;
        if (mouseEvent.getSource() instanceof AbstractButton && (action = this.getAction((abstractButton = (AbstractButton)mouseEvent.getSource()).getActionCommand())) != null) {
            String string = (String)action.getValue("LongDescription");
            this.support.firePropertyChange("begin-command", "", string);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        Action action;
        if (mouseEvent.getSource() instanceof AbstractButton && (action = this.getAction((abstractButton = (AbstractButton)mouseEvent.getSource()).getActionCommand())) != null) {
            String string = (String)action.getValue("LongDescription");
            this.support.firePropertyChange("end-command", string, "");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!Thread.interrupted()) {
            String string;
            try {
                this.processNextEvent();
            }
            catch (NullPointerException nullPointerException) {
                string = "ActionManager NullPointerException processing event: " + nullPointerException.getMessage();
                this.support.firePropertyChange("message-command", "", string);
            }
            catch (Exception exception) {
                string = "ActionManager fatal exception processing event: " + exception.getMessage();
                this.support.firePropertyChange("message-command", "", string);
                exception.printStackTrace();
            }
            finally {
                System.runFinalization();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(AWTEvent aWTEvent) {
        if (!this.isDupe(aWTEvent)) {
            this.queue.addElement(aWTEvent);
            ActionManager actionManager = this;
            synchronized (actionManager) {
                this.notify();
            }
        } else {
            BasicUtilities.beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AWTEvent getNextEvent() {
        Object object;
        if (this.queue.size() == 0) {
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object = (AWTEvent)this.queue.firstElement();
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextEvent() {
        AWTEvent aWTEvent = this.getNextEvent();
        if (aWTEvent == null) {
            return;
        }
        try {
            if (aWTEvent instanceof ActionEvent) {
                if (this.listener != null) {
                    this.listener.actionPerformed((ActionEvent)aWTEvent);
                }
            } else if (aWTEvent instanceof ItemEvent && this.itemlistener != null) {
                this.itemlistener.itemStateChanged((ItemEvent)aWTEvent);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.queue.removeElementAt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDupe(AWTEvent aWTEvent) {
        if (this.queue.isEmpty()) {
            return false;
        }
        Vector vector = this.queue;
        synchronized (vector) {
            AWTEvent aWTEvent2 = (AWTEvent)this.queue.firstElement();
            if (aWTEvent2 == null) {
                return false;
            }
            return aWTEvent.getID() == aWTEvent2.getID();
        }
    }

    public static class 1 {
    }

    private static class BasicActionManager
    extends ActionManager {
        private BasicActionManager() {
        }

        public void addActions() {
        }

        public /* synthetic */ BasicActionManager(1 var1_1) {
            this();
        }
    }
}

