/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ITableCellEditor
extends DefaultCellEditor {
    private int sqlType = 1111;
    private SimpleDateFormat sdf = new SimpleDateFormat("");

    public ITableCellEditor(int n2) {
        super(new JTextField());
        this.sqlType = n2;
    }

    public Object getCellEditorValue() {
        UserPreferences userPreferences;
        SystemConfig systemConfig = SystemConfig.getInstance();
        String string = (String)super.getCellEditorValue();
        if (JDBCUtilities.isDateType(this.sqlType)) {
            this.sdf.applyPattern(systemConfig.getFormatForSQLType(this.sqlType));
            try {
                return this.sdf.parse(string);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                return string;
            }
        }
        if (string != null && (userPreferences = systemConfig.getPreferences()).getBoolean("general.ascii2native-enabled")) {
            return StringUtilities.encode(string, false, false);
        }
        return super.getCellEditorValue();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
        Object object2;
        SystemConfig systemConfig = SystemConfig.getInstance();
        if (JDBCUtilities.isDateType(this.sqlType)) {
            this.sdf.applyPattern(systemConfig.getFormatForSQLType(this.sqlType));
            try {
                if (object == null) {
                    object = new Date();
                }
                object = this.sdf.format((Date)object);
            }
            catch (Throwable throwable) {}
        } else if (object != null && ((UserPreferences)(object2 = systemConfig.getPreferences())).getBoolean("general.ascii2native-enabled")) {
            object = StringUtilities.decode(object.toString());
        }
        object2 = super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
        ((Component)object2).setBackground(UIManager.getColor("ToolTip.background"));
        ((Component)object2).setForeground(UIManager.getColor("ToolTip.foreground"));
        int n4 = ((Component)object2).getPreferredSize().height;
        int n5 = jTable.getRowHeight();
        jTable.setRowHeight(Math.max(n5, n4));
        return object2;
    }
}

