/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class OrderEditor
extends JComponent {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DELETE = 1;
    public static final int STYLE_ASCENDING = 0;
    public static final int STYLE_DESCENDING = 1;
    private DefaultComboBoxModel mdlColumn = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlStyle = new DefaultComboBoxModel<Object>(new Object[]{BasicUtilities.getString("QBuild_Natural_Ascending"), BasicUtilities.getString("QBuild_Natural_Descending")});
    private JComboBox jcbColumn = new JComboBox(this.mdlColumn);
    private JComboBox jcbStyle = new JComboBox(this.mdlStyle);
    private JButton btnAdd = new JButton(BasicUtilities.getString("QBuild_Natural_Plus"));
    private JButton btnDel = new JButton(BasicUtilities.getString("QBuild_Natural_Minus"));
    private TreeMap meta = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList listenerList = null;
    private ActionHandler actionHandler = new ActionHandler(null);

    public OrderEditor(Map map) {
        this.setLayout(new GridBagLayout());
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setPreferredSize(this.btnDel.getMinimumSize());
        this.btnAdd.setPreferredSize(this.btnAdd.getMinimumSize());
        this.add((Component)this.jcbColumn, OrderEditor.constrain(0, 0.0, 17, 2));
        this.add(Box.createHorizontalStrut(8), OrderEditor.constrain(1, 0.0, 17, 0));
        this.add((Component)this.jcbStyle, OrderEditor.constrain(2, 0.0, 17, 0));
        this.add(Box.createHorizontalGlue(), OrderEditor.constrain(3, 1.0, 17, 2));
        this.add((Component)this.btnDel, OrderEditor.constrain(4, 0.0, 17, 0));
        this.add((Component)this.btnAdd, OrderEditor.constrain(5, 0.0, 17, 0));
        this.jcbColumn.addActionListener(this.actionHandler);
        this.jcbStyle.addActionListener(this.actionHandler);
        this.btnDel.addActionListener(this.actionHandler);
        this.btnAdd.addActionListener(this.actionHandler);
        this.updateMetamap(map);
        this.validateTree();
    }

    public int getSelectedStyle() {
        return this.jcbStyle.getSelectedIndex();
    }

    public ColumnMetaData getSelectedColumn() {
        Object object = this.jcbColumn.getSelectedItem();
        return (ColumnMetaData)this.meta.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetamap(Map map) {
        TreeMap treeMap = this.meta;
        synchronized (treeMap) {
            this.meta.clear();
            if (map != null) {
                this.meta.putAll(map);
            }
        }
        this.loadMap();
    }

    public void setAddEnabled(boolean bl2) {
        this.btnAdd.setEnabled(bl2);
    }

    public void setDeleteEnabled(boolean bl2) {
        this.btnDel.setEnabled(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener actionListener) {
        if (this.listenerList != null && this.listenerList.contains(actionListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(actionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener actionListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(actionListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(actionListener);
            }
        }
    }

    private void loadMap() {
        Iterator iterator = this.meta.keySet().iterator();
        this.mdlColumn.removeAllElements();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.mdlColumn.addElement(string);
        }
    }

    private static Object constrain(int n2, double d2, int n3, int n4) {
        Insets insets = new Insets(1, 1, 1, 1);
        return new GridBagConstraints(n2, 0, 1, 1, d2, 0.0, n3, n4, insets, 1, 1);
    }

    public void forwardEvent(ActionEvent actionEvent) {
        if (this.listenerList != null) {
            Iterator iterator = this.listenerList.iterator();
            Object object = actionEvent.getSource();
            int n2 = object == this.btnAdd ? 0 : 1;
            ActionEvent actionEvent2 = new ActionEvent(this, n2, actionEvent.getActionCommand(), actionEvent.getModifiers());
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                try {
                    actionListener.actionPerformed(actionEvent2);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void setEnabled(boolean bl2) {
        this.jcbColumn.setEnabled(bl2);
        this.jcbStyle.setEnabled(bl2);
        this.btnAdd.setEnabled(bl2);
        this.btnDel.setEnabled(bl2);
    }

    public static class 1 {
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == OrderEditor.this.btnAdd || object == OrderEditor.this.btnDel) {
                OrderEditor.this.forwardEvent(actionEvent);
            }
        }

        public /* synthetic */ ActionHandler(1 var2_2) {
            this();
        }
    }
}

